@ECHO OFF

REM Last Changed: 2010-06-23 by Stefan Heule

::::::::::::::::::::::::::
:: CONFIG
set seven_zip_path="C:\cmdlinetools\7z-patched-to-be-quiet.exe"
set ttbin2hex_path="C:\cmdlinetools\ttbin2hex.exe"
set tifileprop_path="C:\cmdlinetools\tifileprop.exe"
set tprbuilder_path="C:\Program Files\GCC4TI\tprbuilder.exe"
set tpr_count_path="C:\cmdlinetools\tprcount.exe"
:: END CONFIG
::::::::::::::::::::::::::

ECHO ---------------------------------------------------------
ECHO English version
ECHO ---------------------------------------------------------
ECHO Pre-compile eventhook.c (TI-89 Titaium)
tigcc -DUSE_TI89 -DLANG_EN -Os -mno-bss -W -Wall -outputbin eventhook.c
%ttbin2hex_path% -quiet -a eventhook_89 -ss 2 -se 1 eventhook.z89 eventhook_89.h

ECHO Pre-compile eventhook.c (Voyage 200)
tigcc -DUSE_V200 -DLANG_EN -Os -mno-bss -W -Wall -outputbin eventhook.c
%ttbin2hex_path% -quiet -a eventhook_v2 -ss 2 -se 1 eventhook.zv2 eventhook_v2.h

ECHO Pre-compile trap4hook.c (TI-89 Titaium and Voyage 200)
tigcc -Os -mno-bss -W -Wall -outputbin trap4hook.c
%ttbin2hex_path% -quiet -a trap4hook -ss 2 -se 1 trap4hook.zv2 trap4hook.h

del eventhook.z*
del trap4hook.z*

ECHO Compile amsextender_uc.tpr - uncompressed version
%tprbuilder_path% -q -DLANG_EN amsextender_uc.tpr

FOR %%A IN (amsextender_uc.*z) DO "%tifileprop_path%" -d a -fi amsext -c "AMS Extender by Stefan Heule" -q "%%A"

move /Y amsextender_uc.v2z "../bin/english/voyage 200/uncompressed/ams extender (english, voyage 200, uncompressed).v2z" >> nul
move /Y amsextender_uc.9xz "../bin/english/ti-92 plus/uncompressed/ams extender (english, ti-92 plus, uncompressed).9xz" >> nul
move /Y amsextender_uc.89z "../bin/english/ti-89 titanium/uncompressed/ams extender (english, ti-89 titanium, uncompressed).89z" >> nul

ECHO Compile amsextender_c.tpr - compressed version
%tprbuilder_path% -q -DLANG_EN amsextender_c.tpr

FOR %%A IN (amsextender_c.*y) DO "%tifileprop_path%" -d a -c "AMS Extender by Stefan Heule" -q "%%A"
FOR %%A IN (amsextender_c.*z) DO "%tifileprop_path%" -d a -fi amsext -c "AMS Extender by Stefan Heule" -q "%%A"

move /Y amsextender_c.v2z "../bin/english/voyage 200/compressed/ams extender (english, voyage 200, compressed).v2z" >> nul
move /Y amsextender_c.9xz "../bin/english/ti-92 plus/compressed/ams extender (english, ti-92 plus, compressed).9xz" >> nul
move /Y amsextender_c.89z "../bin/english/ti-89 titanium/compressed/ams extender (english, ti-89 titanium, compressed).89z" >> nul
move /Y amsextender_c.v2y "../bin/english/voyage 200/compressed/ams extender (english, voyage 200, compressed).v2y" >> nul
move /Y amsextender_c.9xy "../bin/english/ti-92 plus/compressed/ams extender (english, ti-92 plus, compressed).9xy" >> nul
move /Y amsextender_c.89y "../bin/english/ti-89 titanium/compressed/ams extender (english, ti-89 titanium, compressed).89y" >> nul

ECHO ---------------------------------------------------------
ECHO German version
ECHO ---------------------------------------------------------
ECHO Pre-compile eventhook.c (TI-89 Titaium)
tigcc -DUSE_TI89 -DLANG_DE -Os -mno-bss -W -Wall -outputbin eventhook.c
%ttbin2hex_path% -quiet -a eventhook_89 -ss 2 -se 1 eventhook.z89 eventhook_89.h

ECHO Pre-compile eventhook.c (Voyage 200)
tigcc -DUSE_V200 -DLANG_DE -Os -mno-bss -W -Wall -outputbin eventhook.c
%ttbin2hex_path% -quiet -a eventhook_v2 -ss 2 -se 1 eventhook.zv2 eventhook_v2.h

ECHO Pre-compile trap4hook.c (TI-89 Titaium and Voyage 200)
tigcc -Os -mno-bss -W -Wall -outputbin trap4hook.c
%ttbin2hex_path% -quiet -a trap4hook -ss 2 -se 1 trap4hook.zv2 trap4hook.h

del eventhook.z*
del trap4hook.z*

ECHO Compile amsextender_uc.tpr - uncompressed version
%tprbuilder_path% -q -DLANG_DE amsextender_uc.tpr

FOR %%A IN (amsextender_uc.*z) DO "%tifileprop_path%" -d a -fi amsext -c "AMS Extender by Stefan Heule" -q %%A

move /Y amsextender_uc.v2z "../bin/german/voyage 200/uncompressed/ams extender (german, voyage 200, uncompressed).v2z" >> nul
move /Y amsextender_uc.9xz "../bin/german/ti-92 plus/uncompressed/ams extender (german, ti-92 plus, uncompressed).9xz" >> nul
move /Y amsextender_uc.89z "../bin/german/ti-89 titanium/uncompressed/ams extender (german, ti-89 titanium, uncompressed).89z" >> nul

ECHO Compile amsextender_c.tpr - compressed version
%tprbuilder_path% -q -DLANG_DE amsextender_c.tpr

FOR %%A IN (amsextender_c.*y) DO "%tifileprop_path%" -d a -c "AMS Extender by Stefan Heule" -q %%A
FOR %%A IN (amsextender_c.*z) DO "%tifileprop_path%" -d a -fi amsext -c "AMS Extender by Stefan Heule" -q %%A

move /Y amsextender_c.v2z "../bin/german/voyage 200/compressed/ams extender (german, voyage 200, compressed).v2z" > nul
move /Y amsextender_c.9xz "../bin/german/ti-92 plus/compressed/ams extender (german, ti-92 plus, compressed).9xz" > nul
move /Y amsextender_c.89z "../bin/german/ti-89 titanium/compressed/ams extender (german, ti-89 titanium, compressed).89z" >> nul
move /Y amsextender_c.v2y "../bin/german/voyage 200/compressed/ams extender (german, voyage 200, compressed).v2y" > nul
move /Y amsextender_c.9xy "../bin/german/ti-92 plus/compressed/ams extender (german, ti-92 plus, compressed).9xy" > nul
move /Y amsextender_c.89y "../bin/german/ti-89 titanium/compressed/ams extender (german, ti-89 titanium, compressed).89y" >> nul

ECHO ---------------------------------------------------------
REM "tprcount"
ECHO ---------------------------------------------------------

IF "%1" EQU "-q" goto eof
PAUSE

:eof
