/****************************************************************************/
//                                                                          //
//                          BASE CONVERTER V 2.0                            //
//                                                                          //
// Permet de convertir un nombre d'une base quelconque en un nombre de la   //
// base dsire. A t fait pour les cours de SPE Maths.                    //
// Utilisation :                                                            //
//   chgbase(A,B,"String") o A et B sont des nombres entiers naturels      //
//   compris entre 2 et 36; et String un nombre d'une base A infrieur ou   //
//   gale  2^32-1 (Base 10). B est la base du rsultat.                   //
//     exs :  soit chgbase(16,2,"Cafe") -> "1100101011111110"               //
//                 chgbase(36,18,"zut") -> "7H7B"                           //
//                                                                          //
//    compil avec tigcc.																										//
//    command line : tigcc -02 chgbase.c										                //
//    mode sign implment : conversion signe                             //
//                                                                          //
//  Stanowski Etienne alias IronMan                                         //
//  Si vous avez des commentaires : Stan.Etienne@caramail.com               //
//                                                                          //
/****************************************************************************/

// For english users, comments will be only in French

#define RETURN_VALUE       // retourne un resultat dans le stack
#define USE_LONGDIV_PATCH  //    pour utilisation 
#define USE_LONGMUL_PATCH  //      des longints
#define OPTIMIZE_ROM_CALLS // rduit le code et optimise les rom calls
#define Fr2Eng(x,y) x      // x pour le francais, y pour l'anglais

#define Length  strlen(Chiffre)
#define Positif 2
#define Negatif 3

// Compile en mode nostub

int _ti89;                 // compile pour la Ti89
int _ti92plus;             // compile pour la Ti92+

#include <TiGccLib.h>      // librairie TiGcc

typedef unsigned char Byte;
typedef unsigned long LongInt;


/****************************************************************************/
//------------------------------- FUNCTION ---------------------------------//
/****************************************************************************/

void Error(Byte Erreur)
{
  char *Tab[4] =
  { Fr2Eng("Erreur! syntaxe: chgbase(b1,b2,'str')","Error! usage: chgbase(b1,b2,'str')"),
    Fr2Eng("Erreur! syntaxe du nombre incorrecte" ,"Error! syntax of number incorrect"),
    Fr2Eng("Erreur! base du nombre erronee"       ,"Error! base of number is erroneous"),
    Fr2Eng("Erreur! nombre trop grand : > 2^32-1" ,"Error! number too large : > 2^32-1")};
  ST_helpMsg(Tab[Erreur-1]);
  push_quantum_pair(0x01,0xEC);
}

/****************************************************************************/
//------------------------------- FUNCTION ---------------------------------//
/****************************************************************************/

LongInt Power(Byte Nbr, Byte Exposant)
{
  Byte i;
  LongInt Result = 1;
  for (i = 0; i < Exposant; i++)
   Result *= Nbr;
  return Result;
}

/****************************************************************************/
//----------------------------- MAIN FUNCTION ------------------------------//
/****************************************************************************/

void _main(void)
{
  ESI ArgPtr;              // pointe vers les arguments
  Byte Erreur = FALSE;     // erreur ?
  Byte Bases[2];           // arguments : base du chiffre, et base du rsultat
  char *Chiffre;           // pointe vers le chiffre entr

  InitArgPtr(ArgPtr);      // initialise le pointeur

/* vrifie que les bons arguments ont t entrs */

  if (ArgCount() != 3 || GetArgType(ArgPtr) != POSINT_TAG || GetArgType(EX_getArg(1)) != POSINT_TAG || GetArgType(EX_getArg(2)) != STR_TAG)
    Erreur = TRUE;
  else
    if ((Bases[1] = GetIntArg(ArgPtr)) > 36 || Bases[1] < 2 || (Bases[2] = GetIntArg(ArgPtr)) > 36 || Bases[2] < 2)
      Erreur = TRUE;
     else
       Chiffre = GetStrnArg(ArgPtr);

  push_END_TAG();          // prpare la rponse

/* si les bons arguments sont entrs ...*/

  if (Erreur == FALSE)
  {
    Byte i, Inc;
    Byte Signe = FALSE;    // Mode sign
    LongInt Nombre = 0;    // Nombre de passage en base 10
    char Temp[36];         // Sauve le rsultat
    char *Lettres = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    char *StrStack = 0;    // Place le rsultat dans le stack

 /* mode utilis                                                 */
    if (*Chiffre == '+' | *Chiffre == '-' | *Chiffre == '')
    {
      if (*Chiffre == '+') Signe = Positif;
        else Signe = Negatif;
      Chiffre++;
    }
 /* limine les 0 de devant                                      */
    while (*Chiffre == '0') Chiffre++;
 /* boucle de vrification                                       */
    for (i = 0; i < Length; i++)
 /* transforme les minuscules en majuscules si ncessaire        */
     if (islower((int)*(Chiffre+i)) != 0) *(Chiffre+i) = (char)toupper((int)*(Chiffre+i));
 /* vrifie que tous les caractres sont des chiffres ou lettres */
      else if (isalnum((int)*(Chiffre+i)) == 0) Erreur = 2;
 /* vrifie que les caractres correspondent  la base           */
    if (strpbrk(Chiffre, Lettres+Bases[1]) != 0) Erreur = 3;
     else if (Length > 32) Erreur = 4;

 /* s'il y a erreur, affiche le bon message et arrte le prog    */

    if (Erreur != FALSE)
    {
      Error(Erreur);
      return;
    }

/*    Passe en base 10        */

    for (i = 0; i < Length; i++)
    {
      for (Inc = 0; *(Chiffre+i) != *(Lettres+Inc); Inc++);
      Nombre += Inc * Power(Bases[1], Length-i-1);

    /* vrifie que le nombre ne dpasse pas 2^32-1 */

      if (Inc = 1)   // trange mais rduit le code 40 octets
        if (Nombre < Inc * Power(Bases[1], Length-i-1))
        {
          Error(4);
          return;
        }
    }

/* conversion signe */

    if (Signe > FALSE)
    {
      if (Nombre > 2147483647) // 2^31-1
      {
        if (Bases[2] == 10)
        { 
          Nombre = ~Nombre + 1;
          Signe = (Signe == Negatif ? Positif : Negatif);        	
        } else if (Signe == Negatif) Nombre = ~Nombre + 1;
      }
      else if (Signe == Negatif) if (Bases[2] != 10) Nombre = ~Nombre + 1;
    }

/* passe dans la base dsire */

    for (Inc = 35; Nombre >= Bases[2]; Inc--)
    {
      Temp[Inc] = *(Lettres+ Nombre%Bases[2]);
      Nombre /= Bases[2];
    }
    Temp[Inc] = *(Lettres+Nombre);

/* ajoute le signe */

    if (Signe > FALSE) if (Bases[2] == 10) Temp[--Inc] = (Signe == Positif ? '+' : '');
                        else Temp[--Inc] = '+';

/* place le rsultat dans StrStack */

    StrStack = (char*) malloc(sizeof(char)*(37-Inc));
    strncpy(StrStack, Temp+Inc, 36-Inc);
    *(StrStack+36-Inc) = 0;  // fin de la chaine de caractres

/* place le rsultat dans le stack */

    push_ANSI_string(StrStack);

  }
  else
    Error(Erreur);     // erreur lors de l'entre des arguments
  return;              // fin du programme
}

/****************************************************************************/
//------------------------------ END OF FILE -------------------------------//
/****************************************************************************/
