        include "92plus.h"
        xdef    _library
        xdef    _ti92plus ; TI-92 Plus
        xdef    _ti89     ; TI-89
        xdef    bignum@0000

;-----------------------------------------------------------
;  BigAdd(dword num2, dword num1, word length)
;  Adds two same-size arbitrary-length numbers stored in RAM.
;
;  length       Size of numbers (in bytes)
;  num1         Address of first number
;  num2         Address of second number
;
;  Parameters are, of course, pushed onto the stack.
;  Output appears in num1.
;  No registers destroyed.
;-----------------------------------------------------------
bignum@0000:
  
  movem.l       D0/A2-A3,-(A7) ;save A2/A3/D0 on stack
  ;
  move.l        12(A7),D0       ;load length into D0
  move.l        16(A7),A2       ;load num1 into A2
  move.l        20(A7),A3       ;load num2 into A3
  add.l         d0,a2           ;set address to one byte past end
  add.l         d0,a3           ; ditto
  subi.w        #1,d0           ;subtract one from length indicator
  move          #0,CCR          ;clear CCR
loop:
  addx.b        -(A3),-(A2)     ;add bytes and increment indicators
  dbra          d0,loop
  movem.l       (A7)+,D0/A2-A3  ;restore registers  
  rts

  end
