/*****************************************************************************************************

======================================
By: Jason Ho
Email: cho@mindspring.com
AIM: Bravo585
URL: http://www.geocities.com/dakron15
======================================

This tutorial assumes the knowledge of the Unit Circle, Pythagorean Theorem, and Sines and Cosines.

UNIT CIRCLE
-----------
	 
	 .5*PI		Basically you define 4 points on the unit circle, evenly spaced out (in radians). You
     ___			find the (x,y) coordinates by taking the cosine and sine of the points respectively.
    /   \ 		You then connect the 4 points to create a square. Repeat this same process but shift the
PI |  o  | 0	(x,y) coordinates down and to the right to create another square. Then connect the two
    \___/		squares to form the illusion of a cube. Its sorta like programming the steps to drawing
    				that cube you always drew when you were in 3rd grade.
    1.5*PI				 ___
							|\ _|_
							|_|_| |
			  				 \|__\|
			  				 
*****************************************************************************************************/

#define OPTIMIZE_ROM_CALLS
#define SAVE_SCREEN
#include <tigcclib.h>

short _ti89;
short _ti92plus;

//4 points on the unit circle
float point[4];

//Variables to store the x coordinate of the 4 points.
int point_x[4];

//Variables to store the y coordinate of the 4 points.
int point_y[4];

//Variable to store the virtual screen.
char virtual[3840];

//Determines the shift needed from the first square to the second square.
float shift;

//Changable variables
int size;
float speed;

void _main(void)
{
	//Local variables
	int count = 0;
	
	//Initialize variables
	size = 30;
	speed = 0.1;
	shift = 21.2132;
	
	//Initialize the 4 points on the unit circle, each PI/2 units apart (2 PI in a unit circle)
	point[0] = 0.;
	point[1] = PI * 0.5;
	point[2] = PI;
	point[3] = PI * 1.5;
	
	//Sets up the virtual screen.
	PortSet(virtual, 239, 127);
	//Disables all default keyboard interupts
	OSSetSR(0x0700);
	
	for(;;)	//Loop infinitely
	{
		//On the unit circle, cosine of a radian gives its x coordinate (range of 0 to 1)
		//times 'size' makes radius of unit circle 'size' times longer; cube gets larger.
		//plus 70 shifts points 70-30 (or 40) pixels to the right.
		for(count = 0; count < 4; count++)
			point_x[count] = cos(point[count]) * size + 70;
		
		//On the unit circle, sin of a radian gives its y coordinate (range of 0 to 1)
		//times 'size' makes radius of unit circle 'size' times longer;cube gets larger.
		//plus 40 shifts points 40-30 (or 10) pixels down.
		for(count = 0; count < 4; count++)
			point_y[count] = sin(point[count]) * size + 40;
		
		//Rotates the points on the unit circle (all points are evenly spaced to look like a cube)
		for(count = 0; count < 4; count++)
			point[count] += speed;
			
		//Draws first square by connecting the points
		DrawLine(point_x[0], point_y[0], point_x[1], point_y[1], A_NORMAL);
		DrawLine(point_x[1], point_y[1], point_x[2], point_y[2], A_NORMAL);
		DrawLine(point_x[2], point_y[2], point_x[3], point_y[3], A_NORMAL);
		DrawLine(point_x[3], point_y[3], point_x[0], point_y[0], A_NORMAL);
		
		/*
		 ___
		|  _|_	<-- original square
		|_|_| |
		  |___|	<-- shifted square
		
		*/
		
		shift = sqrt( pow(size,2) + pow(size,2) )/2;
		
		//Draws the second square; this is a shifting of the first square
		//Shift is exactly half of a side of the square. The center of the unit circle to a point
		//on the unit circle is half the diagonal of the square...so do the math to find the shift ;)
		DrawLine(point_x[0]+shift, point_y[0]+shift, point_x[1]+shift, point_y[1]+shift, A_NORMAL);
		DrawLine(point_x[1]+shift, point_y[1]+shift, point_x[2]+shift, point_y[2]+shift, A_NORMAL);
		DrawLine(point_x[2]+shift, point_y[2]+shift, point_x[3]+shift, point_y[3]+shift, A_NORMAL);
		DrawLine(point_x[3]+shift, point_y[3]+shift, point_x[0]+shift, point_y[0]+shift, A_NORMAL);
		
		//Links the two squares together to form a cube.
		DrawLine(point_x[0], point_y[0], point_x[0]+shift, point_y[0]+shift, A_NORMAL);
		DrawLine(point_x[1], point_y[1], point_x[1]+shift, point_y[1]+shift, A_NORMAL);
		DrawLine(point_x[2], point_y[2], point_x[2]+shift, point_y[2]+shift, A_NORMAL);
		DrawLine(point_x[3], point_y[3], point_x[3]+shift, point_y[3]+shift, A_NORMAL);
		
		//Draws the virtual screen to the actual screen.
		memcpy (LCD_MEM, virtual, LCD_SIZE);
		
		//Clear the screen.
		ClrScr();
		if(_rowread(0xFD)&0x2) speed += 0.01;	//Press + to increase speed of rotation	
		if(_rowread(0xFD)&0x4) speed -= 0.01;	//Press - to decrease speed of rotation
		if(_rowread(0xDF)&0x80)	//Press F1 to increase size of cube
		{
			size += 1;
			if(size > 40) size = 40;
		}
		if(_rowread(0xEF)&0x80)	//Press F2 to decrease size of cube
		{
			size -= 1;
			if(size < -40) size = -40;
		}
		if(_rowread(0xFD)&0x1) speed *= -1;	//Press 13 to change the direction of rotation of the cube.
		if(_rowread(0xBF)&0x1)	//Press Escape to quit
		{
			PortRestore();	//Cancels the virtual screen
			OSSetSR(0x0000);	//Re-enables the interrupts
			return;
		}
	}
}
