// These are the tile sprites

#include "tiles.h"




// Draw a single Tile
void drawTile(Tile tile,int x,int y){
  if(x<0 || x>=ScrRect->xy.x1-8)return; // Check bounds
  if(y<0 || y>=ScrRect->xy.y1-8)return;

  unsigned char* spr; // The sprite to draw
  switch(tile) // Decide which sprite this tile is
    {
    case WHITE:spr=tile_white;break;
    case GRAY:spr=tile_gray;break;
    case BLACK:spr=tile_black;break;
    default:spr=tile_outline;break;
    }
  Sprite8(x,y,TILEDIM,spr,LCD_MEM,SPRT_AND); // Draw it with AND and then OR to cover up whatever was there before
  Sprite8(x,y,TILEDIM,spr,LCD_MEM,SPRT_OR);
}



unsigned char tile_white[]={
  0b00000000,
  0b01111110,
  0b01000010,
  0b01000010,
  0b01000010,
  0b01000010,
  0b01111110,
  0b00000000  
};

unsigned char tile_black[]={
  0b00000000,
  0b01111110,
  0b01111110,
  0b01111110,
  0b01111110,
  0b01111110,
  0b01111110,
  0b00000000
};

unsigned char tile_gray[]={
  0b00000000,
  0b01010100,
  0b00101010,
  0b01010100,
  0b00101010,
  0b01010100,
  0b00101010,
  0b00000000
};

unsigned char tile_outline[]={
  0b11111111,
  0b10000001,
  0b10000001,
  0b10000001,
  0b10000001,
  0b10000001,
  0b10000001,
  0b11111111
};


unsigned char tile_blank[]={
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000,
  0b00000000
};
