#define USE_TI89
#define SAVE_SCREEN
#define C99

#include <stdio.h>
#include <kbd.h>
#include <graph.h>
#include <sprites.h>
#include <string.h>
#include <stdlib.h>
#include <system.h>

#include "tiles.h"
#include "intro.h"
#include "board.h"
#include "defines.h"




void changeTiles(Board board,int oldx,int oldy); // Change colors of tiles in response to moving across them
int gameLoop(Board board,Board targetboard); // Main game loop
int checkForWin(Board board,Board targetboard); // Check if boards are equal
void drawMoves(int moves); // Draw the move counter to the bottom of the screen





void _main(){
  // Intro screen
  clrscr();
  introPage();
  ngetchx();
  clrscr();

  // Make boards
  randomize();
  Board board,targetboard;
  board=initBoard();
  targetboard=initBoard();

  // Play game
  int moves=gameLoop(board,targetboard);

  // If game was won, not exited, display winning screen
  if(moves!=0)
    {
      drawBoard(board,BOARDX,BOARDY);
      char* str=malloc(100);
      sprintf(str,"You won in %i moves!",moves);
      DrawStr(0,ScrRect->xy.y1-8,str,A_REPLACE);
      free(str);
      ngetchx();
    }

  // Free boards
  free(targetboard.board);
  free(board.board);
}






int gameLoop(Board board,Board targetboard){
  int key;
  int moves=0;
  board.cursorx=0; // Put cursor on board
  board.cursory=0;

  drawBoard(board,BOARDX,BOARDY); // Draw boards
  drawBoard(targetboard,TARGETX,BOARDY);

  drawMoves(moves); // Draw 0 moves
  while(key=ngetchx()) // For each keypress
    {
      int oldx=board.cursorx,oldy=board.cursory; // Record where we were
      switch(key)
	{
	case KEY_ESC:return 0;break; // Exit loop and game
	  // Movement keys
	case KEY_UP:if(board.cursory>0)board.cursory--;break;
	case KEY_DOWN:if(board.cursory<BOARD_YDIM-1)board.cursory++;break;
	case KEY_LEFT:if(board.cursorx>0)board.cursorx--;break;
	case KEY_RIGHT:if(board.cursorx<BOARD_XDIM-1)board.cursorx++;break;
	}
      if(oldx!=board.cursorx || oldy!=board.cursory) // If cursor moved
	{
	  moves++;
	  changeTiles(board,oldx,oldy);
	  if(checkForWin(board,targetboard)!=0)
	    return moves;
	  drawMoves(moves);
	  drawBoard(board,BOARDX,BOARDY); // Draw (maybe changed) board
	}
    }
  return 0;
}





// Draws a line at the bottom saying how many moves you've made
void drawMoves(int moves){
  char* str=malloc(100);
  sprintf(str,"Moves: %i",moves);
  DrawStr(0,ScrRect->xy.y1-8,str,A_REPLACE);
  free(str);
}





// Checks if two boards are equivalent.
int checkForWin(Board b,Board t){
  Tile *board=b.board,*targetboard=t.board;
  for(int n=0;n!=BOARD_XDIM*BOARD_YDIM;n++)
    {
      if(board[n]!=targetboard[n])return 0;
    }
  return 1;
}





// Changes tile colors in response to moves
void changeTiles(Board board,int oldx,int oldy){
  // Check bounds
  if(oldx<0 || oldx>=BOARD_XDIM ||
     oldy<0 || oldy>=BOARD_YDIM ||
     board.cursorx<0 || board.cursorx>=BOARD_XDIM ||
     board.cursory<0 || board.cursory>=BOARD_YDIM)
    return;

  // A is where we were, B is where we are
  Tile a=board.board[oldx+oldy*BOARD_XDIM],
    b=board.board[board.cursorx+board.cursory*BOARD_XDIM];
  if(a!=b) // If they're the same, do nothing, otherwise, change b to the third color
    {
      int x=(int)(a+1)*(int)(b+1); // HACK
      switch(x)
	{
	case 2:b=BLACK;break;
	case 3:b=GRAY;break;
	case 6:b=WHITE;break;
	}
      board.board[board.cursorx+board.cursory*BOARD_XDIM]=b; // Write new color back to board
    }
}
