#include "board.h"


// Make a new board
Board initBoard(){
  Tile* b=malloc(BOARD_XDIM*BOARD_YDIM*sizeof(Tile));
  for(int n=0;n!=BOARD_XDIM*BOARD_YDIM;n++)
    {
      b[n]=random(3);
    }
  Board board;
  board.board=b;
  board.cursorx=-1;
  board.cursory=-1;
  return board;
}








// Draw a board to the screen
void drawBoard(Board board,int xstart,int ystart){
  for(int y=0;y!=BOARD_YDIM;y++) // For each row and column
    for(int x=0;x!=BOARD_XDIM;x++)
      {
	drawTile((board.board)[x+y*BOARD_XDIM],
		 xstart+x*(TILEDIM+2),
		 ystart+y*(TILEDIM+2)); // Draw each tile
	if(board.cursorx==x && board.cursory==y) // If the cursor is here, draw it
	  {
	    Sprite8(xstart+board.cursorx*(TILEDIM+2),
		    ystart+board.cursory*(TILEDIM+2)
		    ,TILEDIM,tile_outline,LCD_MEM,SPRT_XOR);
	  }
      }
}
