// C Source File
// Created 26/08/2007; 18:08:42

#include <tigcclib.h>

#include "soufflerie.h"

int LaissePasser(int i, int j)
{
	return (	m[i][j]==RIEN
			||	m[i][j]==GRAVITE_PLUS
			||	m[i][j]==GRAVITE_NORMALE
			||	m[i][j]==CHECKPOINT
			||	m[i][j]==GRAVITE_INVERSE
			||	m[i][j]==ARRIVEE
			||	(m[i][j]>=TOUCHES && m[i][j]<=DISABLED_GRAVITY)
			||	(m[i][j] >= PICS_CLIGNOTANTES1_DEBUT && m[i][j] <= PICS_CLIGNOTANTES1_FIN && !((objet_on1 >> (m[i][j] % 10) ) & 1) )
			||	(m[i][j] >= PICS_CLIGNOTANTES2_DEBUT && m[i][j] <= PICS_CLIGNOTANTES2_FIN && !((objet_on2 >> (m[i][j] % 10) ) & 1) )
			);
}


unsigned char objet_to_char (int coordonnees_case, int coordonnees_objet)
{
	unsigned char result = 0;
	int k;
	if ((coordonnees_objet >> 3) < coordonnees_case) // objet dpasse par le haut
	{
		for (k = 0; k < (coordonnees_objet & 7); k++)
		{
			result |= 1 << k; 
		}
	} 
	else // objet  l'intrieur ou dpasse par le bas
	{
		for (k = coordonnees_objet - (coordonnees_case << 3) ; k < 8 ; k++)
		{
			result |= 1 << k; 
		}
	}
	return result;
}

int soufflerie_gauche (int i, int j, int y, HASHTABLE * h)
{
	unsigned char balle = 0 , result = 0;
	OBJET o;
	int xo,yo,l,k = 1;
	while (j-k>0 && (LaissePasser(i, j-k) || m[i][j-k]==OBJET_VIDE)) k++;
	if (m[i][j-k]==SOUFFLERIE_DROITE)
	{
		balle = objet_to_char(i,y);
		if (balle == 1 || balle == 128 || result == 255) return 0; 
		for (l =0; l< h -> nb_total; l++)
		{
			o = h -> reference[l] -> objet;
			xo = o.x >> 3;
			yo = o.y >> 3;
			if (xo > j - k && xo <= j && yo >= i - 1 && yo <= i ) result |= objet_to_char(i, o.y);
		}
		return (result&balle) != balle;
	}
	else return 0;
}

int soufflerie_droite (int i, int j, int y, HASHTABLE * h)
{
	unsigned char balle = 0 , result = 0;
	OBJET o;
	int xo,yo,l,k = 1;
	while (j+k < 19 && (LaissePasser(i, j+k) || m[i][j+k]==OBJET_VIDE)) k++;
	if (m[i][j+k]==SOUFFLERIE_GAUCHE)
	{
		balle = objet_to_char(i,y);
		if (balle == 1 || balle == 128 || result == 255) return 0; 
		for (l =0; l< h -> nb_total; l++)
		{
			o = h -> reference[l] -> objet;
			xo = o.x >> 3;
			yo = o.y >> 3;
			if (xo >= j && xo < j+k && yo >= i - 1 && yo <= i ) result |= objet_to_char(i, o.y);
		}
		return (result&balle) != balle;
	}
	else return 0;
}

int soufflerie_haut (int i, int j, int x, HASHTABLE * h)
{
	unsigned char balle = 0 , result = 0;
	OBJET o;
	int xo,yo,l,k = 1;
	while (i-k>0 && (LaissePasser(i-k, j) || m[i-k][j]==OBJET_VIDE)) k++;
	if (m[i-k][j]==SOUFFLERIE_BAS)
	{
		balle = objet_to_char(j,x);
		if (balle == 1 || balle == 128 || result == 255) return 0; 
		for (l =0; l< h -> nb_total; l++)
		{
			o = h -> reference[l] -> objet;
			xo = o.x >> 3;
			yo = o.y >> 3;
			if (yo > i - k && yo <= i && xo >= j - 1 && xo <= j ) result |= objet_to_char(j, o.x);
		}
		return (result&balle) != balle;
	}
	else return 0;
}

int soufflerie_bas (int i, int j, int x, HASHTABLE * h)
{
	unsigned char balle = 0, result = 0;
	OBJET o;
	int xo,yo,l,k = 1;
	while (i+k < 12 && (LaissePasser(i+k, j) || m[i+k][j]==OBJET_VIDE)) k++;
	if (m[i+k][j]==SOUFFLERIE_HAUT)
	{
		balle = objet_to_char(j,x);
		if (balle == 1 || balle == 128 || result == 255) return 0; 
		for (l =0; l< h -> nb_total; l++)
		{
			o = h -> reference[l] -> objet;
			xo = o.x >> 3;
			yo = o.y >> 3;
			if (yo >= i && yo < i+k && xo >= j - 1 && xo <= j ) result |= objet_to_char(j, o.x);
		}
		return (result&balle) != balle;
	}
	else return 0;
}