// C Source File
// Created 16/05/2013; 18:45:40

#include <tigcclib.h>

#include "menu.h"
#include "fonctions graphiques.h"
#include "fonctions.h"
#include "highscores.h"

int load_position = 0;
int load_page_lvl = 0;

void xor_cursor()
{
	FillRect( LIGHT_PLANE, X(20), Y(6*load_position+28), X(138), Y(6*load_position+32), A_XOR);
}

inline int menu( int level, LISTE_SCORE** liste_rec, char** fptr, int* ghost_lect )
{
	int i;
	int curs=1,ligne,page=1,time,levelancien;
	char buffer[5],buffer2[50];

	memset(GrayGetPlane (LIGHT_PLANE),255,LCD_SIZE);
	memset(GrayGetPlane (DARK_PLANE),255,LCD_SIZE);
	FillRect(LIGHT_PLANE, X(0),Y(0),X(159),Y(99), A_REVERSE);
	FillRect(DARK_PLANE, X(0),Y(0),X(159),Y(99), A_REVERSE);
deb:
	FontSetSys(1);
	sprintf (buffer, "%d", level);	
	FillRect(LIGHT_PLANE,X(13),Y(25),X(145),Y(88),A_REVERSE);
	FillRect(DARK_PLANE,X(0),Y(0),X(159),Y(99),A_NORMAL);
	FillRect(DARK_PLANE,X(13),Y(25),X(145),Y(88),A_REVERSE);	//efface rectangle et pointeur sur DARK_PLANE
	DrawStr (X(24), Y(8), STR_TITLE, A_XOR);
	DrawStr (X(129), Y(15), STR_VERSION, A_XOR);
	DrawStr (X(41), Y(31), STR_LVL, A_XOR);
	DrawStr (X(41), Y(46), STR_LOAD, A_XOR);
	DrawStr (X(41), Y(61), STR_REC, A_XOR);
	DrawStr (X(41), Y(76), STR_QUIT, A_XOR);
	DrawStr (X(86), Y(31), buffer, A_NORMAL);
	FillRect(LIGHT_PLANE,X(14),Y(26),X(145),Y(89),A_NORMAL); //affiche rectangle et pointeur sur LIGHT_PLANE
	rect(X(0), Y(0), X(159), Y(99), LIGHT_PLANE);
	rect(X(0), Y(0), X(158), Y(98), LIGHT_PLANE);
	rect(X(12), Y(24), X(146), Y(89), DARK_PLANE);
	rect(X(12), Y(24), X(147), Y(90), LIGHT_PLANE);
		
	DrawStr (X(23), Y(7), STR_TITLE, A_NORMAL);
	DrawStr (X(130), Y(16), STR_VERSION, A_NORMAL);
	DrawStr (X(40), Y(30), STR_LVL, A_XOR);
	DrawStr (X(40), Y(45), STR_LOAD, A_XOR);
	DrawStr (X(40), Y(60), STR_REC, A_XOR);
	DrawStr (X(40), Y(75), STR_QUIT, A_XOR);
	DrawStr (X(85), Y(31), buffer, A_XOR);
	
	FontSetSys(0); //affiche nom du level
	GraySetAMSPlane (DARK_PLANE);
	sprintf (buffer2, STR_LEVEL, packlevel);
	DrawStr (X(15), Y(92), buffer2, A_REVERSE) ;
	GraySetAMSPlane (DARK_PLANE);
	FontSetSys(1);
	
	affiche_curs(curs);
	
	while(!_keytest(RR_ESC))
	{
		Counter=0;
		if (_keytest(RR_PLUS))
		{
			OSContrastUp (); 
			while (Counter < 4);
		}
		if (_keytest(RR_MINUS))
		{
			OSContrastDn (); 
			while (Counter < 4);
		}
		
		if ((_keytest(RR_LEFT) || _keytest(RR_RIGHT)) && curs==1)
		{
			levelancien=level;
			level-=_keytest(RR_LEFT)*(9*_keytest(RR_DIAMOND)+1);
			level+=_keytest(RR_RIGHT)*(9*_keytest(RR_DIAMOND)+1);
			if (level<1)level=nb_level;
			if (level>nb_level)level=1;
			if (level!=levelancien)
			{
				affiche_curs(curs);
				sprintf (buffer, "%d  ", level);
				GraySetAMSPlane (DARK_PLANE);
				DrawStr (X(86), Y(31), buffer, A_REPLACE);
				GraySetAMSPlane (LIGHT_PLANE);
				FillRect(LIGHT_PLANE,X(81),Y(30),X(111),Y(40),A_NORMAL);
				DrawStr (X(85), Y(30), buffer, A_XOR);
				affiche_curs(curs);
				WAIT( _keytest(RR_LEFT) || _keytest(RR_RIGHT) );
			}
		}
		else if (_keytest(RR_UP) || _keytest(RR_DOWN))
		{
			affiche_curs(curs);
			curs-=_keytest(RR_UP);
			curs+=_keytest(RR_DOWN);
			if (curs==0)curs=4;
			if (curs==5)curs=1;
			affiche_curs(curs);
			WAIT( _keytest(RR_UP) || _keytest(RR_DOWN) );
		}
		
		if (_keytest(RR_ENTER) || _keytest(RR_2ND)) 
		{
			WAIT(_keytest(RR_ENTER) || _keytest(RR_2ND));
			if( curs == 1 ) //LEVEL
			{
				return level;
			}
			else if( curs == 2 ) //LOAD
			{
				char file_name[18];
				char filenames[MAXFILES][18];
				for( i = 0 ; i < MAXFILES ; i++ ) filenames[i][0] = '\0';
				
				FontSetSys(0);
				GraySetAMSPlane (DARK_PLANE);
				FillRect(LIGHT_PLANE,X(14),Y(26),X(145),Y(88),A_NORMAL);
				FillRect(DARK_PLANE,X(13),Y(25),X(145),Y(88),A_REVERSE);

				int index = 0;
				SYM_ENTRY* SymPtr = SymFindFirst( NULL, FO_RECURSE );
				while( SymPtr && index < MAXFILES )
				{
					strcpy( file_name, SymFindFolderName() );
					strcat( file_name, "\\" );
					strcat( file_name, SymPtr->name );
					
					char* f;
					if( openReadFile( file_name, &f ) )
					{
						if( numberOfLevels(f) > 0 )
						{
							strcpy( filenames[index], file_name );
							index++;
						}
					}
					SymPtr = SymFindNext();
				}
				int files_count = index;
				
				if( load_page_lvl < 0 ) load_page_lvl = 0;
				if( load_position < 0 ) load_position = 0;
				if( load_page_lvl > (files_count-1)/10 ) load_page_lvl = 0;
				while( load_page_lvl*10 + load_position >= files_count || filenames[load_page_lvl*10 + load_position][0] == '\0' ) load_position--;
				
				
				for( i = 0 ; i < 10 && load_page_lvl*10 + i < files_count ; i++ )
				{
					DrawStr (X(57), Y(i*6 + 28), filenames[load_page_lvl*10 + i], A_NORMAL);
				}
				
				char page_number[10];
				sprintf( page_number, "%d-%d/%d", load_page_lvl*10+1, min( load_page_lvl*10+10, files_count ), files_count );
				DrawStr (X(22), Y(28), page_number , A_NORMAL);
				xor_cursor();
				
				while( ! _keytest(RR_ESC) )
				{
					//Counter = 0;
					if( _keytest(RR_LEFT) )
					{
						xor_cursor();
						load_page_lvl--;
						if(load_page_lvl < 0) load_page_lvl = (files_count-1)/10;
						while( load_page_lvl*10 + load_position >= files_count || filenames[load_page_lvl*10 + load_position][0] == '\0' ) load_position--;
						FillRect(LIGHT_PLANE,X(14),Y(26),X(145),Y(88),A_NORMAL);
						FillRect(DARK_PLANE,X(13),Y(25),X(145),Y(88),A_REVERSE);
						for( i = 0 ; i < 10 && load_page_lvl*10 + i < files_count ; i++ )
						{
							DrawStr (X(57), Y(i*6 + 28), filenames[load_page_lvl*10 + i], A_NORMAL);
						}
						sprintf( page_number, "%d-%d/%d", load_page_lvl*10+1, min( load_page_lvl*10+10, files_count ), files_count );
						DrawStr (X(22), Y(28), page_number , A_NORMAL);
						xor_cursor();
						WAIT( _keytest(RR_LEFT) );
					}
					else if( _keytest(RR_RIGHT) )
					{
						xor_cursor();
						load_page_lvl++;
						if( load_page_lvl > (files_count-1)/10 ) load_page_lvl = 0;
						while( load_page_lvl*10 + load_position >= files_count || filenames[load_page_lvl*10 + load_position][0] == '\0' ) load_position--;
						FillRect(LIGHT_PLANE,X(14),Y(26),X(145),Y(88),A_NORMAL);
						FillRect(DARK_PLANE,X(13),Y(25),X(145),Y(88),A_REVERSE);
						for( i = 0 ; i < 10 && load_page_lvl*10 + i < files_count ; i++ )
						{
							DrawStr (X(57), Y(i*6 + 28), filenames[load_page_lvl*10 + i], A_NORMAL);
						}
						sprintf( page_number, "%d-%d/%d", load_page_lvl*10+1, min( load_page_lvl*10+10, files_count ), files_count );
						DrawStr (X(22), Y(28), page_number , A_NORMAL);
						xor_cursor();
						WAIT( _keytest(RR_RIGHT) );
					}
					else if( _keytest(RR_UP) )
					{
						xor_cursor();
						load_position--;
						if(load_position < 0) load_position = 9;
						while( load_page_lvl*10 + load_position >= files_count || filenames[load_page_lvl*10 + load_position][0] == '\0' ) load_position--;
						xor_cursor();
						WAIT( _keytest(RR_UP) );
					}
					else if( _keytest(RR_DOWN) )
					{
						xor_cursor();
						load_position++;
						if( load_position > 9 || load_page_lvl*10 + load_position == files_count || filenames[load_page_lvl*10 + load_position][0] == '\0' ) load_position = 0;
						xor_cursor();
						WAIT( _keytest(RR_DOWN) );
					}
					
					if( _keytest(RR_2ND) || _keytest(RR_ENTER) )
					{
						if( filenames[load_page_lvl * 10 + load_position][0] != '\0' )
						{
							if( nouveau_record )
							{
								//Enregistrement des records
								set_score(*liste_rec);
								nouveau_record = 0;
							}
							
							//Slection du pack
							strcpy( packlevel, filenames[load_page_lvl * 10 + load_position] );
							openReadFile(packlevel, fptr);
							nb_level = (unsigned char) *(*fptr+3); //lecture du deuxieme caractere qui correspond au nombre de levels
							level = 1;
							
							//Rcupration des records
							free( *liste_rec );
							*liste_rec = (LISTE_SCORE*)malloc( nb_level*sizeof(LISTE_SCORE) );
							get_score( *liste_rec, *fptr );
							page = 1; //page des records remise au dbut
											
							//Suppression du ghost
							*ghost_lect = 0;
							
							WAIT( _keytest(RR_2ND) || _keytest(RR_ENTER) );
							curs = 1;
							break;
						}
					}
				}
				WAIT(_keytest(RR_ESC));
				FontSetSys(1);
				goto deb;
			}
			else if( curs == 3 ) //HIGHSCORES
			{
				FontSetSys(0);
				GraySetAMSPlane (DARK_PLANE); 
				DrawStr (X(15), Y(92), STR_RESET_HIGH, A_REVERSE) ;
				if(nb_level > 10)
				{
					DrawStr (X(5), Y(80), "<", A_REVERSE) ; 
					DrawStr (X(150), Y(80), ">", A_REVERSE) ; 
				}
				GraySetAMSPlane (DARK_PLANE); 
				
				while (!_keytest(RR_ESC))
				{
					FillRect(LIGHT_PLANE,X(14),Y(26),X(145),Y(88),A_NORMAL);
					FillRect(DARK_PLANE,X(13),Y(25),X(145),Y(88),A_REVERSE);
					
					ligne = 28;
					for (i=page*10-10;i<page*10 && i<NB_LEVEL;i++)
					{
						DrawStr(X(87), Y(ligne), (*liste_rec)[i].nom, A_NORMAL);
						time = (*liste_rec)[i].score;
						sprintf (buffer2, "%d \" %02d ", time/20,(time%20)*5);
						DrawStr (X(57), Y(ligne), buffer2, A_NORMAL);
						sprintf (buffer2, STR_NUM_LVL, i+1); 
						GraySetAMSPlane (LIGHT_PLANE); 
						DrawStr (X(15), Y(ligne-1), buffer2, A_REVERSE) ; 
						GraySetAMSPlane (DARK_PLANE); 
						DrawStr (X(16), Y(ligne), buffer2, A_NORMAL);
						ligne += 6 ;
					}						

					while(!_keytest(RR_ESC))
					{
						if (_keytest(RR_LEFT))
						{
							page--; 
							if (page==0) page=(NB_LEVEL-1)/10+1;
							break;
						}
						else if (_keytest(RR_RIGHT))
						{
							if (page==(NB_LEVEL-1)/10+1) page=0;
							page++;
							break;
						}
						else if (_keytest(RR_2ND) && _keytest(RR_CLEAR) && _keytest(RR_ENTER))
						{
							//rinitialisation des records
							for (i=0 ; i<NB_LEVEL ; i++)
							{
								(*liste_rec)[i].score=HIGH_INIT_SCORE*20; //initialisation  600 secondes
								strcpy((*liste_rec)[i].nom, HIGH_INIT_NAME); //initialisation  "bob"
							}
							nouveau_record=1;
							WAIT(_keytest(RR_2ND));
							break;
						}
					}
				}
				WAIT(_keytest(RR_ESC));
				FontSetSys(1); 
				goto deb;
			}
			else if( curs == 4 ) //EXIT
			{
				break;
			}
		}
	}
	WAIT(_keytest(RR_ESC) || _keytest(RR_ENTER) || _keytest(RR_2ND));
	return 0;
}