// Header File
// Created 24/12/04; 14:34:32

#ifndef _HACHAGE_H_
#define _HACHAGE_H_

#include "defines.h"
//#include "global.h"
#include "types.h"

struct cellule {
	OBJET objet; 
	int numero; // numro de l'objet attribu  l'initialisation du level <=> indice dans la table de references
	int zone; // zone de la carte  laquelle appartient l'objet <=> indice ds la table de hachage 
	struct cellule *suivante;
	struct cellule *precedente;
};
typedef struct cellule CELLULE;

struct table_de_hachage {
	CELLULE *table[MAX_HASHTABLE]; // objets rangs par zone
	CELLULE *reference[MAX_OBJET]; // garde une rfrence sur tous les objets pour un accs rapide
	int nb_total; // nombre total d'objet	
};
typedef struct table_de_hachage HASHTABLE;


// Initialise la table de hachage
inline HASHTABLE* hachage_init(void);

// Reinitialise la table de hachage -> ne ralloue pas la table
inline void hachage_reinit(HASHTABLE* h);


//Ajouter un objet
inline void ht_ajouter_objet(HASHTABLE *h, OBJET* o);

//Deplacer objet
inline void ht_deplacer_objet(HASHTABLE *h, CELLULE* c, int h_code_deb, int x, int y);

inline CELLULE* next(CELLULE* c);


/**********************
LIBERATON DE LA MEMOIRE
**********************/

inline void liberer_hashtable(HASHTABLE *h);

#endif
