// C Source File
// Created 26/08/2007; 18:07:05

#include <tigcclib.h>

#include "hachage.h"

// Initialise la table de hachage
inline HASHTABLE* hachage_init(void)
{
	int i;
	HASHTABLE* result = (HASHTABLE*)malloc(sizeof(HASHTABLE));
	for (i=0; i<MAX_HASHTABLE; i++) result -> table[i] = NULL;
	result -> nb_total = 0;
	return result;
}

// Reinitialise la table de hachage -> ne ralloue pas la table
inline void hachage_reinit(HASHTABLE* h)
{
	int i;
	for (i=0; i< h->nb_total; i++)
	{
		free(h -> reference[i]);
	}
	for (i=0; i<MAX_HASHTABLE; i++) h -> table[i] = NULL;
	h -> nb_total = 0;
}


//Ajouter un objet
inline void ht_ajouter_objet(HASHTABLE *h, OBJET* o)
{
	CELLULE* c = (CELLULE*)malloc(sizeof(CELLULE));
	int h_code = (o->x>>3) + (o->y>>3) * LEVEL_WIDTH;
	// cre la cellule
	c -> objet = *o; 
	c -> zone = h_code;
	c -> numero = h -> nb_total;
	c -> suivante = h -> table[h_code];
	if (c -> suivante != NULL) (c -> suivante) -> precedente = c;
	c -> precedente = NULL;
	// affecte la cellule  la table
	h -> table[h_code] = c;
	h -> reference[h -> nb_total] = c; 	
	(h -> nb_total)++;
}

//Deplacer objet
inline void ht_deplacer_objet(HASHTABLE *h, CELLULE* c, int h_code_deb, int x, int y)
{
	int h_code_fin = (x>>3) + (y>>3) * LEVEL_WIDTH;
	if (h_code_fin != h_code_deb)
	{
		if (c -> precedente == NULL)
		{
			h -> table[h_code_deb] = c -> suivante;
			if (c -> suivante != NULL) (c -> suivante) -> precedente = NULL;
		} 
		else
		{
			(c -> precedente) -> suivante = c -> suivante;
			if (c -> suivante != NULL) (c -> suivante) -> precedente = c -> precedente;
		}
		c -> suivante = h -> table[h_code_fin];
		if (c -> suivante != NULL) (c -> suivante) -> precedente = c;
		c -> precedente = NULL;
		h -> table[h_code_fin] = c;
		c -> zone = h_code_fin;
	}
}

inline CELLULE* next(CELLULE* c)
{
	return c -> suivante;
}


/**********************
LIBERATON DE LA MEMOIRE
**********************/

inline void liberer_hashtable(HASHTABLE *h) {
	int i;
	for (i=0; i< h->nb_total; i++) {
		free(h -> reference[i]);
	}
	free(h);
}