// C Source File
// Created 11/01/04; 14:57:36

#include <tigcclib.h>         // Include All Header files

#include "global.h"
#include "types.h"

INT_HANDLER OldInt1 = NULL;
INT_HANDLER OldInt5 = NULL;

volatile unsigned int Counter = 0;
volatile unsigned int compteur = 0;
volatile unsigned int objet_on1 = 0, objet_on2 = 0xFFFF;

volatile int ghost=0;

DEFINE_INT_HANDLER( MyInt1 )
{
	compteur++; //ce compteur servira  ralentir le programme
}
DEFINE_INT_HANDLER( MyInt5 )
{
	if (Counter++ % 2)
	{
		objet_on1 = (objet_on1 ^ (1 << ((Counter % 20) >> 1))) ;
		objet_on2 = (objet_on2 ^ (1 << ((Counter % 20) >> 1))) ;
	}
	ghost = 1;
}

unsigned char m[LEVEL_HEIGHT][LEVEL_WIDTH]; //tableau principal qui va contenir le level
unsigned char packlevel[18];//nom du pack de levels
unsigned char nb_level;//nombre de levels du pack
unsigned int nouveau_record;//s'il y a un nouveau record, sauvegarde  la fermeture du programme


#include "extgraph.h"
#include "graphique.h"
#include "hachage.h"
#include "fonctions graphiques.h"
#include "soufflerie.h"
#include "fonctions.h"
#include "highscores.h"
#include "menu.h"
#include "ghost.h"
#include "config.h"

inline void presentation();
short gameover(int x, int y, int type);

void _main(void)
{
	unsigned char buffer[50], *on;
	int tour=0, a, b, lvl=1, lvl_ancien, jump=1, time ;
	int x,y,xn,yn;
	int vect[2],gravite=1, enabled_gravity=1, coef_friction=1;
	int gauche_droite=1, haut_bas=1;
	int inverse_gauche_droite,inverse_haut_bas;
	int j,k,colli;
	int checkx,checky, checkg, checkeg, check_gd, check_hb, check_igd, check_ihb;
	int zone_balle, zone_objet=zone_objet; // designe la zone de la balle et des objets lors du test de collision
	int zone_dep[9] = {-LEVEL_WIDTH+1,-LEVEL_WIDTH,-LEVEL_WIDTH-1,-1,0,1,LEVEL_WIDTH-1,LEVEL_WIDTH,LEVEL_WIDTH+1};
	HASHTABLE *h = NULL;
	CELLULE *c;
	OBJET *o;
	char objet_teste[MAX_OBJET];
	char *light , *dark ;
	char *lvl_light, *lvl_dark;
	
	LISTE_SCORE *liste_rec;
	
	int ghost_i=0;
	COORD *ghost_liste_temp;
	
	COORD *ghost_liste_save;
	COORD *ghost_liste_lect;
	int ghost_i_save, ghost_i_lect;
	
	//pour calcul fps
	int frame_count=0;
	char frame_nb[4];
	int est_comptee = 0;
	
	ESI argptr;
	InitArgPtr (argptr);
	packlevel[0]=0;
	int have_arg = 0;
	if (GetArgType (argptr) == STR_TAG) //test si on a pass un level en argument
	{
		have_arg = 1;
		strcpy(packlevel,GetStrnArg(argptr));
	}
	if (packlevel[0]==0) strcpy(packlevel, "gravlvl"); //si pas de level pass en argument, mettre "gravlvl"

	char *fptr=NULL;
	if(openReadFile(packlevel, &fptr))
	{	
		nb_level = (unsigned char) *(fptr+3); //lecture du deuxieme caractere qui correspond au nombre de levels
	}
	else //si le level n'existe pas
	{
		fptr = NULL;
		if( ! have_arg ) //si on n'a pas pass d'argument
		{
			//recherche le premier level existant
			char level_name_search[18];
			SYM_ENTRY* SymPtr = SymFindFirst( NULL, FO_RECURSE );
			while( SymPtr )
			{
				strcpy( level_name_search, SymFindFolderName() );
				strcat( level_name_search, "\\" );
				strcat( level_name_search, SymPtr->name );
				
				char* f;
				if( openReadFile( level_name_search, &f ) )
				{
					unsigned char number_of_levels = numberOfLevels(f);
					if( number_of_levels > 0 )
					{
						nb_level = number_of_levels;
						strcpy( packlevel, level_name_search ); 
						fptr = f;
						break;
					}
				}
				SymPtr = SymFindNext();
			}
		}
	
		if( !fptr ) //si aucun level trouv
		{
			ST_helpMsg (STR_LVL_NOT_FOUND);
			ngetchx();
			return;
		}
	}
  
	liste_rec = (LISTE_SCORE*)malloc(nb_level*sizeof(LISTE_SCORE));
	get_score(liste_rec, fptr);
	nouveau_record = 0;
	
	load_configuration();
	
	
	OldInt1 = GetIntVec (AUTO_INT_1); 
	OldInt5 = GetIntVec (AUTO_INT_5);
	SetIntVec (AUTO_INT_5, MyInt5); //redirection des interruptions
	SetIntVec (AUTO_INT_1, MyInt1); //redirection des interruptions
	
	if (!GrayOn ()) return; //activation des niveaux de gris
	
	
	light = (char*)malloc(LCD_SIZE*sizeof(char));
	dark = (char*)malloc(LCD_SIZE*sizeof(char));
	lvl_light = (char*)malloc(LCD_SIZE*sizeof(char));
	lvl_dark = (char*)malloc(LCD_SIZE*sizeof(char));
	on = (unsigned char*)malloc(LEVEL_SIZE*sizeof(char));
	memset(on,0,LEVEL_SIZE * sizeof(char));
	
	
	ghost_liste_save = (COORD*)malloc(MAX_GHOST*20*sizeof(COORD));
	ghost_liste_lect = (COORD*)malloc(MAX_GHOST*20*sizeof(COORD));
	ghost_i_save=0;
	ghost_i_lect=0;
	
	presentation();
	
menujeu:
	lvl_ancien = lvl;
	lvl = menu(lvl, &liste_rec, &fptr, &ghost_i_lect); //menu et retour du level choisi
	if(lvl_ancien != lvl) ghost_i_lect = 0;
	
	checkx=0; checky=0; checkg=1; checkeg=1;  //remise  0 des checkpoints (et de la gravit)
	check_gd=1;check_hb=1;
	check_igd=1;check_ihb=1;
	if (h) liberer_hashtable(h); // libre la place alloue pour la table de hachage
	if (lvl==0) //si on a appuy sur ESC
	{
		if(nouveau_record)
		{
			set_score(liste_rec);
			openReadFile(packlevel, &fptr);
		}
		
		GrayOff(); //fin des niveaux de gris
		SetIntVec (AUTO_INT_1, OldInt1); //remise en place des vecteurs d'interruptions
		SetIntVec (AUTO_INT_5, OldInt5); //remise en place des vecteurs d'interruptions
		free(on);
		free(dark);
		free(light);
		free(lvl_dark);
		free(lvl_light);
		free(ghost_liste_save); free(ghost_liste_lect);
		free(liste_rec);
		GKeyFlush ();
		return; //fin du programme
	}
	h = hachage_init();
	memset(objet_teste,0,MAX_OBJET * sizeof(char));

deb:
	memset(lvl_light,255,LCD_SIZE);
	memset(lvl_dark,255,LCD_SIZE);
	
	FastFillRect(lvl_light,X(0),Y(0),X(159),Y(103),A_REVERSE); //efface l'cran de jeu
	FastFillRect(lvl_dark,X(0),Y(0),X(159),Y(103),A_REVERSE); //efface l'cran de jeu
	memset(vect,0,2*sizeof(int)); //vitesse

	if (checkx==0 && checky==0)  //si on n'a pas atteint de checkpoints
	{	
		x=0; y=(1<<NB_BIT_VIRGULE_FIXE) *8; //initialisation de la position de depart de la balle	
		hachage_reinit(h);
		//openReadFile(packlevel, &fptr);
		init_mvt(h, fptr, lvl, &x, &y);
		
		unsigned char ghost_name[16];
		int ghost_time = 0;
		ghost_load( ghost_name, &ghost_time, &ghost_liste_lect, &ghost_i_lect );
		
		//char buffer[128];
		//sprintf( buffer, "%s : %d, %d", ghost_name, ghost_time, ghost_i_lect );
		//draw_center_dialogbox( "Name", buffer );
		//while (!_keytest(RR_ENTER) && !_keytest(RR_2ND));
		
		gauche_droite=1; haut_bas=1; //initialisation des touches autorises
		inverse_gauche_droite = 1 ; inverse_haut_bas = 1; //initialisation des touches inverses
		ghost_i=0;
		ghost_i_save = 0;
		Counter = 0; objet_on1 = 0; objet_on2 = 0xFFFF; gravite=1, enabled_gravity=1; //remise a zero du temps, des objets clignotants et de la gravite
		xn=x; yn=y; //initialisation de xnouveau et ynouveau  x et y
	}
	else //sinon placement de la balle au bon endroit
	{
		x = xn = checkx;
		y = yn = checky;
		gravite = checkg;
		enabled_gravity = checkeg;
		gauche_droite = check_gd;
		haut_bas = check_hb;
		inverse_gauche_droite =  check_igd;
		inverse_haut_bas = check_ihb;
	}
	tour=0;
	affiche_level(lvl_light, lvl_dark); //affichage du level
	
/*****debut du jeux*****/
	while (Counter < 15*60*20) //tant que moins de 15 minutes
	{	
 		FastCopyScreen_R(lvl_light, light);
		FastCopyScreen_R(lvl_dark, dark);
		
		while (compteur < (HW_VERSION==1 ? 6 : 4)); // ralentit le programme
		compteur=0;
		
		if( _keytest(RR_LEFT)	&& gauche_droite									) { vect[0] -= inverse_gauche_droite; }
		if( _keytest(RR_RIGHT)	&& gauche_droite									) { vect[0] += inverse_gauche_droite; }
		if( _keytest(RR_UP)		&& haut_bas && (!enabled_gravity || tour % 2 == 0)	) { vect[1] -= inverse_haut_bas; }
		if( _keytest(RR_DOWN)	&& haut_bas && (!enabled_gravity || tour % 2 == 0)	) { vect[1] += inverse_haut_bas; }
		if( _keytest(RR_APPS)	) off();
		if( _keytest(RR_F2)		) { while (_keytest(RR_F2)); goto deb; } //Retour au dernier checkpoint
		if( _keytest(RR_ESC)	) { while (_keytest(RR_ESC)); goto menujeu; } //Retour au menu
		if( _keytest(RR_PLUS)	&& (tour % 8 == 0)	) { OSContrastUp (); } //Augmente le contraste
		if( _keytest(RR_MINUS)	&& (tour % 8 == 0)	) { OSContrastDn (); } //Diminue le contraste
		if( _keytest(RR_DIAMOND)					) //Affichage du fps
		{
			if( Counter%20==0 && !est_comptee )
		  	{
		  		sprintf(frame_nb, "%d", frame_count);
		  		frame_count=0;
		  		est_comptee=1;
		  	}
	  		else if(Counter%20==1) est_comptee=0;
	  		frame_count++;
	  		GrayDrawStr2B( 0, 0, frame_nb, A_REPLACE, light, dark );
		}
		if( _keytest(RR_SHIFT)									) //Affichage du temps
		{
			time = Counter;
			sprintf (buffer, "%d\"%02d", time/(20),(time%(20))*5);
			GrayDrawStr2B( 0, 0, buffer, A_REPLACE, light, dark );
		}
		
  		
		if( enabled_gravity )
		{
			if (tour % (4 * ((gravite+5)/4)) == 0) vect[1]+=gravite; //gestion gravite	
		}
		else
		{
			if(vect[1]!=0)
				if (tour % 4 == 0) {if (vect[1]>0) vect[1] -= coef_friction; else vect[1] += coef_friction;} //frottements
		}
			
		
		if(vect[0]!=0)
		{
			if(coef_friction==0) //pour la glace
			{
				if(gravite==1) vect[0] += (vect[0]>0?2:-2);
				else if (gravite==3 || gravite==-1) vect[0] += (vect[0]>0?1:-1);
			}
				
			if (tour % 4 == 0) {if (vect[0]>0) vect[0] -= coef_friction; else vect[0] += coef_friction;} //frottements
		}
		
		if (vect[0] > PRECISION ) vect[0]= PRECISION;	////////////////////////////////////////////////
		if (vect[0] < -PRECISION) vect[0]=-PRECISION;	//Limitation de la vitesse					  //
		if (vect[1] > PRECISION ) vect[1]= PRECISION;	//pour ne pas dpasser un pixel de dplacement//
		if (vect[1] < -PRECISION) vect[1]=-PRECISION;	////////////////////////////////////////////////
		
		
		//<rebonds sur les bords de l'cran>
		if((x+vect[0]) < 0){vect[0]=-vect[0]-8;xn=0;}
	 	else if((x+vect[0]) > 152*PRECISION){vect[0]=-vect[0]+8; xn=152<<NB_BIT_VIRGULE_FIXE;}
	 	else xn=x+vect[0];
	 	if((y+vect[1]) < 0){vect[1]=-vect[1] - (vect[1]<-3 ? 2 : 0) * 4;yn=0;}
	 	else yn=y+vect[1];
		//</rebonds sur les bords de l'cran>
	
//animation :
		if (tour % 4 == 0 )
		{
			for (j=0;j<LEVEL_HEIGHT;j++)
			{
				for (k=0;k<LEVEL_WIDTH;k++)
				{
					if (m[j][k] >= PICS_CLIGNOTANTES1_DEBUT && m[j][k] <= PICS_CLIGNOTANTES1_FIN ) //pics clignotantes
					{
						if ((objet_on1 >> (m[j][k] % 10)) & 1){on[j*LEVEL_WIDTH+k]=1; GrayTile8x8_RPLC_R(X8(k),Y(J),pics1,pics2,lvl_light,lvl_dark);}
						else if (on[j*LEVEL_WIDTH+k]==1){on[j*LEVEL_WIDTH+k]=0; GrayTile8x8_AND_R(X8(k), Y(J), mask, mask, lvl_light, lvl_dark);}
					}
					else if (m[j][k] >= PICS_CLIGNOTANTES2_DEBUT && m[j][k] <= PICS_CLIGNOTANTES2_FIN ) //pics clignotantes
					{
						if ((objet_on2 >> (m[j][k] % 10)) & 1){on[j*LEVEL_WIDTH+k]=1; GrayTile8x8_RPLC_R(X8(k),Y(J),pics1,pics2,lvl_light,lvl_dark);}
						else if (on[j*LEVEL_WIDTH+k]==1){on[j*LEVEL_WIDTH+k]=0; GrayTile8x8_AND_R(X8(k), Y(J), mask, mask, lvl_light, lvl_dark);}
					}
					else switch (m[j][k]) 
					{
						case JUMPER_HAUT			: GrayTile8x8_RPLC_R(X8(k), Y(J), jump11[jump]					, jump21[jump]					, lvl_light, lvl_dark); break;
						case SOUFFLERIE_HAUT		: GrayTile8x8_RPLC_R(X8(k), Y(J), soufflerie11[tour>>2]			, soufflerie21[tour>>2]			, lvl_light, lvl_dark); break;
						case GRAVITE_PLUS			: GrayTile8x8_RPLC_R(X8(k), Y(J), plus							, plus							, lvl_light, lvl_dark); break;
						case GRAVITE_NORMALE		: GrayTile8x8_RPLC_R(X8(k), Y(J), zero							, zero							, lvl_light, lvl_dark); break;
						case CHECKPOINT				: GrayTile8x8_RPLC_R(X8(k), Y(J), checkpoint1					, checkpoint2					, lvl_light, lvl_dark); break;
						case SOUFFLERIE_BAS			: GrayTile8x8_RPLC_R(X8(k), Y(J), soufflerie13[tour>>2]			, soufflerie23[tour>>2]			, lvl_light, lvl_dark); break;
						case SOUFFLERIE_GAUCHE		: GrayTile8x8_RPLC_R(X8(k), Y(J), soufflerie12[tour>>2]			, soufflerie22[tour>>2]			, lvl_light, lvl_dark); break;
						case SOUFFLERIE_DROITE		: GrayTile8x8_RPLC_R(X8(k), Y(J), soufflerie14[tour>>2]			, soufflerie24[tour>>2]			, lvl_light, lvl_dark); break;
						case JUMPER_BAS				: GrayTile8x8_RPLC_R(X8(k), Y(J), jump12[jump]					, jump22[jump]					, lvl_light, lvl_dark); break;
						case JUMPER_GAUCHE			: GrayTile8x8_RPLC_R(X8(k), Y(J), jump13[jump]					, jump23[jump]					, lvl_light, lvl_dark); break;
						case JUMPER_DROITE			: GrayTile8x8_RPLC_R(X8(k), Y(J), jump14[jump]					, jump24[jump]					, lvl_light, lvl_dark); break;
						case GRAVITE_INVERSE		: GrayTile8x8_RPLC_R(X8(k), Y(J), moins							, moins							, lvl_light, lvl_dark); break;
						case ARRIVEE				: GrayTile8x8_RPLC_R(X8(k), Y(J), arrive						, arrive						, lvl_light, lvl_dark); break;
						case TOUCHES				: 
						case TOUCHES_GAUCHE_DROITE	: 
						case TOUCHES_HAUT_BAS		: GrayTile8x8_RPLC_R(X8(k), Y(J), pave1[m[j][k]-TOUCHES]		, pave2[m[j][k]-TOUCHES]		, lvl_light, lvl_dark); break;
						case INVERSE_TOUT      		:
						case INVERSE_GAUCHE_DROITE 	:
						case INVERSE_HAUT_BAS  		: GrayTile8x8_RPLC_R(X8(k), Y(J), inverse1[m[j][k]-INVERSE_TOUT], inverse2[m[j][k]-INVERSE_TOUT], lvl_light, lvl_dark); break;	
						case ENABLED_GRAVITY		: GrayTile8x8_RPLC_R(X8(k), Y(J), enabled_gravity1				, enabled_gravity2				, lvl_light, lvl_dark); break;
						case DISABLED_GRAVITY		: GrayTile8x8_RPLC_R(X8(k), Y(J), disabled_gravity1				, disabled_gravity2				, lvl_light, lvl_dark); break;
					}
				}
			}
			if (tour==0) jump=1-jump; 
		}
		
//fin animation.
		
		coef_friction=1; //coefficient de base de frottement
		
		
		if (tour%4==0)
		{		
			// Collision des objets avec lments de la carte
			for (j=0 ; j<h -> nb_total ; j++)
			{
				if (!objet_teste[j])
				{
					c = h -> reference[j];	
					o = &(c -> objet);
					switch (o -> type)
					{
						case PICS_MVT_HAUT : 	if (o -> y<1 || !LaissePasser((o -> y-1)/8, o -> x/8)) propager_collision(h,c,LEVEL_WIDTH,objet_teste); break;
						case PICS_MVT_GAUCHE : 	if (o -> x<1 || !LaissePasser(o -> y/8, (o -> x-1)/8)) propager_collision(h,c,1,objet_teste); break;
						case PICS_MVT_BAS : 	if (!LaissePasser(o -> y/8+1, o -> x/8)) propager_collision(h,c,-LEVEL_WIDTH,objet_teste); break;
						case PICS_MVT_DROITE : 	if (o -> x>19*8-2 || !LaissePasser(o -> y/8, o -> x/8+1)) propager_collision(h,c,-1,objet_teste); break;
					}		
				}
			}

			// Collision entre objets
			for( j = 0 ; j < h->nb_total ; j++ )
			{	
				if( ! objet_teste[j] )
				{
					o = &((h -> reference[j]) -> objet);
					switch (o -> type)
					{
						case PICS_MVT_HAUT :
							zone_objet = (o->x /8) + ((o->y-8)/8) * LEVEL_WIDTH;
							c = h -> table[zone_objet];
							while (c != NULL)
							{
								if( (c->objet).type==PICS_MVT_BAS && (o -> y - 8) <= (c -> objet).y )
								{ 
									propager_collision( h, c, -LEVEL_WIDTH, objet_teste);
									propager_collision( h, h->reference[j], LEVEL_WIDTH, objet_teste);
								}
								c = next(c);
							}
							break;
						case PICS_MVT_BAS :
							zone_objet = (o->x /8) + ((o -> y+8)/8) * LEVEL_WIDTH;
							c = h -> table[zone_objet];
							while (c != NULL)
							{
								if( (c->objet).type==PICS_MVT_DROITE && (o -> x - 8) <= (c -> objet).x )
								{
									propager_collision( h, c, -1, objet_teste );
									propager_collision( h, h->reference[j], 1, objet_teste );
								}
								c = next(c);
							}
							break;
						case PICS_MVT_GAUCHE :
							zone_objet = ((o -> x-8)/8) + (o->y /8) * LEVEL_WIDTH;
							c = h -> table[zone_objet];
							while (c != NULL)
							{
								if( (c->objet).type==PICS_MVT_HAUT && (o -> y + 8) >= (c -> objet).y )
								{
									propager_collision( h, c, LEVEL_WIDTH, objet_teste );
									propager_collision( h, h->reference[j], -LEVEL_WIDTH, objet_teste );
								}
								c = next(c);
							}
							break;
						case PICS_MVT_DROITE :
							zone_objet = ((o -> x+8)/8) + (o->y /8) * LEVEL_WIDTH;
							c = h -> table[zone_objet];
							while (c != NULL)
							{
								if( (c->objet).type==PICS_MVT_GAUCHE && (o -> x + 8) >= (c -> objet).x )
								{
									propager_collision( h, c, 1, objet_teste );
									propager_collision( h, h->reference[j], -1, objet_teste );
								}
								c = next(c);
							}
							break;
					}
				}	
			}

			memset(objet_teste,0,MAX_OBJET * sizeof(char)); // reinitialise la liste des objets tests pour collision

			// Deplacement des objets
			for (j=0 ; j<h -> nb_total ; j++)
			{
				c = h -> reference[j];
				o = &(c -> objet);
				
				GraySprite8_AND_R (X(o->x), Y(o->y), 8, mask2, mask2, lvl_light, lvl_dark); //effacement de l'ancien objet
				if (o -> type==PICS_MVT_HAUT) o -> y--;
				else if (o -> type==PICS_MVT_GAUCHE) o -> x--;
				else if (o -> type==PICS_MVT_BAS) o -> y++;
				else if (o -> type==PICS_MVT_DROITE) o -> x++;
				ht_deplacer_objet(h,c,c->zone,o -> x, o-> y); // actualise la place des objets
				GraySprite8_OR_R (X(o -> x), Y(o->y), 8, pics1, pics2, lvl_light, lvl_dark); //affichage  la nouvelle coordonne
			} // fin for j
			
						
			// Collision de la balle avec les objets 
			//  pr tour %2 p
			zone_balle = (xn >> NB_BIT_VIRGULE_FIXE)/8 + (yn >> NB_BIT_VIRGULE_FIXE)/8 * LEVEL_WIDTH;
			for (k = 0; k<9 ; k++)
			{
				zone_objet = zone_balle + zone_dep[k];
				if (zone_objet > -1 && zone_objet < MAX_HASHTABLE)
				{
					c = h -> table[zone_objet];
					while (c != NULL)
					{
						if (TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,yn>>NB_BIT_VIRGULE_FIXE,(c -> objet).x,(c -> objet).y,8,balle2, pics2))
						{
							virtuel2reel(light, dark);
							if (gameover(x,y,0)==1)goto deb; else goto menujeu;
						}
						c = next(c);
					} 
				}
			}
			
		}
		

		
		
		
		a=yn>>8 ; // /(256) //////////////////////////////////////////
		b=xn>>8 ; // /(256) //calcul pour ne tester que 4 collisions//
		if (b>19)b=19;      //////////////////////////////////////////
		
		for (j= a;j<a+2;j++)
		{
			for (k=b;k<b+2;k++)
			{
				if ((m[j][k]>= PICS_CLIGNOTANTES1_DEBUT && m[j][k]<= PICS_CLIGNOTANTES1_FIN && (objet_on1 >> (m[j][k] % 10)) & 1) || m[j][k]==MINE) //si la pic clignotante est allume
				{
					if(TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,yn>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2, pics2)){virtuel2reel(light, dark);if (gameover(x,y,0)==1)goto deb; else goto menujeu;}
				}
				else if ((m[j][k]>= PICS_CLIGNOTANTES2_DEBUT && m[j][k]<= PICS_CLIGNOTANTES2_FIN && (objet_on2 >> (m[j][k] % 10)) & 1) || m[j][k]==MINE) //si la pic clignotante est allume
				{
					if(TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,yn>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2, pics2)){virtuel2reel(light, dark);if (gameover(x,y,0)==1)goto deb; else goto menujeu;}
				}
				else if (m[j][k]==BRIQUE || m[j][k]==SOUFFLERIE_HAUT || m[j][k]==JUMPER_HAUT || (m[j][k]>=SOUFFLERIE_BAS && m[j][k]<=JUMPER_DROITE)) //test brique+glace+jumpers+souffleries
				{
					colli=collision(xn,yn,j*8,k*8,0b0000,carre1);
					if (colli==HAUT) 
					{
						vect[1]=(m[j][k]==JUMPER_HAUT ? -PRECISION : -vect[1] + (vect[1]>3 ? 8 : 0)); 
						if (TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,(yn-PRECISION)>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2, carre1)) yn-=PRECISION;
						yn-=PRECISION;
						if (m[j][k]==GLACE)coef_friction = 0; 
					}
					else if (colli==GAUCHE) {vect[0]=(m[j][k]==JUMPER_GAUCHE ? -PRECISION : -vect[0]+8); xn=xn-PRECISION;}
					else if (colli==DROITE) {vect[0]=(m[j][k]==JUMPER_DROITE ? PRECISION : -vect[0]-8); xn=xn+PRECISION;}
					else if (colli==BAS) 
					{
						vect[1]=(m[j][k]==JUMPER_BAS ? PRECISION : -vect[1] - (vect[1]<-3 ? 8 : 0));
						if (TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,(yn+PRECISION)>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2,carre1)) yn+=PRECISION;
						yn+=PRECISION;
					}
				}
				else if (m[j][k]>=PIC_EN_HAUT && m[j][k]<=PIC_A_GAUCHE) //test des 4 pics
				{
					int laPic=(m[j][k]==PIC_EN_HAUT ? 0 : (m[j][k]==PIC_A_GAUCHE ? 1 : (m[j][k]==PIC_EN_BAS ? 2 : 3)));
					colli=collision(xn,yn,j*8,k*8,1<<laPic,pic2[laPic]);
					//colli=collision(xn,yn,j*8,k*8,0b0000,pic2[laPic]);
					if (colli==HAUT) 
					{
						vect[1]=-vect[1] + (vect[1]>3 ? 8 : 0);
						if (TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,(yn-PRECISION)>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2, pic2[laPic])) yn-=PRECISION;
						yn-=PRECISION;
					}
					if (colli==GAUCHE) { vect[0]=-vect[0]+8; xn=xn-PRECISION;}
					if (colli==DROITE) { vect[0]=-vect[0]-8; xn=xn+PRECISION;}
					if (colli==BAS) 
					{
						vect[1]=-vect[1] - (vect[1]<-3 ? 8 : 0);
						if (TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,(yn+PRECISION)>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2,pic2[laPic])) yn+=PRECISION;
						yn+=PRECISION;
					}
					if (colli==laPic+1) {virtuel2reel(light, dark); if (gameover(x,y,0)==1)goto deb; else goto menujeu;}
				}
				else if (m[j][k]==ARRIVEE && TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,yn>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2,arrive)) //si on a touch le A (arrive)
				{
					GraySprite8_MASK_R(X((x>>NB_BIT_VIRGULE_FIXE)), Y((y>>NB_BIT_VIRGULE_FIXE)),8,balle1, balle2,mask, mask, light, dark); //affichage de la balle
					virtuel2reel(light, dark);
					
					time = Counter;
					sprintf (buffer, STR_TIME, time/(20),(time%(20))*5);
					
					draw_center_dialogbox( STR_GOOD_GAME, buffer );
					
					while (!_keytest(RR_ENTER) && !_keytest(RR_2ND));
					GraySetInt1Handler(OldInt1); //remise du vecteur d'interruption (pour ngetchx() )
					if( high(&liste_rec[lvl-1], time) ) // nouveau record
					{
						nouveau_record = 1;	
					}
					GraySetInt1Handler(MyInt1);//redirection du vecteur d'interruption
					
					if( (ghost_i_lect>ghost_i_save || ghost_i_lect==0) && ghost_i_save<MAX_GHOST*20 )
					{
						ghost_liste_temp = ghost_liste_save;
						ghost_liste_save = ghost_liste_lect;
						ghost_liste_lect = ghost_liste_temp;
						ghost_i_lect = ghost_i_save;
						
						if( configuration[CFG_SAVE_GHOST] )
						{
							unsigned char name[16];
							sprintf( name, "lvl%d", lvl );
							ghost_save( name, time, ghost_liste_lect, ghost_i_lect );
						}
					}
					
					while (_keytest(RR_ENTER) || _keytest(RR_2ND));
					goto menujeu; //retour au menu
				}
				else if ( m[j][k]==GRAVITE_PLUS 			&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, plus)) 				gravite=3;
				else if ( m[j][k]==GRAVITE_NORMALE 			&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, zero)) 				gravite=1;
				else if ( m[j][k]==GRAVITE_INVERSE 			&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, moins)) 				gravite=-1;
				
				else if ( m[j][k]==TOUCHES 					&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, pave1[0])) 			{gauche_droite=1; haut_bas=1; inverse_gauche_droite=1; inverse_haut_bas=1;}
				else if ( m[j][k]==TOUCHES_GAUCHE_DROITE 	&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, pave1[1])) 			{gauche_droite=1; haut_bas=0; inverse_gauche_droite=1; inverse_haut_bas=1;}
				else if ( m[j][k]==TOUCHES_HAUT_BAS			&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, pave1[2])) 			{gauche_droite=0; haut_bas=1; inverse_gauche_droite=1; inverse_haut_bas=1;}
				else if ( m[j][k]==INVERSE_TOUT 			&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, inverse1[0])) 			{inverse_gauche_droite=-1; inverse_haut_bas=-1; gauche_droite=1; haut_bas=1;}
				else if ( m[j][k]==INVERSE_GAUCHE_DROITE 	&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, inverse1[1])) 			{inverse_gauche_droite=-1; inverse_haut_bas=1; gauche_droite=1; haut_bas=1;}
				else if ( m[j][k]==INVERSE_HAUT_BAS 		&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, inverse1[2])) 			{inverse_gauche_droite=1; inverse_haut_bas=-1; gauche_droite=1; haut_bas=1;}
				
				else if ( m[j][k]==ENABLED_GRAVITY 			&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, enabled_gravity1)) 	enabled_gravity = 1;
				else if ( m[j][k]==DISABLED_GRAVITY 		&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE, yn>>NB_BIT_VIRGULE_FIXE, k*8, j*8, 8, balle2, disabled_gravity1))	enabled_gravity = 0;
				
				else if ( m[j][k]==CHECKPOINT 				&& TestCollide8_R(xn>>NB_BIT_VIRGULE_FIXE,yn>>NB_BIT_VIRGULE_FIXE,k*8,j*8,8,balle2,checkpoint1)) 
				{
					checkx=K <<NB_BIT_VIRGULE_FIXE ; checky=J <<NB_BIT_VIRGULE_FIXE ; checkg=gravite ; checkeg= enabled_gravity ;
					check_gd = gauche_droite;
					check_hb = haut_bas;
					check_igd = inverse_gauche_droite;
					check_ihb = inverse_haut_bas;
				}
			
			}
		}
		
		// Test pour savoir si la balle est prise par le vent
		if (tour % 2 == 0)
		{
			if (	soufflerie_gauche( yn >> (NB_BIT_VIRGULE_FIXE + 3)	   , xn >> (NB_BIT_VIRGULE_FIXE + 3)	 , yn >> NB_BIT_VIRGULE_FIXE, h)
				||	soufflerie_gauche((yn >> (NB_BIT_VIRGULE_FIXE + 3)) + 1, xn >> (NB_BIT_VIRGULE_FIXE + 3)	 , yn >> NB_BIT_VIRGULE_FIXE, h)) vect[0]++ ;
			if (	soufflerie_droite( yn >> (NB_BIT_VIRGULE_FIXE + 3)	   , xn >> (NB_BIT_VIRGULE_FIXE + 3)	 , yn >> NB_BIT_VIRGULE_FIXE, h)
				||	soufflerie_droite((yn >> (NB_BIT_VIRGULE_FIXE + 3)) + 1, xn >> (NB_BIT_VIRGULE_FIXE + 3)	 , yn >> NB_BIT_VIRGULE_FIXE, h)) vect[0]-- ;
			if (	soufflerie_haut(   yn >> (NB_BIT_VIRGULE_FIXE + 3)	   , xn >> (NB_BIT_VIRGULE_FIXE + 3)	 , xn >> NB_BIT_VIRGULE_FIXE, h)
				||	soufflerie_haut(   yn >> (NB_BIT_VIRGULE_FIXE + 3)	   ,(xn >> (NB_BIT_VIRGULE_FIXE + 3)) + 1, xn >> NB_BIT_VIRGULE_FIXE, h)) vect[1]++ ;
			if (	soufflerie_bas(    yn >> (NB_BIT_VIRGULE_FIXE + 3)	   , xn >> (NB_BIT_VIRGULE_FIXE + 3)	 , xn >> NB_BIT_VIRGULE_FIXE, h)
				||	soufflerie_bas(	   yn >> (NB_BIT_VIRGULE_FIXE + 3)	   ,(xn >> (NB_BIT_VIRGULE_FIXE + 3)) + 1, xn >> NB_BIT_VIRGULE_FIXE, h)) vect[1]-- ;
		}

/***************/		
/*****GHOST*****/
/***************/		
		if(ghost && ghost_i<MAX_GHOST*20 && ghost_i_save<MAX_GHOST*20)
		{
			if(ghost_i<ghost_i_lect)
			{
				GraySprite8_MASK_R(X(ghost_liste_lect[ghost_i].x), Y(ghost_liste_lect[ghost_i].y),8,balle1, balle2,mask, mask, light, light);
				ghost_i++;
			}
			
			ghost_liste_save[ghost_i_save].x = x>>NB_BIT_VIRGULE_FIXE;
			ghost_liste_save[ghost_i_save].y = y>>NB_BIT_VIRGULE_FIXE;
			ghost_i_save++;
			ghost=0;
		}
		else if(ghost_i<ghost_i_lect)
		{
			GraySprite8_MASK_R(X(ghost_liste_lect[ghost_i].x), Y(ghost_liste_lect[ghost_i].y),8,balle1, balle2,mask, mask, light, light);
		}
/***************/		
		
		GraySprite8_MASK_R(X((x>>NB_BIT_VIRGULE_FIXE)), Y((y>>NB_BIT_VIRGULE_FIXE)),8,balle1, balle2,mask, mask, light, dark); //affichage de la balle		
		
		x=xn; y=yn; // actualise les coordonnes de la balle
		
		virtuel2reel(light, dark); //transfert cran virtuel -> cran rel
		
		tour++; tour&=15; //compteur interne
	}
	
	virtuel2reel(light, dark);
	gameover(xn,yn,1);
	goto menujeu;
}



/*** FONCTIONS ***/

inline void presentation()
{
	int i;
	memset(GrayGetPlane (LIGHT_PLANE),0,LCD_SIZE); //efface l'cran
	memset(GrayGetPlane (DARK_PLANE),0,LCD_SIZE); //efface l'cran
 	
	GraySetAMSPlane (DARK_PLANE);
	BitmapPut (X(16), Y(16), &logograv_C0, &(SCR_RECT){{0, 0, 239, 127}}, A_NORMAL); 
	BitmapPut (X(62), Y(80), &bobti89_C0, &(SCR_RECT){{0, 0, 239, 127}}, A_REPLACE); 
  
	GraySetAMSPlane (LIGHT_PLANE);
	BitmapPut (X(17), Y(17), &logograv_C0, &(SCR_RECT){{0, 0, 239, 127}}, A_NORMAL); 
	BitmapPut (X(63), Y(81), &bobti89_C0, &(SCR_RECT){{0, 0, 239, 127}}, A_REPLACE);
	
	for(i = 0 ; i < LEVEL_HEIGHT ; i++) {GrayTile8x8_RPLC_R(0+5*(!TI89),Y(i*8),carre1, carre2,GrayGetPlane (LIGHT_PLANE),GrayGetPlane (DARK_PLANE)); GrayTile8x8_RPLC_R(19+5*(!TI89),Y(i*8),carre1, carre2,GrayGetPlane (LIGHT_PLANE),GrayGetPlane (DARK_PLANE));}
 	for(i = 0 ; i < LEVEL_WIDTH ; i++) 	{GrayTile8x8_RPLC_R(i+5*(!TI89),Y(0),carre1, carre2,GrayGetPlane (LIGHT_PLANE),GrayGetPlane (DARK_PLANE)); GrayTile8x8_RPLC_R(i+5*(!TI89),Y(96),carre1, carre2,GrayGetPlane (LIGHT_PLANE),GrayGetPlane (DARK_PLANE));	}
 	
	while (Counter<3*20 && !_keytest(RR_ENTER) && !_keytest(RR_2ND) && !_keytest(RR_ESC));
	while (_keytest(RR_ENTER) || _keytest(RR_2ND) || _keytest(RR_ESC));
	ClrScr();
}


short gameover( int x, int y, int type )
{
	int countsave = Counter, objet_on1_save = objet_on1, objet_on2_save = objet_on2, i; //sauvegarde du temps
	for (i=0;i<8;i+=2) //animation (balle qui explose)
	{
		GraySprite8_OR_R ((x>>NB_BIT_VIRGULE_FIXE)+40*(!TI89), (y>>NB_BIT_VIRGULE_FIXE)+14*(!TI89), 8, bfin[i], bfin[i+1], GrayGetPlane (LIGHT_PLANE), GrayGetPlane (DARK_PLANE));
		Counter=0; while (Counter < 3);
		GraySprite8_AND_R ((x>>NB_BIT_VIRGULE_FIXE)+40*(!TI89), (y>>NB_BIT_VIRGULE_FIXE)+14*(!TI89), 8, mask, mask, GrayGetPlane (LIGHT_PLANE), GrayGetPlane (DARK_PLANE));
	}
	/*drawbox(35+40*(!TI89),42+14*(!TI89),124+40*(!TI89),58+14*(!TI89)); //affichage de la boite de dialogue
	GraySetAMSPlane (DARK_PLANE);
	DrawStr (45+40*(!TI89), 46+14*(!TI89), s, A_XOR); //affichage du message
	GraySetAMSPlane (LIGHT_PLANE);
	DrawStr (46+40*(!TI89), 47+14*(!TI89), s, A_XOR); //affichage du message*/
	
	if( type == 0 ) //Game over
	{
		draw_center_dialogbox( STR_GAME_OVER, STR_GAME_OVER_KEYS );
	}
	else //Time out
	{
		draw_center_dialogbox( STR_TIME_OUT, STR_TIME_OUT_KEYS );
	}
	
	while (!_keytest(RR_ESC) && !_keytest(RR_ENTER) && !_keytest(RR_2ND));
	if (_keytest(RR_ESC)) {while (_keytest(RR_ESC)); return 0;}
	Counter = countsave ; objet_on1 = objet_on1_save ; objet_on2 = objet_on2_save ; return 1; //remise en route du temps
}
