// C Source File
// Created 24/05/2014; 15:31:21

#include <tigcclib.h>

#include "ghost.h"
#include "global.h"
#include "fonctions.h"

void ghost_hash( unsigned char hash[GHOST_HASH_SIZE+1] )
{
	hash[GHOST_HASH_SIZE] = '\0';
	int i;
	int j = 0;
	int somme = 0;
	for( i = 0 ; i < LEVEL_SIZE ; i++ )
	{
		somme += m[i/LEVEL_WIDTH][i%LEVEL_WIDTH];
		if( i % (LEVEL_SIZE/GHOST_HASH_SIZE) == (LEVEL_SIZE/GHOST_HASH_SIZE)-1 )
		{
			hash[j++] = 'a' + somme % 26;
			somme = 0;
		}
	}
}

void ghost_filename( unsigned char filename[18] )
{
	unsigned char ghost_name[GHOST_HASH_SIZE+1];
	ghost_hash( ghost_name );
	
	strcpy( filename, GHOST_FOLDER );
	strcat( filename, "\\" );
	strcat( filename, ghost_name );
}

int ghost_load( unsigned char name[16], int* score, COORD** coordinates, int* count )
{
	unsigned char filename[18];
	ghost_filename( filename );
	
	char* fptr;
	if( !openReadFile( filename, &fptr ) )
		return FALSE;

	char* ptr = fptr + 2; //Skip size
	
	//Get name
	strcpy( name, ptr );
	ptr += 16;
	
	//Get score
	*score = *(short*)ptr;
	ptr += 2;
	
	//Get ghost coordinates
	*count = *(short*)ptr; //Get number of coordinates
	ptr += 2;
	
	int i;
	for( i = 0 ; i < *count ; i++ )
	{
		(*coordinates)[i].x = *ptr++;
		(*coordinates)[i].y = *ptr++;
	}
	
	return TRUE;
}

int ghost_save( unsigned char name[16], int score, COORD* coordinates, int count )
{
	unsigned char filename[18];
	ghost_filename( filename );
	
	int file_size = 2 + 8 + 16 + 2 + 2*count;
	
	FolderAdd( SYMSTR(GHOST_FOLDER) ); //Create ghost folder if not exist
	
	HSym hsym;
	SYM_ENTRY *SymPtr;
	HANDLE handle;
	char *fptr=fptr;
	hsym = SymFind (SYMSTR (filename));
	SymPtr = DerefSym (hsym);
		
	
	if( SymPtr ) //si le fichier existe
	{
		if(SymPtr->flags.bits.archived)
			EM_moveSymFromExtMem( NULL, hsym ); // desarchive la variable
		handle = HeapRealloc (SymPtr->handle, file_size);
	}
	else
	{
		handle=HeapAlloc(file_size);
		SymPtr=DerefSym(SymAdd(SYMSTR(filename)));
		SymPtr->handle=handle;
	}

	fptr=HeapDeref(SymPtr->handle);
  	
	*(short*)fptr=file_size-2;
	fptr[file_size-6]=0;
	strcpy(fptr+file_size-5,"GHO");
	fptr[file_size-1]=OTH_TAG; 
	
	char* ptr = fptr + 2; //Skip size

	//Set name
	strcpy( ptr, name );
	ptr += 16;
	
	//Set score
	*(short*)ptr = score;
	ptr += 2;
	
	//Set ghost coordinates
	*(short*)ptr = count; //Set number of coordinates
	ptr += 2;
	
	int i;
	for( i = 0 ; i < count ; i++ )
	{
		*ptr++ = coordinates[i].x;
		*ptr++ = coordinates[i].y;
	}
 	return TRUE;
}

