;
; XXXX   XXX  XX  X XX    XXXX  XXXXX XXXX    XXXX   XXX   XXX  XX  X TM
; XX  X XX  X XX  X XX    XX  X XX    XX  X   XX  X XX  X XX  X XX  X
; XX  X XX  X XX  X XX    XX  X XX    XX  X   XX  X XX  X XX    XX  X
; XXXX  XX  X XX  X XX    XX  X XXX   XXXX    XX  X XX  X  XXX  XXXXX
; XX  X XX  X XX  X XX    XX  X XX    XX  X   XX  X XXXXX     X XX  X
; XX  X XX  X XX  X XX    XX  X XX    XX  X   XX  X XX  X XX  X XX  X
; XXXX   XXX   XXX  XXXXX XXXX  XXXXX XX  X   XXXX  XX  X  XXX  XX  X
;
;             v. 1.1b5
;
;   68K ASM SOURCE   - files needed to compile:   bd.asm
;                                                 bd.var
;                                                 bd.gfx
;                                                 macros.h
;                                                 flib.h
;                                                 tios.h
;                                                 gray4lib.h
;
;
;      ------------------------------------------------------------
;
;         CODED BY.....: JIMMY MARDELL aka YARIN <mja@algonet.se>
;         PORTED BY....: SKIP JORDAN             <LGB240@aol.com>
;         TI89 PORT BY.: MIKAEL SUNDBERG         <inzomniac@usa.net>
;         LAST UPDATE..: 98-11-13
;
;      ------------------------------------------------------------
;
;           PLEASE DO NOT MAKE ANY CHANGES WITHOUT TELLING ME!
;
;      ------------------------------------------------------------
;

 include "flib.h"
 include "tios.h"
 include "gray4lib.h"
 include "macros.h"
 xdef   _main
 xdef   _ti89
 xdef   _comment

_main:
 bsr ChooseCave
; jsr    flib::idle_loop ; Why?
 clr.w   score
 move.b  #$03,lives
 move.w  #500,nextEL
 clr.b   graycnt
 bsr Init

StartLevel:
 sf      intflag
 bsr DecodeCave
 bsr ShowLevelInfo
 bsr ShowInfoText
 clr.b   flags
 move.b  #4,delaycnt
MainLoop:
 st      KeyStat
 st      KeyStat+1
 st      intflag

Delay:
 bsr ScanKeys
 tst.w   ticks
 bne Delay
 move.w  #1,ticks
 bsr UpdateCounters
 bsr ScanFrame
 bsr ShowScreen
CheckUpdate:
 btst.b  #2,flags
 beq CheckEnclosedAmoeba
 bsr UpdateInfo
CheckEnclosedAmoeba:
 btst.b  #4,flags
 bne CheckBigAmoeba
 move.b  #$15,amTurn
CheckBigAmoeba:
 move.b  noAmoeba,d0
 cmp.b   #200,d0
 bcs CheckFlash
 move.b  #$11,amTurn
CheckFlash:
 btst.b  #3,flags
 beq CheckTime
 bsr FlashScreen
CheckTime:
 move.b  timeleft,d0
 beq TimeOut
 btst.b  #1,finished
 bne LevelDone
 tst.b   delaycnt
 beq TestKeys
 subq.b  #1,delaycnt
 bra MainLoop

TestKeys:
 clr.b   flags
 bsr ScanKeys
 btst.b  #0,KeyStat+1
 beq IncContrast
 btst.b  #1,KeyStat+1
 beq DecContrast
 btst.b  #1,KeyStat
 beq RestartLevel
 btst.b  #3,KeyStat
 beq PauseGame
 btst.b  #6,keyscan+1
 bne MainLoop
Exit:
 bsr Done
 clr.w   tios::kb_vars+$1C
 bra _main

; --------------------------------
;
;  Scans for new keypresses
;
; --------------------------------

ScanKeys:
 movem.l d0-d2/a0,-(a7)
 lea    keyscan(PC),a0
 clr.l  d0
 move.b  #9,d0
 move.w  #$FFFE,d1
RepScanKeys:
 move.w  d1,($600018)
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 move.b  $60001B,(a0)+
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 rol.w  #1,d1
 dbra   d0,RepScanKeys
 lea    keyscan(PC),a0
 clr.l  d0
 move.b  (a0),d0

 CopyBit 1,0,#1,#4 ; Left       ;DST, ROW, COL(BIT), DST(BIT)
 CopyBit 1,0,#0,#5 ; Up
 CopyBit 1,0,#3,#6 ; Right
 CopyBit 1,0,#2,#7 ; Down

 CopyBit 1,0,#4,#0 ; 2nd

 CopyBit 1,0,#6,#0 ; Diamond
 CopyBit 1,3,#1,#7 ; 2
 CopyBit 1,2,#2,#6 ; 6
 CopyBit 1,3,#2,#7 ; 5
 CopyBit 1,4,#2,#4 ; 4
 CopyBit 1,3,#3,#5 ; 8
 CopyBit 1,5,#1,#3 ; P
 CopyBit 1,0,#7,#3 ; Alpha
 CopyBit 1,6,#0,#1 ; Esc
 CopyBit 1,1,#6,#2 ; Clear
 
 btst.b #6,keyscan
 bne EndScanKeys
 
 CopyBit 2,1,#1,#0 ; +
 CopyBit 2,1,#2,#1 ; -

EndScanKeys:
 movem.l (a7)+,d0-d2/a0
 rts
BitCopy1:
 btst.b  d1,d0
 bne Return
 bclr.b  d2,KeyStat
Return:
 rts
BitCopy2:
 btst.b  d1,d0
 bne Return
 bclr.b  d2,KeyStat+1
 bra Return

; --------------------------------
;
;  Update info
;
; --------------------------------

UpdateInfo:
 SetFont #0
 clr.l   d0
 move.b  dmtaken,d0
 moveq   #3,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 WriteStr #130,#32,#4,strbuf
 move.b  timeleft,d0
 moveq   #3,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 WriteStr #130,#51,#4,strbuf
 move.w  score,d0
 move.w  nextEL,d1
 cmp.w   d1,d0
 bcs NoExtraLife
 add.w   #500,nextEL
 addq.b  #1,lives
NoExtraLife:
 moveq   #5,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 WriteStr #130,#70,#4,strbuf
 move.b  lives,d0
 moveq   #2,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 WriteStr #130,#90,#4,strbuf
 rts

; --------------------------------
;
;  Update counters
;
; --------------------------------

UpdateCounters:
 move.b  flashcnt,d0
 beq GrayCounter
 subq.b  #1,flashcnt
GrayCounter:
 move.b  graycnt,d0
 beq TimeCounter
 subq.b  #1,graycnt
TimeCounter:
 btst.b  #1,finished
 bne Return
 move.b  timecnt,d0
 addq.b  #1,d0
 move.b  d0,timecnt
 cmp.b   #9,d0
 bne Return
 clr.b   timecnt
 subq.b  #1,timeleft
 bset.b  #2,flags
 subq.b  #1,amTime
 bne AmSameSpeed
 move.b  #32,amSpeed
AmSameSpeed:
 move.b  mwactive,d0
 beq Return
 subq.b  #1,mwatime
 bne Return
 clr.b   mwactive
 rts

; --------------------------------
;
;  Flash the screen
;
; --------------------------------

FlashScreen:
 moveq   #3,d4
RepFlash:
 lea     LCD_MEM,a0
 move.l  plane0,a1
 move.l  #959,d0
RepXOR:
 eori.l  #$FFFFFFFF,(a0)+
 eori.l  #$FFFFFFFF,(a1)+
 dbra    d0,RepXOR
WaitVBL:
 tst.w   vbl_phase
 bne WaitVBL
 add.w   #16,vbl_phase
 dbra    d4,RepFlash
 rts

; --------------------------------
;
;  Change contrast
;
; --------------------------------

IncContrast:
 moveq   #9,d0
 trap    #9
 jsr     (a0)
 bra MainLoop
DecContrast:
 moveq   #10,d0
 trap    #9
 jsr     (a0)
 bra MainLoop

; --------------------------------
;
;  Pause
;
; --------------------------------

PauseGame:
 sf      intflag
 bsr ClearScreen
 DrawBox #20,#36,#140,#64
 SetFont #2
 WriteStr #60,#46,#4,PauseText
 clr.w   tios::kb_vars+$1c
 jsr flib::idle_loop
 bsr ClearScreen
 bsr ShowInfoText
 bsr UpdateInfo
 move.b  #5,delaycnt
 bra MainLoop

; --------------------------------
;
;  Out of time!
;
; --------------------------------

TimeOut:
 DrawBox #10,#36,#150,#64
 SetFont #2
 WriteStr #38,#46,#4,OOTText
 clr.w   tios::kb_vars+$1c
 sf      intflag
 jsr flib::idle_loop
 bra RestartLevel

; --------------------------------
;
;  Cave finished!
;
; --------------------------------

LevelDone:
 tst.b   timeleft
 beq EnterNextCave
 subq.b  #1,timeleft
 add.w   #1,score
 bsr UpdateCounters
 bsr ShowScreen
 bsr UpdateInfo
 bra LevelDone

; --------------------------------
;
;  Entering the next cave
;
; --------------------------------

EnterNextCave:
 clr.l   d0
 move.b  curCave,d0
 cmp.b   #16,d0
 bcc IMSucc
 addq.b  #1,d0
 move.b  d0,curCave
 move.l  d0,d1
 and.b   #$03,d0
 bne StartLevel
 lsr.b   #2,d1
 add.b   #15,d1
 move.b  d1,curCave
 bra StartLevel
IMSucc:
 addq.b  #1,lives
 DrawBox #10,#36,#150,#64
 SetFont #2
 WriteStr #41,#46,#4,ELText
 clr.w   tios::kb_vars+$1c
 sf      intflag
 jsr flib::idle_loop
IMPlayed:
 move.b  curCave,d0
 sub.b   #15,d0
 lsl.b   #2,d0
 move.b  d0,curCave
 cmp.b   #16,d0
 bne StartLevel
 clr.b   curCave
 move.b  difLevel,d0
 cmp.b   #4,d0
 beq StartLevel
 addq.b  #1,difLevel
 bra StartLevel

; --------------------------------
;
;  Retry the cave
;
; --------------------------------

RestartLevel:
 sf      intflag
 move.b  curCave,d0
 cmp.b   #16,d0
 bcc IMPlayed
 subq.b  #1,lives
 bne StartLevel
 bra GameOver

; --------------------------------
;
;  Game Over
;
; --------------------------------

GameOver:
 sf      intflag
 DrawBox #10,#36,#150,#64
 SetFont #2
 WriteStr #21,#46,#4,GOText
 clr.w   tios::kb_vars+$1C
 jsr flib::idle_loop
 bra Exit

; --------------------------------
;
;  Scans through the whole cave
;
; --------------------------------

ScanFrame:
 clr.b   noAmoeba
 clr.l   d0
 clr.l   d1
 move.l  cavestart,a0
 move.w  #879,d7
CheckTiles:
 clr.l   d0
 move.b  (a0),d0
 move.b  d0,d1
 move.b  d0,d2
 and.b   #%11111001,d2
 cmp.b   #$10,d2   ; Check if unscanned boulder or jewel
 beq     FallingObj
 and.b   #%11111100,d1
 beq NextTile      ; Space, Dirt, Brick/magic wall? Skip all
 cmp.b   #$07,d0
 beq NextTile      ; Steel wall? Skip all
 cmp.b   #$08,d1
 beq Firefly
 cmp.b   #$30,d1
 beq Butterfly
 cmp.b   #$3A,d0
 beq Amoeba
 cmp.b   #$04,d0
 bne CheckJE4
 btst.b  #0,finished
 beq CheckJE4
 move.b  #$05,(a0)
 bra NextTile
CheckJE4:
 cmp.b   #$1F,d0
 bne CheckSE4
 clr.b   (a0)
 bra NextTile
CheckSE4:
 cmp.b   #$24,d0
 bne CheckEM
 move.b  #$15,(a0)
 bra NextTile
CheckEM:
 cmp.b   #$1B,d0
 bcs CheckRockford
 cmp.b   #$24,d0
 bcc CheckRockford
 addq.b  #1,(a0)
CheckRockford:
 cmp.b   #$38,d0
 beq MoveRockford
CheckPreRFStage:
 cmp.b   #$26,d0
 bcs CheckInbox
 cmp.b   #$29,d0
 bcc NextTile
 addq.b  #1,(a0)
 cmp.b   #$28,d0
 bne NextTile
 move.b  #$38,(a0)
 bra NextTile
CheckInbox:
 cmp.b   #$25,d0
 bne NextTile
 move.b  flashcnt,d2
 bne NextTile
 move.b  #$26,(a0)
NextTile:
 addq.l  #1,a0
NoDisp:
 dbra    d7,CheckTiles
 bsr ShowScreen
 move.l  cavestart,a0
 move.w  #879,d7
RemoveSTF:
 move.b  (a0),d0
 move.b  d0,d1
 and.b   #%11111001,d1
 cmp.b   #$11,d1
 bne CheckRFSTF
 bclr.b  #0,(a0)
CheckRFSTF:
 move.b  d0,d1
 cmp.b   #$39,d1
 bne CheckAmoebaSTF
 move.b  #$38,(a0)
CheckAmoebaSTF:
 cmp.b   #$3B,d0
 bne CheckExplS0
 move.b  #$3A,(a0)
CheckExplS0:
 cmp.b   #$1B,d0
 beq ExpStage0
 cmp.b   #$20,d0
 beq ExpStage0
 and.b   #%11111100,d0
 cmp.b   #$0C,d0
 beq EnemySTF
 cmp.b   #$34,d0
 beq EnemySTF
NextTileSTF:
 addq.l  #1,a0
 dbra    d7,RemoveSTF
 rts
ExpStage0:
 addq.b  #1,(a0)
 bra NextTileSTF
EnemySTF:
 bclr.b  #2,(a0)
 bra NextTileSTF

; --------------------------------
;
;  A boulder or a jewel is found
;
; --------------------------------

FallingObj:
 cmp.w   #40,d7
 bcs NextTile
 move.b  40(a0),d1
 bne FO_NoFallDown
 ori.b   #$03,d0
 move.b  d0,40(a0)
 clr.b   (a0)
 bra NextTile
FO_NoFallDown:
 move.b  d1,d2
 cmp.b   #$03,d1
 beq MWBelow
 cmp.b   #$02,d1
 beq CheckDiagFall
 and.b   #%11111010,d1
 cmp.b   #$10,d1
 beq CheckDiagFall
 btst.b  #1,d0
 beq NextTile
 bclr.b  #0,d2
 cmp.b   #$38,d2
 beq MakeSpcExpl
 and.b   #%11111000,d2
 cmp.b   #$08,d2
 beq MakeSpcExpl
 cmp.b   #$30,d2
 bne MakeStationary
 move.b  #$20,d0
 bra MakeExpl
MakeSpcExpl:
 move.b  #$1B,d0
MakeExpl:
 lea     40(a0),a1
 bsr Explode
 bra NextTile
MakeStationary:
 bclr.b  #1,(a0)
 bra NextTile
CheckDiagFall:
 or.b    #%00000011,d0
 move.b  -1(a0),d1
 bne CheckDiagFallR
 move.b  39(a0),d1
 bne CheckDiagFallR
 move.b  d0,-1(a0)
 move.b  #0,(a0)
 bra NextTile
CheckDiagFallR:
 move.b  1(a0),d1
 bne MakeStationary
 move.b  41(a0),d1
 bne MakeStationary
 move.b  d0,1(a0)
 move.b  #0,(a0)
 bra NextTile
MWBelow:
 btst.b  #1,d0
 beq NextTile
 tst.b   (mwatime)
 beq ClearAbove
 move.b  #1,mwactive
 move.b  80(a0),d1
 bne ClearAbove
 ori.b   #$03,d0
 eori.b  #$04,d0
 move.b  d0,80(a0)
ClearAbove:
 clr.b   (a0)
 bra NextTile

; --------------------------------
;
;  Moving a Firefly
;
; --------------------------------

Firefly:
 bsr CheckSur
 beq FFExplode
 and.b  #%00000011,d0
 lea    EnemyTable(PC),a1
 move.b 0(a1,d0),d2
 ext.w  d2
 ext.l  d2
 move.b 1(a1,d0),d3
 ext.w  d3
 ext.l  d3
 subq.b #1,d0
 move.l a0,a2
 adda.l d2,a2
 move.b (a2),d4
 beq MoveFF
 addq.b #1,d0
 move.l a0,a2
 adda.l d3,a2
 move.b (a2),d4
 beq MoveFF
 addq.b #1,d0
 and.b  #$03,d0
 or.b   #$0C,d0
 move.b d0,(a0)
 bra NextTile
MoveFF:
 and.b  #$03,d0
 or.b   #$0C,d0
 move.b d0,(a2)
 clr.b  (a0)
 bra NextTile
FFExplode:
 move.l a0,a1
 move.b #$1B,d0
 bsr Explode
 bra NextTile

; --------------------------------
;
;  Moving a Butterfly
;
; --------------------------------

Butterfly:
 bsr CheckSur
 beq BFExplode
 and.b  #%00000011,d0
 lea    EnemyTable+1(PC),a1
 move.b 0(a1,d0),d2
 ext.w  d2
 ext.l  d2
 move.b -1(a1,d0),d3
 ext.w  d3
 ext.l  d3
 addq.b #1,d0
 move.l a0,a2
 adda.l d2,a2
 move.b (a2),d4
 beq MoveBF
 subq.b #1,d0
 move.l a0,a2
 adda.l d3,a2
 move.b (a2),d4
 beq MoveBF
 subq.b #1,d0
 and.b  #$03,d0
 or.b   #$34,d0
 move.b d0,(a0)
 bra NextTile
MoveBF:
 and.b  #$03,d0
 or.b   #$34,d0
 move.b d0,(a2)
 clr.b  (a0)
 bra NextTile
BFExplode:
 move.l a0,a1
 move.b #$20,d0
 bsr Explode
 bra NextTile

; --------------------------------
;
;  Amoeba found
;
; --------------------------------

Amoeba:
 move.b  amTurn,d1
 beq NoAmTurn
 move.b  d1,(a0)
 bra NextTile
NoAmTurn:
 addq.b  #1,noAmoeba
 btst.b  #4,flags
 bne AmCanMove
 lea     EnemyTable(PC),a1
 moveq   #3,d2
CheckEnclosed:
 move.b  (a1)+,d1
 ext.w   d1
 ext.l   d1
 move.b  0(a0,d1),d1
 and.b   #$FE,d1
 bne A_NextDir
 bset.b  #4,flags
A_NextDir:
 dbra    d2,CheckEnclosed
AmCanMove:
 clr.l   d1
 move.b  amSpeed,d1
 clr.l   d0
 move.b  #128,d0
 jsr flib::random
 cmp.b   d1,d0
 bcc NextTile
 and.b   #$03,d0
 lea     EnemyTable(PC),a1
 move.b  0(a1,d0),d0
 ext.w   d0
 ext.l   d0
 move.b  0(a0,d0),d1
 and.b   #$FE,d1
 bne NextTile
 move.b  #$3B,0(a0,d0)
 bra NextTile

; --------------------------------
;
;  Rockford is found
;
; --------------------------------

MoveRockford:
 clr.l   d2
 clr.l   d3
 move.l  a0,a1
 move.l  a0,a2
 bclr.b  #3,(RFMove)
 bset.b  #0,(flags)
 bsr ScanKeys
 move.b  KeyStat,d0
 move.b  d0,d1
 or.b    #%00011111,KeyStat
 btst.b  #4,d0 ;#4
 beq MoveLeft
 btst.b  #6,d0 ;#6
 beq MoveRight
 btst.b  #5,d0 ;#5
 beq MoveUp
 btst.b  #7,d0 ;#7
 beq MoveDown
 bra NextTile
MoveLeft:
 bclr.b  #4,RFMove
 subq    #1,a1
 subq    #2,a2
 move.b  #-1,d2
 bra HorzMove
MoveRight:
 bset.b  #4,RFMove
 addq    #1,a1
 addq    #2,a2
 moveq   #1,d2
HorzMove:
 bset.b  #3,RFMove
 bset.b  #1,flags
 move.b  (a1),d0
 bclr.b  #0,d0
 cmp.b   #$10,d0
 bne CheckMove
 move.b  (a2),d0
 bne NextTile
 moveq   #4,d0
 jsr flib::random
 or.b    d0,d0
 bne NextTile
 move.b  #$11,(a2)
 bra MoveOK
MoveUp:
 bset.b  #3,RFMove
 lea     -40(a1),a1
 move.b  #-1,d3
 bra CheckMove
MoveDown:
 bset.b  #3,RFMove
 lea     40(a1),a1
 moveq   #1,d3
CheckMove:
 bset.b  #1,flags
 move.b  (a1),d0
 cmp.b   #$05,d0
 beq MoveToOutBox
 bclr.b  #0,d0
 or.b    d0,d0
 beq MoveOK
 bclr.b  #1,d0
 cmp.b   #$14,d0
 bne NextTile
 clr.l   d0
 move.b  dmscore1,d0
 btst.b  #0,finished
 beq NoBonus
 move.b  dmscore1+1,d0
NoBonus:
 add.w   d0,score
 addq.b  #1,dmtaken
 move.b  dmtaken,d0 
 cmp.b   dmneeded,d0
 bne NotLastJewel
 bset.b  #0,finished
 bset.b  #3,flags
NotLastJewel:
 bset.b  #2,flags
MoveOK:
 clr.b   (a1)
 btst.b  #0,d1
 beq NextTile
 clr.b   (a0)
 move.b  #$39,(a1)
 add.b   d2,rockfordX
 add.b   d3,rockfordY
 bra NextTile
MoveToOutBox:
 bset.b  #1,finished
 bra MoveOK

; --------------------------------
;
;  Check the surrounding areas
;
;  IN:  A0 - centre square
;  OUT: ZF - explode
;
; --------------------------------

CheckSur:
 movem.l d0-d1/a1,-(a7)
 lea     EnemyTable(PC),a1
 moveq   #3,d0
CS_RepScan:
 move.b  (a1)+,d1
 ext.w   d1
 ext.l   d1
 move.b  0(a0,d1),d1
 cmp.b   #$3A,d1
 beq CS_Found
 bclr.b  #0,d1
 cmp.b   #$38,d1
 beq CS_Found
 dbra    d0,CS_RepScan
CS_Found:
 movem.l (a7)+,d0-d1/a1
 rts

; --------------------------------
;
;  Creates an explosion
;
;  IN:  a1 - Explosion centre
;       d0 - Object to fill with
;
; --------------------------------

Explode:
 movem.l d1/a1,-(a7)
 lea     -41(a1),a1
 moveq   #2,d1
RepPutExpl:
 bsr E_CheckSq
 addq.l  #1,a1
 bsr E_CheckSq
 addq.l  #1,a1
 bsr E_CheckSq
 lea     38(a1),a1
 dbra    d1,RepPutExpl
 movem.l (a7)+,d1/a1
 rts
E_CheckSq:
 move.b  (a1),d2
 cmp.b   #$07,d2
 beq     Return
 move.b  d0,(a1)
 rts

; --------------------------------
;
;  Shows the cave
;
; --------------------------------

ShowScreen:
 movem.l d0-d7/a0-a2,-(a7)
 clr.l   d4
 clr.l   d5
 move.b  rockfordX,d4
 move.b  rockfordY,d5
 moveq   #$24,d6 ;22
 moveq   #$15,d7 ;14
 cmp.b   #$04,d4
 bcc LeftEdgeOK
 moveq   #$04,d4
LeftEdgeOK:
 cmp.b   d6,d4
 bcs RightEdgeOK
 move.b  d6,d4
RightEdgeOK:
 cmp.b   #$05,d5
 bcc TopEdgeOK
 move.b  #$05,d5
TopEdgeOK:
 cmp.b   d7,d5
 bcs BotEdgeOK
 move.b  d7,d5
BotEdgeOK:
 sub.b   #4,d4
 sub.b   #3,d5
 lea     SpriteTable(PC),a2
 clr.l   d0            ; d0 = xscr
 clr.l   d1            ; d1 = yscr
 move.l  cave,a1
 move.l  d5,d6
 mulu    #40,d6
 add.l   d4,d6
 adda.l  d6,a1         ; a1 = ptr to first square to put
 moveq   #5,d7         ; d7 = y loop
 moveq   #7,d6        ; d6 = x loop
SS_NextY:
 movem.l d6/a1,-(a7)
SS_NextX:
 clr.l   d3
 move.b  animcnt,d3
 clr.l   d2
 move.b  (a1)+,d2      ; d2 = item no to put
 cmp.b   #$03,d2       ; Check if magic wall
 beq CheckMWActive
GetSprite:
 move.b  0(a2,d2),d2   ; Get sprite to put
 cmp.b   #$07,d2       ; Check if diamond
 beq Anim8
 cmp.b   #$22,d2       ; Check if firefly
 beq Anim4
 cmp.b   #$2F,d2       ; Check if amoeba/slime
 beq Anim4
 cmp.b   #$26,d2       ; Check if butterfly
 beq AnimButterfly
 cmp.b   #$04,d2       ; Check if inbox/flashing outbox
 beq AnimInbox
 cmp.b   #$0F,d2       ; Check if Rockford
 beq AnimRockford
PutIt:
 lea     Sprites(PC),a0
 lsl.l   #6,d2
 adda.l  d2,a0
 bsr PutSprite
 add.b   #1,d0
 dbra    d6,SS_NextX
 movem.l (a7)+,d6/a1
 lea     40(a1),a1
 add.b   #1,d1
 clr.l   d0
 dbra    d7,SS_NextY
 addq.b  #1,animcnt
 movem.l (a7)+,d0-d7/a0-a2
 rts
CheckMWActive:
 move.b  mwactive,d4
 beq GetSprite
 moveq   #$2B,d2
Anim4:
 lsr.b   #1,d3
 and.b   #$03,d3
 add.b   d3,d2
 bra PutIt
Anim8:
 and.b   #$07,d3
 add.b   d3,d2
 bra PutIt
AnimButterfly:
 lsr.b   #1,d3
 and.b   #$07,d3
 lea     ButAnim(PC),a0
 add.b   0(a0,d3),d2
 bra PutIt
AnimInbox:
 lsr.b   #2,d3
 and.b   #$01,d3
 sub.b   d3,d2
 bra PutIt

AnimRockford:
 move.l  d0,d4
 and.b   #$07,d3
 bne SameAnim
 moveq   #$10,d0
 jsr flib::random
 or.b    d0,d0
 bne NoTapChange
 bchg.b  #1,RFMove
NoTapChange:
 bclr.b  #0,RFMove
 moveq   #$08,d0
 jsr flib::random
 or.b    d0,d0
 bne SameAnim
 bset.b  #0,RFMove
SameAnim:
 move.l  d4,d0
 btst.b  #3,RFMove
 beq RF_FaceForward
 and.b   #%11111100,RFMove
 moveq   #$15,d2
 btst.b  #4,RFMove
 beq MovingLeft
 moveq   #$32,d2
MovingLeft:
 add.b   d3,d2
 or.b    d3,d3
 bne PutIt
 addq.b  #1,d2
 bra PutIt
RF_FaceForward:
 move.b  RFMove,d4
 and.b   #%00000011,d4
 beq PutIt
 subq.b  #1,d4
 lsl.b   #3,d4
 lea     BlinkAnim(PC),a3
 adda.l  d4,a3
 add.b   0(a3,d3),d2
 bra PutIt

; --------------------------------
;
;  Puts a 16x16 sprite (grayscale)
;
;  IN:  a0 - Pointer to sprite
;       d0 - x coord
;       d1 - y coord
;
;  OUT: -
;
; --------------------------------

PutSprite:
 movem.l d0-d2/a0-a2,-(a7)
 lsl.w   #1,d0
 lsl.w   #5,d1
 move.l  d1,d2
 lsl.w   #4,d2
 sub.w   d1,d2
 add.w   d0,d2
 lea     LCD_MEM,a1
 move.l  plane0,a2
 adda.w  d2,a1
 adda.l  d2,a2
 moveq   #3,d0
PS_NewRow:
 move.w  (a0)+,(a1)
 move.w  (a0)+,(a2)
 move.w  (a0)+,30(a1)
 move.w  (a0)+,30(a2)
 move.w  (a0)+,60(a1)
 move.w  (a0)+,60(a2)
 move.w  (a0)+,90(a1)
 move.w  (a0)+,90(a2)
 lea     120(a1),a1
 lea     120(a2),a2
 dbra    d0,PS_NewRow
 movem.l (a7)+,d0-d2/a0-a2
 rts

; --------------------------------
;
;  Show info text
;
; --------------------------------

ShowInfoText:
 SetFont #0
 clr.l   d0
 WriteStr #130,#1,#4,CaveStr
 move.b  curCave,d0
 add.b   #65,d0
 WriteChar #154,#1,#4,d0
 WriteStr #130,#13,#4,LevelStr
 move.b  difLevel,d0
 add.b   #49,d0
 WriteChar #154,#13,#4,d0
 WriteChar #142,#32,#4,#47
 move.b  dmneeded,d0
 moveq   #3,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 WriteStr #146,#32,#4,strbuf
 SetFont #0
 WriteStr #130,#25,#4,JewelStr
 WriteStr #130,#44,#4,TimeStr
 WriteStr #130,#64,#4,ScoreStr
 WriteStr #130,#82,#4,LivesStr
 bsr UpdateInfo
 rts

; --------------------------------
;
;  Converts a number to a string
;
;   IN:  d0  - The number
;        d1  - Number of digits
;        a0  - Pointer to string
;   OUT: *a0 - The string (null-terminated)
;
; --------------------------------

ConvStr:
 adda.l  d1,a0
 clr.b   (a0)   
 subq.b  #1,d1
RepConv:
 divu    #10,d0
 move.l  d0,d2
 lsr.l   #8,d2
 lsr.l   #8,d2
 add.b   #48,d2
 move.b  d2,-(a0)
 and.l   #$FFFF,d0
 dbra    d1,RepConv
 rts


; --------------------------------
;
;  Gets the next "random" number
;
; --------------------------------

NextRandom:
 movem.l d0-d3,-(a7)
 move.b  randseed1,d0
 lsl.b   #7,d0
 move.b  d0,d1
 move.b  randseed2,d0
 move.b  d0,d3
 lsr.b   #1,d0
 move.b  d0,d2
 move.b  d3,d0
 lsl.b   #7,d0
 add.b   d3,d0
 moveq   #$13,d3
 addx.b  d3,d0
 move.b  d0,randseed2
 move.b  randseed1,d0
 addx.b  d1,d0
 addx.b  d2,d0
 move.b  d0,randseed1
 movem.l (a7)+,d0-d3
 rts

; --------------------------------
;
;  Decodes a cave into the cave
;  handle
;
;  IN:  curCave  - cave to decode
;       difLevel - dif level
;
; --------------------------------

DecodeCave:
 clr.l   d0
 lea     timecnt(PC),a0
 moveq   #7,d1
DC_RepClr:
 move.b  d0,(a0)+
 dbra    d1,DC_RepClr
 clr.l   d1
 move.l  (CurSet),a0
 move.b  curCave,d0
 beq CaveFound
 subq    #1,d0
SearchCaveStart:
 move.w  (a0),d1
 adda.l  d1,a0
 dbra    d0,SearchCaveStart
CaveFound:
 clr.l   d0
 lea     3(a0),a0
 move.b  (a0),d0
 move.b  (a0)+,mwatime
 move.b  (a0)+,dmscore1
 move.b  (a0)+,dmscore1+1
 move.b  d0,amTime
 move.l  a0,a1
 move.b  difLevel,d0
 lea     0(a0,d0),a0
 move.b  (a0),randseed2
 lea     5(a0),a0
 move.b  (a0),dmneeded
 lea     5(a0),a0
 move.b  (a0),timeleft
 lea     20(a1),a0
 move.b  timeleft,d0
 move.l  (a0)+,randobj
 move.l  (a0)+,probobj
 moveq   #0,d4
 moveq   #3,d5
ScatNext:
 bsr NextRandom
 moveq   #1,d2
 moveq   #3,d3
 lea     probobj(PC),a1
 move.b  randseed1,d0
CheckProb:
 cmp.b   (a1)+,d0
 bcc NotLesser
 move.b  -5(a1),d2
NotLesser:
 dbra    d3,CheckProb
 move.b  d2,d0
 bsr StoreObject
 add.b   #1,d4
 cmp.b   #40,d4
 bcs ScatNext
 moveq   #0,d4
 add.b   #1,d5
 cmp.b   #24,d5
 bcs ScatNext
 moveq   #7,d0
 moveq   #0,d4
 moveq   #2,d5
 moveq   #40,d6
 moveq   #22,d7
 bsr DrawRect
ReadCaveData:
 move.b  (a0)+,d0
 move.b  (a0)+,d4
 move.b  (a0)+,d5
 move.b  (a0),d6
 move.b  1(a0),d7
 move.b  2(a0),d3
 cmp.b   #$FF,d0
 beq CaveEnd
 move.b  d0,d1
 and.b   #$3F,d0
 lsr.b   #6,d1
 beq StoObj
 sub.b   #1,d1
 beq DrLine
 sub.b   #1,d1
 beq FillRec
DrRec:
 lea     2(a0),a0
 bsr DrawRect
 bra ReadCaveData
StoObj:
 bsr StoreObject
 cmp.b   #$25,d0
 bne ReadCaveData
 move.b  d4,rockfordX
 move.b  d5,rockfordY
 bra ReadCaveData
DrLine:
 lea     2(a0),a0
 bsr DrawLine
 bra ReadCaveData
FillRec:
 lea     3(a0),a0
 bsr DrawFillRect
 bra ReadCaveData
CaveEnd:
 move.b  #10,flashcnt
 move.b  #4,amSpeed
 rts

; --------------------------------
;
;  Stores an object in the cave
;
;  IN:  d0 - Object number
;       d4 - x
;       d5 - y
;
; --------------------------------

StoreObject:
 movem.l d5/a0,-(a7)
 move.l  cave,a0
 mulu    #40,d5
 add.l   d4,d5
 cmp.w   #$03C0,d5
 bcc Out
 cmp.w   #$0000,d5
 bcs Out
 move.b  d0,0(a0,d5)
Out:
 movem.l (a7)+,d5/a0
 rts

; --------------------------------
;
;  Draws a line in the cave
;
;  IN:  d0 - Object
;       d4 - Start X
;       d5 - Start Y
;       d6 - Length
;       d7 - Direction
;
; --------------------------------

DrawLine:
 movem.l d4-d6,-(a7)
 lea     DirTable(PC),a4
 sub.b   #1,d6
DL_Plot:
 bsr StoreObject
 add.b   0(a4,d7),d4
 add.b   8(a4,d7),d5
 dbra    d6,DL_Plot
 movem.l (a7)+,d4-d6
 rts

; --------------------------------
;
;  Draws a rectangle in the cave
;
;  IN:  d0 - Border
;       d4 - Start X
;       d5 - Start Y
;       d6 - Length X
;       d7 - Length Y
;
; --------------------------------

DrawRect:
 movem.l d0-d7,-(a7)
 move.b  d6,d1
 move.b  d7,d2
 move.b  d4,d3
 moveq   #2,d7
 bsr DrawLine
 move.b  d2,d6
 moveq   #4,d7
 bsr DrawLine
 add.b   d1,d4
 sub.b   #1,d4
 bsr DrawLine
 move.b  d3,d4
 add.b   d2,d5
 sub.b   #1,d5
 move.b  d1,d6
 moveq   #2,d7
 bsr DrawLine
 movem.l (a7)+,d0-d7
 rts

; --------------------------------
;
;  Draws a filled rectangle in the cave
;
;  IN:  d0 - Border
;       d3 - Object to fill with
;       d4 - Start X
;       d5 - Start Y
;       d6 - Length X
;       d7 - Length Y
;
; --------------------------------

DrawFillRect:
 bsr DrawRect
 move.b  d3,d0
RepDFR:
 add.b   #1,d4
 add.b   #1,d5
 sub.b   #2,d6
 ble Return
 sub.b   #2,d7
 ble Return
 bsr DrawRect
 bra RepDFR
 rts

; --------------------------------
;
;  Clear screen (grayscale)
;
; --------------------------------

ClearScreen:
 movem.l d0-d1/a0-a1,-(a7)
 clr.l   d0
 move.l  #959,d1
 move.l  plane0,a0
 move.l  #LCD_MEM,a1
RepClr:
 move.l  d0,(a0)+
 move.l  d0,(a1)+
 dbra    d1,RepClr
 movem.l (a7)+,d0-d1/a0-a1
 rts

; --------------------------------
;
;  Show info about the current level
;
; --------------------------------

ShowLevelInfo:
 bsr ClearScreen
 SetFont #2
 move.l  (CurSet+4),a5
 move.b  curCave,d0
 move.b  d0,d4
 beq DescFound
 cmp.b   #16,d0
 bcs SearchDesc
 WriteStr #25,#10,#4,IMText
 add.b   #33,d4
 WriteChar #125,#10,#4,d4
 bra ShowCaveDat
SearchDesc:
 subq.b  #1,d0
 clr.l   d1
RepSearchDesc:
 move.b  (a5)+,d1
 adda.l  d1,a5
 dbra    d0,RepSearchDesc
DescFound:
 add.b   #65,d4
 move.b  (a5)+,d1
 move.b  (a5)+,d1
 clr.l   d3
 move.b  #81,d3
 sub.b   d1,d3
 WriteStr #57,#10,#4,CaveStr
 WriteChar #100,#10,#4,d4
 SetFont #0
 move.w  #4,-(a7)
 move.l  a5,-(a7)
 move.w  #25,-(a7)
 move.w  d3,-(a7)
 jsr tios::DrawStrXY
 lea     10(a7),a7
ShowCaveDat:
 DrawBox #20,#35,#140,#85
 SetFont #0
 WriteStr #25,#40,#4,LevelStr
 WriteStr #25,#48,#4,Time2Str
 WriteStr #25,#56,#4,JewNStr
 WriteStr #25,#64,#4,LivesStr
 clr.l   d0
 move.b  difLevel,d0
 add.b   #49,d0
 WriteChar #131,#40,#4,d0
 move.b  timeleft,d0
 moveq   #3,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 bsr ClearZeros
 WriteStr #123,#48,#4,strbuf
 move.b  dmneeded,d0
 moveq   #3,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 bsr ClearZeros
 WriteStr #125,#56,#4,strbuf
 move.b  lives,d0
 moveq   #2,d1
 lea     strbuf(PC),a0
 bsr ConvStr
 bsr ClearZeros
 WriteStr #129,#64,#4,strbuf
 move.b  curCave,d0
 lea     GetReadyText(PC),a0
 moveq   #43,d1
 cmp.b   #16,d0
 bcs NoBonusTry
 lea     BTText(PC),a0
 moveq   #43,d1
NoBonusTry:
 move.w  #4,-(a7)
 move.l  a0,-(a7)
 move.w  #76,-(a7)
 move.w  d1,-(a7)
 jsr tios::DrawStrXY
 lea     10(a7),a7
 clr.w   tios::kb_vars+$1c
 jsr flib::idle_loop
 move.b  #5,delaycnt
 bsr ClearScreen
 rts
ClearZeros:
 move.b  (a0),d0
 cmp.b   #48,d0
 bne Return
 move.b  #32,(a0)+
 bra ClearZeros

; --------------------------------
;
;  Start menu - choose cave
;
; --------------------------------

ChooseCave:
 jsr flib::clr_scr
 SetFont #2
 WriteStr #14,#7,#1,_comment
 SetFont #0
 WriteStr #16,#60,#4,InfoText
 WriteStr #9,#70,#4,PorterText
 WriteStr #20,#77,#4,Porter2NText
 WriteStr #43,#84,#4,Porter2EText
 SetFont #1
 WriteStr #51,#27,#4,CaveSetStr
 WriteStr #26,#42,#4,CaveStr
 WriteStr #94,#42,#4,LevelStr
 clr.l   d4
 clr.l   d6
 clr.l   d7
RepCC:
 cmp.b   #3,d6
 bcs LowLevel
 clr.l   d4
LowLevel:
 moveq   #65,d5
 add.b   d4,d5
 WriteChar #61,#42,#4,d5
 moveq   #49,d5
 add.b   d6,d5
 WriteChar #133,#42,#4,d5
 moveq   #49,d5
 add.b   d7,d5
 WriteChar #103,#27,#4,d5
 clr.w   (tios::kb_vars+$1C)
WaitKey:
 jsr flib::idle_loop
 cmp.w   #338,d0
 beq CaveDec
 cmp.w   #344,d0
 beq CaveInc
 cmp.w   #337,d0
 beq LevelInc
 cmp.w   #340,d0
 beq LevelDec
 cmp.w   #266,d0
 beq CaveSetInc
 cmp.w   #264,d0
 beq Quit
 cmp.w   #263,d0
 beq Quit
 cmp.w   #13,d0
 bne WaitKey
 move.b  d4,curCave
 move.b  d6,difLevel
 lea     Caves(PC),a0
 lsl.w   #3,d7
 move.l  0(a0,d7),(CurSet)
 move.l  4(a0,d7),(CurSet+4)
 rts
Quit:
 lea     4(a7),a7
 rts
CaveDec:
 subq.b  #4,d4
 bcc RepCC
 clr.l   d4
 bra RepCC
CaveInc:
 addq.b  #4,d4
 cmp.b   #16,d4
 bcs RepCC
 moveq   #12,d4
 bra RepCC
LevelInc:
 addq.b  #1,d6
 cmp.b   #5,d6
 bcs RepCC
 moveq   #4,d6
 bra RepCC
LevelDec:
 subq.b  #1,d6
 bcc RepCC
 clr.l   d6
 bra RepCC
CaveSetInc:
 addq.b  #1,d7
 cmp.b   #2,d7
 bcs RepCC
 clr.l   d7
 bra RepCC

; --------------------------------
;
;  Interrupt handler - counting interrups
;
; --------------------------------

int_1:
 add.w   #1,vbl_phase
 and.w   #15,vbl_phase
 tst.w   ticks
 beq     noticking
 add.w   #1,ticks
 and.w   #63,ticks
noticking:
 tst.b   (intflag)
 bne EndInt
 move.l  old_int_1,-(a7)
 rts
EndInt:
 rte

; --------------------------------
;
;  Turn grayscale off
;
; --------------------------------

TurnGSOff:
 movem.l d0-d1/a0-a1/a6,-(a7)
 jsr gray4lib::off
 move.l  #$F08,-(a7)
 jsr     tios::HeapAlloc
 add.l   #$04,a7
 move.w  d0,dummy_h
 tios::DEREF d0,a6
 move.l  a6,plane0
 move.b  #2,graycnt
 movem.l (a7)+,d0-d1/a0-a1/a6
 rts

; --------------------------------
;
;  Turn grayscale on
;
; --------------------------------

TurnGSOn:
 movem.l d0-d1/a0-a1/a6,-(a7)
 move.w  dummy_h(pc),-(a7)
 jsr     tios::HeapFree
 add.l   #$02,a7
 jsr gray4lib::on
 move.l gray4lib::plane0,plane0
 move.b  #2,graycnt
 clr.l   d0
 move.l  #959,d1
RepClr0:
 move.l  d0,(a6)+
 dbra    d1,RepClr0
 movem.l (a7)+,d0-d1/a0-a1/a6
 rts

; --------------------------------
;
;  Initialize grayscale and handles
;
; --------------------------------

Init:
 move.w #$700,d0
 trap   #1
 move.l d0,oldmask
 bclr.b #2,$600001
 move.l $64,old_int_1
 move.l #int_1,$64
 bset.b #2,$600001
 move.l oldmask,d0
 trap   #1
 move.l  #$03C0,-(a7)
 jsr     tios::HeapAlloc
 add.l   #$04,a7
 move.w  d0,cave_h
 tios::DEREF d0,a0
 move.l  a0,cave
 lea     80(a0),a0
 move.l  a0,cavestart
 jsr gray4lib::on
 move.l gray4lib::plane0,plane0
 bsr ClearScreen
 btst.b  #0,Grayscale
 beq TurnGSOff
 rts

; --------------------------------
;
;  Remove grayscale and handles
;
; --------------------------------

Done:
 sf      intflag
 btst.b  #0,Grayscale
 beq AlreadyOff
 bsr TurnGSOff
AlreadyOff:
 move.w  dummy_h(pc),-(a7)
 jsr     tios::HeapFree
 add.l  #2,a7
 move.w  cave_h(pc),-(a7)
 jsr     tios::HeapFree
 add.l   #2,a7
 move.w #$700,d0
 trap   #1
 bclr.b  #2,$600001
 move.l old_int_1,$64
 bset.b #2,$600001
 trap   #1
 rts
 
; --------------------------------
;
;  All cavesets - label Caves
;
; --------------------------------

Caves:
 dc.l CaveSet1,CaveDesc1,CaveSet2,CaveDesc2

CaveSet1:
 incbin bd1caves.bin

CaveDesc1:
 dc.b 7,10,"Intro",0
 dc.b 7,10,"Rooms",0
 dc.b 6,9,"Maze",0
 dc.b 13,17,"Butterflies",0
 dc.b 8,11,"Guards",0
 dc.b 14,20,"Firefly dens",0
 dc.b 8,22,"Amoeba",0
 dc.b 16,25,"Enchanted wall",0
 dc.b 7,10,"Greed",0
 dc.b 8,11,"Tracks",0
 dc.b 7,10,"Crowd",0
 dc.b 7,9,"Walls",0
 dc.b 12,18,"Apocalypse",0
 dc.b 8,11,"Zigzag",0
 dc.b 8,11,"Tunnel",0
 dc.b 17,26,"Enchanted boxes",0,0

CaveSet2:
 incbin bd3caves.bin

CaveDesc2:
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0
 dc.b 3,3,"?",0

CurSet:    ; Ptr to the cave data and the cave desc for the current cave set
 dc.l 0,0

; --------------------------------
;
;  All graphics - label Sprite
;
; --------------------------------

 include bd.gfx

; --------------------------------
;
;  Variables & Constants
;
; --------------------------------

 include bd.var

oldmask dc.l    0
_comment     dc.b "BoulderDash 1.15",0

 end
