; ******************************************************************
;
; 			Sprite-Aux-Fer3C header file
;
; ******************************************************************


; ******************************************************************
;
; D6-D7 and A5-A7 are 'global variables' for a sprite
; If you change them, be careful !
; d6.w = X_Fernando
; d7.w = Y_Fernando
; a5.l = Current sprite (at the end of the sprite, a5 must point to the next sprite)
; a6.l = $600000 (I/O)
; a7.l = Stack
;
; ******************************************************************


; ******************************************************************
;
; Start Fernando 3-C
; Entry : a0 -> dc.w NumberOfLevels
;		ds.b Packed World
; Return : nothing
; Destroy : all registers
; ******************************************************************

fer3c::Start		EQU	fer3c@0000

; ******************************************************************
;
; 	Global variables of fer3c
;
; ******************************************************************

fer3c::Variable		EQU	fer3c@0001

; ******************************************************************
;
; Adress of the current screen
;
; ******************************************************************
fer3c::Screen		EQU	fer3c@0001+4

; ******************************************************************
;
; Adress of the virtual-screen
;
; ******************************************************************
fer3c::VirtualScreenADR	EQU	fer3c@0001+0

; ******************************************************************
;
; Adress of the Level-Graph-File
;
; ******************************************************************
fer3c::LevelADR		EQU	fer3c@0001+14

; ******************************************************************
;
; Adress of the level-Test-File
;
; ******************************************************************
fer3c::LevelTestADR	EQU	fer3c@0001+18

; ******************************************************************
;
; Adress of the sprite-buffer (and the end)
;
; ******************************************************************
fer3c::SpriteADR	EQU	fer3c@0001+22
fer3c::SpriteEndADR	EQU	fer3c@0001+26

; ******************************************************************
;
;	Adress of the GraphFile
;
; ******************************************************************
fer3c::GraphADR		EQU	fer3c@0001+30

; ******************************************************************
;
; Current-Time : usefull to synchronize
;
; ******************************************************************
fer3c::Time		EQU	fer3c@0001+54

; ******************************************************************
;
; X_Scrolling and Y_Scrolling
;
; ******************************************************************
fer3c::Xs		EQU	fer3c@0001+42
fer3c::Ys		EQU	fer3c@0001+44


; ******************************************************************
;
; Adress of Init and Exec Add-On.
;
; ******************************************************************
fer3c::InitAddOnADR	EQU	fer3c@0001+60
fer3c::ExecAddOnADR	EQU	fer3c@0001+56

; ******************************************************************
;
; TURBO MODE : 1 or 2
;
; ******************************************************************
fer3c::Turbo		EQU	fer3c@0001+64

; ******************************************************************
;
; 	Number of players
;
; ******************************************************************
fer3c::Nbr_Player	EQU	fer3c@0001+66

; ******************************************************************
;
; Fernando global data
;
; ******************************************************************
fer3c::Power		EQU	fer3c@0001+74
fer3c::Coins		EQU	fer3c@0001+76
fer3c::Life		EQU	fer3c@0001+72
fer3c::Keys		EQU	fer3c@0001+70
fer3c::Switch		EQU	fer3c@0001+68
fer3c::Plan		EQU	fer3c@0001+69
fer3c::Inv		EQU	fer3c@0001+78
fer3c::Statut		EQU	fer3c@0001+13

; ******************************************************************
;
; Key Board access
;
; ******************************************************************
fer3c::KeyStat		EQU	fer3c@0010

; ******************************************************************
;
; Init one sprite
; Entry : d0.w = Type of the sprite
;	  d1.w = X-Start
;	  d2.w = Y_Start
;	 (d3.w = Adress in the Level-File)
; 	Other entries, look at fer3c.asm (Sprite_Init section)
; Return : The sprite is activated in the sprite-buffer
; Destroy : d0, a0, a1
; 	Some sprites detroy also : d2 and a2
;
; ******************************************************************
fer3c::SpriteInit	EQU	fer3c@0002

; ******************************************************************
;
; Delete the sprite in the sprite-buffer
;
; Entry : a5.l  -> Sprite to destroy.
;	  d0.l	-> Length of the sprite.
; Return : No Return : exit the current sprite and destroy it.
; Destroy:	a0,a1,d0
; ******************************************************************

fer3c::DestroySprite	EQU	fer3c@0003

; ******************************************************************
;
; Put one sprite (16 * 16) on the current screen
; Entry :	d0.w = X (between 0 and 4095)
;		d1.w = Y (between 0 and 32*32-1)
;		a0.l = ADR of the sprite (No mask)
;		Screen
; Return : Put the sprite at the current screen
; No registers destroyed
; ******************************************************************
fer3c::PutSprite	EQU	fer3c@0004

; ******************************************************************
;
; Is the sprite on a block ?
; Entry :	d0.w = X
;		d1.w = Y
; Return:	Zero_Flag activated if 'Yes'.
; Destroy : d2 and a0
; ******************************************************************
fer3c::GetTest		EQU	fer3c@0005

; ******************************************************************
;
; Is the sprite tuch Fernando ?
; Entry :	d0.w = X	d6.w = X_Fernando
;		d1.w = Y	d7.w = Y_Fernando
; Return:	Zero_Flag activated if 'Yes'.
; Destroy:	d2
;
; ******************************************************************
fer3c::TestCollision	EQU	fer3c@0006

; ******************************************************************
;
; Is the sprite outside the screen ?
; Entry :	d0.w = X
;		d1.w = Y
; Return:	Zero_Flag activated if 'Yes'.
; Destroy:	d2
;
; ******************************************************************
fer3c::TestExitScreen	EQU	fer3c@0007

; ******************************************************************
;
; Decrease fernando's power and kill him if power=0.
; Entry :	Nothing
; Return:	Flash_Screen and set the global variables
; Destroy:	d2
;
; ******************************************************************
fer3c::Hurt		EQU	fer3c@0008

; ******************************************************************
;
;	Put the scrolling on the current screen
;	And make the sprite appears in the current screen if the virtual
;	screen must be updated.
; Warning : Use it at your own risk.
; Entry:	LevelADR
;		LevelTestADR
;		Screen
;		VirtualScreenADR
;		GraphADR
;		Xs and Ys
;		XsOld and YsOld
; Return:	Put the Graphs
;		Init sprites
;		Update variables
; Destroy:	All registers
;
; ******************************************************************
fer3c::Scrolling	EQU	fer3c@0009

; ******************************************************************
;
; UpDate ScollVariables : center the scolling on (D0.w, D1.w)
; Entry:	d0 & d1
; Return:	UpDate XsNew and YsNew
; Destroy:	d0 and d1
;
; ******************************************************************
fer3c::UpDateScrollVar	EQU	fer3c@000A

; ******************************************************************
;
;	Draw a fer3c text structure in LCD_MEM.
; Input:	a3 -> Structure
;		d7 = Numbers of entries - 1
; Return:	Clear the screen and put it
; Destroy:	a0, a1, a2, a3, d0, d1, d2 & d7.
; Structure: One entry
; 	Text	dc.w NORMAL		; SetFontSys
;		dc.w 10			; X
;		dc.w 25			; Y
;		dc.l MyText		; *String
;	MyText	dc.b "Hello world",0	; String
;
; ******************************************************************
fer3c::DrawText		EQU	fer3c@000B

; ******************************************************************
;
;	Put 3 Horizontal lines on the screen (Y=d1)
; Input:	d1 = 0 ... 32*32-1
;		Screen
; Return:	Nothing
; Destroy:	Nothing
;
; ******************************************************************
fer3c::PutHor		EQU	fer3c@000C


; ******************************************************************
;
;	Put 3 vertical lines on the screen (X=d0)
; Input:	d1 = 0 ... 4095
;		Screen
; Return:	Nothing
; Destroy:	Nothing
;
; ******************************************************************
fer3c::PutVer		EQU	fer3c@000D

; ******************************************************************
;
;	Exec a level
; Warning : SpriteADR = SpriteEndADR = Adress of a free sprite-buffer.
;	SpriteInit+8 -> End of the free sprite-buffer.
;	a5 -> Compressed Gfx.
;	a1 -> Uncompressed level.
;	a6 -> $60000
; ******************************************************************
fer3c::ExecLevel	EQU	fer3c@000E

; ******************************************************************
;
;	Read the option in LevelTestADR
; 	And update data.
; Entry : a5 -> Fernando sprite
;	d6.w = X_Fernando
;	d7.w = Y_Fernando
; Return : Update Fernando structure
;
; ******************************************************************
fer3c::ReadOption	EQU	fer3c@000F

