program World;
{$M 8192,0,0}           { Leave memory for child process }

uses crt,dos;

const MaxLevel=100;

type
 Tab = ARRAY [0..MaxLevel-1] of byte;
 Tab2 = ARRAY [0..MaxLevel-1] of string[15];

label LabelError;

var
 F: Text;
 F1, F2 : file of byte;
 i,j,k,N, Decalage,Decalage2,MkName: Integer;
 Ch: char;
 Bt: byte;
 FileName,s,s2,GraphName,Comment,ShellStr,AddOnStr:String [100];

 Tipe:tab;
 Name:tab2;

function Upper(s:string):string;
var i:integer;
begin
for i := 1 to Length(s) do
  s[i] := UpCase(s[i]);
Upper:=s;
end;

function IntToStr(I: Longint): String;
{ Convert any integer type to a string }
var
 S: string[11];
begin
 Str(I, S);
 IntToStr := S;
end;

function StrToInt(s:string): integer;
var i,code:integer;
begin
  Val(s,i,code);
  StrToInt:=i;
end;

function DestroyExt(s:string):string;
var
   i:integer;

begin
    i:=Pos('.',s);
    if i>0 then DestroyExt:=Copy(s,1,i-1) else DestroyExt:=s;
end;

function DestroyPatch(s:string):string;
var
   i:integer;

begin
    i:=Pos('\',s);
    if i>0 then DestroyPatch:=DestroyPatch(Copy(s,i+1,length(s))) else DestroyPatch:=s;
end;

begin
 Decalage:= 86;
 Decalage2:=12+16;
 MkName:=0;

 clrscr;
 Writeln('MkWorld v0.28 by Pelissier Patrick');
 Writeln('Make a 92P or 9XZ World for Fernando 3-C');
 Writeln;

if ParamStr(1)='' then
 Writeln('MkWorld FileName')
else
 begin
 FileName:=DestroyPatch(DestroyExt(ParamStr(1)));
 GraphName:='';
 ShellStr:='';
 AddOnStr:='';

 {Lecture du fichier Monde}
 writeln('Reading :',FileName,'.WLD');
 Assign(F,FileName+'.WLD');
 Reset(F);
 i:=0;
 while (i<MaxLevel) and (Not(Eof(F))) do
  begin
  Readln(F,s);
  s:=Upper(s);
  s2:=copy(s,1,4);
  s:=copy(s,6,length(s));
  if s2='GRPH' then GraphName:=s
  else if s2='PLAY' then begin
                          Tipe[i]:=0;
                          Name[i]:=s;
                          i:=i+1;
                         end
  else if s2='NAME' then comment:=s
  else if s2='SHLL' then shellstr:=s
  else if s2='LOAD' then
                        begin
                        Tipe[i]:=1;
                        Name[i]:=s;
                        i:=i+1;
                        end
  else if s2='OFST' then decalage:=StrToInt(s)
  else if s2='OFS2' then decalage2:=StrToInt(s)
  else if s2='JUMP' then
                    begin
                       Tipe[i]:=0;
                       Name[i]:='File'+IntToStr(MkName)+'.$$$';
                       assign(F1,Name[i]);
                       rewrite(F1);
                       Bt:=0; Write(F1,Bt);
                       Bt:=4; Write(F1,Bt);
                       Bt:=0; Write(F1,Bt);
                       Bt:=StrToInt(s); Write(F1,Bt);
                       close(F1);
                       MkName:=MkName+1;
                       i:=i+1;
                    end
  else if s2='JKEY' then
                    begin
                       Tipe[i]:=0;
                       Name[i]:='File'+IntToStr(MkName)+'.$$$';
                       assign(F1,Name[i]);
                       rewrite(F1);
                       Bt:=0; Write(F1,Bt);
                       Bt:=6; Write(F1,Bt);
                       Bt:=0; Write(F1,Bt);
                       Bt:=StrToInt(s); Write(F1,Bt);
                       close(F1);
                       MkName:=MkName+1;
                       i:=i+1;
                    end
  else if s2='ADDO' then
                      AddOnStr:=s
  else writeln('Can''t understand :',s2);
  end;

  {Lecture termine : verification des paramtres}
  if (GraphName='') or (shellstr='') then
     goto LabelError;
  writeln('GraphName and ShellName Ok');

  { Convertit les fichiers 92P ou 9XZ en leur prlevant le code}

  for j:=0 to (i-1) do
      begin
      if Tipe[j]=1 then begin
                        Assign(F1,Name[j]);
                        Name[j]:=DestroyExt(Name[j])+'.$$$';
                        writeln('Creating ',Name[j]);
                        Assign(F2,Name[j]);
                        Reset(F1);
                        ReWrite(F2);
                        for k:=1 to Decalage do
                            Read(F1,Bt);
                       { N:=(FileSize(F1)-Decalage-Decalage2+2);
                        for k:=1 to N do }
                        while not eof(F1) do
                              begin
                                  Read(F1,Bt);
                                  Write(F2,Bt);
                              end;
                        Close(F);
                        Bt:=255;
                        for k:=1 to Decalage2 do
                            Write(F2,Bt);
                        Close(F2);
                        end;
      end;

  { Fabrique le fichier pour packer92}
  writeln('Making FileList.par for packer92...');
  s:='Packer92 -n @FileList.Par '+FileName+'.P92';
  Assign(F,'FileList.PAR');
  ReWrite(F);
  Writeln(F,GraphName);
  for j:=0 to (i-1) do
      begin
        Writeln(F,Name[j]);
        writeln(Tipe[j],'-',Name[j]);
      end;
  Close(F);

  writeln('Making ok !');
  Writeln;
  Writeln('Graph Name: ',GraphName);
  Writeln('Comment   : ',Comment);
  Writeln('Shell     : ',shellstr);
  Writeln('Offset of the start of the Aux-files : ',decalage);
  Writeln('Number of 255 at the end of the Aux-Files : ',decalage2);
  Writeln;

  {Fabrique le fichier ASM}
  writeln('Making ',FileName,'.ASM...');
  Assign(F,FileName+'.ASM');
  ReWrite(F);
  If AddOnStr<>'' then Writeln(F,' include ',AddOnStr);
  Writeln(F,'	xdef	_main');
  Writeln(F,'	xdef	_comment');
  Writeln(F,'_main:');
  if AddOnStr<>'' then
                  begin
                      Writeln(F,' lea    SpriteInit(PC),a0');
                      Writeln(F,' move.l a0,fer3c::InitAddOnADR');
                      Writeln(F,' lea    SpriteExec(PC),a0');
                      Writeln(F,' move.l a0,fer3c::ExecAddOnADR');
                  end;
  writeln(F,'         lea        Start(PC),a0');
  Writeln(F,'         jmp        fer3c@0000');
  Write(F,'Start:     dc.w       ');
  Writeln(F,IntToStr(i));
  Write(F,'	INCBIN	');
  Write(F,FileName);
  Writeln(F,'.p92');
  Write(F,'_comment:	dc.b	"');
  Write(F,Comment);
  Writeln(F,'",0');
  Writeln(F,'	end');
  Close(F);
  writeln('Making ok !');
  writeln;
  writeln('Starting packer92, ',shellstr, ' and del all temp files...');

  SwapVectors;
  Exec(GetEnv('COMSPEC'), '/C '+s);
  Exec(GetEnv('COMSPEC'), '/C '+shellstr+' '+FileName);
  Exec(GetEnv('COMSPEC'), '/C del '+FileName+'.ASM');
  Exec(GetEnv('COMSPEC'), '/C del '+FileName+'.P92');
  Exec(GetEnv('COMSPEC'), '/C del '+FileName+'.INC');
  Exec(GetEnv('COMSPEC'), '/C del FileList.PAR');
  Exec(GetEnv('COMSPEC'), '/C del *.$$$');
  SwapVectors;
  if DosError <> 0 then
     WriteLn('Could not execute COMMAND.COM, DosError :',DosError);

LabelError:
 if GraphName='' then writeln('Graph File Name not found : GRPH graph.d32');
 if shellstr='' then writeln('I don''t know what Shell I have to use ! (shll fargo)');
 end;
end.
