{Level.PAS}
{$M 8192,0,0}           { Leave memory for child process }

uses Crt,dos;

const
 MAXx = 128;
 MAXy = 32;
 TailleX = 10;
 TailleY = 6;
 Start = 64;
 MAXgx = 32;
 MAXgy = 32;
 MAXDRAW = 200;
 MAXgD = 4;

 Test_Str: array [0..MAXDRAW] of string[15]
          =(''' ''','Block','PLat-Form','Fer rises','Power','OneUp','Bumper'
          ,'Key','Gate','Spike','Up','Down','Left','Right','The End'
          ,'HyperPower','Invisible','Fall-Down','Teleport','Speed'
          ,'Laser','I-Gravity','Swith','Door','Hooking','E-Dance'
          ,'Fly','Bomb','BadaBoum','Garbesh','Block Plan 1','Plan no 0','Plan no 1'
          ,'Blob','Bat','Fish','Fer-Hunter','Fungus','Ghost','Deca-Vert'
          ,'S-Bat','Star','Gray','Scroll-Right','Shifting','Boat-Effect'
          ,'Sun','Diag Right','Diag Left','Mode X-Or','Cinema'
          ,'Column','Moon','Shooter','Crabe','Shifting 2','Monkey','Deca'
          ,'Miror','Link Graph-Test','Anim 2'
          ,'ConcScrolling','Deca-Sac_Flam','Glooner','Boolder','HoloD..e'
          ,'HoloD..e2','FlyBoot','Scarat','Point Dexter','Bloominator','Flamme'
          ,'Repeat 1','Repeat 2','Repeat 3','Repeat A','Repeat B','Repeat C','AddOn','D79','D80'
          ,'D81','D82','D83','D84','D85','D86','D87','D88','D89','D90'
          ,'D91','D92','D93','D94','D95','D96','D97','D98','d99','D100'
          ,'D101','D102','D103','D104','D105','D106','D107','D108','d109','D110'
          ,'D111','D112','D113','D114','D115','D116','D117','D118','d119','D120'
          ,'D121','D122','D123','D124','D125','D126','D127','D128','d129','D130'
          ,'D131','D132','D133','D134','D135','D136','D137','D138','d139','D140'
          ,'D141','D82','D83','D84','D85','D86','D87','D88','D89','D90'
          ,'D151','D92','D93','D94','D95','D96','D97','D98','d99','D100'
          ,'D161','D102','D103','D104','D105','D106','D107','D108','d109','D110'
          ,'D171','D112','D113','D114','D115','D116','D117','D118','d119','D120'
          ,'D181','D122','D123','D124','D125','D126','D127','D128','d129','D130'
          ,'D191','D132','D133','D134','D135','D136','D137','D138','d139','D200');

type
 Tab = ARRAY [0..MAXx-1] of array [0..MAXy-1] of byte;
 BigTab = ARRAY [0..MAXDRAW-1] of byte;
 GraphTab = array [0..1] of ARRAY [0..MAXgD-1] of array [0..MAXgy-1] of array [0..MAXDRAW-1] of byte;

var
 C: Char;
 StartX,StartY,Screen: byte;
 i,j,k,xs,ys,Select: Integer;
 Pict,Test: Tab;
 Liaison: BigTab;
 Ch: Char;
 s,s2,sgraph : String;
 Continuer : BOOLEAN;
 Mem: GraphTab;
 xresolution,yresolution,video_seg:word;
 OrigMode :Integer;
 List: integer;


label
     FinLevel, DebutEdition,LabelError;

function DestroyExt(s:string):string;
var
   i:integer;

begin
    i:=Pos('.',s);
    if i>0 then DestroyExt:=Copy(s,1,i-1) else DestroyExt:=s;
end;

function FileExists(FileName: String): Boolean;
var
 F: file;
begin
 {$I-}
 Assign(F, FileName);
 FileMode := 0;  { Set file access to read only }
 Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
end;  { FileExists }

procedure SaveFile(FileName: String);
var
 F: Text;
 i,j: Integer;
 Ch: char;

begin
 Assign(F,FileName);
 ReWrite(F);
 Write(F,chr(0)+chr(0));
 Write(F,chr(StartX));
 Write(F,chr(StartY));
 for j := 0 to MAXy - 1 do
     for i := 0 to (MAXx - 1) do
            Write(F, Chr(Pict[i][j]));
 for j := 0 to MAXy - 1 do
     for i := 0 to (MAXx - 1) do
            Write(F, Chr(Test[i][j]));
 Close(F);
end;

procedure OpenFile(FileName: String);
var
 F: Text;
 i,j,k: Integer;
 Ch: char;

begin
 Assign(F,FileName);
 Reset(F);
 Read(F,Ch);
 Read(F,Ch);
 Read(F,Ch); StartX:=ord(ch);
 Read(F,Ch); StartY:=ord(ch);
 for j := 0 to MAXy - 1 do
        for i := 0 to (MAXx - 1) do
            Begin
            Read(F, Ch);
            Pict[i][j]:= ord(ch);
            end;
 for j := 0 to MAXy - 1 do
        for i := 0 to (MAXx - 1) do
            Begin
            Read(F, Ch);
            Test[i][j]:= ord(ch);
            end;
end;

procedure OpenFileGraph(FileName: String);
var
 F: Text;
 i,j,k: Integer;
 Ch: char;

begin
 Assign(F,FileName);
 Reset(F);
 k:=0;
  for i:=1 to MAXgD*MAXgy do
     read(F,Ch);

 while (not Eof(F)) and (k<MAXDRAW) do
  begin
    for j := 0 to MAXgy - 1 do
        for i := 0 to (MAXgD - 1) do
            Begin
            Read(F, Ch);
            Mem[screen][i][j][k] := ord(ch);
            end;
    k:= k + 1;
  end;
end;

procedure init_Mcga;
begin
yresolution:=200;
xresolution:=320;
video_seg:=$A000;
asm
mov xresolution,320d
mov ax,13h
int 10h
end
end;

procedure sp(xl,yl,coul:word); assembler;
asm
 mov ax,yl
 mul xresolution
 mov bx,xl
 add bx,ax
 mov es,video_seg
 mov ax,coul
 mov es:[bx],al
end;

procedure box(xl,yl,xl1,yl1,coul:word);assembler;
var i:word;
label a,b;
asm
 mov es,video_seg
 mov dx,xl
 mov i,dx
 a:
 mov Cx,yl
 b:
 mov ax,cx
 mul xresolution
 mov bx,i
 add bx,ax

 mov ax,coul
 mov es:[bx],al
 inc cx
 cmp cx,yl1
 jbe b
 inc i
 mov dx,i
 cmp dx,xl1
 jbe a
end;

procedure PrintGraph(No,xj,yj:integer);
var i,j:integer;
c:byte;

label Boucle,B18;

begin
    for j:=0 to MAXgy-1 do
        for i:=0 to MAXgd-1 do
            begin
                  c:=Mem[screen][i][j][No];
                  asm
                   mov ax,j
                   add ax,yj
                   mul xresolution
                   mov bx,ax
                   mov ax,i
                   add ax,ax
                   add ax,ax
                   add ax,ax
                   add bx,xj
                   add bx,ax
                   mov ah,c
                   mov es,video_seg
                   mov cx,7
Boucle:
                   mov al,18
                   mov dx,1
                   sal dx,cl
                   and dl,ah
                   je  B18
                   mov al,75
B18:
                   mov es:[bx],al
                   inc bx
                   dec cx
                   cmp cx,-1
                   jne Boucle
                  end;
              end;
end;


procedure PrintLevel(xs,ys:integer);
var i,j:integer;
    cc: byte;
begin
  for i:=xs to xs+Taillex - 1 do
     for j:= ys to ys+Tailley - 1 do
         begin
             if Screen=0 then cc:=Pict[i][j] else cc:=Test[i][j];
             if cc>0 then
                         PrintGraph(cc-1,(i-xs)*32,(j-ys)*32)
                         else
                         Box((i-xs)*32,(j-ys)*32,(i-xs+1)*32,(j-ys+1)*32,18);
         end;

end;

Function SelectTest(Element:integer):Integer;
var
 c:char;
 i,k:integer;
 Terminated : Boolean;
begin
 TextMode(OrigMode);
     Terminated:=False;
     SelectTest:=0;
     i:=0;
     while not(Terminated) do
           begin
                clrscr;
                writeln('SELECT A TEST for ',Element,' ( ',Chr(Element+Start),' ) : DEL -> Nothing');
                for k:=i to i+20 do
                    writeln(chr(K+Start),'  No:',K+Start,'       ',Test_Str[K]);
                c:=ReadKey;
                if c=chr(0) then
                             begin
                             c:=ReadKey;
                             if (c='P') and ((i+20)<MAXDRAW) then i:=i+1
                             else if (c='H') and (i>0) then i:=i-1;
                             end
                else if c=chr(27) then begin
                                  Terminated:=TRUE;
                                  SelectTest:=Liaison[Element];
                                  end
                else if c=chr(8) then begin
                                 Terminated:=TRUE;
                                 SelectTest:=0;
                                 end
                else if (ord(c)>Start) and (ord(c) < Start+MAXDRAW) then
                   begin
                   SelectTest:=ord(c)-Start;
                   Terminated:=TRUE;
                   end;
           end;
 Init_Mcga;

end;

procedure DefineLiaison;
var
 c: char;
 i,j,k,Scr:integer;
 Terminated : Boolean;


begin
 Terminated:=False;
 i:=Select;
 Scr:=Screen;
 List:=300;
 while not(Terminated) do
           begin
                box(0,0,320,200,0);
                j:=0;
                for k:=i to i+5 do
                    begin
                    Screen:=0;
                    PrintGraph(K-1,50,j);
                    Screen:=1;
                    printGraph(Liaison[K]-1,150,j);
                    j:=j+33;
                    end;
                Box(0,(Select-i)*32,40,(Select-i+1)*32,180);
                c:=ReadKey;
                if c=chr(0) then
                                begin
                                c:=ReadKey;
                                if (c='P') and (Select<MAXDRAW) then
                                               begin
                                               Select:=select+1;
                                               if Select>(i+5) then i:=i+1;
                                               end
                                else if (c='H') and (Select>0) then
                                                begin
                                                Select:=Select-1;
                                                if Select<i then i:=i-1;
                                                end
                                end
                else if c=chr(27) then Terminated:=TRUE
                else if c=chr(13) then
                                  begin
                                     Terminated:=TRUE;
                                     List:=Select;
                                  end
                else if c=chr(32) then Liaison[Select]:=SelectTest(Select);
           end;
 Screen:=Scr;
end;

procedure SaveLiaison;
var
 F: Text;
 j: Integer;
 ch: char;

begin
 Assign(F,'LIAISON.DAT');
 ReWrite(F);
 for j := 0 to MAXDRAW - 1 do
       BEGIN
            Ch:=chr(Liaison[j]);
            Write(F, ch);
       END;
 Close(F);
end;

procedure OpenLiaison;
var
 F: Text;
 j: Integer;
 ch: char;

begin
 Assign(F,'LIAISON.DAT');
 Reset(F);
 for j := 0 to MAXDRAW - 1 do
       begin
            Read(F, Ch);
            Liaison[j]:=ord(Ch);
       end;
end;


procedure SaveFileText(FileName: String);
var
 F: Text;
 Str: string;
 FileName2: string;

begin
 Writeln('Comment: ?');
 readln(Str);
 FileName2:=FileName+'.ASM';

 Assign(F,FileName2);
 ReWrite(F);
 Writeln(F,'	xdef	_main');
 Writeln(F,'	xdef	_comment');
 Writeln(F,'_main:	lea        Start(PC),a0');
 Writeln(F,'            jmp        fer3c@0000');
 Writeln(F,'Start:      dc.w       1');
 Write(F,'	INCBIN	');
 Write(F,FileName);
 Writeln(F,'.p92');
 Write(F,'_comment:	dc.b	"');
 Write(F,Str);
 Writeln(F,'",0');
 Writeln(F,'	end');
 Close(F);
end;


begin
  { Get file to read from command line : ParamStr(1) }

  OrigMode := LastMode;
 Select:=0;

  clrscr;
  Screen:=0;
  Writeln('FERNANDO 3-C Editor (C) 1998 HD Developement');
  writeln;
  Write('Enter File Graph Name: ');
  if ParamStr(2)='' then Readln(sgraph) else sgraph:=ParamStr(2);
  if sgraph='' then sgraph:='Graph.d32';
  if FileExists(sgraph) then
   begin
   Writeln('Graph File exists : ',sgraph);
   OpenFileGraph(sgraph);
  end
 else
   Begin
   Writeln('Graph File not found : ',sgraph);
   Goto LabelError;
   end;
  Screen:=1;
  Write('Enter File test Graph Name: ');
{  Readln(s); }
  s:='Test.d32';
  if FileExists(s) then
   begin
   Writeln('Test Graph File exists');
   OpenFileGraph(s);
  end
 else
   Begin
   Writeln('Test Graph File not found');
   Goto LabelError;
   end;
  Write('Enter Liaison File Name: ');
  if FileExists('LIAISON.DAT') then
   begin
   Writeln('Liaison File exists');
   OpenLiaison;
  end
 else
   Writeln('Liaison File not found');

  Write('Enter File Name : ');
  if ParamStr(1)='' then Readln(s) else s:=ParamStr(1);
  Writeln('You typed: ',s);
  s2:=DestroyExt(s);
  s:=s2 + '.LVL';

  if FileExists(s) then
   begin
   Writeln('File exists');
   OpenFile(s);
  end
 else
   Begin
   Writeln('File not found');
   writeln('New file:',s2,'.Lvl');
   end;
 writeln;
 writeln('Use the PAD to move the cursor (or Page Up, Page Down)');
 writeln('Press SPACE to switch betwen Graph Screen and Test Screen');
 writeln('Press DEL to delete the graph and the test (or only test)');
 writeln('Press F2 -> Save        F3 -> starting point  F6 -> Make 92P file');
 writeln('Press F4 -> information F5 -> Test-List');
 writeln;
 writeln('When you press F1, you will associate a test at a graph:');
 writeln('Example : If you want when you press graph A, test X');
 writeln('will be automatically pressed, Press : ');
 writeln(' F1 to enter the DefineInput, then press A (or SPACE), then X - ESC to quit');
 writeln(' Press [ENTER] to put the graph in the level');
 writeln;
 writeln('Press A B ...(Ascii table) to draw a graph (or a test if you are in test scren)');
 writeln;
 writeln('Press ENTER to start and ESC TO QUIT');
 readln;

DebutEdition:
 init_Mcga;
 i:=0; j:=0; xs:=0; ys:=0;Screen:=0;

 Continuer:=TRUE;

 while continuer do
 begin
  PrintLevel(xs,ys);
  Box((i-xs)*32+1,(j-ys)*32+1,(i-xs+1)*32-1,(j-ys+1)*32-1,28);
  C := Readkey;
  if c=chr(0) then
              begin
                c:=ReadKey;
                if (c = 'K') and (i > 0) then
                                begin
                                i:= i - 1;
                                if xs>i then xs:=i;
                                end
                else if (c = 'M') and (i< (MAXx - 1)) then begin
                                        i:= i + 1;
                                        if xs+TailleX-1<i then
                                           xs:=i-TailleX+1;
                                        end
                else if (c = 'H') and (j>0) then
                         begin
                         j:=j-1;
                         if ys>j then ys:=j;
                         end
                else if (c = 'P') and (j<(MAXy - 1)) then
                            begin
                             j:=j + 1;
                             if ys+TailleY-1<j then
                                              ys:=j-TailleY+1;
                            end
                else if (c = 'I') then
                            begin
                               j:=0;
                               ys:=0;
                            end
                else if (c = 'Q') then
                            begin
                               j:=MAXy-1;
                               Ys:=MAXy-TailleY;
                            end
                else if (c = ';') then
                                  begin
                                  DefineLiaison;
                                  if List<300 then
                                           begin
                                           Pict[i][j]:=List;
                                           Test[i][j]:=Liaison[Pict[i][j]];
                                           end;
                                  end

                else if (c = '<') then SaveFile(s)
                else if (c = '=') then
                                  begin
                                  StartX:=i; StartY:=j;
                                  TextMode(OrigMode);
                                  writeln('New start at ',StartX,',',StartY);
                                  writeln('Press ENTER to continue...');
                                  readln;
                                  Init_Mcga;
                                  end
                else if (c = '>') then
                                  begin
                                  TextMode(OrigMode);
                                  writeln('Position :',i,'/',MAXx-1,',',j,'/',MAXy-1);
                                  writeln('Graph No :',Pict[i][j]);
                                  writeln('Test No  :',Test[i][j]);
                                  writeln('Start    :',StartX,',',StartY);
                                  writeln('Press ENTER to continue...');
                                  readln;
                                  Init_Mcga;
                                  end
                else if (c = '?') then k:=SelectTest(0)
                else if (c = '@') then
                                  begin
                                  TextMode(OrigMode);
                                  writeln('Make 92p File...');
                                  SaveFileText(s2);
                                  SwapVectors;
                                  Exec(GetEnv('COMSPEC'), '/C packer92 -n '+sGraph+' '+s+' '+s2+'.P92');
                                  Exec(GetEnv('COMSPEC'), '/C fargo '+s2);
                                  Exec(GetEnv('COMSPEC'), '/C del '+s2+'.ASM');
                                  Exec(GetEnv('COMSPEC'), '/C del '+s2+'.P92');
                                  Exec(GetEnv('COMSPEC'), '/C del '+s2+'.INC');
                                  SwapVectors;
                                  if DosError <> 0 then
                                  WriteLn('Could not execute COMMAND.COM, DosError :',DosError);
                                  writeln('Press Enter to continue');
                                  readln;
                                  Init_Mcga;
                                  end
              end
  else if c = chr(27) then Continuer := FALSE
  else if c = ' 'then Screen := 1-Screen
  else if c = chr(8)  then
          begin
              Test[i][j]:=0;
              IF screen = 0 then Pict[i][j]:=0;
          end
  else if c=chr(13) then
          begin
                           Pict[i][j]:=Select;
                           Test[i][j]:=Liaison[Pict[i][j]];

          end
  else if (ord(c)>Start) and (ord(c)<Start+MAXDRAW+1) then
          begin
           IF Screen=0 then
                           begin
                           Pict[i][j]:=ord(c)-Start;
                           Test[i][j]:=Liaison[Pict[i][j]];
                           end
                       else Test[i][j]:=ord(c)-Start;
          end;
  end;

FinLevel:
  SaveLiaison;
  TextMode(OrigMode);
  writeln('Save ? (Yes / No / Cancel)');
  c:=' ';
  while ((c<>'Y') and (c<>'N') and (c<>'C')) do
        c:=upcase(readkey);
  if c='Y' then SaveFile(s);
  if c='C' then goto DebutEdition;
LabelError:

end.
