;	Level-Editor for Fer3c
;	Copyright (C) 1998 by Pelissier Patrick

	include	"tios.h"
	include "flib.h"
	include "hexlib.h"
	include "pk92lib.h"
	include	"fer3c.h"
	include "macros.h"

	include "sprite.h"

	xdef	_library
	xdef	fer3edit@0000

; include "FARGOII.h"
; include "Plus92.h"
 include "H89.h"

 include "tinyscr.h"
; include "splits.h"

fer3edit@0000:
	move.l	a1,GraphCAdr
	move.l	a0,StartAdr
	addq.l	#2,a0
	move.l	a0,LevelADR
	lea	(128*32)(a0),a0
	move.l	a0,LevelTestADR
	clr.w	fer3c::Nbr_Player

Main_Loop:
	clr.b	BoxON
	jsr	flib::zap_screen

	moveq	#0,d0
	lea	GraphTest(PC),a0	; Adr a0
	jsr     pk92lib::Extract
	tst.b	d0	; Ok ?
	bne	ExitPK92
	move.w	d1,-(a7); Save the handle on the stack in order to be deleted before quitting
	move.l	a1,GraphTestADR

	moveq	#0,d0
	move.l	GraphCAdr,a0	; Adr a0
	jsr     pk92lib::Extract
	tst.b	d0	; Ok ?
	bne	Exit2PK92
; Save the handle on the stack in order to be deleted before quitting
	move.w	d1,-(a7)
	move.l	a1,GraphADR

	clr.b	ExitBool
\Conti:
	bsr	Action
	tst.b	ExitBool
	beq	\Conti

	jsr	tios::HeapFree
	addq.l	#2,a7
Exit2PK92:
	jsr	tios::HeapFree
	addq.l	#2,a7
ExitPK92:

End_Main_Loop:

	cmp.b	#2,ExitBool
	bne	\Exit
; A1 pointe vers le niveau
; A5 vers les graphs compresses
; A6 vers $600000
; SpriteAdr vers un buffer libre de SPRITE_BUFFER
; SpriteAdr+4 (SpriteAdr+4) vers ce meme buffer
; SpriteInit+8 vers la fin de ce buffer
	lea    $600000,a6	; Set a6 to I/O ...

; If we know the Handle of the I/O we will use it, else we will use a buffer
 ifeq	HANDLEOK-1
 moveq	#(4*HANDLEIO),d0	; Set Sprite-Buffer : I/O Screen
 move.l	tios::Heap,a1		; Insert tios::DEREF Macro
 move.l	0(a1,d0.w),a1		; and optimize it to be shorter...
 addq.l	#4,a1			; Find Adress of I/O Screen
 endif

 ifeq	HANDLEOK
 move.l #(SPRITE_BUFFER+2*MAX_SPRITE_SIZE),-(a7)
 jsr	tios::HeapAlloc
 addq.l	#4,a7
 tst.l	d0
 bne	\Ok
 rts
\Ok:
 move.w	d0,-(a7)	; we will destroy it before quitting
 tios::DEREF  d0,a1
 endif

	move.l a1,fer3c::SpriteADR
	move.l a1,fer3c::SpriteADR+4
	adda.l	#SPRITE_BUFFER,a1		; Adr of the end of the buffer
	move.l	a1,fer3c::SpriteInit+8	; Save here ! (Immediate value)

	move.l	#(32*128*2+4),-(a7)
	jsr	tios::HeapAlloc
	addq.l	#4,a7
	tst.l	d0
	beq	\ExitExec
	move.w	d0,-(a7)	; Put the handle on the stack in order to ...

	tios::DEREF	d0,a0
	move.l	a0,-(a7)
	move.l	StartAdr,a1
	move.l	#(32*128*2+4-1),d0
\Copy:
	move.b	(a1)+,(a0)+
	dbf	d0,\Copy
	move.l	(a7)+,a1

	move.l	GraphCAdr,a5
	move.w	#$700,d0
	trap	#1
	jsr	fer3c::ExecLevel
	moveq	#0,d0
	trap	#1
	move.b #$B2,$17(a6)	; Restore processor's clock
\EraseMem:
	jsr	tios::HeapFree	; Destroy level
	addq.l	#2,A7
; Destroy the reserved Handle (for sprite) if we have create it
 ifeq	HANDLEOK
 jsr	tios::HeapFree	
 addq.l	#2,a7	
 endif
\ExitExec:
	bra	Main_Loop
\Exit:	
	rts

; Gestion des touches et autres
Action:
	movem.l	d0-d5/a0-a3,-(a7)

	bsr	PutScreen
	bsr	PutList
	bsr	Invert_Graph

	jsr	flib::idle_loop

	bsr	MoveCursor
	cmp.w	#[2nd]+KEY_LEFT,d0
	beq	\Speed
\NoLeft2:
	cmp.w	#[2nd]+KEY_RIGHT,d0
	beq	\Speed
\NoRight2:
	cmp.w	#[2nd]+KEY_UP,d0
	beq	\Speed
\NoUp2:
	cmp.w	#[2nd]+KEY_DOWN,d0
	bne	\NoDown2
\Speed:
	sub.w	#[2nd],d0
	moveq	#7,d5
\loop
	bsr	MoveCursor
	dbf	d5,\loop
\NoDown2:
	cmp.w	#264,d0
	bne	\NoEsc
	st	ExitBool
	bra	ExitKey
\NoEsc:
	cmp.w	#268,d0
	bne	\NoF1
	jsr	flib::zap_screen
	move.b	Current,d5
	clr.b	Current
	WriteStr #20,#40,#4,Graph_Str
	bsr	SelectAnItem
	beq	\ExitF1
	move.w	List,d4
	WriteStr #20,#40,#4,Test_Str
	move.b	#1,Current
	bsr	SelectAnItem
	beq	\ExitF1
	lea	TableGraphTest(PC),a0
	move.w	List,d1
	move.b	d1,0(a0,d4.w)
\ExitF1:
	move.b	d5,Current
	bra	ExitKey
\NoF1:
	cmp.w	#269,d0
	bne	\NoF2
	move.b	#2,ExitBool
	bra	ExitKey
\NoF2:
	cmp.w	#270,d0
	bne	\NoF3
	move.l	StartAdr,a0
	move.w	X,d1
	move.b	d1,(a0)+
	move.w	Y,d1
	move.b	d1,(a0)
	bra	ExitKey
\NoF3:
	cmp.w	#271,d0
	bne	\NoF4
	jsr	flib::zap_screen
	WriteStr #20,#40,#4,Clear_Str
	jsr	flib::idle_loop
	cmp.w	#13,d0
	bne	ExitKey
	move.l	LevelADR,a0
	move.l	#(2*128*32-1),d0
\Loop:
	clr.b	(a0)+
	dbf	d0,\Loop
	bra	ExitKey
\NoF4:
	cmp.w	#272,d0
	bne	\NoF5
	st.b	BoxON
	move.w	X,Xbox
	move.w	Y,Ybox
	bra	ExitKey
\NoF5:
	cmp.w	#273,d0
	bne	\NoF6
	bsr	ShowMap
	bra	ExitKey
\NoF6:
	cmp.w	#43,d0
	bne	\NoPlus
	addq.w	#1,List
	bra	ExitKey
\NoPlus:
	cmp.w	#45,d0
	bne	\NoMoins
	tst.w	List
	beq	\NoMoins
	subq.w	#1,List
	bra	ExitKey
\NoMoins:
	cmp.w	#13,d0
	bne	\NoEnter
	move.w	List,d0
	bsr	PutData
	bra	ExitKey
\NoEnter:
	cmp.w	#32,d0
	bne	\NoSpace
	eor.b	#1,Current
	bra	ExitKey
\NoSpace:
	cmp.w	#257,d0
	bne	\NoDel
	move.w	#(65-1),d0
	bra	\CharacterPut
\NoDel:
	cmp.w	#46,d0
	bne	\NoPoint
	clr.w	List
	bra	ExitKey
\NoPoint:
	cmp.w	#8240,d0
	blt	\NoSShortCut
	cmp.w	#(8240+9),d0
	bgt	\NoSShortCut
	sub.w	#8240,d0
	tst.b	Current
	beq	\Ok
	add.w	#10,d0
\Ok:
	bsr	ReturnAdr
	moveq	#0,d1
	move.w	Y,d1
	lsl.w	#7,d1
	add.w	X,d1
	adda.l	d1,a1
	move.b	(a1),d1
	lea	TableShortCut(PC),a0
	move.b	d1,0(a0,d0.w)
	bra	ExitKey
\NoSShortCut:
	cmp.w	#48,d0
	blt	\NoShortCut
	cmp.w	#(48+9),d0
	bgt	\NoShortCut
	sub.w	#48,d0
	tst.b	Current
	beq	\Ok2
	add.w	#10,d0
\Ok2:
	lea	TableShortCut(PC),a0
	move.b	0(a0,d0.w),d0
	bsr	PutData
	bra	ExitKey
\NoShortCut:
	cmp.w	#65,d0
	blt	\NoAscii
	cmp.w	#(65+253),d0
	bgt	\NoAscii
\CharacterPut:
	sub.w	#(65-1),d0
	bsr	PutData
\NoAscii:
ExitKey:
	movem.l	(a7)+,d0-d5/a0-a3
	rts

MoveCursor:
	cmp.w	#KEY_LEFT,d0
	bne	\NoLeft
	tst.w	X
	ble	\NoLeft
	subq.w	#1,X
	move.w	X,d2
	cmp.w	Xs,d2
	bge	\NoLeft
	subq.w	#1,Xs
\NoLeft:
	cmp.w	#KEY_RIGHT,d0
	bne	\NoRight
	cmp.w	#127,X
	bge	\NoRight
	addq.w	#1,X
	move.w	Xs,d1
	add.w	#(SCR_X/4-2),d1
	move.w	X,d2
	cmp.w	d1,d2
	ble	\NoRight
	addq.w	#1,Xs
\NoRight:
	cmp.w	#KEY_UP,d0
	bne	\NoUp
	tst.w	Y
	ble	\NoUp
	subq.w	#1,Y
	move.w	Y,d2
	cmp.w	Ys,d2
	bge	\NoUp
	subq.w	#1,Ys
\NoUp:
	cmp.w	#KEY_DOWN,d0
	bne	\NoDown
	cmp.w	#31,Y
	bge	\NoDown
	addq.w	#1,Y
	move.w	Ys,d1
	add.w	#(SCREEN_Y/32-1),d1
	move.w	Y,d2
	cmp.w	d1,d2
	ble	\NoDown
	addq.w	#1,Ys
\NoDown:
	rts

; Set D0 in (x,y)
PutData:
	movem.l	d0-d5/a0-a1,-(a7)
	move.l	X,-(a7)	; Save X and Y in the stack
	bsr	PutIt
	tst.b	BoxON
	beq	\Exitb
	move.w	X,d1
	cmp.w	Xbox,d1
	blt	\NoEx
	move.w	Xbox,d2
	move.w	d1,Xbox
	move.w	d2,X
\NoEx:
	move.w	Y,d1
	cmp.w	Ybox,d1
	blt	\NoEx2
	move.w	Ybox,d2
	move.w	d1,Ybox
	move.w	d2,Y
\NoEx2:
	move.w	Ybox,d1
	sub.w	Y,d1
	move.w	Xbox,d2
	move.w	X,d3
	sub.w	d3,d2
\Loop1:
	move.w	d3,X
	move.w	d2,d4
\Loop2:
	bsr	PutIt
	addq.w	#1,X
	dbf	d4,\Loop2
	addq.w	#1,Y
	dbf	d1,\Loop1
\Exitb:
	clr.b	BoxON
	move.l	(a7)+,X	; Restore X and Y
	movem.l	(a7)+,d0-d5/a0-a1
	rts

PutIt:
	movem.l	d0-d2/a0-a2,-(a7)
	bsr	ReturnAdr
	moveq	#0,d1
	move.w	Y,d1
	lsl.w	#7,d1
	add.w	X,d1
	adda.l	d1,a1
	move.b	d0,(a1)
	tst.b	Current
	bne	\Exit
	move.b	#1,Current
	bsr	ReturnAdr
	adda.l	d1,a1
	lea	TableGraphTest(PC),a0
	move.b	0(a0,d0.w),d0
	move.b	d0,(a1)
	clr.b	Current
\Exit:
	movem.l	(a7)+,d0-d2/a0-a2
	rts

ShowMap:
	move.w	List,-(a7)
	jsr	flib::zap_screen
	SetFont	NORMAL
	WriteStr #10,#40,#4,Item_Str
	bsr	SelectAnItem
	jsr	flib::zap_screen
	tst.w	d0
	beq	\ExitMap
	bsr	ReturnAdr
	lea	(128*32)(a1),a1
	move.w	List,d3
	moveq	#31,d1
\Loop1:
	moveq	#127,d0
\Loop2:
	move.b	-(a1),d2
	tst.w	d3	; List =0 ?
	bne	\Next	; Non 
	tst.b	d2	; QQchose ?
	beq	\No
	bra	\Ok
\Next:
	cmp.b	d3,d2
	bne	\No
\Ok:
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	jsr	flib::pixel_on
	addq.l	#4,a7
\No:
	dbf	d0,\Loop2
	dbf	d1,\Loop1
	lea	LCD_MEM,a0
	lea	(16)(a0),a0
	moveq	#31,d1
\l2:
	move.b	#%10000000,(a0)
	lea	SCREEN_X(a0),a0
	dbf	d1,\l2
	moveq	#-1,d0
	lea	(SCREEN_X-16)(a0),a0
	moveq	#3,d1
\l1:
	move.l	d0,(a0)+
	dbf	d1,\l1
	move.w	#35,-(a7)
	move.w	X,-(a7)
	jsr	flib::pixel_on
	addq.l	#4,a7
	move.w	Y,-(a7)
	move.w	#130,-(a7)
	jsr	flib::pixel_on
	addq.l	#4,a7
	WriteStr #5,#70,#4,Title_Str
	WriteStr #0,#80,#4,Copyright_Str
	jsr	flib::idle_loop
\ExitMap:
	move.w	(a7)+,List
	rts

; Put the graph No D2.l of a0 at D0.l =Absolute long (0..2..28), D1.l = Row (0..127)
PutGraph:
	movem.l	d0-d4/a0-a3,-(a7)
	lsl.l	#7,d2
	lea	0(a0,d2.w),a2
	mulu.w	#SCREEN_X,d1
	add.w	d1,d0
	lea	LCD_MEM,a0
	adda.l	d0,a0
	moveq	#31,d0
\Put_Loop:
	move.l	(a2)+,(a0)
	lea	SCREEN_X(a0),a0
	dbf	d0,\Put_Loop
	movem.l	(a7)+,d0-d4/a0-a3
	rts

Invert_Graph:
	movem.l	d0-d4/a0-a3,-(a7)
	moveq	#0,d1
	moveq	#0,d0
	move.w	Y,d1
	sub.w	Ys,d1
	mulu.w	#(SCREEN_X*32),d1
	move.w	X,d0
	sub.w	Xs,d0
	lsl.w	#2,d0	; x 4
	add.w	d1,d0
	lea	LCD_MEM,a0
	adda.l	d0,a0
	moveq	#31,d0
\Put_Loop:
	not.l	(a0)
	lea	SCREEN_X(a0),a0
	dbf	d0,\Put_Loop
	movem.l	(a7)+,d0-d4/a0-a3
	rts

PutScreen:
	movem.l	d0-d3/a0-a1,-(a7)
	moveq	#0,d0
	move.w	Xs,d0
	move.w	Ys,d1
	lsl.w	#7,d1	; x 128
	add.w	d1,d0
	bsr	ReturnAdr
	adda.l	d0,a1
	moveq	#0,d1
	moveq	#(SCREEN_Y/32-1),d3
\LoopY:
	moveq	#0,d0
	moveq	#((SCR_X/4-1)-1),d4
\LoopX:
	moveq	#0,d2
	move.b	(a1)+,d2
	bsr	PutGraph
	add.w	#4,d0
	dbf	d4,\LoopX
	lea	(128-((SCR_X/4)-1))(a1),a1
	add.w	#32,d1
	dbf	d3,\LoopY
	movem.l	(a7)+,d0-d3/a0-a1
	rts

PutList:
	movem.l	d0-d3/a0-a1,-(a7)
	bsr	ReturnAdr
	moveq	#0,d0
	moveq	#0,d2
	move.w	List,d2
	moveq	#(SCR_X-4),d0
	moveq	#0,d1
	moveq	#(SCREEN_Y/32-1),d3
\Loop:
	bsr	PutGraph
	addq.w	#1,d2
	add.w	#32,d1
	dbf	d3,\Loop
	movem.l	(a7)+,d0-d3/a0-a1
	rts


; Return in a0 the ADR of the Graph-File
; Return in a1 the ADR of the level-File
ReturnAdr:
	tst.b	Current
	bne	\Test
\Graph:
	move.l	GraphADR,a0
	move.l	LevelADR,a1
	bra	\Suite
\Test:
	move.l	GraphTestADR,a0
	move.l	LevelTestADR,a1
\Suite:
	rts

SelectAnItem:
\Loop:
	bsr	PutList
	jsr	flib::idle_loop
	cmp.w	#264,d0
	beq	\EndEsc	; Esc
	cmp.w	#KEY_UP,d0
	bne	\NoNUp
	tst.w	List
	ble	\Loop
	subq.w	#1,List
\NoNUp:
	cmp.w	#KEY_DOWN,d0
	bne	\NoNDown
	cmp.w	#254,List
	bge	\Loop
	addq.W	#1,List
\NoNDown:
	cmp.w	#65,d0
	blt	\NoAscii
	cmp.w	#(65+253),d0
	bgt	\NoAscii
	sub.w	#(65-1),d0
	move.w	d0,List
\NoAscii:
	cmp.w	#13,d0
	bne	\Loop
\End:
	moveq	#1,d0
	rts
\EndEsc:
	clr.l	d0
	rts

Current		dc.b	0	; Current : Graph 0 / Test 1
ExitBool	dc.b	0	; Sortie : 0,1 or 2
BoxON		dc.b	0	; Box Mode ?
		dc.b	0
GraphADR	dc.l	0	; Adress of the graphs
GraphCAdr	dc.l	0	; Adress of the compressed graphs
GraphTestADR	dc.l	0	; Adress of the test-graphs
StartAdr	dc.l	0	; Adress of the level
LevelADR	dc.l	0	; Adress of the Graph-Level
LevelTestADR	dc.l	0	; Adress of the test-level
X		dc.w	0	; X coordinate
Y		dc.w	0	; y "
Xbox		dc.w	0	; X for Box-mode
Ybox		dc.w	0	; Y for box-mode
Xs		dc.w	0	; X_Scroll
Ys		dc.w	0	; Y_Scroll
List		dc.w	0	; pointer to the current list

TableGraphTest	ds.b	256	; Table of the link between graphs and tests

TableShortCut	ds.b	20	; Table of short-cut

GraphTest:
	INCBIN	Test.P92

Graph_Str:
	dc.b "Select your graph",0
Test_Str:
	dc.b "Select your test ",0
Clear_Str:
	dc.b "Clear the level ? Enter=Yes",0
Item_Str:
	dc.b "Select the item for Map-Mode",0
Title_Str:
	dc.b "Fer3c-Level-Editor",0
Copyright_Str:
	dc.b "(C) 1998 Pelissier Pat",0

	ifeq	LIBRARYOK-1
_library:	dc.b "fer3edit",0
	endif

	end
