;
;****************************************************************************
;****************************************************************************
;****************************************************************************
;***                                                                      ***
;***            F E R N A N D O   3-C 	TI-ASM 68000 Version		  ***
;***                                                                      ***
;*** 		Copyright 1998-1999 by Pelissier Patrick		  ***
;***                                                                      ***
;****************************************************************************
;****************************************************************************
;****************************************************************************
;

; Current release : see at the end of this file (Title).

 include "TIOS.h"
 include "Kernel.h"
 include "Flib.h"
 include "Pk92lib.h"
 include "Hexlib.h"

 include "Macros.h"
 include "Sprite.h"

	xdef	_library
	xdef	fer3c@0000
	xdef	fer3c@0001
	xdef	fer3c@0002
	xdef	fer3c@0003
	xdef	fer3c@0004
	xdef	fer3c@0005
	xdef	fer3c@0006
	xdef	fer3c@0007
	xdef	fer3c@0008
	xdef	fer3c@0009
	xdef	fer3c@000A
	xdef	fer3c@000B
	xdef	fer3c@000C
	xdef	fer3c@000D
	xdef	fer3c@000E
	xdef	fer3c@000F
	xdef	fer3c@0010
;
;****************************************************************************
;***                                                                      ***
;***            		Choose your O.S.		  	  ***
;***                                                                      ***
;****************************************************************************

; include "FargoII.h"
; include "Plus92.h"
 include "H89.h"
 
;
;****************************************************************************
;***                                                                      ***
;***            	Choose your Screen Size.		  	  ***
;***                                                                      ***
;****************************************************************************

; include "Splits.h"
; include "FullScr.h"
 include "TinyScr.h"

;
;****************************************************************************
;***                                                                      ***
;***            		Starting Fer3c	.		  	  ***
;***                                                                      ***
;****************************************************************************

fer3c@0000:
 lea    $600000,a6	; Set a6 to I/O ...

 move.l	a0,LevelADR	; Save ADR of the world-file...

; If we know the Handle of the I/O we will use it, else we will use a buffer
 ifeq	HANDLEOK-1
 moveq	#(4*HANDLEIO),d0	; Set Sprite-Buffer : I/O Screen
 move.l	tios::Heap,a1		; Insert tios::DEREF Macro
 move.l	0(a1,d0.w),a1		; and optimize it to be shorter...
 addq.l	#4,a1			; Find Adress of I/O Screen
 endif

 ifeq	HANDLEOK
 move.l #(SPRITE_BUFFER+2*MAX_SPRITE_SIZE),-(a7)
 jsr	tios::HeapAlloc
 addq.l	#4,a7
 tst.l	d0
 bne	\Ok
 rts
\Ok:
 move.w	d0,-(a7)	; we will destroy it before quitting
 tios::DEREF  d0,a1
 endif

 move.l a1,SpriteADR
 adda.l	#SPRITE_BUFFER,a1		; Adr of the end of the buffer
 move.l	a1,SpriteInitEndBuffer+2	; Save here ! (Immediate value)

 move.w	#1,Turbo		; No turbo mode
 lea	Vide_Str(PC),a0
 move.l	a0,(Intro_Text+6)

; jsr	tios::reset_link		; Reset link-Buffer
 
; move.b	#1,Link
; bra	StartDebugHere

Intro:
 moveq	#5,d7
 lea	Intro_Text(PC),a3
 bsr	DrawText	; Show intro-menu-text
; clr.b	Link		; No link

Waiting_Loop:
 moveq	#0,d3
 move.b Frame_Time,d3
 moveq	#FRAME_Y,d4
 bsr	PutNumber	; Put the speed of the game on the screen

 clr.w   tios::kb_vars+$1C
 jsr	flib::idle_loop	; Read one key

 cmp.w #264,d0		; ESC
 bne \skip

; Destroy the reserved Handle (for sprite) if we have create it
 ifeq	HANDLEOK
 jsr	tios::HeapFree	
 addq.l	#2,a7	
 endif
 clr.l	ExecAddOnADR	; Clear the add-on.
 clr.l	InitAddOnADR
 move.b #$B2,$17(a6)	; Restore processor's clock
 rts			; Exit fernando 3-c

\skip:
 cmp.w	#CHEAT_KEY,d0	; Cheat code 2 * more speed !!!!!
 bne	\Skip2
 move.w	#2,Turbo
 lea	Turbo_Str(PC),a0
 move.l	a0,(Intro_Text+6)
 bra	Intro

\Skip2:
 cmp.w #KEY_RIGHT,d0		; Right ?
 bne	\Skip2a
 addq.b #1,Frame_Time	; Speed - 1
 bra	Waiting_Loop

\Skip2a:
 cmp.w #KEY_LEFT,d0		; Left ?
 bne	\Skip2b
 subq.b #1,Frame_Time	; Speed + 1
 bra	Waiting_Loop

\Skip2b:
 cmp.w #268,d0
 bne \NoF1
 move.l	#(20*65536+400),Diff	; Easy Mode
 bra \LetsGo

\NoF1:
 cmp.w #269,d0
 bne \NoF2
 move.l	#(50*65536+150),Diff	; Normal Mode
 bra \LetsGo

\NoF2:
 cmp.w #270,d0
 bne	\NoF3
 move.l	#(20000*65536+3),Diff	; Hard Mode
 bra \LetsGo

\NoF3:
; cmp.w	#271,d0
; bne	\NoF4
; move.b	#1,Link		;Set Link
; bra	\NoChoose

\NoF4:
 cmp.w	#272,d0
 bne	Waiting_Loop
 lea	Save(PC),a0	; Load a game
 move.l	LevelADR,a1
 cmp.w	(a0)+,(a1)+
 bne	Waiting_Loop	; Not the same number of levels : Quit
 moveq	#9,d0
\Cmp_Loop:
 cmpm.b	(a1)+,(a0)+
 bne	Waiting_Loop
 lea	254(a1),a1
 dbf	d0,\Cmp_Loop

; Ok it's validate,
 move.w	(a0)+,Vi	; Reading Life

 move.l	LevelADR,a5	; Load Level ADR
 move.l	a5,-(a7)	; Save ADR of Level File
 move.w (a5)+,d7	; Read Number of Levels
 move.w	(a0)+,d6	; Read current Level
 bra	StartFile

\LetsGo:
 bsr	Select_Player	; ?
 bne	Intro
\NoChoose:

StartDebugHere:
 move.w #3,Vi		; Set Life to 3


; On se rappelle l'adresse du monde : World
 move.l	LevelADR,a5
 move.l	a5,-(a7)

; On lit le nombre de niveau dans d7 : Numbers of levels
 move.w (a5)+,d7

; On initialise Level  1 : dans d6  : Level No 1
 moveq #1,d6

AventureMode:
StartFile:
; Extraction du niveau
 move.w d6,d0	; File d0
 move.l	a5,a0	; Adr a0
 jsr    pk92lib::Extract
 tst.b	d0	; Ok ?
 bne	Memory0

; Save the handle on the stack in order to be deleted before quitting
 move.w d1,-(a7)

; ReInit Sprite Table
 move.l SpriteADR,SpriteADREnd

 move.b #LEVEL_COMPLETED,Mort		; Level completed (if not, it will change)

; The adresse is in a1 and the handle in D1.
 movem.l d6-d7/a5-a6,-(a7)
 move.w	(a1)+,d2		; Get the type of the level in d2.w
 cmp.w	#MAX_TYPE_LEVEL,d2
 bls	\Ok			; Level-Type > MaxLevelType ?
 move.w d1,-(a7)		; So it's an aux-program
 jsr	kernel::exec		; Execution
 addq.l #2,a7
 bra	\Skip
\Ok:
 move.w #$0700,d0	; Hight priority level : Set all int off
 trap #1		; Don't really work if you use PlusShell Browser...
 move.w	Type_Code_Table(pc,d2.w),d0
 jsr	Type_Code_Table(pc,d0.w)	; Exec the level
 moveq #0,d0		; Restore all auto-int.
 trap	#1
\Skip:
 movem.l (a7)+,d6-d7/a5-a6

; Destroy the handle of the level file
 jsr	tios::HeapFree
 addq.l	#2,a7
 
; Clear the screen and set Font as GRAS
 jsr		flib::zap_screen
 SetFont	GRAS

; Vie >0 ? Not, Game Over
 tst.w	Vi
 beq	GameOver

; Test
 cmpi.b #QUICK_EXIT,Mort
 bne	NoSave
 bra	SaveIt

Type_Code_Table:
	dc.w	BeginLevel-Type_Code_Table
	dc.w	BeginBoss-Type_Code_Table
	dc.w	JumpLevel-Type_Code_Table
	dc.w	JumpKey-Type_Code_Table

SaveIt:
 WriteStr #END_X,#END_Y,#4,Save_Str
 jsr	flib::idle_loop
 cmp.w	#13,d0
 bne	ExitQuick
 lea	Save(PC),a0
 move.w	d7,(a0)+	; Save the number of levels
 move.l	a5,a1
 moveq	#9,d0
\Cmp_Loop:
 move.b	(a1)+,(a0)+	; Save some data about the world
 lea	254(a1),a1
 dbf	d0,\Cmp_Loop
 move.w	Vi,(a0)		; Save life and
 addq.w	#1,(a0)+	; Add 1 because it's Vi-1+1
 move.w	d6,(a0)+	; Save No-level
 bra	ExitQuick

NoSave:
 cmpi.b	#MEMORY,Mort
 beq	Memory

 cmpi.b	#JUMP_LEVEL,Mort
 bne	\NoJump
 move.w	d5,d6
 bra	StartFile
\NoJump:
 cmpi.b	#LEVEL_COMPLETED,Mort
 bne	StartFile ; We restart this level.

NextLevel:
 cmp.w	d6,d7		; LevlNo = LevelMax ?
 beq	Thatsall
 addq.w	#1,d6		; LevlNo +=1
 bra	StartFile	; Next Level

Memory0:
 jsr	flib::zap_screen
Memory:
 move.w	#4,-(a7)
 pea	Memory_Str(PC)
 bra	Show_The_Text

Thatsall:
 move.w	#4,-(a7)
 pea	Thats_all_Str(PC)
 bra	Show_The_Text

GameOver:
 move.w	#4,-(a7)
 pea	Game_Over_Str(PC)
Show_The_Text:
 move.w	#END_Y,-(a7)
 move.w	#END_X,-(a7)
 jsr	tios::DrawStrXY
 lea	10(a7),a7

; Back to intro
ExitPK92:
 bsr		WaitForAllKey

ExitQuick:
 move.l (a7)+,LevelADR	; restore ADR

 bra Intro

Init2ndScreen:
 addq.l #7,d0
 lsr.l  #3,d0
 move.w d0,Table+2*0		; This adress must be a x 8
 lsl.l  #3,d0
 move.l	d0,SecondScreenIV+2	; Save this Adress
 move.l #LCD_MEM,d0
 move.l d0,Screen
 lsr.l  #3,d0
 move.w d0,Table+2*1
 rts





; *********************************************************************
;
;			LEVELS		FILES
;
; *********************************************************************

JumpLevel:
	move.b	#JUMP_LEVEL,Mort
	move.w	(a1),d5
	rts

JumpKey:
	tst.w	Cf
	beq	JumpLevel
	rts

fer3c@000E:
BeginLevel:
; Try
 cmpa.l #(VIRTUAL_SIZE+SCREEN_SIZE+1000),a7
 bls	ExitLevel	; La pile est surcharge : on quitte immdiatement !
			; User Stack : $0120

; Set the 2nd Screen
 suba.l #(SCREEN_SIZE+8),a7	; On stocke le second cran dans la pile
 move.l a7,d0			; Push Screen2
 bsr	Init2ndScreen

; Set the virtual screen
 suba.l	#(VIRTUAL_SIZE),a7	; On stocke l'cran virtuel dans la pile
 move.l a7,VirtualScreen	; Push VirtualScreen

; Set the level file
 clr.w  d0
 move.b (a1)+,d0
 lsl.w  #5,d0
 move.w d0,StartX		; Read and set the start position
 clr.w  d1
 move.b (a1)+,d1
 lsl.w  #5,d1
 move.w d1,StartY

 move.l a1,LevelADR		; Save adress of Gfx-table
 lea	(128*32)(a1),a1
 move.l a1,LevelTestADR		; Save adress of test-table

; Extract the graph file.
 move.l	a5,a0
 clr.w	d0		; File No 0
 jsr     pk92lib::Extract
 tst.b	d0		; Is  there enought memory left ?
 bne	Overflow	; No Enought Mem
 move.l	a1,GraphADR	; Save Adresse 

; Compte les Bijous et les vies du niveau 
 clr.w d2
 clr.w d3
 move.l #4095,d0
 move.l LevelTestADR,a0
\Loop0:
 move.b (a0)+,d1
 cmpi.b  #4,d1		; Power ?
 bne	  \Skip0
 addq.w #1,d2
\Skip0:
 cmpi.b  #5,d1		; One-Up ?
 bne	  \Skip1
 addq.w #1,d3
\Skip1:
 cmpi.b  #15,d1		; Hyper Power ?
 bne	  \Skip2
 addi.w #8,d2
\Skip2:
 dbf d0,\Loop0

 move.w d2,ComptBj
 move.w d3,ComptVi


; Reset Statut
 clr.l  Bj
 clr.l  BoutON
 move.w #100,v

; Show Statut
 bsr Statut

 bsr	WaitForNotKey

; Init Fernando
 bsr	Init_Fernando

; Clear Time
 clr.l	Clock

StartTeleportation:
 moveq	#6,d0
 move.w  StartX,d1
 move.w  StartY,d2
 bsr	 SpriteInit	; Init explode

; UpDate Scroll Var
 move.w d1,d0
 move.w d2,d1
 bsr	UpDateScrollVar
 move.l	XsNew,Xs

; refresh VirtualScreen
 move.w #4000,YsOld

; Set Mort = False
 move.b #OK,Mort

; Init all sprites in the screen
 moveq	#0,d0
 moveq	#0,d1
 move.w Xs,d0
 move.w Ys,d1
 lsr.l  #5,d0
 lsr.l  #5,d1
 lsl.l  #7,d1		; Taille niveau X = 128 = 2^7
 add.l  d1,d0
 move.l LevelTestADR,a0
 adda.l	d0,a0

 moveq	#0,d0
 moveq  #SCREEN_Y/32,d2		; 4 or 3 ?
\Loop2:
 moveq  #(SC_X/4-1),d1
\Loop: 
 move.b (a0),d0		; Get the test
 cmpi.b #(SpriteAutoStart),d0
 bls	\s1
 bsr	NewSprite
\s1:
 addq  #1,a0
 dbra  d1,\Loop
 lea	(128-SC_X/4)(a0),a0
 dbra	d2,\Loop2

 bsr	WaitForNotKey

; WARNING MAIN LOOP
Loop:

 bsr	ChangeScreen	; Change the current screen

 move.b #1,$17(a6)	; Set the processor' s clock to 1

 bsr	Scrolling	; Put the graphs of the levels on the current
			; screen

 bsr    GetKeyStat	; Read the keys
 Exit_Key_Test		; Exit Key ?
 bne	\skip
 move.b #QUICK_EXIT,Mort		; Quit the Main Loop

\skip:
 Pause_Key_Test
 bne	\skip2
 movem.l d0-d7/a0-a6,-(a7)
 trap #4		; Pause and turn off the calc
 movem.l (a7)+,d0-d7/a0-a6
\skip2:
 
 bsr  SpriteGestion	; Gestion des sprites

 PUT_STATUT

 move.b Frame_Time,d0
\Wait:
 cmp.b $17(a6),d0	; Wait for the processor's clock
 bhi	\Wait

 move.l	XsNew,Xs	; UpDate Scroll Variables

; move.l SpriteADREnd,d0
; sub.l  SpriteADR,d0
; moveq.l #10,d1
; moveq.l #10,d2
; moveq.l #4,d4
; jsr	hexlib::put_hex

; move.l	#0,d0
; moveq	#Row_Key,d5
; lea	keystat(PC),a0
; moveq.l #3,d1
;\Loop:
; move.b	(a0)+,d0
; moveq.l #10,d2
; moveq.l #7,d4
; jsr	hexlib::put_bin
; addq	#1,d1
; dbf	d5,\Loop

 moveq	#0,d0
 move.w	Turbo,d0
 add.l d0,Clock		; The time is incremented

 cmpi.b #OK,Mort
 beq    Loop		; If Mort = False, continue the main loop

; End of Main Loop


 cmpi.b #TELEPORTATION,Mort
 beq	StartTeleportation

 move.w	Table+2(PC),$10(a6)	; Restore correct Screen

 cmpi.b #LEVEL_COMPLETED,Mort
 beq	LevelCompleted
ExitToGameOver:
 subq.w #1,Vi
 bra	exit

LevelCompleted:
 lea		Level_Completed_Text(PC),a3
 moveq.l	#5,d7
 bsr		DrawText
 move.w		Bj,d3
 moveq		#LEVEL2_Y,d4
 bsr		PutNumber
 move.w		Coins,d3
 moveq		#LEVEL5_Y,d4
 bsr		PutNumber
 move.w		ComptBj,d3
 moveq		#SLASH_Y,d4
 bsr		PutNumber
 move.w		ComptVi,d3
 moveq		#LEVEL3_Y,d4
 bsr		PutNumber
 move.l		Clock,d3
 moveq		#LEVEL4_Y,d4
 bsr		PutNumber

 bsr		WaitForAllKey

exit:
 jsr	pk92lib::FreeMem	; Destroy the handle of the Graph File !

 bsr	WaitForNotKey

 adda.l #(VIRTUAL_SIZE+SCREEN_SIZE+8),a7	; Pop Virtual Screen & 2nd Screen

ExitLevel:
 rts

Overflow:
 move.b	#MEMORY,Mort
 bra	exit










BeginBoss:
; Try
 cmpa.l #(SCREEN_SIZE+5*128+1000),a7
 bls	ExitBoss	; La pile est surcharge : on quitte immdiatement !
			; User Stack : $0120

; Set the 2nd Screen
 suba.l #(SCREEN_SIZE+8),a7	; On stocke le second cran dans la pile
 move.l a7,d0
 bsr	Init2ndScreen

; Make a tiny-Buffer for Fernando Test
 suba.l	#(5*128),a7	; 5 Rows of 128 Coloums
 move.l	a7,LevelTestADR
 move.l	a7,a0
 moveq	#(128*4/4-1),d0 ; 4 Rows cleared
\Loop0:
 clr.l	(a0)+
 dbf	d0,\Loop0
 moveq	#(128/4-1),d0
\Loop1:
 move.l	#$01010101,(a0)+
 dbf	d0,\Loop1
 move.l	a7,a0
 lea	6(a0),a0
 moveq	#4,d0
\Loop2:
 move.b	#01,(a0)+
 lea	127(a0),a0
 dbf	d0,\Loop2

; Save a1 (File Adr) while Fernando's initialization
 move.l a1,-(a7)

; Init Fernando for boss
 moveq	 #100,d1
 move.w	d1,Bj
 move.w	d1,StartX
 move.w	d1,StartY
 move.w	d1,BossLife		; Set BossLife
 bsr	Init_Fernando

; Restore a1 (File Adr)
 move.l	(a7)+,a1


; Load NbrElement & NbrPhase 
 moveq	#0,d0
 moveq	#0,d1
 move.b	(a1)+,d0
 move.w	d0,NbrElement
 move.b	(a1)+,d1
 addq.w	#1,d1
 move.w	d1,NbrPhase
 
 move.l a1,LevelADR

; Calcul de TaillePhase
 addq.w	#1,d0
 lsl.w	#1,d0
 addq.w	#1,d0
 move.w	d0,TaillePhase

; Init datas
 clr.l	Phase1		; Phase1 = 0 and Phase2 = 0
 addq.w	#1,Phase2	; Phase2 = 1
 move.l	a1,Phase1ADR
 adda.l	d0,a1
 move.l	a1,Phase2ADR

; Init Phase 0
 move.b	(a1),Vitesse

; Init all elements of the boss

 moveq	#0,d3
\Loop:
 moveq	#14,d0
 bsr	SpriteInit	; One element initialization
 addq.w	#1,d3
 cmp.w	NbrElement,d3
 bls	\Loop

 clr.l	Xs	; Xs & Ys cleared

; Show Statut
 move.b #OK,Mort
 bsr	Statut
 moveq	#0,d7
 lea	Boss_Text(PC),a3
 bsr	DrawTextWithoutClear
 bsr	CopyTo2ndScreen
 SetFont NORMAL

; Clear Time
 clr.l	Clock

Boss_Loop:
 bsr ChangeScreen

 clr.b	Refresh

 move.b #1,$17(a6)	; Set the processor' s clock to 1

; Clear Screen
 move.l	Screen,a0
 moveq	#(SCREEN_Y-1),d1
\Y_Loop:
 moveq	#(SC_X/2-1),d0
\X_Loop:
 clr.w	(a0)+
 dbf	d0,\X_Loop
 NEXT_ROW a0
 dbf	d1,\Y_Loop

; Change Phase
 move.w	Time,d0
 addq.w	#1,d0
 moveq	#1,d1
 move.b	Vitesse,d2
 lsl.w	d2,d1
 cmp.w	d1,d0
 bne	\SkipChangePhase
 move.b	#1,Refresh	; All data of the boss must be refreshed
 move.l	Phase2ADR,a0
 move.l	a0,Phase1ADR
 move.b	(a0),Vitesse
 move.w	Phase2,d1
 move.w	d1,Phase1
 addq.w	#1,d1
 cmp.w	NbrPhase,d1
 bne	\NoBack
 clr.w	Phase2
 move.l	LevelADR,Phase2ADR
 bra	\Go
\NoBack:
 move.w	d1,Phase2
 moveq	#0,d1
 move.w	TaillePhase,d1
 add.l	d1,Phase2ADR
\Go
 clr.w	d0
\SkipChangePhase:
 move.w	d0,Time

; move.l Phase1ADR,d0
; moveq.l #1,d1
; moveq.l #10,d2
; moveq.l #6,d4
; jsr	hexlib::put_hex 

; move.l Phase2ADR,d0
; moveq.l #2,d1
; moveq.l #10,d2
; moveq.l #6,d4
; jsr	hexlib::put_hex 

; move.l LevelADR,d0
; moveq.l #3,d1
; moveq.l #10,d2
; moveq.l #6,d4
; jsr	hexlib::put_hex 

; Read the keys :
 bsr    GetKeyStat
 Exit_Key_Test
 bne	\skip
 move.b #QUICK_EXIT,Mort
\skip:
 Pause_Key_Test
 bne	\skip2
 movem.l d0-d7/a0-a6,-(a7)
 trap #4		; Pause and turn off the calc
 movem.l (a7)+,d0-d7/a0-a6
\skip2:

 bsr  SpriteGestion

 BOSS_SCROLL
 PUT_STATUT

 move.b Frame_Time,d0
\Wait
 cmp.b $17(a6),d0	; Wait for the processor's clock
 bhi	\Wait

 cmpi.b #OK,Mort
 beq    Boss_Loop
; End of Main Loop

 cmp.b	#LEVEL_COMPLETED,Mort
 beq	\NoDec
 subq.w	#1,Vi
\NoDec:

; Restore correct Screen
 move.w	Table+2(PC),$10(a6)

 bsr	WaitForNotKey

; Pop the 2nd Screen & Tyni-Buffer
 adda.l #(SCREEN_SIZE+8+5*128),a7
ExitBoss:
 rts























; ************************************************************
;
;				Sprites
;
; ************************************************************

; Inialisation du sprite No d0.w et ajout dans la 'liste-pile' 
; 	D1.W = X_Start  D2.W = Y_Start D3.W = Adresse relative
; Destruction de a0.l, a1.l, a2.l, d0.l, d1.l, d2.l, d3.l, d4.l
; Pas tout le temps, sinon ...
fer3c@0002:
SpriteInit:
; For debug
; cmp.w	#MAX_INIT_SPRITE,d0	; Normally, we can not have an error ...
; bhi	SpriteInitError		; Warning : If we use these lines, do
				; not use fer3edit
 move.l	SpriteADREnd,a1	
SpriteInitEndBuffer:		; Program will write here !!
 move.l #0,a0			; = SpriteADR + SPRITE_BUFFER

 move.w	Sprite_Init_Code_Table(pc,d0.w),d0

 jsr	Sprite_Init_Code_Table(pc,d0.w)

 move.l	a1,SpriteADREnd		; Save the end of the buffer

SpriteInitError:
 rts

Sprite_Init_Code_Table:
	dc.w Sprite_Init_Fernando-Sprite_Init_Code_Table	;0
	dc.w Sprite_Init_FallDown-Sprite_Init_Code_Table	;2
	dc.w Sprite_Init_Laser-Sprite_Init_Code_Table		;4
	dc.w Sprite_Init_Explosion-Sprite_Init_Code_Table	;6
	dc.w Sprite_Init_Brique-Sprite_Init_Code_Table		;8
	dc.w Sprite_Init_Explosion2-Sprite_Init_Code_Table	;10
	dc.w Sprite_Init_Garbesh-Sprite_Init_Code_Table		;12
	dc.w Sprite_Init_Element-Sprite_Init_Code_Table		;14
	dc.w Sprite_Init_Fernando_Multi-Sprite_Init_Code_Table	;16
	dc.w Sprite_Init_Gestion_Multi-Sprite_Init_Code_Table	;18
	dc.w Sprite_Init_Link_Gestion-Sprite_Init_Code_Table	;20

	dc.w Sprite_Init_Blob-Sprite_Init_Code_Table		;22
	dc.w Sprite_Init_Bat-Sprite_Init_Code_Table		;24
	dc.w Sprite_Init_Fish-Sprite_Init_Code_Table		;26
	dc.w Sprite_Init_Fer_Hunter-Sprite_Init_Code_Table	;28
	dc.w Sprite_Init_Fungus-Sprite_Init_Code_Table		;30
	dc.w Sprite_Init_Ghost-Sprite_Init_Code_Table		;32
	dc.w Sprite_Init_Deca_Vert-Sprite_Init_Code_Table	;34
	dc.w Sprite_Init_Special_Bat-Sprite_Init_Code_Table	;36
	dc.w Sprite_Init_Star-Sprite_Init_Code_Table		;38
	dc.w Sprite_Init_Gray-Sprite_Init_Code_Table		;40
	dc.w Sprite_Init_Scroll_R-Sprite_Init_Code_Table	;42
	dc.w Sprite_Init_Inv-Sprite_Init_Code_Table		;44
	dc.w Sprite_Init_Boat-Sprite_Init_Code_Table		;46
	dc.w Sprite_Init_Sun-Sprite_Init_Code_Table		;48
	dc.w Extra47-Sprite_Init_Code_Table			;50 Extra Option
	dc.w Extra48-Sprite_Init_Code_Table			;52 Extra Option
	dc.w Sprite_Init_Eor-Sprite_Init_Code_Table		;54
	dc.w Sprite_Init_Cinema-Sprite_Init_Code_Table		;56
	dc.w Sprite_Init_Colonne-Sprite_Init_Code_Table		;58
	dc.w Sprite_Init_Montagne-Sprite_Init_Code_Table	;60
	dc.w Sprite_Init_Tirelle-Sprite_Init_Code_Table		;62
	dc.w Sprite_Init_Crabe-Sprite_Init_Code_Table		;64
	dc.w Sprite_Init_Inv2-Sprite_Init_Code_Table		;66
	dc.w Sprite_Init_Gorille-Sprite_Init_Code_Table		;68
	dc.w Sprite_Init_Deca-Sprite_Init_Code_Table		;70
	dc.w Sprite_Init_Mirroir-Sprite_Init_Code_Table		;72
	dc.w Extra59-Sprite_Init_Code_Table			;74 Extra Option
	dc.w Sprite_Init_Anim2-Sprite_Init_Code_Table		;76
	dc.w Sprite_Init_Concentrate-Sprite_Init_Code_Table	;78
	dc.w Sprite_Init_Deca_Sac-Sprite_Init_Code_Table	;80
	dc.w Sprite_Init_Glooner-Sprite_Init_Code_Table		;82
	dc.w Sprite_Init_Boolder-Sprite_Init_Code_Table		;84
	dc.w Sprite_Init_Holo_D-Sprite_Init_Code_Table		;86
	dc.w Sprite_Init_Holo_D2-Sprite_Init_Code_Table		;88
	dc.w Sprite_Init_FlyBoot-Sprite_Init_Code_Table		;90
	dc.w Sprite_Init_Scarat-Sprite_Init_Code_Table		;92
	dc.w Sprite_Init_Point_Dexter-Sprite_Init_Code_Table	;94
	dc.w Sprite_Init_Bloominator-Sprite_Init_Code_Table	;96
	dc.w Sprite_Init_Flammes-Sprite_Init_Code_Table		;98
	dc.w Sprite_Init_Nest1-Sprite_Init_Code_Table		;100
	dc.w Sprite_Init_Nest2-Sprite_Init_Code_Table		;102
	dc.w Sprite_Init_Nest3-Sprite_Init_Code_Table		;104
	dc.w Sprite_Init_NestA-Sprite_Init_Code_Table		;106
	dc.w Sprite_Init_NestB-Sprite_Init_Code_Table		;108
	dc.w Sprite_Init_NestC-Sprite_Init_Code_Table		;110
	dc.w Sprite_Init_Add_On-Sprite_Init_Code_Table		;112

Extra47:
	move.l LevelTestADR,a0
	move.b  #47,0(a0,d3.w)
	rts

Extra48:
	move.l LevelTestADR,a0
	move.b  #48,0(a0,d3.w)
	rts

Extra59:
	move.l LevelTestADR,a0
	move.b  #59,0(a0,d3.w)
	rts

Sprite_Init_Fernando:
 lea	-F_End(a0),a0
 cmp.l	a0,a1	; Is there enougth memory left ?
 bhi	SkipFernando
 clr.w  No(a1)
 move.w StartX,Xj(a1)
 move.w StartY,Yj(a1)
Turbo1:
 move.w Turbo,F_Speed(a1)
 move.w #68,F_Haut(a1)
 clr.l  F_Sens(a1)	; clr.w  F_Sens(a1)	& clr.w  F_Action(a1)
 clr.l	F_Mx(a1)	; clear F_Mx and F_My
 lea F_End(a1),a1
SkipFernando:
 rts

Sprite_Init_Fernando_Multi:
 bsr	Sprite_Init_Fernando
 move.w	#16,(No-F_End)(a1)
 move.w	Bj,(F_Power-F_End)(a1)
 lea (F_Multi_End-F_End)(a1),a1
 rts

Sprite_Init_Gestion_Multi:
 lea	-Gest_Multi_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w	#18,No(a1)
 move.w	NbrJoueur,d0
 mulu.w #(F_Multi_End/4),d0
 subq.w	#1,d0
 move.w	d0,TailleGest(a1)
 clr.w	G_Power(a1)
 lea	Gest_Multi_End(a1),a1
\Skip:
 rts

Sprite_Init_FallDown:
 lea	-FD_End(a0),a0
 cmp.l	a0,a1
 bhi	\skip2
 move.w #2,No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 lea	FD_End(a1),a1
\skip2
 rts

Sprite_Init_Brique:
 moveq #8,d0
LaserEntry:
 lea	-LaserEND(a0),a0
 cmp.l	a0,a1
 bhi	\skip1
 move.w d0,No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d4,LaserVx(a1)
 move.w d5,LaserVy(a1)
 lea LaserEND(a1),a1
\skip1:
 rts

Sprite_Init_Laser:
 moveq #4,d0
 bra	LaserEntry

Sprite_Init_Explosion2:
 moveq #10,d0
 bra Explode

Sprite_Init_Explosion:
 moveq #6,d0
Explode:
 lea	-EXP_END(a0),a0
 cmp.l   a0,a1
 bhi	\skip
 move.w d0,No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 clr.w  EXP_Dx(a1)
 lea EXP_END(a1),a1
\skip:
 rts

Sprite_Init_Garbesh:
 lea	-Garbesh_End(a0),a0
 cmp.l   a0,a1
 bhi	\skip
 move.w #12,No(a1)
 move.w d3,Adresse(a1)
 move.w #64,Garbesh_Temp(a1)
 add.w  #128,d3
 move.l LevelTestADR,a0
 move.b 0(a0,d3.w),Garbesh_Test(a1)
 move.l LevelADR,a0
 move.b 0(a0,d3.w),Garbesh_Dessin(a1)
 lea Garbesh_End(a1),a1
\skip:
 rts

Sprite_Init_Element:
 lea	-Element_End(a0),a0
 cmp.l	a0,a1
 bhi	\skipper
 move.w	#14,No(a1)

; Calcul de l'adresse du graph de l'lment du boss
 moveq	#0,d0
 moveq	#0,d1
 move.w	NbrPhase,d0
 move.w	TaillePhase,d1
 mulu.w	d1,d0
 add.l	LevelADR,d0

 move.l	d3,d1
 lsl.l	#5,d1
 add.l	d1,d0
 move.l	d0,Grph(a1)

 move.w	d3,d0
 lsl.w	#1,d0
 addq.w	#1,d0
 move.w	d0,Nbr(a1)

 bsr	InitHandD

 lea	Element_End(a1),a1
\skipper:
 rts

Sprite_Init_Link_Gestion:
 lea	-Link_Gestion_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w	#20,(a1)+
; move.w #20,No(a1)
; lea	Link_Gestion_End(a1),a1
\Skip:
 rts


Sprite_Init_Blob:
 moveq #(2*SpriteInitStart+2),d0
Sprite_Init_Blob_Entry:
 lea	-Blob_End(a0),a0
 cmp.l	a0,a1
 bhi	skip1
 move.w d0,No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w Turbo,Blob_Vx(a1)
 move.l SpriteADR,a0
 move.w Xj(a0),d0
 cmp.w  d1,d0
 bhi	\Ok
 neg.w  Blob_Vx(a1)
\Ok:

 move.w Turbo,Blob_Vy(a1)
 lea Blob_End(a1),a1
skip1:
 rts

Sprite_Init_Bat:
 moveq #(2*SpriteInitStart+4),d0
 bra	Sprite_Init_Blob_Entry

Sprite_Init_Special_Bat:
 moveq #(2*SpriteInitStart+16),d0
 bra	Sprite_Init_Blob_Entry

Sprite_Init_Fish:
 lea	-Fish_End(a0),a0
 cmp.l	a0,a1
 bhi	\skip2
 move.w #(2*SpriteInitStart+6),No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w	Turbo,d0
 neg.w	d0
 move.w	d0,Fish_Vy(a1)
 move.w	#(32*3),Fish_Loop(a1)
 lea Fish_End(a1),a1
\skip2:
 rts

Sprite_Init_Fer_Hunter:
 lea	-FH_End(a0),a0
 cmp.l	a0,a1	; Is there enougth memory left ?
 bhi	\skip
 move.w #(2*SpriteInitStart+8),No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,FH_Adresse(a1)
 move.w Turbo,F_Speed(a1)
 move.w #68,F_Haut(a1)
 clr.w  F_Sens(a1)
 clr.w  F_Action(a1)
 clr.W  FH_V(a1)
 move.W #100,FH_Bj(a1)
 lea	FH_End(a1),a1
\skip:
 rts
 
Sprite_Init_Fungus:
 lea	  -Fungus_End(a0),a0
 cmp.l  a0,a1
 bhi	  \skipF
 move.w #(2*SpriteInitStart+10),No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w #20,Fungus_Vi(a1)
 lea	Fungus_End(a1),a1
\skipF:
 rts

Sprite_Init_Ghost:
 lea	  -Ghost_End(a0),a0
 cmp.l  a0,a1
 bhi	  \skipG
 move.w #(2*SpriteInitStart+12),No(a1)
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 lea	Ghost_End(a1),a1
\skipG:
 rts

Sprite_Init_Deca_Vert:
 moveq #(2*SpriteInitStart+14),d0
 bra	EorEntry

Sprite_Init_Star:
 lea	-Star_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+18),No(a1)
StarEntry:
 move.w d1,Xj(a1)
StarEntry2:
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 lea	Star_End(a1),a1
SkipStar:
 rts

Sprite_Init_Gray:
 moveq #(2*SpriteInitStart+20),d0
 bra	EorEntry

Sprite_Init_Scroll_R:
 lea	-Scroll_R_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+22),No(a1)
 move.w Xs,Xj(a1)
 bra	StarEntry2

Sprite_Init_Inv:
 lea	-Inv_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+24),No(a1)
 bra	StarEntry

Sprite_Init_Boat:
 lea	-Inv_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+26),No(a1)
 bra	StarEntry

Sprite_Init_Sun:
 moveq #(2*SpriteInitStart+28),d0
SunEntry:
 lea	-Sun_End(a0),a0
 cmp.l	a0,a1
 bhi	\SkipSun
 move.w d0,No(a1)
 lea	Sun_End(a1),a1
\SkipSun:
 rts

Sprite_Init_Eor:
 moveq #(2*SpriteInitStart+30),d0 
EorEntry:
 lea	-Eor_End(a0),a0
 cmp.l  a0,a1
 bhi	SkipStar
 move.w d0,No(a1)
 moveq	#0,d0
 move.l	LevelADR,a0
 move.b 0(a0,d3.w),d0
 lsl.w  #7,d0
 add.l  GraphADR,d0
 move.l d0,Eor_Graph(a1)
 lea	Eor_End(a1),a1
 rts

Sprite_Init_Cinema:
 lea	-Cinema_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w #(2*SpriteInitStart+32),No(a1)
 lea	Cinema_End(a1),a1
\Skip:
 rts

Sprite_Init_Colonne:
 lea	-Colonne_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+34),No(a1)
 move.w d1,d2
 lsr.w  #5,d2
 andi.w #15,d2
 bra	StarEntry

Sprite_Init_Montagne:
 moveq #(2*SpriteInitStart+36),d0
 bra	SunEntry

Sprite_Init_Tirelle:
 lea    -Star_End(a0),a0
 cmp.l  a0,a1
 bhi    SkipStar
 move.w #(2*SpriteInitStart+38),No(a1)
 addi.w	#16,d2
 bra    StarEntry

Sprite_Init_Crabe:
 moveq #(2*SpriteInitStart+40),d0
 bra	Sprite_Init_Blob_Entry
 
Sprite_Init_Inv2:
 lea	-Inv_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+42),No(a1)
 bra	StarEntry

Sprite_Init_Gorille:
 lea	-Gorille_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w	#(2*SpriteInitStart+44),No(a1)
 move.w d1,Xj(a1)
 addi.w #16,d2
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w #(2*32),Gorille_Loop(a1)
 move.w Turbo,Gorille_Vx(a1)
 clr.w Gorille_Sens(a1)
 lea Gorille_End(a1),a1
\Skip:
 rts

Sprite_Init_Deca:
 moveq #(2*SpriteInitStart+46),d0
 bra	EorEntry

Sprite_Init_Mirroir:
 lea	-Star_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+48),No(a1)
 bra	StarEntry

Sprite_Init_Anim2:
 moveq #(2*SpriteInitStart+50),d0
 bra	EorEntry

Sprite_Init_Concentrate:
 lea	-Star_End(a0),a0
 cmp.l	a0,a1
 bhi	SkipStar
 move.w #(2*SpriteInitStart+52),No(a1)
 bra	StarEntry

Sprite_Init_Deca_Sac:
 moveq #(2*SpriteInitStart+54),d0
 bra	EorEntry

Sprite_Init_Glooner:
 move.l	a0,a2
 moveq #(2*SpriteInitStart+56),d0
 addq.w	#1,d2
 bsr	Sprite_Init_Blob_Entry
 move.l	a2,a0
 moveq #(2*SpriteInitStart+56),d0
 addq.w	#5,d1
 addq.w	#5,d2
 bsr	Sprite_Init_Blob_Entry
 move.l	a2,a0
 moveq #(2*SpriteInitStart+56),d0
 addq.w	#5,d1
 addq.w	#5,d2
 bsr	Sprite_Init_Blob_Entry
 move.l	a2,a0
 moveq #(2*SpriteInitStart+56),d0
 addq.w	#5,d1
 addq.w #4,d2
 bra	Sprite_Init_Blob_Entry
 
Sprite_Init_Boolder:
 lea	-Boolder_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w	#(2*SpriteInitStart+58),No(a1)
 addq.w	#7,d1
 addq.w	#7,d2
 move.w d1,Xj(a1)
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w #20,Boolder_Time(a1)
 clr.w	Boolder_C(a1)
 lea	Boolder_End(a1),a1
\Skip:
 rts

Sprite_Init_Holo_D:
 moveq #60,d0
Init_Holo_D_Entry:
 lea	-Holo_D_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w	#(2*SpriteInitStart+60),No(a1)
 move.w d1,Xj(a1)
 addi.w	#16,d2
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w	d0,Holo_D_Sens(a1)
 lea	Holo_D_End(a1),a1
\Skip:
 rts

Sprite_Init_Holo_D2:
 moveq #-60,d0
 bra	Init_Holo_D_Entry

Sprite_Init_FlyBoot:
 moveq.l #(2*SpriteInitStart+62),d0
 bra	Sprite_Init_Blob_Entry

Sprite_Init_Scarat:
 lea	-Scarat_End(a0),a0
 cmp.l	a0,a1
 bhi	\Skip
 move.w	#(2*SpriteInitStart+64),No(a1)
 move.w d1,Xj(a1)
 addi.w	#16,d2
 move.w d2,Yj(a1)
 move.w d3,Adresse(a1)
 move.w	#SCARAT,Dessin(a1)
 move.w Turbo,d0
 move.w	d0,Scarat_Sens(a1)
 move.w	#60,Scarat_Loop(a1)
 clr.w	Scarat_Xj_2(a1)
 move.w d0,Scarat_Sens_2(a1)
 move.w	#16,Scarat_Loop_2(a1)
 lea	Scarat_End(a1),a1
\Skip:
 rts

Sprite_Init_Point_Dexter:
 lea	-Point_End(a0),a0
 cmp.l	a0,a1
 bhi	Skip_Bloomi
 move.w #(2*SpriteInitStart+66),No(a1)
 move.w	#POINT_DEXTER,Dessin(a1)
 move.w	#80,Point_Loop(a1)
Point_Dexter_Init_Entry:
 move.w	d1,Xj(a1)
 addq.w	#7,d2
 move.w	d2,Yj(a1)
 move.w	d3,Adresse(a1)
 move.w	Turbo,Point_Sens(a1)
 lea	Point_End(a1),a1
Skip_Bloomi:
 rts

Sprite_Init_Bloominator:
 lea	-Point_End(a0),a0
 cmp.l	a0,a1
 bhi	Skip_Bloomi
 move.w #(2*SpriteInitStart+68),No(a1)
 move.w #16,Point_Loop(a1)
 move.w #BLOOMINATOR,Dessin(a5)
 addq.w	 #7,d1
 addi.w	#9,d2
 bra	Point_Dexter_Init_Entry
 
Sprite_Init_Flammes:
 lea	(-2*Flamme_End)(a0),a0
 cmp.l	a0,a1
 bhi	\Next
 moveq #(2*SpriteInitStart+70),d0
 move.w	d0,No(a1)
 move.w	d1,Xj(a1)
 add.w	#16,d2
 move.w	d2,Yj(a1)
 move.w	d3,Adresse(a1)
 move.w	Turbo,Flamme_Sens(a1)
 move.w #64,Flamme_Loop(a1)
 lea	Flamme_End(a1),a1
 move.w	d0,No(a1)
 addi.w	#(64),d1
 move.w	d1,Xj(a1)
 move.w	d2,Yj(a1)
 move.w	d3,Adresse(a1)
 move.w	#-1,Flamme_Sens(a1)
 move.w #64,Flamme_Loop(a1)
 lea	Flamme_End(a1),a1 
\Next:
 rts

Sprite_Init_Nest1:
 moveq	#72,d0
 moveq	#32,d0
 moveq	#0,d4
 bra	Sprite_Init_Nest

Sprite_Init_Nest2:
 moveq	#73,d0
 moveq	#80,d4
 moveq	#0,d5
 bra	Sprite_Init_Nest

Sprite_Init_Nest3:
 moveq	#74,d0
 moveq	#127,d4
 moveq	#0,d5
 bra	Sprite_Init_Nest

Sprite_Init_NestA:
 moveq	#75,d0
 moveq	#16,d4
 moveq	#4,d5
 bra	Sprite_Init_Nest

Sprite_Init_NestB:
 moveq	#76,d0
 moveq	#40,d4
 moveq	#4,d5
 bra	Sprite_Init_Nest

Sprite_Init_NestC:
 moveq	#77,d0
 moveq	#90,d4
 moveq	#4,d5
Sprite_Init_Nest:
 lea	(-Nest_End)(a0),a0
 cmp.l	a0,a1
 bhi	\Next
 move.w #(2*SpriteInitStart+72),No(a1)
 move.w	d1,Xj(a1)
 move.w	d2,Yj(a1)
 move.w	d3,Adresse(a1)
 move.w	d4,Nest_T(a1)
 move.w	d5,Nest_Kill(a1)
 clr.w	Nest_Count(a1)
 move.w	d0,Nest(a1)
 move.l LevelADR,a0
 move.b 0(a0,d3.w),Nest_Gfx(a1)
 clr.b	0(a0,d3.w)
 lea	Nest_End(a1),a1
\Next:
ErrorAddOn:
 rts

Sprite_Init_Add_On:
 move.l	InitAddOnADR,a2
 move.l	a2,d0
 beq	ErrorAddOn
 moveq	#(2*SpriteInitStart+74),d0
 jmp	(a2)




SpriteGestion:
 move.l SpriteADR,a5

\GestSpriteLoop:
 moveq	#0,d0
 moveq	#0,d1
 move.w	No(a5),d0	; Get the type of the sprite
; cmp.w	#MAX_SPRITE,d0
; bhi	\Error		; Normaly, we can not have an error ...
 move.w	Sprite_Code_Table(pc,d0.w),d0     
 jsr	Sprite_Code_Table(pc,d0.w)
 cmp.l	SpriteADREnd,a5	; End of the Sprite-Buffer ?
 bmi	\GestSpriteLoop
\Error:
 rts

; Lors d'un appel vers un sprite, d1.l = 0 mais seulement les 16 plus
; hauts bits de d0 sont  zro !

Sprite_Code_Table:
	dc.w Sprite_Fernando-Sprite_Code_Table		;0
	dc.w Sprite_FallDown-Sprite_Code_Table		;2
	dc.w Sprite_Laser-Sprite_Code_Table		;4
	dc.w Sprite_Explosion-Sprite_Code_Table		;6
	dc.w Sprite_Brique-Sprite_Code_Table		;8
	dc.w Sprite_Explosion2-Sprite_Code_Table	;10
	dc.w Sprite_Garbesh-Sprite_Code_Table		;12
	dc.w Sprite_Element-Sprite_Code_Table		;14
	dc.w Sprite_Fernando_Multi-Sprite_Code_Table	;16
	dc.w Sprite_Gestion_Multi-Sprite_Code_Table	;18
	dc.w Sprite_Link_Gestion-Sprite_Code_Table	;20

	dc.w Sprite_Blob-Sprite_Code_Table		;22
	dc.w Sprite_Bat-Sprite_Code_Table		;24
	dc.w Sprite_Fish-Sprite_Code_Table		;26
	dc.w Sprite_Fer_Hunter-Sprite_Code_Table	;28
	dc.w Sprite_Fungus-Sprite_Code_Table		;30
	dc.w Sprite_Ghost-Sprite_Code_Table		;32
	dc.w Sprite_Deca_Vert-Sprite_Code_Table		;34
	dc.w Sprite_Special_Bat-Sprite_Code_Table	;36
	dc.w Sprite_Star-Sprite_Code_Table		;38
	dc.w Sprite_Gray-Sprite_Code_Table		;40
	dc.w Sprite_Scroll_Right-Sprite_Code_Table	;42
	dc.w Sprite_Inv-Sprite_Code_Table		;44
	dc.w Sprite_Boat-Sprite_Code_Table		;46
	dc.w Sprite_Sun-Sprite_Code_Table		;48
	dc.w Sprite_Eor-Sprite_Code_Table		;50
	dc.w Sprite_Cinema-Sprite_Code_Table		;52
	dc.w Sprite_Colonne-Sprite_Code_Table		;54
	dc.w Sprite_Montagne-Sprite_Code_Table		;56
	dc.w Sprite_Tirelle-Sprite_Code_Table		;58
	dc.w Sprite_Crabe-Sprite_Code_Table		;60
	dc.w Sprite_Inv2-Sprite_Code_Table		;62
	dc.w Sprite_Gorille-Sprite_Code_Table		;64
	dc.w Sprite_Deca-Sprite_Code_Table		;66
	dc.w Sprite_Mirroir-Sprite_Code_Table		;68
	dc.w Sprite_Anim2-Sprite_Code_Table		;70
	dc.w Sprite_Conc_Scroll-Sprite_Code_Table	;72
	dc.w Sprite_Deca_Sac-Sprite_Code_Table		;74
	dc.w Sprite_Glooner-Sprite_Code_Table		;76
	dc.w Sprite_Boolder-Sprite_Code_Table		;78
	dc.w Sprite_Holo_D-Sprite_Code_Table		;80
	dc.w Sprite_FlyBoot-Sprite_Code_Table		;82
	dc.w Sprite_Scarat-Sprite_Code_Table		;84
	dc.w Sprite_Point_Dexter-Sprite_Code_Table	;86
	dc.w Sprite_Bloominator-Sprite_Code_Table	;88
	dc.w Sprite_Flamme-Sprite_Code_Table		;90
	dc.w Sprite_Nest-Sprite_Code_Table		;92
	dc.w Sprite_Add_On-Sprite_Code_Table		;94


Sprite_Fernando:
;	Moteur du personnage principal similaire  Fer 3 v2.55
;      (qqs Optimisations en plus)
;	a5 -> Adresse du personnage
;	d6 -> X position du perso
;	d7 -> Y position du perso
;	d5 -> KeyStat.b

 move.w Xj(a5),d6
 move.w Yj(a5),d7

; F5, F6 & F7 -> Speed = 1, 2 or 4

 Speed1_Key_Test
 bne    FerNoF5
 move.w Turbo,F_Speed(a5)
 move.w #68,F_Haut(a5)
FerNoF5:
 Speed2_Key_Test
 bne FerNoF6
 move.w	Turbo,d0
 add.w	d0,d0
 move.w d0,F_Speed(a5)
 move.w #70,F_Haut(a5)
FerNoF6:
 Speed3_Key_Test
 bne FerNoF7
 move.w	Turbo,d0
 lsl.w	#2,d0
 move.w d0,F_Speed(a5)
 move.w #72,F_Haut(a5)
FerNoF7:

 move.b keystat,d5
 move.w d6,d0
 move.w d7,d1

; Left ?
 btst.b #Left_Key,d5
 bne    NoLeft

 move.w #1,F_Sens(a5)
 sub.w  F_Speed(a5),d0
 bsr    GetTest
 beq    SuiteAct
 move.w d0,d6
 bra	SuiteAct

; Right ?
NoLeft: 
 btst.b #Right_Key,d5
 bne    SuiteAct
 clr.w  F_Sens(a5)
 add.w  F_Speed(a5),d0
 bsr    GetTest
 beq    SuiteAct
 move.w d0,d6
SuiteAct:

; Test sortie Gauche/Droite
 cmpi.w #4080,d0	; 32 * tailleX - TaillXFer
 bls    Suitegd0
 clr.w  F_Mx(a5)
 clr.w  d6
 cmpi.w #10000,d0
 bhi    Suitegd0
 move.w #4080,d6
Suitegd0:

 move.w   F_Action(a5),d0
 move.w   Action_Code_Table(pc,d0.w),d0     
 jsr      Action_Code_Table(pc,d0.w)

 bsr	Limites
 bsr	ReadOption
 
 move.w d6,Xj(a5)
 move.w d7,Yj(a5)

 moveq	#0,d2
 move.w	d6,d0
 move.w	d7,d1
 move.w	Dessin(a5),d2
 add.w	F_Sens(a5),d2
 bsr	PutSprite

; Print the shield
 move.w v,d2
 beq	\Escape
 subq.w #1,d2
 move.w d2,v
 moveq	#BULLE,d2
 bsr	PutSprite
\Escape:

; Mise  jour des coordonnes du scrolling
 bsr	UpDateScrollVar

; Next Sprite
 lea	F_End(a5),a5
 rts

Action_Code_Table:
	dc.w Tombe-Action_Code_Table		; 0
	dc.w Marche-Action_Code_Table		; 2
	dc.w Saut-Action_Code_Table		; 4
	dc.w Bumper-Action_Code_Table		; 6
	dc.w Propulseur-Action_Code_Table	; 8
	dc.w Special_Saut-Action_Code_Table	; 10
	dc.w Accroche-Action_Code_Table		; 12
	dc.w PasseurAct-Action_Code_Table	; 14
	dc.w Fly-Action_Code_Table		; 16

Special_Saut:
 move.w #SPECIAL_SAUT,Dessin(a5)
 bra	SautRoutine

Saut:
 move.w #SAUT,Dessin(a5)
SautRoutine:
 move.w F_St(a5),d2
 blt   Sau2
 and.w #15,d2
 bne   SautEntry
 btst.b #Jump_Key,d5
 beq   SautEntry
 clr.w F_St(a5)
SautEntry:
 move.w F_Speed(a5),d2
 sub.w  d2,F_St(a5)
 move.w d6,d0
 move.w d7,d1
 sub.w  d2,d1
 bsr    GetTest
 beq    SautEnd
 move.w d1,d7
SautEnd:
 rts 
Sau2:
 clr.w F_Action(a5)

Tombe:
 move.w d6,d0
 move.w d7,d1
 add.w	F_Speed(a5),d1
 bsr	GetTest
 bne    \TombeL1
 move.w d7,d1
 addq.w #1,d1		; Corrige un bug <= Vitesse >1
 bsr	GetTest
 beq    Marche
\TombeL1:
 move.w d1,d7
 move.w #TOMBE,Dessin(a5)
 rts

Marche:
 btst.b #Jump_Key,d5
 bne  Mar1
 move.w F_Haut(a5),d2
 move.w d2,F_St(a5)
 move.w #4,F_Action(a5)
 bra  SautEntry

Mar1:
 cmpi.b #255,d5
 bne    Mar2
 tst.b	F_BWait(a5)
 beq    PasseTemps
 addq.b #1,F_BWait(a5)
 move.w #DEBOUT,Dessin(a5)
 rts

Mar2:
 move.b #1,F_BWait(a5)
 move.w #MARCHE,Dessin(a5)
MarcheEntry:
 move.w  F_Phase(a5),d0
 addq.w  #1,d0
 andi.w  #31,d0
 move.w  d0,F_Phase(a5)
 andi.w  #24,d0
 lsr.w   #2,d0
 add.w   d0,Dessin(a5)
 rts

PasseTemps:
 move.w #PASSE_TEMPS,Dessin(a5)
 bra    MarcheEntry

Bumper:
 move.w F_St(a5),d2
 blt    Sau2
 move.w #BUMPER,Dessin(a5)
 bsr    MarcheEntry
 bra    SautEntry

Propulseur:
 move.w F_Mx(a5),d0
 bne	PropSuite
 tst.w	F_My(a5)
 beq	ThatsAll
PropSuite:
 add.w  d6,d0
 move.w d7,d1
 clr.w  F_Sens(a5)
 bsr    GetTest
 beq    ThatsAll
 move.w d0,d6
 add.w  F_My(a5),d1
 bsr    GetTest
 beq    ThatsAll
 move.w d1,d7
 rts

ThatsAll:
 clr.l  F_Mx(a5)
 bra    Sau2 

Accroche:
 move.w #ACCROCHE,Dessin(a5)
 btst.b #Right_Key,d5
 beq    \Exit0
 btst.b #Left_Key,d5
 bne    Accroche_Exit1
\Exit0:
 bsr    MarcheEntry
Accroche_Exit1:
 btst.b #Jump_Key,d5
 bne    \Exit2
 move.w F_Haut(a5),d0
 move.w d0,F_St(a5)
 move.w #4,F_Action(a5)
 rts
\Exit2:
 clr.w  F_Action(a5)
 rts

PasseurAct:
 move.w F_Phase(a5),d0
 addq.w #1,d0
 andi.w #31,d0
 move.w d0,F_Phase(a5)
 lsr.w  #4,d0
 add.w  #PASSEUR,D0
 move.w d0,Dessin(a5)
 clr.w  F_Sens(a5)

 move.w Time,d1
 lsr.w  #4,d1
 andi.w #31,d1
 and.w  #$FFE0,d7
 cmpi.w #16,d1
 bls	\Nothing
 add.w  #32,d7
 neg.w  d1
\Nothing:
 add.w  d1,d7
 bra	Accroche_Exit1

Fly:
; Explosion ?
 move.w  Time,d0
 andi.w  #127,d0
 bne	\skip
 moveq #10,d0
 move.w  d6,d1
 move.w  d7,d2
 bsr	SpriteInit
\skip:
 move.W d6,d0
 move.w d7,d1
 move.w #FLY,Dessin(a5)

; Up ?
 btst.b #Up_Key,d5
 bne    \NoDown

 move.w #FLY_UP,Dessin(a5)
 sub.w  F_Speed(a5),d1
 bsr    GetTest
 beq    SuiteAct2
 move.w d1,d7
 rts

; Down ?
\NoDown:
 btst.b #Down_Key,d5
 bne    SuiteAct2
 move.w #FLY_DOWN,Dessin(a5)
 add.w  F_Speed(a5),d1
 bsr    GetTest
 beq    SuiteAct2
 move.w d1,d7
SuiteAct2:
 rts

Limites:
; Test sortie Gauche/Droite
 move.w	d6,d0
 cmpi.w #4080,d0	; 32 * tailleX - TaillXFer
 bls    Suitegd
 clr.w  F_Mx(a5)	; Stop X-propulsor 
 clr.w  d6		; X = 0
 cmpi.w #10000,d0
 bhi    Suitegd
 move.w #4080,d6	; X = 4080
Suitegd:

; Test sortie Haut/Bas
 cmpi.w	#1004,d7
 bls	Suitehb
 cmpi.w	#2000,d7
 bhi	SortieHaut
 clr.b	Mort		; You die !
SortieHaut:
 clr.w	F_My(a5)	; Stop Up-propulsor
 clr.w	d7		; Y=0
Suitehb:
 rts

fer3c@000F:
ReadOption:		; Lecture des options
 move.w d6,d0
 move.w d7,d1

 clr.w  d2
 bsr    Lecture
 add.w  d2,d2
 move.w Option_Code_Table(pc,d2.w),d2     
 jsr    Option_Code_Table(pc,d2.w)

 add.w  #15,d1
 clr.w  d2
 bsr    Lecture
 add.w  d2,d2
 move.w Option_Code_Table(pc,d2.w),d2     
 jsr    Option_Code_Table(pc,d2.w)

 add.w  #15,d0
 clr.w  d2
 bsr	Lecture
 add.w  d2,d2
 move.w Option_Code_Table(pc,d2.w),d2     
 jsr    Option_Code_Table(pc,d2.w)

 sub.w  #15,d1
 clr.w  d2
 bsr	Lecture
 add.w	d2,d2
 move.w	Option_Code_Table(pc,d2.w),d2     
 jsr    Option_Code_Table(pc,d2.w)

 rts

Option_Code_Table:	
	dc.w Rien-Option_Code_Table			;0
	dc.w Rien-Option_Code_Table			;1
	dc.w PlateForme-Option_Code_Table		;2
	dc.w Monte-Option_Code_Table			;3
	dc.w Bijou-Option_Code_Table			;4
	dc.w OneUp-Option_Code_Table			;5
	dc.w BumperG-Option_Code_Table			;6
	dc.w Clef-Option_Code_Table			;7
	dc.w Porte-Option_Code_Table			;8
	dc.w Pic-Option_Code_Table			;9
	dc.w Haut-Option_Code_Table			;10
	dc.w Bas-Option_Code_Table			;11
	dc.w Gauche-Option_Code_Table			;12
	dc.w Droite-Option_Code_Table			;13
	dc.w Arrive-Option_Code_Table			;14
	dc.w GrosBijou-Option_Code_Table		;15
	dc.w Invulnerable-Option_Code_Table		;16
	dc.w GoFallDown-Option_Code_Table		;17
	dc.w Teleportation-Option_Code_Table		;18
	dc.w HyperVitesse-Option_Code_Table		;19
	dc.w GoLaser-Option_Code_Table			;20
	dc.w Apesanteur-Option_Code_Table		;21
	dc.w Bouton-Option_Code_Table			;22
	dc.w PorteBouton-Option_Code_Table		;23
	dc.w AccrocheOpt-Option_Code_Table		;24
	dc.w Passeur-Option_Code_Table			;25
	dc.w Voler-Option_Code_Table			;26
	dc.w Bombe-Option_Code_Table			;27
	dc.w WallExploded-Option_Code_Table		;28
	dc.w Garbesh_Collector-Option_Code_Table	;29
	dc.w A_Block-Option_Code_Table			;30
	dc.w Plan0-Option_Code_Table			;31
	dc.w Plan1-Option_Code_Table			;32
; Starting Sprites : Normalement le perso ne devrait jamais arriv  ces tests
	dc.w Rien-Option_Code_Table			;33	Blob
	dc.w Rien-Option_Code_Table			;34	Bat
	dc.w Rien-Option_Code_Table			;35	Fish
	dc.w Rien-Option_Code_Table			;36	Fer Hunter
	dc.w Rien-Option_Code_Table			;37	Fungus
	dc.w Rien-Option_Code_Table			;38	Ghost
	dc.w Rien-Option_Code_Table			;39	Water Fall
	dc.w Rien-Option_Code_Table			;40	Special Bat
	dc.w Rien-Option_Code_Table			;41	Star
	dc.w Rien-Option_Code_Table			;42	Gray
	dc.w Rien-Option_Code_Table			;43	Scroll_R
	dc.w Rien-Option_Code_Table			;44	Shifting
	dc.w Rien-Option_Code_Table			;45	Mal de mer
	dc.w Rien-Option_Code_Table			;46	Sun
	dc.w Extra_Pente_Droite-Option_Code_Table	;47	Extra Option : Not a sprite
	dc.w Extra_Pente_Gauche-Option_Code_Table	;48	Extra Option : Not a sprite
	dc.w Rien-Option_Code_Table			;49	Eor-Xor
	dc.w Rien-Option_Code_Table			;50	Cinma
	dc.w Rien-Option_Code_Table			;51	Colonnes
	dc.w Rien-Option_Code_Table			;52	Montagne
	dc.w Rien-Option_Code_Table			;53	Tirelle
	dc.w Rien-Option_Code_Table			;54	Crabe
	dc.w Rien-Option_Code_Table			;55	Shifting 2
	dc.w Rien-Option_Code_Table			;56	Gorille
	dc.w Rien-Option_Code_Table			;57	Deca-Rol
	dc.w Rien-Option_Code_Table			;58	Mirroir
	dc.w Link_Graph_Test-Option_Code_Table		;59	Extra Option
	dc.w Rien-Option_Code_Table			;60	Anim 2
	dc.w Rien-Option_Code_Table			;61	Concentrate Scroll
	dc.w Rien-Option_Code_Table			;62	Deca_Sac
	dc.w Rien-Option_Code_Table			;63	Glooner
	dc.w Rien-Option_Code_Table			;64	Boolder
	dc.w Rien-Option_Code_Table			;65	Holo_D...
	dc.w Rien-Option_Code_Table			;66	Holo_D... 2
	dc.w Rien-Option_Code_Table			;67	FlyBoot
	dc.w Rien-Option_Code_Table			;68	Scarat
	dc.w Rien-Option_Code_Table			;69	Point_Dexter
	dc.w Rien-Option_Code_Table			;70	Bloominator
	dc.w Rien-Option_Code_Table			;71	Flamme
	dc.w Rien-Option_Code_Table			;72	Nest 1
	dc.w Rien-Option_Code_Table			;73	Nest 2
	dc.w Rien-Option_Code_Table			;74	Nest 3
	dc.w Rien-Option_Code_Table			;75	Nest 4
	dc.w Rien-Option_Code_Table			;76	Nest 5
	dc.w Rien-Option_Code_Table			;77	Nest 6
	dc.w Rien-Option_Code_Table			;78	Add-On

PlateForme:
	movem.l d0-d2,-(a7)
	move.w  d1,d2
	andi.w  #28,d2
	bne 	\PlateFormeSuite
	and.w	#$FFE0,d1
	sub.w   #16,d1
	ble	\PlateFormeSuite
	move.w  d6,d0
	bsr	GetTest
	beq	\PlateFormeSuite
	move.w  d1,d7
	bsr	Marche
\PlateFormeSuite:
	movem.l (a7)+,d0-d2
A_Block:
Rien:	
	rts	; Pas trs joli mais 4 octets en moins

Monte:
	movem.l d0-d2,-(a7)
	move.w  d6,d0
	move.w  d7,d1
	sub.w   F_Speed(a5),d1
	bsr	GetTest
	beq	\skip
	tst.w   d1
	ble	\skip
	move.w  d1,d7
\skip:	bsr	Marche
	movem.l (a7)+,d0-d2
	sub.w   F_Speed(a5),d1
	rts

GrosBijou:
	addq.w	#7,Bj
	addq.w	#7,Coins
Bijou:
	addq.w	#1,Coins
	addq.w	#1,Bj
	bsr PutPower
Clear:
	movem.l d0-d1/a0,-(a7)
	lsr.w  #5,d0
	lsr.w  #5,d1
	lsl.w  #7,d1		; Taille niveau X = 128 = 2^7
	add.w  d0,d1
	move.l LevelTestADR,a0
	clr.b  0(a0,d1.w)
	move.l LevelADR,a0
	clr.b  0(a0,d1.w)
	
	move.W	#4000,YsOld	; Oblige le rafraichissement de l'cran virtuel
	bsr	CopyTo2ndScreen
	movem.l (a7)+,d0-d1/A0
	rts

OneUp:
	addq.w	#1,Vi
	bsr	PutLife
	bra	Clear


Invulnerable:
	move.w #1000,v
	bra	Clear

Apesanteur:
	tst.w	F_Speed(a5)
	blt	\skip
	neg.w	F_Speed(a5)
\skip:
	rts

Clef:	
	addq.w	#1,Cf
Cl125:	
	bsr	PutKey
	bra	Clear

Bouton:
	tst.b	BoutON
	bne	\skip
	st	BoutON
	movem.l d0-d1,-(a7)
	bsr	PutON
	movem.l (a7)+,d0-d1
\skip:
	rts

Porte:
	move.w  Cf,d2
 	beq 	NoPass
	subq.w  #1,d2
	MOVE.w  d2,Cf
	bra	Cl125

NoPass: move.w	d1,d2
	and.w	#$FFE0,d2
	cmp.w	d2,d7
	bge	\NoUp
	sub.w	F_Speed(a5),d7
	rts
\NoUp:  move.w	d0,d2
	and.w	#$FFE0,d2
	cmp.w	d2,d6
	blt	\Right
	add.w  	F_Speed(a5),d6
	rts
\Right:	sub.w	F_Speed(a5),d6
	rts

PorteBouton:
	tst.b BoutON
	beq	NoPass
	clr.b	BoutON
	movem.l d0-d1,-(a7)
	bsr	Clear
	bsr	PutOFF
	movem.l (a7)+,d0-d1
	rts

BumperG:
	move.l d1,-(a7)
	and.w	#31,d1
	cmp.w	#20,d1
	ble	\BumpNotOK
	move.w	#6,F_Action(a5)
	move.W	F_Haut(a5),d2
	add.w	d2,d2
	move.w	d2,F_St(a5)	     ; Puissance Bumper
\BumpNotOK:
	move.l	(a7)+,d1
	rts

Pic:
	movem.l d0-d1,-(a7)
	and.w 	#$0018,d1
	eor.w 	#$0018,d1
	bne  	\PicRien
	bsr	Touche
\PicRien:
	movem.l (a7)+,d0-d1
	rts

Haut:	
	move.W #8,F_Action(a5) 
	move.w F_Speed(a5),d2
	add.w  d2,d2
	neg.w  d2
	move.w d2,F_My(a5)
	move.w #HAUT,Dessin(a5)
	rts
Bas:	
	move.w #8,F_Action(a5)
	move.w F_Speed(a5),d2
	add.w  d2,d2
	move.w d2,F_My(a5)
	move.w #BAS,Dessin(a5)
	rts

Gauche:
	move.w #8,F_Action(a5)
	move.w F_Speed(a5),d2
	add.w  d2,d2
	neg.w  d2
	move.w d2,F_Mx(a5)
	move.w #GAUCHE,Dessin(a5)
	rts

Droite:
	move.w #8,F_Action(a5)
	move.w F_Speed(a5),d2
	add.w  d2,d2
	move.w d2,F_Mx(a5)
	move.w #DROITE,Dessin(a5)
	rts

Arrive:
	move.b #LEVEL_COMPLETED,Mort
	rts

GoFallDown:
 movem.l d0-d3/a0-a1,-(a7)
 bsr	 ClearTab
 move.w  d1,d3
 moveq #2,d0
 move.w  d6,d1
 move.w  YsOld,d2
 bsr	 SpriteInit
 movem.l (a7)+,d0-d3/a0-a1
 rts

GoLaser:
 movem.l d0-d5/a0-a1,-(a7)
 move.w  Time,d0
 andi.w  #15,d0
 bne	 \Skip
 moveq #4,d0
 move.w  XsOld,d1
 move.w  d7,d2
 moveq #2,d4
 moveq #0,d5
 bsr	 SpriteInit
 moveq #4,d0
 addi.w  #(32*7-20),d1
 moveq #-2,d4
 bsr	 SpriteInit
\Skip:
 movem.l (a7)+,d0-d5/a0-a1
 rts
 

Teleportation:
 btst.b #Down_Key,d5		; Bas est-il presse ?
 bne \NotOk
 movem.l d0-d3/a0,-(a7)
 move.l d1,d3
\Loop1:
 addi.w #32,d1
 bsr	Lecture
 cmpi.b  #18,d2
 beq	\Found
 cmpi.w  #(32*32),d1	; Est-on arriv  la fin (Verticalement) du niveau ?
 bls	\Loop1
 moveq #-1,d1
\Loop2:
 addi.w #32,d1
 bsr	Lecture
 cmpi.b  #18,d2
 beq	\Found
 cmp.w  d3,d1
 bls	\Loop2
\Found:
 andi.w #$FFE0,d0
 andi.w #$FFE0,d1
 move.w d0,d6
 move.w d1,d7
 move.w	d0,StartX	; You need it for Multi-Player
 move.w	d1,StartY	;
 move.b #TELEPORTATION,Mort	; Fernando will restart at this new point
 movem.l (a7)+,d0-d3/a0
\NotOk:
 rts
 
HyperVitesse:
 move.w	Turbo,d0
 lsl.w	#3,d0
 move.w d0,F_Speed(a5)
 rts

AccrocheOpt:
 move.w  d7,d2
 and.w   #24,d2		; Bonne hauteur dans la case ?
 bne	\No
 btst.b #Up_Key,d5		; Haut est-il apuyee ?
 bne    \No
 and.w	#$FFE0,d7	; Pas d7 -> d1 sinon Crash (Tout en haut)!
 move.w #12,F_Action(a5)
\No:
 rts

Passeur:
 move.l d1,-(a7)
 and.w	#$FFE0,d1
 cmp.w  d7,d1
 bhi	\SkIp
 add.w  #17,d1
 cmp.w  d7,d1
 bls	\SkIp
 cmp.w #8,F_Action(a5)
 beq \SkIp
 move.w #14,F_Action(a5) 
\SkIp:
 move.l (a7)+,d1
 rts

Voler:
 move.w #16,F_Action(a5)
 rts

Bombe:
 movem.l d0-d1,-(a7)
 clr.w  v		; The bomb is so powerFull that the shield is destroyed
 bsr	Touche
 move.w d1,d2
 move.w d0,d1
 bsr	\BombeA
 add.w  #32,d1
 bsr	\BombeA
 add.w	#32,d2
 bsr	\BombeA
 sub.w	#32,d1
 bsr	\BombeA
 movem.l (a7)+,d0-d1
 bra	Clear
\BombeA:
 moveq	#6,d0
 bsr	SpriteInit
 moveq	#10,d0
 bsr	SpriteInit
 rts

WallExploded:
 movem.l d0-d5/a0-a1,-(a7)
 and.w   #$FFE0,d0
 and.w	 #$FFE0,d1
 move.w  d1,d2 		; Position Y
 move.w  d0,d1		; Position X
 moveq #-1,d4		; Vx
 moveq #1,d5		; Vy
 moveq.l #8,d0		; Type = Brique
 bsr	 SpriteInit
 moveq #2,d5		; Vy
 moveq.l #8,d0		; Type
 bsr	 SpriteInit
 add.w	 #32,d1
 moveq #1,d4
 moveq.l #8,d0
 bsr	SpriteInit
 moveq #1,d5
 moveq.l #8,d0
 bsr	SpriteInit
 movem.l (a7)+,d0-d5/a0-a1
 bra	Clear
 
Garbesh_Collector:
 movem.l d0-d3/a0-a1,-(a7)
 bsr	 ClearTab
 move.w  d1,d3 
 moveq #12,d0
 bsr	 SpriteInit
 movem.l (a7)+,d0-d3/a0-a1
 rts

Plan0:
 tst.b Plan
 bne	SwitchBetweenPlan
Retour:
 rts

Plan1:
 tst.b Plan
 bne   Retour
SwitchBetweenPlan:
 MOVE.w #4000,YsOld	; Refresh VirtualScreen
 eori.b #1,Plan		; Change Plan
 movem.l d0-d2/a0-a1,-(a7)
 move.l  LevelADR,a0
 move.l  LevelTestADR,a1
 move.b  (a0)+,d2
 addq.l  #1,a1
 move.l  #(32*128-2),d0
\Loop:
 move.b (a1)+,d1
 cmpi.b  #30,d1
 bne	\NoInvTestToGraph
 move.b #1,-1(a1)
 move.b d2,(a0)+
 bra	\NextLoop
\NoInvTestToGraph:
 subq.b  #1,d1	; <=> cmpi.b  #1,d1 et d1 dtruit
 bne	 \NextLoop0
 cmp.b   (a0),d2
 bne     \NextLoop0
 clr.b   (a0)
 move.b  #30,-1(a1)
\NextLoop0:
 addq.l  #1,a0
\NextLoop:
 dbf	d0,\Loop
 movem.l (a7)+,d0-d2/a0-a1
 rts

Extra_Pente_Droite:
 movem.l d0-d2,-(a7)
 move.w  d6,d0
 addi.w  #15,d0
 andi.w  #31,d0
 andi.w  #$FFE0,d1
 neg.w   d0
 addi.w  #(32-17),d0
 add.w   d0,d1
 cmp.w   d1,d7
 bcs	 \Skip
 move.w  d1,d7
 bsr	 Marche
\Skip:
 movem.l (a7)+,d0-d2
 rts

Extra_Pente_Gauche:
 movem.l d0-d2,-(a7)
 move.w  d6,d0
 andi.w  #31,d0
 andi.w  #$FFE0,d1
 add.w   d0,d1
 subi.w  #16,d1
 cmp.w   d1,d7
 bcs	 \Skip
 move.w  d1,d7
 bsr	 Marche
\Skip:
 movem.l (a7)+,d0-d2
 rts

Link_Graph_Test:
 movem.l d0-d3/a0,-(a7)
 move.w	d0,d2
 move.w	d1,d3
 move.l	LevelADR,a0
 lsr.w  #5,d0
 lsr.w  #5,d1
 lsl.w  #7,d1		; Taille niveau X = 128 = 2^7
 add.w  d0,d1
 moveq	#0,d0
 move.b  0(a0,d1.w),d0
 lsl.l	#7,d0		; A graph is 128 Bytes long
 add.l	GraphADR,d0
 move.l	d0,a0
 moveq	#31,d1
 and.w	d1,d2
 neg.w	d2
 add.w	d1,d2
 moveq	#1,d0
 lsl.l	d2,d0
\Loop:
 move.l	(a0)+,d2
 and.l	d0,d2
 bne	\Found
 dbf	d1,\Loop
 bra	\Skip
\Found:
 andi.w	#$FFE0,d3
 sub.w	d1,d3
 addi.w	#(31-16),d3
 cmp.w	d7,d3
 bhi	\Skip
 move.w	d3,d7
 bsr	Marche
\Skip:
 movem.l (a7)+,d0-d3/a0
 rts












Sprite_FallDown:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	addq.w	#2,d1
	move.w	d1,Yj(a5)
	bsr	TestCollision
	bne	\No
	bsr	Touche
\No:
	bsr	TestExitScreen
	bne	\Suite
	move.l	LevelTestADR,a0
	move.w	Adresse(a5),d0
	move.b	#17,0(a0,d0.w)
	moveq.l	#FD_End,d0
	bra	DestroySprite
\Suite:
	moveq.l	#FALLDOWN,d2
	bsr	PutSprite
	lea	FD_End(a5),a5
	rts

Sprite_Laser:
	bsr	ComportementLikeLaser
	bsr	TestCollision
	bne	\No
	bsr	Touche
\No:	bsr	TestExitScreen
	bne	\Suite
	moveq.l	#LaserEND,d0
	bra	DestroySprite
\Suite:
	moveq.l	#LASER,d2
	bsr	PutSprite
	lea	LaserEND(a5),a5
	rts

Sprite_Explosion:
	move.w  EXP_Dx(a5),d3
	addq.w  #2,d3
	move.w  Xj(a5),d0
	move.w  Yj(a5),d1
	SUB.w   d3,d1
	moveq.l #EXP_HAUT,d2
	bsr	PutSprite
	add.w	d3,d1
	add.w	d3,d1
	moveq.l #EXP_BAS,d2
	bsr	PutSprite
	sub.w	d3,d1
	add.w	d3,d0
	moveq.l #EXP_DROIT,D2
	bsr	PutSprite
	sub.w	d3,d0
	sub.w   d3,d0
	moveq.l #EXP_GAUCHE,d2
	bsr	PutSprite
	move.w  d3,EXP_Dx(a5)
	cmpi.w  #EXP_TIME,d3
	blt	\Exit
	moveq.l	#EXP_END,d0
	bra	DestroySprite	
\Exit:
	lea	EXP_END(a5),a5
	rts

Sprite_Explosion2:
	move.w  EXP_Dx(a5),d3
	addq.w  #3,d3
	move.w  Xj(a5),d0
	move.w  Yj(a5),d1
	SUB.w   d3,d1
	bsr	PutHor
	add.w	d3,d1
	add.w	d3,d1
	bsr	PutHor
	add.w	d3,d0
	bsr	PutVer
	sub.w	d3,d0
	sub.w   d3,d0
	bsr	PutVer
	move.w  d3,EXP_Dx(a5)
	cmpi.w  #(2*EXP_TIME),d3
	blt	\Exit
	moveq.l	#EXP_END,d0
	bra	DestroySprite	
\Exit:
	lea	EXP_END(a5),a5
	rts

Sprite_Brique:
	bsr	ComportementLikeLaser
	bsr	TestExitScreen
	bne	\Suite
	moveq.l	#LaserEND,d0
	bra	DestroySprite
\Suite:
	moveq.l	#BRIQUE,d2
	bsr	PutSprite
	lea	LaserEND(a5),a5
	rts

Sprite_Garbesh:
	move.w	Adresse(a5),d1
	move.w	d1,d2		; Save Adresse(a5) in d2
	move.w	Turbo,d3
	sub.w	d3,Garbesh_Temp(a5)
	bne	\skip
	move.l	LevelTestADR,a0
	add.w	#128,d1
	clr.b	0(a0,d1.w)
	move.l	LevelADR,a0
	clr.b	0(a0,d1.w)
	move.w	#4000,YsOld	; refresh Virtual Screen
\skip:
	move.w	d2,d0		; d0 = Adresse(a5)
	andi.w	#127,d0
	lsl.w	#5,d0
	lsr.w	#2,d1
	bsr	TestExitScreen
	bne	\Suite_Collector
	move.w	Adresse(a5),d1
	move.l	LevelTestADR,a0
	move.b	#29,0(a0,d1.w)
	add.w	#128,d1
	move.b	Garbesh_Test(a5),0(a0,d1.w)
	move.l	LevelADR,a0
	move.b	Garbesh_Dessin(a5),0(a0,d1.w)
	moveq.l	#Garbesh_End,d0
	bra	DestroySprite
\Suite_Collector:
	lea	Garbesh_End(a5),a5
	rts	

Sprite_Element:
	cmp.b	#1,Refresh
	bne	\Skip
	move.l	a5,a1
	bsr	InitHandD
\Skip:
	move.b	Vitesse,d3
; Calcul position X,Y
	move.w	Ho(a5),d0
	add.w	Do(a5),d0
	move.w	d0,Ho(a5)
	asr.w	d3,d0
	add.w	Xi(a5),d0

	move.w	Hi(a5),d1
	add.w	Di(a5),d1
	move.w	d1,Hi(a5)
	asr.w	d3,d1
	add.w	Yi(a5),d1
; test collision avec fernando
	bsr	TestCollision
	bne	\Ok
	move.l  SpriteADR,a0	; ATTENTION : Fernando doit tre le premier
	move.w  F_Haut(a0),d2	; de la liste pile
	move.w  d2,F_St(a0)
	move.w  #10,F_Action(a0)
	cmp.w	#1,Nbr(a5)
	bne	\Bam
	cmp.w	Yj(a5),d7
	bge	\Bam
	movem.l	d0-d1,-(a7)
	moveq	#10,d0
	move.w  d6,d1
	move.w  d7,d2
	bsr	SpriteInit	; Init 1 explosion
	movem.l	(a7)+,d0-d1
	bsr	PutKey		; In fact put BossLife (same routine)
	bsr	CopyTo2ndScreen
	subq.w	#1,BossLife
	bne	\Ok
	move.b	#LEVEL_COMPLETED,Mort
	bra	\Ok
\Bam:
	bsr	Touche
\Ok:
; Affichage
	move.l	Grph(a5),a0
	bsr	PutSpriteA0

	lea	Element_End(a5),a5
	rts

InitHandD:
 move.w	Nbr(a1),d0

 move.l	Phase1ADR,a0
 move.l Phase2ADR,a2
 
 clr.w	d1
 clr.w	d2
 move.b 0(a0,d0.w),d1
 move.w	d1,Xi(a1)	; Formule : X = Xi + Time * Do / 2^Vitesse
 move.b	0(a2,d0.w),d2
 sub.w	d1,d2		; Changed in : Hi = Hi + D0
 move.w d2,Do(a1)	; 	X = X + Hi/2^Vitesse

 clr.w	d1
 clr.w	d2
 move.b 1(a0,d0.w),d1
 move.w	d1,Yi(a1)	; Formule : Y = Yi + Time * Di / 2^Vitesse
 move.b	1(a2,d0.w),d2
 sub.w	d1,d2
 move.w d2,Di(a1)

 clr.w	Hi(a1)
 clr.w	Ho(a1)
 rts

Sprite_Blob:
	move.w  #BLOB,Dessin(a5)
	moveq	#33,d3
Blob_1st_Entry:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	addq.w	#1,d1
	bsr	GetTest
	beq	Blob_Entry
	move.w	d1,Yj(a5)
Blob_Entry:
	bsr	VitesseX
BlobSuite0:
	move.w  Xj(a5),d0
	move.w  Yj(a5),d1
	bsr	TestCollision
	bne	\No
	cmp.w	Yj(a5),d7
	blt	DestroyBlob
	bsr	Touche
\No:	
	bsr	TestExitScreen
	bne	BlobSuite
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b	d3,0(a0,d0.w)	; Restore ce qu'il faut ie d3
	moveq.l	#Blob_End,d0
	bra	DestroySprite
BlobSuite:
	bsr	CalculOfD2
	bsr	PutSprite
	lea	Blob_End(a5),a5
	rts

Sprite_Bat:
	move.w  #BAT,Dessin(a5)
	moveq	#34,d3
 	bra	Blob_Entry

Sprite_Special_Bat:
	move.w  #BAT,Dessin(a5)
	moveq	#40,d3
Special_Bat_Entry:
	move.w Xj(a5),d0
	move.w Yj(a5),d1
	move.w Blob_Vy(a5),d4
	add.w  d4,d1
	neg.w	d4
	bsr	GetTest
	beq	\Saut
	move.w	d1,Yj(a5)
	neg.w	d4
\Saut:
	move.w  d4,Blob_Vy(a5)
 	bra	  Blob_Entry


Sprite_Crabe:
	move.w #CRABE,Dessin(a5)
	move.w Time,d0
	andi.w #127,d0
	bne    \Skip
	neg.w  Blob_Vx(a5)
\Skip:
	moveq	#54,d3
	bra     Blob_1st_Entry

Sprite_Glooner:
	btst.b	#0,Blob_Vy(a5)
	bne	\Ok
	move.w	#1,Blob_Vy(a5)
\Ok:
	move.w	#BLOB,Dessin(a5)
	move.w	Yj(a5),d1
	move.w	d1,d0
	andi.w	#15,d0
	bne	\Skip
	neg.w	Blob_Vy(a5)
\Skip:
	add.w	Blob_Vy(a5),d1
	move.w	d1,Yj(a5)
	moveq	#63,d3
	bra	Blob_Entry

Sprite_FlyBoot:
	bsr	VitesseX
	add.w	#8,d0
	add.w	#8,d1

	bsr	TestCollision
	bne	\No
	cmp.w	Yj(a5),d7
	blt	DestroyBlob
	bsr	Touche
\No:	
	bsr	TestExitScreen
	bne	\Suite
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b	#67,0(a0,d0.w)
	moveq.l	#Blob_End,d0
	bra	DestroySprite

\Suite:
	move.w	#BAT,Dessin(a5)
	bsr	CalculOfD2
	bsr	PutSprite

	move.w	Time,-(a7)
	moveq	#3,d5
\Loop:
	move.l	a5,-(a7)
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	bsr	IN_STAR
	move.l	(a7)+,a5
	add.w	#(512/4),Time	; 512 is the periode of the star
	dbf	d5,\Loop
	move.w	(a7)+,Time

	lea	Blob_End(a5),a5
	rts

Sprite_Fish:
	move.w  Xj(a5),d0
	move.w  Yj(a5),d1
	move.w	Turbo,d2
	add.w   Fish_Vy(a5),d1
	move.w  d1,Yj(a5)
	sub.w   d2,Fish_Loop(a5)
	bne     \Ok
	move.w  #(32*3),Fish_Loop(a5)
	neg.w	  Fish_Vy(a5)
\Ok:
	bsr	  TestCollision
	bne	  \No
	moveq.l #Fish_End,d3
	cmp.w	  Yj(a5),d7
	blt	  Destroy
	bsr	  Touche
\No:	bsr	  TestExitScreen
	bne	  \Suite1
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b  #35,0(a0,d0.w)
	moveq.l #Fish_End,d0
	bra	  DestroySprite
\Suite1:
	moveq	#0,d2	; D2.L
	move.w  Fish_A(a5),d2
	addq.w  #1,d2
	andi.w  #31,d2
	move.w  d2,Fish_A(a5)
	lsr.w   #4,d2
	addi.w  #FISH,d2
	bsr	PutSprite
	lea	Fish_End(a5),a5
	rts

FH_xInf:
	bclr.b #Left_Key,d5	; Left
	bra    FH_C1
FH_xSup:
	bclr.b #Right_Key,d5	; Right
	bra	FH_C1
FH_yInf:
	bclr.b #Jump_Key,d5	; hand
	bclr.b #Up_Key,d5	; up
	bra	FH_C2

Sprite_Fer_Hunter:
	moveq #-1,d5
	cmp.w Xj(a5),d6
	blt	FH_xInf
	bgt	FH_xSup
FH_C1:
	cmp.w Yj(a5),d7
	blt	FH_yInf
FH_C2:
	move.b d5,keystat

	move.l	XsNew,-(a7)	; Xs & Ys
	move.l	Vi,-(a7)	; Stockage de Vi & Bj
	move.w	v,-(a7)
	move.b	Mort,-(a7)
	movem.l d6-d7/a5,-(a7)
	move.w	FH_Bj(a5),Bj
	move.w	FH_V(a5),v
	move.b	#OK,Mort
	bsr	Sprite_Fernando
	move.b	Mort,d5
	movem.l	(a7)+,d6-d7/a5
	move.w	Bj,FH_Bj(a5)
	move.w	v,FH_V(a5)
	move.b	(a7)+,Mort
	move.w	(a7)+,v
	move.l	(a7)+,Vi	; Vi & Bj
	move.l	(a7)+,XsNew	; Xs & Ys
	moveq.l	#FH_End,d3
	tst.b	d5
	beq	Destroy

	move.w Xj(a5),d0
	move.w Yj(a5),d1
	bsr	TestCollision
	bne	\No
	cmp.w	Yj(a5),d7
	blt	\FH_Destroy
	bsr	Touche
	bra	\No
\FH_Destroy:
	tst.w FH_V(a5)
	bne	\No1
	move.w #80,FH_V(a5)
	sub.w #20,FH_Bj(a5)
	ble	Destroy
\No1:
	move.l  SpriteADR,a0	; ATTENTION : Fernando doit tre le premier
	move.w  F_Haut(a0),d3	; de la liste pile
	move.W  d3,F_St(a0)
	move.w  #10,F_Action(a0)
\No:	
      	bsr	  TestExitScreen
	bne	 \Suite1
	move.l  LevelTestADR,a0
	move.w  FH_Adresse(a5),d0
	move.b  #36,0(a0,d0.w)
	moveq.l #FH_End,d0
	bra	  DestroySprite
\Suite1: 
	lea	FH_End(a5),a5
	rts

Sprite_Fungus:
	move.w   Xj(a5),d0
	move.w   Yj(a5),d1
	add.w   Turbo,d1
	bsr	   GetTest
	beq	   \skip
	move.w   d1,Yj(a5)
\skip:
	move.w   Yj(a5),d1
	bsr	   TestCollision
	bne	   \No
	cmp.w	   Yj(a5),d7
	blt	   Fungus_Destroy
	bsr	   Touche
\No:	
	bsr	   TestExitScreen
	bne	   Fungus_SKIP
	move.l   LevelTestADR,a0
	move.w   Adresse(a5),d0
	move.b   #37,0(a0,d0.w)
	moveq.l  #Fungus_End,d0
	bra	   DestroySprite
Fungus_Destroy:
	move.l  SpriteADR,a0	; ATTENTION : Fernando doit tre le premier
	move.w  F_Haut(a0),d3	; de la liste pile
	move.w  d3,F_St(a0)
	move.w  #10,F_Action(a0)
	moveq	#Fungus_End,d3
	sub.w   #1,Fungus_Vi(a5)
	bne	  Fungus_SKIP
	bra	  Destroy
Fungus_SKIP:
	move.w	#FUNGUS,Dessin(a5)
	bsr	CalculOfD2
	bsr	PutSprite
	lea	Fungus_End(a5),a5
	rts

Ghost_xInf:
	subq.w  #2,d0
	bra	Ghost_C1
Ghost_yInf:
	subq.w #2,d1
	bra	Ghost_C2

Sprite_Ghost:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	addq.w	#1,d0
	addq.w	#1,d1
	cmp.w	d0,d6
	blt	Ghost_xInf
Ghost_C1:
	cmp.w	d1,d7
	blt	Ghost_yInf
Ghost_C2:
	move.w	d0,Xj(a5)
	move.w	d1,Yj(a5)
	bsr	TestCollision
	bne	\No
	tst.w	Bj
	beq	\No
	move.w	Blob_A(a5),d2
	bne	\No
	subq.w	#1,Bj
	bsr	PutPower
	bsr	CopyTo2ndScreen
\No:	
      	bsr	TestExitScreen
	bne	Ghost_SKIP
Ghost_Destroy:
	move.l   LevelTestADR,a0
	move.w   Adresse(a5),d0
	move.b   #38,0(a0,d0.w)
	moveq.l  #Ghost_End,d0
	bra	DestroySprite
Ghost_SKIP:
	move.w	#GHOST,Dessin(a5)
	bsr	CalculOfD2
	bsr	PutSprite
	lea	Ghost_End(a5),a5
	rts

Sprite_Deca_Vert:
 move.w Time,d0
 andi.w #7,d0
 bne	\Skip
 move.l Eor_Graph(a5),a0
 moveq.l #30,d3
 lea	(4*31)(a0),a0	; On pointe  la fin
 move.l	(a0),d2		; On lit et conserve le dernier
 lea	4(a0),a1
\Deca_loop:
 move.l -(a0),-(a1)	; On recopie
 dbra   d3,\Deca_loop
 move.l	d2,(a0)
 move.w #4000,YsOld
\Skip:
 lea    Eor_End(a5),a5
 rts

Sprite_Star:
	move.w Xj(a5),d0
	move.w Yj(a5),d1
	moveq  #41,d3
        bsr	   TestExitScreen
	beq	   DestroyStar
IN_STAR:
	move.w	Time,d2
	lsr.w	#3,d2
	move.w	d2,d3
	move.w	d3,d4
	lsr.w	#3,d3
	andi.w	#6,d3
	andi.w	#15,d4
	move.w	Star_Table(PC,d3.w),d3
	jsr	Star_Table(PC,d3.w)
	move.w	d2,d3
	bsr	TestCollision
	bne	\DSkip
	bsr	Touche
\DSkip:	moveq	#0,d2
	move.w	d3,d2
	andi.w	#1,d2
	add.w   #ETOILE,d2
	bsr	PutSprite
	lea	Star_End(a5),a5
	rts
Star_Table:
	dc.w Star1-Star_Table
	dc.w Star2-Star_Table
	dc.w Star3-Star_Table
	dc.w Star4-Star_Table
Star1:	add.w	d4,d0
	rts
Star2:	add.w	d4,d1
	add.w	#16,d0
	rts
Star3:	add.w	#16,d0
	add.w	#16,d1
	sub.w	d4,d0
	rts
Star4:	add.w	#16,d1
	sub.w	d4,d1
	rts

Sprite_Scroll_Right:
	move.w	Xj(a5),d0
	cmpi.w	#(128*32-SC_X*8),d0
	bls	\SKIP
	moveq	#43,d3
	bra	DestroyStar
\SKIP:
	add.w	Turbo,d0
	move.w	d0,XsNew
	move.w	d0,Xj(a5)
	cmp.w   d0,d6
	bhi	\Ok
	clr.b	Mort	; You die !
\Ok:
	lea	Scroll_R_End(a5),a5
	rts


Sprite_Inv:
	move.w Time,d5
	lsr.w  #1,d5
	moveq	#0,d3
	move.l	Screen,a0
	moveq.l	#(SCREEN_Y-1),d0
	move.w	Yj(a5),d1
	sub.w  Ys,d1
	blt	Deca_Loop1
	move.w d1,d0
	cmpi.w #SCREEN_Y,d0
	bcc	NoPrint

	lsl.w   #1,d1
	move.l  d1,d2
	lsl.w   #4,d2
	sub.w   d1,d2
 
	adda.l  d2,a0

	neg.w	d0
	addi.w	#(SCREEN_Y-1),d0
Deca_Loop1:
	andi.w	#15,d5
	move.b	Deca_Table(PC,d5.w),d3
	moveq.l	#(SC_X/2-1),d1
Deca_Loop2:
	move.l	(a0),d2
	lsr.l	d3,d2
	move.w	d2,(a0)+
	dbf	d1,Deca_Loop2
	NEXT_ROW	a0
	addq.w	#1,d5
	dbf	d0,Deca_Loop1
NoPrint:
	lea	Inv_End(a5),a5
	rts
Deca_Table:
	dc.b	13,13,12,11
	dc.b	10,10,11,12
	dc.b	13,13,14,15
	dc.b	16,16,15,14

Sprite_Boat:
 move.w Time,d1
 move.w YsNew,d0
 lsr.w  #2,d1
 andi.w #31,d1
 cmpi.w #16,d1
 bls	\Nothing
 addi.w #32,d0
 neg.w  d1
\Nothing:
 add.w  d1,d0
 cmpi.w #(32*32-SCREEN_Y),d0
 bhi	  \No
 move.w d0,YsNew
\No:
 lea	Boat_End(a5),a5
 rts

Sprite_Sun:
 move.w Time,d1
 move.w d1,d2
 and.w 	Turbo,d2
 bne	\Skip_SUN

 lsr.w  #4,d1
 andi.w #30,d1
 lea     Fernand(PC),a0
 adda.l  #(SUN*32),a0
 adda.l  d1,a0
 not.w	(a0)

 bsr	LikeSun
 moveq	#SUN,d2
 bsr	PutSprite
 
 not.w	(a0)

\Skip_SUN:
 lea	Sun_End(a5),a5
 rts

Sprite_Eor:
 moveq	#31,d2
 move.w Time,d3
 and.w	d2,d3
 bne	\Skip2
 move.l Eor_Graph(a5),a0
\EOR_loop:
 not.l	(a0)+
 dbf	d2,\EOR_loop
 move.w #4000,YsOld
\Skip2:
 lea	Eor_End(a5),a5
 rts

Sprite_Cinema:
 move.l Screen,a0
 moveq	#-1,d4
 moveq	#1,d0
\l0:
 moveq	#15,d1
\l1:
 moveq	#(SC_X/2-1),d2
\l2:
 move.w d4,(a0)+
 dbf	d2,\l2
 NEXT_ROW	a0
 dbf	d1,\l1
 lea	((SCREEN_Y-32)*SCREEN_X)(a0),a0
 dbf	d0,\l0
 lea	Cinema_End(a5),a5
 rts

Sprite_Colonne:
	move.w Xj(a5),d0
	move.w Ys,d1
	move.w d1,d3
	bsr	   TestExitScreen
	bne	   \SKIP
	moveq  #51,d3
	bra	DestroyStar
\SKIP:
	move.w  Xs,d0
	lsr.l	#2,d0
	add.w	Yj(a5),d0
	neg.w   d0
	addi.w	#32,d0
	andi.w  #31,d0
	cmpi.w  #(SC_X-1),d0
	bhi	\NoPut
	move.l  Screen,a0
	add.l   d0,a0
	moveq	#(SCREEN_Y-1),d0
	move.b	#$FE,d1
	andi.w	#7,d3
	rol.b	d3,d1
\loop:
	move.b  d1,(a0)
	rol.b   #1,d1
	lea	SCREEN_X(a0),a0
	dbf	d0,\loop
\NoPut:
	lea	Colonne_End(a5),a5
	rts

Sprite_Montagne:
 move.w Time,d0
 andi.w #1,d0
 beq	\Skip
 bsr	LikeSun
 moveq	#MONTAGNE,d2		; Montagne dans la lune
 bsr    PutSprite
\Skip:
 lea    Sun_End(a5),a5
 rts

Sprite_Tirelle:
	move.w Time,d0
	move.w d0,d1
	lsr.w	#3,d1
	andi.w #15,d1
	add.w  Xj(a5),d1	; Calcul of X
	move.w Yj(a5),d2
	andi.w #(128+7),d0	; Fire ? (<- Time)
	bne    \NoFire
	moveq	#0,d4
	moveq	#-2,d5
	moveq	#4,d0
	bsr     SpriteInit	; Init Laser
\NoFire:
	move.w d1,d0
	move.w d2,d1
	bsr    TestExitScreen
	bne    \SKIP
	moveq  #53,d3
	bra     DestroyStar
\SKIP:
	moveq.l	#TIRELLE,d2
	bsr	PutSprite
	lea     Star_End(a5),a5
	rts


Sprite_Inv2:
	move.w Time,d1
	lsr.w  #2,d1
	andi.w #15,d1
	neg.w  d1
	addi.w #16,D1

	lsl.w   #1,d1
	move.l  d1,d2
	lsl.w   #4,d2
	sub.w   d1,d2
	move.l  Screen,a1
	adda.l  d2,a1
	moveq.l #(SCREEN_Y/16-1),d1
\PutHorLOOP:
	moveq.l #(SC_X/4-1),d0
\putLoop:
	move.l  (a1),d2
	lsr.l   #2,d2
	move.l  d2,(a1)+
	dbra    d0,\putLoop
	lea     (SCREEN_X-SC_X+SCREEN_X*14)(a1),a1
	dbra    d1,\PutHorLOOP
	lea     Inv_End(a5),a5
	rts

Sprite_Gorille:
	move.w  Xj(a5),d0
	move.w  Yj(a5),d1
	move.w  Time,d2
	andi.w	#3,d2
	bne	\Ok
	add.w	Gorille_Vx(a5),d0
	move.w	d0,Xj(a5)
	move.w	Turbo,d2
	sub.w   d2,Gorille_Loop(a5)
	bne	\Ok
	move.w  #(32*2),Gorille_Loop(a5)
	neg.w	Gorille_Vx(a5)
	eor.w	#1,Gorille_Sens(a5)
\Ok:
	subq.w	#1,d1
	bsr	TestCollision
	bne	\No
\Yeah:
	move.l	SpriteADR,a0
	tst.w	F_Action(a0)	; Does Fernando dance ?
	bne	\BadaBoum
	tst.b	F_BWait(a0)
	beq	\No
\BadaBoum:
	move.w	#8,F_Action(a0)	; Propulseur
	clr.w	F_My(a0)
	move.W  #5,F_Mx(a0)
	cmp.w	Xj(a5),d6
	bhi	\No
	neg.w	F_Mx(a0)
\No:	
	move.w Yj(a5),d1
	bsr	TestExitScreen
	bne	\Suite1
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b  #56,0(a0,d0.w)
	moveq.l #Gorille_End,d0
	bra	DestroySprite
\Suite1:
	moveq	#0,d2
	move.w  Gorille_A(a5),d2
	addq.w  #1,d2
	andi.w  #63,d2
	move.w  d2,Gorille_A(a5)
	andi.w  #48,d2
	lsr.w   #3,d2
	add.w   #GORILLE,d2
	add.w   Gorille_Sens(a5),d2
	bsr	PutSprite
	lea	Gorille_End(a5),a5
	rts

Sprite_Deca:
 move.w Time,d0
 andi.w #7,d0
 bne	\Skip
 move.l Eor_Graph(a5),a0
 moveq.l #31,d3
\Deca_loop:
 move.l (a0),d4
 rol.l  #1,d4
 move.l d4,(a0)+
 dbra   d3,\Deca_loop
 move.w #4000,YsOld
\Skip:
 lea    Eor_End(a5),a5
 rts

Sprite_Mirroir:
 move.w Time,d1
 lsr.w	#3,d1
 move.w Yj(a5),d0
 andi.w #63,d1
 cmpi.w #32,d1
 bls	\Nothing
 addi.w #64,d0
 neg.w  d1
\Nothing:
 add.w  d1,d0
 sub.w  Ys,d0
 move.w d0,d1
 cmpi.w #128,d0
 bcc	\NoPrint
 move.l	Screen,a0

 lsl.w   #1,d1
 move.l  d1,d2
 lsl.w   #4,d2
 sub.w   d1,d2
 
 adda.l  d2,a0
 lea	-SCREEN_X(a0),a1
 
 move.l a1,a2
 moveq.l #(SC_X/4-1),d2
 moveq.l #-1,d3
\l1:
 move.l d3,(a2)+
 dbf	d2,\l1

 neg.w	d0
 addi.w #(127),d0	; It doen't work if ScreenY>128 Rows !!!
 moveq.l #(SCREEN_X+SC_X),d3
\Loop1:
 moveq.l #(SC_X/4-1),d2
\Loop2:
 move.l	(a1)+,(a0)+
 dbf	d2,\Loop2
 NEXT_ROW	a0
 sub.l  d3,a1
 moveq	#(SCREEN_X+2*SC_X),d4
 sub.w  d3,d4
 move.w d4,d3
 dbf	d0,\Loop1
\NoPrint:   
 lea	Star_End(a5),a5
 rts

Sprite_Anim2:
 move.w Time,d3
 andi.w #31,d3
 bne	SkipAnim2
Sprite_Gray:
 move.w #4000,YsOld
 move.l Eor_Graph(a5),a0
 lea	128(a0),a1
 moveq.l #31,d3
\Anim2_loop:
 move.l	(a0),d4
 move.l	(a1),(a0)+
 move.l	d4,(a1)+
 dbra	d3,\Anim2_loop
SkipAnim2:
 lea	Eor_End(a5),a5
 rts

Sprite_Conc_Scroll:
 move.w	Xj(a5),d0
 move.w	Yj(a5),d1
 bsr	TestExitScreen
 bne	\NoExit
 move.l  LevelTestADR,a0
 move.w  Adresse(a5),d0
 move.b  #61,0(a0,d0.w)
 moveq.l #CAS_End,d0
 bra	DestroySprite
\NoExit:
 move.w	XsNew,d2
 add.w	#SCROLLX,d2
 move.w	YsNew,d3
 add.w	#SCROLLY,d3
 add.w	d2,d0		; Fernand a un poids de 3
 add.w	d3,d1		; Le sprite 1
 add.w	d2,d0
 add.w	d3,d1
 add.w	d2,d0
 add.w	d3,d1		; Xs=UpDateX((3*Ferx+Srx)/4)
 lsr.w	#2,d0		; Ys=UpDateY((3*Ferx+Sry)/4)
 lsr.w	#2,d1
 bsr	UpDateScrollVar
 lea	CAS_End(a5),a5
 rts

Sprite_Deca_Sac:
 move.w Time,d3
 move.w	d3,d1
 andi.w #15,d3
 bne	SkipDecaSac
 move.l Eor_Graph(a5),a0
 moveq	#30,d3
 lsr.w	#4,d1
 moveq	#0,d2
Deca2_loop:
 andi.w	#30,d1
 move.w Deca_Sac_Table(PC,d1.w),Deca_Code
 addq.w	#2,d1
 move.l	(a0),d4
Deca_Code:
 rol.l	#1,d4
 move.l	d4,(a0)+
 dbra	d3,Deca2_loop
 move.w #4000,YsOld
SkipDecaSac:
 lea	Eor_End(a5),a5
 rts
Deca_Sac_Table:
	ror.l	#1,d4
	ror.l	#1,d4
	nop
	nop
	rol.l	#1,d4
	rol.l	#1,d4
	nop
	nop
	rol.l	#1,d4
	rol.l	#1,d4
	nop
	nop
	ror.l	#1,d4
	ror.l	#1,d4
	nop
	nop

Sprite_Boolder:
 move.w	Xj(a5),d1
 move.w Yj(a5),d2
 move.w	Turbo,d0
 move.w Boolder_C(a5),d3
 sub.w	d0,Boolder_Time(a5)
 bne	\Skip
 move.w	#20,Boolder_Time(a5)
 addq.w	#4,d3
 andi.w	#28,d3
 move.w	d3,Boolder_C(a5)
 move.w Boolder_Table(PC,d3.w),d4
 move.w (Boolder_Table+2)(PC,d3.w),d5
 moveq #4,d0
 bsr     SpriteInit
\Skip:
 move.w	d1,d0
 move.w	d2,d1
 bsr	TestExitScreen
 bne	\Suite1
 move.l  LevelTestADR,a0
 move.w  Adresse(a5),d0
 move.b  #64,0(a0,d0.w)
 moveq.l #Boolder_End,d0
 bra	DestroySprite
\Suite1:
 moveq.l #SUN,d2
 bsr	PutSprite
 add.w	Boolder_Table(PC,d3.w),d0
 add.w	(Boolder_Table+2)(PC,d3.w),d1
 bsr	PutSprite
 lea	Boolder_End(a5),a5
 rts
Boolder_Table:
	dc.w	2,0,1,1,0,2,-1,1,-2,0,-1,-1,0,-2,1,-1


Sprite_Holo_D:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	bsr	TestCollision
	bne	\No
	moveq.l	#Holo_D_End,d3
	cmp.w	Yj(a5),d7
	blt	Destroy
	bsr	Touche
\No:	
	bsr	TestExitScreen
	bne	\Suite1
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b  #65,0(a0,d0.w)
	move.w	Holo_D_Sens(a5),d3
	bgt	\Ok0
	move.b  #66,0(a0,d0.w)
\Ok0:
	moveq.l #Holo_D_End,d0
	bra	DestroySprite
\Suite1:
	moveq.l	#BLASTOID,d2
	move.w	Holo_D_Sens(a5),d3
	bgt	\Ok
	addq.l	#1,d2
\Ok:
	bsr	PutSprite
	add.w	d3,d0
	bsr	TestCollision
	bne	\Skip
	bsr	Touche
\Skip
	moveq	#0,d2
	bsr	PutSprite
	lea	Holo_D_End(a5),a5
	rts

Sprite_Scarat:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	move.w	Turbo,d2
	move.w	Time,d3
	andi.w	#7,d3
	bne	\Next0
	sub.w	d2,Scarat_Loop(a5)
	bne	\Ok
	move.w	#60,Scarat_Loop(a5)
	move.w	#SCARAT,Dessin(a5)
	neg.w	Scarat_Sens(a5)
	bgt	\Ok
	addq.w	#1,Dessin(a5)
\Ok:
	add.w	Scarat_Sens(a5),d0
	move.w	d0,Xj(a5)
\Next0:	bsr	TestCollision
	bne	\No
	moveq.l	#Scarat_End,d3
	cmp.w	Yj(a5),d7
	blt	Destroy
	bsr	Touche
\No:	
	bsr	TestExitScreen
	bne	\Suite1
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b  #68,0(a0,d0.w)
	moveq.l #Scarat_End,d0
	bra	DestroySprite
\Suite1:
	moveq	#0,d2
	move.w	Dessin(a5),d2
	bsr	PutSprite
	subq.w	#1,Scarat_Loop_2(a5)
	bne	\Next
	neg.w	Scarat_Sens_2(a5)
	move.w	#24,Scarat_Loop_2(a5)
\Next:
	move.w	Scarat_Xj_2(a5),d3
	add.w	Scarat_Sens_2(a5),d3
	move.w	d3,Scarat_Xj_2(a5)
	add.w	d3,d0
	subq.w	#7,d1
	bsr	TestCollision
	bne	\Next2
	bsr	Touche
\Next2:
	moveq.l	#ETOILE2,d2
	bsr	PutSprite
	lea	Scarat_End(a5),a5
	rts

Sprite_Point_Dexter:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	move.w	Turbo,d2
	moveq	#69,d4
	move.w	Time,d3
	andi.w	#7,d3
	bne	Point_Dexter_Entry
	sub.w	d2,Point_Loop(a5)
	bne	\Skip
	move.w	#80,Point_Loop(a5)
	move.w	#POINT_DEXTER,Dessin(a5)
	neg.w	Point_Sens(a5)
	bgt	\Skip
	addq.w	#1,Dessin(a5)
\Skip:
	add.w	Point_Sens(a5),d0
	move.w	d0,Xj(a5)
Point_Dexter_Entry:
	bsr	TestCollision
	bne	\No
	moveq.l	#Point_End,d3
	cmp.w	#1,Point_Sens(a5)
	beq	\No0
	cmp.w	Yj(a5),d7
	blt	Destroy
\No0:	bsr	Touche
\No:	
	bsr	TestExitScreen
	bne	\Suite1
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b  d4,0(a0,d0.w)
	moveq.l #Point_End,d0
	bra	DestroySprite
\Suite1:
	moveq	#0,d2
	move.w	Dessin(a5),d2
	bsr	PutSprite
	lea	Point_End(a5),a5
	rts

Sprite_Bloominator:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	move.w	Turbo,d2
	moveq	#70,d4
	move.w	Time,d3
	andi.w	#15,d3
	bne	Point_Dexter_Entry
	sub.w	d2,Point_Loop(a5)
	bne	\Skip
	move.w	#16,Point_Loop(a5)
	move.w	#BLOOMINATOR,Dessin(a5)
	neg.w	Point_Sens(a5)
	bgt	\Skip
	addq.w	#1,Dessin(a5)
\Skip:
	add.w	Point_Sens(a5),d1
	move.w	d1,Yj(a5)
	bra	Point_Dexter_Entry

Sprite_Flamme:
	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	move.w	Flamme_Loop(a5),d2
	move.w	Time,d3
	cmp.w	#22,d2
	bls	\Sk1
	cmp.w	#42,d2
	bhi	\Sk1
	andi.w	#3,d3
	bne	\Sk2
\Sk1:
	sub.w	Turbo,d2
	bne	\Next
	neg.w	Flamme_Sens(a5)
	moveq	#64,d2
\Next:
	add.w	Flamme_Sens(a5),d0
	move.w	d0,Xj(a5)
	move.w	d2,Flamme_Loop(a5)
\Sk2:
	bsr	TestCollision
	bne	\No
	bsr	Touche
\No:	
	bsr	TestExitScreen
	bne	\Suite1
	move.l  LevelTestADR,a0
	move.w  Adresse(a5),d0
	move.b  #71,0(a0,d0.w)
	moveq.l #Flamme_End,d0
	bra	DestroySprite
\Suite1:
	moveq.l	#FLAMME,d2
	bsr	PutSprite	
	lea	Flamme_End(a5),a5
	rts

Sprite_Nest:
	move.w	Nest_Count(a5),d3
	add.w	Turbo,d3
	cmp.w	Nest_T(a5),d3
	bls	\Exit
	clr.w	d3
	subq.w	#1,Nest_Kill(a5)
	beq	\Kill
	moveq.l	#0,d0
	move.b	Nest_Gfx(a5),d0
	cmp.b	#(SpriteAutoStart),d0
	bls	\No
	sub.w	#(SpriteCorrect),d0
	add.w	d0,d0
	move.w	Xj(a5),d1
	move.w	Yj(a5),d2
	clr.w	d3
	bsr	SpriteInit
\No:
\Exit:
	move.w	d3,Nest_Count(a5)

	move.w	Xj(a5),d0
	move.w	Yj(a5),d1
	bsr	TestExitScreen
	bne	\Suite
\Kill:
	move.l	LevelTestADR,a0
	move.w	Adresse(a5),d0
	move.w	Nest(a5),d1
	move.b	d1,0(a0,d0.w)
	move.l	LevelADR,a0
	move.b	Nest_Gfx(a5),d1
	move.b	d1,0(a0,d0.w)
	moveq	#Nest_End,d0
	bra	DestroySprite
\Suite:
	lea	Nest_End(a5),a5
	rts

Sprite_Add_On:
	move.l	ExecAddOnADR,a0
	beq	\Error
	jmp	(a0)
\Error:
	rts	; Je sais pas si ce cas est possible, m'enfin...








; *****************************************************************
; *****************************************************************
; ***								***
; ***	               Sprite-Routines				***
; ***								***
; *****************************************************************
; *****************************************************************

; Blob-Type
VitesseX:
	move.w  Xj(a5),d0
	move.w  Yj(a5),d1
	move.w  Blob_A(a5),d2
	andi.w  #1,d2
	bne	\Conti2
	add.w   Blob_Vx(a5),d0
	bsr	 GetTest
	beq	\Conti
	cmp.w   #4080,d0
	bhi	\Conti
	move.w  d0,Xj(a5)
	bra	\Conti2
\Conti:	
	neg.w	Blob_Vx(a5)
\Conti2:
	rts

; DestroyBlob
; Entry : a5 -> Blob-Sprite
; Return : No return

; Destroy:
; Entry : a5 -> Sprite with (Xj and Yj) and d3.l = size of the sprite
; Return : No return
DestroyBlob:
	moveq #Blob_End,d3
Destroy:
	moveq	#6,d0		; Init explosion 1
	move.w  Xj(a5),d1
	move.w  Yj(a5),d2
	bsr	SpriteInit
	move.l  SpriteADR,a0	; ATTENTION : Fernando doit tre le premier
	move.w  F_Haut(a0),d0	; de la liste pile
	move.w  d0,F_St(a0)	; Fernando will jump
	move.w  #10,F_Action(a0)
	move.l  d3,d0
	bra	DestroySprite


; Entry  : a5 -> Blob-Sprite
; Return : D2
CalculOfD2:
	moveq	#0,d2		; the highest 16 bits of d2 must be cleared for putsprite
	move.w  Blob_A(a5),d2
	addq.w  #1,d2
	andi.w  #63,d2
	move.w  d2,Blob_A(a5)
	andi.w  #48,d2
	lsr.w   #4,d2
	add.w   Dessin(a5),d2
	rts

; Entry: a5 -> SpriteLaser (or clone)
; Return : calcul of d0 and d1
ComportementLikeLaser:
	move.w Xj(a5),d0
	move.w Yj(a5),d1
	add.w  LaserVx(a5),d0
	add.w  LaserVy(a5),d1
	move.w d0,Xj(a5)
	move.w d1,Yj(a5)
	rts

; Entry: a5 -> SpriteSun (or clone)
; Return : calcul of d0 and d1
LikeSun:
 move.w	Xs,d0
 move.w	d0,d2
 lsr.w	#4,d0
 neg.w	d0
 add.w	#(SC_X*8),d0
 add.w	d2,d0
 move.w	Ys,d1
 move.w	d1,d2
 lsr.w	#3,d1
 neg.w	d1
 add.w	#(SC_Y),d1
 add.w	d2,d1
 rts

; Entry: a5 -> SpriteStar (or clone), d3 must equal to the Sprite-Test in TestTable
; No return
DestroyStar:
	move.l	LevelTestADR,a0
	move.w	Adresse(a5),d0
	move.b	d3,0(a0,d0.w)
	moveq.l	#Star_End,d0
	bra	DestroySprite



; *****************************************************************
; *****************************************************************
; ***								***
; ***	               Routines					***
; ***								***
; *****************************************************************
; *****************************************************************

; This sprite-routine is based on Jimmy Mardell's Sprite routine.

; Puts Sprite with Adr=a0.l at D0.w,D1.w
; 	Sprite is a 32 bytes long :  16 Colonnes * 16 Lignes  (/8)
fer3c@0004:
PutSpriteA0:
 movem.l d0-d3/a0-a1,-(a7)
 moveq	#0,d2
 bra	PutSpriteEntry

; Puts Sprite No D2.l at D0.w,D1.w
; 	Sprite is a 32 bytes long :  16 Colonnes * 16 Lignes  (/8)
PutSprite:
 movem.l d0-d3/a0-a1,-(a7)

 lea     Fernand(PC),a0
 lsl.l   #5,d2
 adda.l  d2,a0		; A0 = &Fernand + D2 * 128

PutSpriteEntry:

 moveq.l #15,d3		; 16 Rows

 move.l  Screen,a1	; Current screen

 sub.w  Xs,d0
 sub.w  Ys,d1
 cmpi.w #(SCREEN_Y-16),d1
 bhi	ClipVert	; Clipping Vertical
 cmpi.w #(SC_X*8-16),d0		; Clipping Horizontal
 bhi	ClipHor

ClipCenter:		; Pas de cliping horizontal.
 lsl.w   #1,d1
 move.w  d1,d2		; Change .l to .w
 lsl.w   #4,d2
 sub.w   d1,d2

 move.b  d0,d1
 and.w   #$FFF0,d0
 lsr.b   #3,d0
 add.w   d0,d2

 and.b   #$0F,d1
 sub.b   #16,d1
 neg     d1

 adda.l  d2,a1

\PF_PutRow:
 moveq	#0,d2
 move.w	(a0)+,d2
 lsl.l	d1,d2
 or.l	d2,(a1)
 lea	SCREEN_X(a1),a1
 dbra	d3,\PF_PutRow
NoPutSprite:
 movem.l (a7)+,d0-d3/a0-a1
 rts

ClipVert:
 cmpi.w	#(SCREEN_Y-1),d1
 bhi	\ClipVert2
 move.w d1,d3
 neg.w	d3
 add.w	#(SCREEN_Y-1),d3
 bra	\ClipCentre
\ClipVert2:
 cmpi.w #-16,d1
 ble	NoPutSprite
 move.w d1,d3
 bgt	NoPutSprite
 addi.w #15,d3
 neg.w	d1
 lsl.w	#1,d1
 move.w	d1,d2		; Add this line because
 adda.l	d2,a0		; We don't known anything about d1.l
 clr.w	d1

\ClipCentre:
 cmpi.w	#(SC_X*8-16+1),d0
 bls	ClipCenter

ClipHor:
 cmpi.w #(SC_X*8-16+16),d0
 bcs	ClipRight
 bge	NoPutSprite
 cmpi.w	#(-16),d0
 ble	NoPutSprite
ClipLeft:
 lsl.w   #1,d1
 move.w  d1,d2		; Change .l to .w
 lsl.w   #4,d2
 sub.w   d1,d2

 and.b   #$0F,d0
 sub.b   #16,d0
 neg     d0
 
 adda.l  d2,a1

\PL_PutRow:
 moveq	#0,d2
 move.w  (a0)+,d2
 lsl.w   d0,d2
 or.w    d2,(a1)
 lea     SCREEN_X(a1),a1
 dbra    d3,\PL_PutRow
 bra	NoPutSprite

ClipRight:
 lsl.w   #1,d1
 move.w  d1,d2		; Change .l to .w
 lsl.w   #4,d2
 sub.w   d1,d2

 and.b   #$0F,d0

 lea	(SC_X-2)(a1,d2.w),a1

\PR_PutRow:
 moveq	#0,d2
 move.w  (a0)+,d2
 lsr.w	 d0,d2
 or.w    d2,(a1)
 lea     SCREEN_X(a1),a1
 dbra    d3,\PR_PutRow
 bra	NoPutSprite




; Put 3 horizontal lines at d0,d1
fer3c@000C:
PutHor:
 movem.l d0-d2/a0-a1,-(a7)
 sub.w  Ys,d1
 cmpi.w #(SCREEN_Y-3),d1
 bhi	NoPutHor
 moveq	#0,d2

 lsl.w   #1,d1
 move.w  d1,d2		; Change .w to .l
 lsl.w   #4,d2
 sub.w   d1,d2
 
 move.l  Screen,a1
 adda.l  d2,a1

 moveq.l #-1,d2
 moveq.l #2,d1
\PutHorLOOP:
 moveq.l #(SC_X/4-1),d0
\putLoop:
 move.l d2,(a1)+
 dbra	d0,\putLoop
 NEXT_ROW	a1
 dbra	d1,\PutHorLOOP
NoPutHor:
 movem.l (a7)+,d0-d2/a0-a1
 rts

; Put 3 vertical lines at d0,d1
fer3c@000D
PutVer:
 movem.l d0-d2/a0-a1,-(a7)
 sub.w  Xs,d0
 cmpi.w #(SC_X*8-32),d0
 bhi	NoPutVer
 
 move.b  d0,d1
 and.w   #$FFF0,d0
 lsr.b   #3,d0

 and.b   #$0F,d1
 sub.b   #16,d1
 neg     d1
 
 move.l	Screen,a1
 lea	0(a1,d0.w),a1
 moveq	#$00000007,d2
 lsl.l	d1,d2
 moveq	#(SCREEN_Y-1),d0

\putVerLoop:
 or.l d2,(a1)
 lea	SCREEN_X(a1),a1
 dbra	d0,\putVerLoop
NoPutVer:
 movem.l (a7)+,d0-d2/a0-a1
 rts

ClearScreen:
 movem.l d0/a1,-(a7)
 move.l  #(SCREEN_SIZE/4-1),d0         ; The screen is $F00 bytes = 960 longwords.
 move.l  Screen,a1       ; and A1 to the LCD memory
\RepClr:
 clr.l   (a1)+           ; Clear a longword, increase A1 with 4
 dbra    d0,\RepClr      ; Repeat
 movem.l (a7)+,d0/a1
 rts

; This KeyStat's routine is taken from Jimmy Marsden's :
;  Tetris, SameGame, ...
GetKeyStat:
 movem.l d0-d1/a0,-(a7)
 lea keystat(PC),a0
 move.w #$FFFE,d0
 moveq  #Row_Key,d1
\GetKeys:
 move.w d0,$18(a6)
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop	; many nops
 nop
 nop
 nop
 nop
 move.b $1B(a6),(a0)+
 rol.w  #1,d0
 dbra   d1,\GetKeys
 movem.l (a7)+,d0-d1/a0
 rts

; Lecture dans la table des tests en d0 -> x , d1 -> y
; Renvoie D2
Lecture:
 move.l LevelTestADR,a0
QLecture:
 movem.l d0-d1,-(a7)
 lsr.w  #5,d0
 lsr.w  #5,d1
 lsl.w  #7,d1		; Taille niveau X = 128 = 2^7
 add.w  d0,d1
 move.b 0(a0,d1.w),d2
 movem.l (a7)+,d0-d1
 rts

; Is the sprite on a block ?
; Entry :	d0.w = X
;		d1.w = Y
fer3c@0005:
GetTest:	; Teste si le perso en D0,D1 est sur un bloc
		; Retourne D2 = 1 (Pas pos), AUTRE sinon
 movem.l d0-d1,-(a7)
 moveq	#0,d2
 bsr Lecture
 cmpi.b #1,d2
 beq TestFaux
 addi.w #15,d0
 bsr QLecture
 cmpi.b #1,d2
 beq TestFaux
 addi.w #15,d1
 bsr QLecture
 cmpi.b #1,d2
 beq TestFaux
 subi.w #15,d0
 bsr QLecture
TestFaux:
 movem.l (a7)+,d0-d1
 subq.b #1,d2
 rts


; Affiche le statut du personnage
Statut:

 move.l #LCD_MEM,a1
 moveq  #(SCREEN_Y-1),d2
 lea	STAT_X(a1),a1
 moveq	#-1,d4
\Loop:
 move.l d4,(a1)+
 move.w d4,(a1)+
 lea	(SCREEN_X-6)(a1),a1
 dbra	d2,\Loop
 
 lea	Statut_Text(PC),a3
 moveq	#3,d7
 bsr	DrawTextWithoutClear

 SetFont	NORMAL

 bsr PutPower
 bsr PutLife
 bsr PutKey

 tst.b	BoutON
 bne	PutON
PutOFF:
 WriteStr #NUMBER_X,#(STAT_Y4+11),#4,OFF_Str
 bra	CopyTo2ndScreen

PutON:
 WriteStr #NUMBER_X,#(STAT_Y4+11),#4,ON_Str
 bra	CopyTo2ndScreen

PutPower:
 move.w  Bj,d3
 moveq	#(STAT_Y1+11),d4
 bra	   PutNumber

PutLife:
 move.w  Vi,d3
 moveq #(STAT_Y2+11),d4
 bra	   PutNumber

PutKey:
 move.w  Cf,d3
 moveq #(STAT_Y3+11),d4

PutNumber:
 cmp.w   #99999,d3
 bhi 	 Stat1

 movem.l d0-d3/a0-a1,-(a7)

 lea    strend(PC),a0
 moveq  #6,d1
 clr.b  (a0)
\Rep1:
 divu   #10,d3
 move.l d3,d2
 swap   d2
 addi.b #48,d2
 move.b d2,-(a0)
 subq   #1,d1
 and.l  #$FFFF,d3
 bne    \Rep1
 tst.w  d1
 beq    \CSDone
 subq   #1,d1
\Rep2:
 move.b #32,-(a0)
 dbra   d1,\Rep2
\CSDone:

 move.w  #4,-(a7)
 move.l  a0,-(a7)
 move.w  d4,-(a7)
 move.w  #NUMBER_X,-(a7)
 jsr 	 tios::DrawStrXY
 lea     10(a7),a7

 movem.l (a7)+,d0-d3/a0-a1

Stat1:
 rts

CopyTo2ndScreen:
SecondScreenIV:
 move.l	#0,a0			; Source : Immediate Value
				; Program will write here...
 move.l	#LCD_MEM,a1		; destination

 moveq  #(SCREEN_Y-1),d2
 lea	STAT_X(a0),a0
 lea	STAT_X(a1),a1
\Loop:
 move.l (a1)+,(a0)+
 move.w (a1)+,(a0)+
 lea	(SCREEN_X-6)(a0),a0
 lea	(SCREEN_X-6)(a1),a1
 dbra	d2,\Loop
 rts

; Decrease fernando's power and kill him if power=0.
fer3c@0008:
Touche:
	tst.w	v
	bne	\PicSort
	bsr	FlashScreen
	move.w	Bj,d2
	beq	\PicMort
	cmp.w	Diff,d2
	bhi	\PicDec
	clr.w	d2
	bra	\PicFin
\PicDec:
	sub.w	Diff,d2
 	bra	\PicFin
\PicMort:
	clr.b	Mort	; You die !
\PicFin:
	move.w	d2,Bj
	move.w	Diff2,v     ; Dure
	bsr	PutPower
	bsr	CopyTo2ndScreen
\PicSort:
	rts

; Collision entre (d0,d1) et (d6,d7) TailleX = TailleY = 16
; Renvoie D2=0, Aucune collision
;	    D2=1, (d0,d1) & (d6,d7)
fer3c@0006:
TestCollision:

	move.w d6,d2
	subi.w  #15,d2
	cmp.w  d2,d0
	blt    NoTuch
	addi.w  #30,d2
	cmp.w  d2,d0
	bgt    NoTuch

	move.w d7,d2
	subi.w  #15,d2
	cmp.w  d2,d1
	blt    NoTuch
	addi.w  #30,d2
	cmp.w  d2,d1
	bgt    NoTuch

	moveq #0,D2
	rts

NoTuch:
	moveq #1,D2
	rts

; Test Sprite exit of the screen (d0,d1)
; Renvoie D2=0, No exit
;	  D2=1 Sprite exit
fer3c@0007:
TestExitScreen:
	move.w  Xs,d2
	subi.w  #(31*2),d2
	cmp.w   d2,d0
	blt     \Exit
	addi.w  #(31*(1+2+1)+32+SC_X*8),d2
	cmp.w   d2,d0
	bgt     \Exit
	move.w  Ys,d2
	subi.w  #(31*2),d2
	cmp.w   d2,d1
	blt     \Exit
	addi.w  #(31*(1+2+2)+SCREEN_Y+32),d2
	cmp.w   d2,d1
	bgt     \Exit
	moveq #1,d2
	rts
\Exit:
	moveq #0,D2
	rts

FlashScreen:
 movem.l d0-d1/a0,-(a7)
 moveq	 #31,d1
RepInverseScr:
 move.l  #(SCREEN_SIZE/4-1),d0
 move.l  Screen,a0
RepInv:
 not.l	(a0)+
 dbf   d0,RepInv
 bsr	ChangeScreen
 dbf   d1,RepInverseScr
 movem.l (a7)+,d0-d1/a0
 rts

fer3c@0003:
; a5.l -> Sprite, d0.l -> Taille du sprite
; Destroy a0,a1,d0
DestroySprite:
	move.l a5,a0		; Source
	move.l a5,a1		; Destination
	add.l  d0,a1
	sub.l  d0,SpriteADREnd	; New SriteADREnd
	move.l	SpriteInitEndBuffer+2,d0	; = SpriteADR + SPRITE_BUFFER
\DelBoucle:
	move.l	(a1)+,(a0)+
	cmp.l	d0,a1		; Do we arrive at the end of the buffer ?
	bmi	\DelBoucle
	rts

WaitForNotKey:
	clr.l	$18(a6)			; Mask to read keys
\WaitForQuit:
	move.b $1B(a6),d0		; Wait for all keys
	cmpi.b #$FF,d0			; to be released
	bne    \WaitForQuit
	rts

WaitForAllKey:
	bsr	WaitForNotKey
\Loop
	move.b $1B(a6),d0		; Wait for all keys
	cmpi.b #$FF,d0
	beq    \Loop
	rts

; a3 -> Structure and d7 = Numbers
fer3c@000B:
DrawText:
	jsr	flib::zap_screen
DrawTextWithoutClear:
\Loop:
	move.w	(a3)+,-(a7)
	jsr	tios::FontSetSys
	move.w	#4,-(a7)
	move.w	(a3)+,d0
	move.w	(a3)+,d1
	move.l	(a3)+,-(a7)
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	jsr     tios::DrawStrXY
	lea	12(a7),a7
	dbf	d7,\Loop
	rts

ClearTab:
	lsr.w   #5,d0
	lsr.w   #5,d1
	lsl.w   #7,d1		; Taille niveau X = 128 = 2^7
	add.w   d0,d1
	move.l  LevelTestADR,a0
	clr.b	 0(a0,d1.w)
	rts

SpriteAutoAppear:
 move.l d5,a0
 add.l  LevelTestADR,a0
 lea (128*(SCREEN_Y/32))(a0),a1

 moveq.l #0,d0
 moveq.l #(SC_X/4),d1
\Loop:

 move.b (a0),d0
 cmpi.b #(SpriteAutoStart),d0
 bls	\s1
 bsr	NewSprite
\s1:
 addq.l #1,a0

 move.b (a1),d0
 cmpi.b #(SpriteAutoStart),d0
 bls	\s2
; cmp.w #(32*(32-5)),Ys
; bcc	\s2
 move.l a0,a4		; Save a0 in a4
 move.l a1,a0		; a1:=a0
 bsr	NewSprite	; New sprite
 move.l a4,a0		; Restore a0
\s2:
 addq.l #1,a1		; Next Item
 dbra   d1,\Loop

 move.l  LevelTestADR,a0
 lea	 127(a0,d5.l),a0
 addq.l	 #1,a0
 moveq.l #2,d1		; Donc maintenant 2 devrait suffire

\loop:

 move.b (a0),d0
 cmpi.b #(SpriteAutoStart),d0
 bls	\s3
 bsr	NewSprite
\s3:
 lea	(SC_X/4)(a0),a0

 move.b (a0),d0
 cmpi.b #(SpriteAutoStart),d0
 bls	\s4
 bsr	NewSprite
\s4:
 lea	(128-SC_X/4)(a0),a0
 dbra	d1,\loop

 rts

NewSprite:
 movem.l d0-d3/a0-a2,-(a7)
 sub.w	#(SpriteCorrect),d0
 add.w	d0,d0			; Calcul du No du sprite

 move.l	a0,d3
 sub.l   LevelTestADR,d3	; Calcul de l'adresse Relative
 cmp.l	#(32*128),d3		; Test si on ne depasse pas le tableau
 bcc	\OutSide
 clr.b	(a0)			; Clear Tab[X_Init,Y_Init]

 move.l  d3,d1
 move.l  d1,d2
 lsr.l   #7,d2
 lsl.l   #5,d2			; Calcul de Y_Init

 andi.l  #127,d1
 lsl.l   #5,d1			; Calcul de X_Init

 bsr	 SpriteInit		; New sprite in the buffer
\OutSide:
 movem.l (a7)+,d0-d3/a0-a2
 rts


; *********************************************************
;
;			MULTI PLAYER
;
; *********************************************************

Select_Player:
	WriteStr	#PLAYER_X,#PLAYER_Y,#4,Player_Menu_Str
	clr.w   tios::kb_vars+$1C
	jsr	flib::idle_loop
	cmp.w	#264,d0
	bne	No_Esc
Exit_Select_Player:
	moveq	#1,d0
	rts
No_Esc:	cmp.w	#268,d0
	bcs	Select_Player
	bne	\NoF1
	clr.w	NbrJoueur
	rts
\NoF1:
	cmp.w #(267+MAX_PLAYER),d0
	bhi	Select_Player
	sub.w	#268,d0
	move.w	d0,NbrJoueur
	move.w	d0,d5
	move.l	SpriteADR,a5
Loop_Search_Key:
	WriteStr	#PLAYER2_X,#PLAYER2_Y,#4,Player_Str
	move.w	d5,d3
	addq.w	#1,d3
	move.w	#PLAYER2_Y,d4
	bsr	PutNumber
	WriteStr	#PLAYER3_X,#PLAYER3_Y,#4,Keyboard_Str
	moveq	#4,d3
\Sub_Loop:
	clr.w   tios::kb_vars+$1C
	jsr	flib::idle_loop
	cmp.w	#264,d0
	beq	Exit_Select_Player
	bsr	GetKeyStat
; move.l	#0,d0
; moveq	#Row_Key,d5
; lea	keystat(PC),a0
; moveq.l #3,d1
;\Loop:
; move.b	(a0)+,d0
; moveq.l #10,d2
; moveq.l #7,d4
; jsr	hexlib::put_bin
; addq	#1,d1
; dbf	d5,\Loop

	moveq	#Row_Key,d0
\Sub2_Loop:
	moveq	#7,d1
\Sub3_Loop:
	btst.b	d1,keystat(PC,d0.w)
	beq	\Find_A_Key
	dbf	d1,\Sub3_Loop
	dbf	d0,\Sub2_Loop
	bra	\Sub_Loop
\Find_A_Key:
;	bsr	ShowD0D1
	move.w	d3,d2
	add.w	d2,d2		; d2 = 2 * d3
	move.b	d1,F_End(a5,d2.w)
	move.b	d0,(F_End+1)(a5,d2.w)
	dbf	d3,\Sub_Loop
	lea	F_Multi_End(a5),a5
	dbf	d5,Loop_Search_Key
	moveq	#0,d0
	rts

; Keystat is here because  I need to access like that : keystat(PC,d0.w)
; in Select_Player and Sprite_Fernando_Multi
fer3c@0010:
keystat		ds.b	10

Sprite_Fernando_Multi:
	move.w	keystat,-(a7)	; Save keys
	move.w	Bj,-(a7)	; Save power
	move.w	F_Power(a5),Bj	; Set power

	moveq	#-1,d4
	clr.w	d0		; D0.l isn't cleared
	move.b	Up(a5),d1
	move.b	(Up+1)(a5),d0
	btst.b	d1,keystat(PC,d0.w)
	bne	\NoUp
	bclr.b	#Up_Key,d4
\NoUp:
	move.b	Down(a5),d1
	move.b	(Down+1)(a5),d0
	btst.b	d1,keystat(PC,d0.w)
	bne	\NoDown
	bclr.b	#Down_Key,d4
\NoDown:
	move.b	Left(a5),d1
	move.b	(Left+1)(a5),d0
	btst.b	d1,keystat(PC,d0.w)
	bne	\NoLeft
	bclr.b	#Left_Key,d4
\NoLeft:
	move.b	Right(a5),d1
	move.b	(Right+1)(a5),d0
	btst.b	d1,keystat(PC,d0.w)
	bne	\NoRight
	bclr.b	#Right_Key,d4
\NoRight:
	move.b	Jump(a5),d1
	move.b	(Jump+1)(a5),d0
	btst.b	d1,keystat(PC,d0.w)
	bne	\NoJump
	bclr.b	#Jump_Key,d4
\NoJump:
	move.b	d4,keystat
;	moveq.l	#0,d0
;	move.b	d4,d0
;	move.w	#1,d1
;	move.w	#1,d2
;	move.w	#7,d4
;	jsr	hexlib::put_bin
	bsr	Sprite_Fernando
	move.w	Bj,(F_Power-F_End)(a5)	; Get power
	move.w	(a7)+,Bj		; Restore power
	move.w	(a7)+,keystat		; Restore keys
	lea	(F_Multi_End-F_End)(a5),a5	; Next sprite
	rts

;ShowD0D1:
;	movem.l	d0-d7/a0-a6,-(a7);
;	move.w	d1,-(a7);
;	move.w	#1,d1
;	move.w	#15,d2
;	move.w	#7,d4
;	jsr	hexlib::put_bin
;	move.w	(a7)+,d0
;	move.w	#2,d1
;	move.w	#15,d2
;	move.w	#7,d4
;	jsr	hexlib::put_bin
;	movem.l	(a7)+,d0-d7/a0-a6
;	rts

Sprite_Gestion_Multi:
	movem.l	d0-d5/a0-a6,-(a7)

; Rotation des fernandos en premire place
	move.w	TailleGest(a5),d7
	move.w	G_Power(a5),d0
	move.w	Bj,d1
	move.l	a5,a6		; Save current position

	move.l	SpriteADR,a5
	add.w	d1,F_Power(a5)	; Save the power of the Fer
	sub.w	d0,F_Power(a5)	; Correction
	move.l	a5,a3
	move.l	a5,a4			; Save a5:SpriteADR
	movem.l	(a5)+,d0-d6/a0-a2	; Load First Fernando Multi : 40 Bytes
\Loop:
	move.l	(a5)+,(a3)+
	dbf	d7,\Loop
	movem.l	d0-d6/a0-a2,-(a5)	; Push First Fernando in the Last place
	
; Initialisation du Fernando qui va se manger les tests de sprite
	move.l	a4,a5			; a5 pointe  nouveau  SpriteADR
	move.w	Xj(a5),d6		; Init X_Fernando
	move.w	Yj(a5),d7		; Init Y_Fernando
	move.w	F_Power(a5),Bj		; Init power
	move.w	F_Power(a5),d0		; Save power in multi-player
	move.w	d0,G_Power(a6)

; Calcul du pointeur de scrolling
	moveq	#0,d0
	moveq	#0,d1
	move.w	NbrJoueur,d2
\Loop2:
	add.w	Xj(a5),d0
	add.w	Yj(a5),d1
	lea	F_Multi_End(a5),a5
	dbf	d2,\Loop2
	move.w	NbrJoueur,d2
	addq.w	#1,d2
	divu.w	d2,d0
	divu.w	d2,d1
	bsr	UpDateScrollVar

; Touche de recentrage alatoire
	ReCenter_Key_Test
	bne	\No
	move.w	Xj(a4),d0
	move.w	Yj(a4),d1
 	bra	\ReCenter
\No
; Verification s'il y a tlportation ?
	cmp.b	#TELEPORTATION,Mort
	bne	\NoNewStart
	move.w	StartX,d0
	move.w	StartY,d1
\ReCenter:
	move.w	NbrJoueur,d2	; a4 pointe vers la liste-pile de sprites
\Starting_Loop:
	move.w	d0,Xj(a4)
	move.w	d1,Yj(a4)
	lea	F_Multi_End(a4),a4
	dbf	d2,\Starting_Loop
\NoNewStart:
	movem.l	(a7)+,d0-d5/a0-a6
	lea	Gest_Multi_End(a5),a5
	rts

Init_Fernando:
	tst.w	NbrJoueur
	bne	\Multi
	moveq	#0,d0
	bra	SpriteInit	; Init Fernando Solo and back	
\Multi:
	move.w	NbrJoueur,d3
\Loop
	moveq	#16,d0		; Init Fernando Multi-Player
	bsr	SpriteInit
	dbf	d3,\Loop
	moveq	#18,d0		; Init Gest Multi-Fernando and back
	bra	SpriteInit











; *********************************************************
;
;			LINK GESTION
;
; *********************************************************

;ChooseSlaveMaster:
;	WriteStr	#1,#1,#4,Wait_Str
;;	bsr	ReceiveByte
;	cmp.b	#$AE,d0
;	beq	\slave
;	move.b	#$C0,d0
;	bsr	SendByte
;\Wait:
;	bsr	GetKeyStat
;	btst	#0,keystat
;	beq	\ExitChoose
;	bsr	ReceiveByte
;	cmp.b	#$C0,d0
;;	beq	\slave
;	cmp.b	#$AE,d0
;	bne	\Wait
;\good:
;	move.b	#$AD,d0
;	bsr	SendByte
;	move.b	#MASTER,Link
;	bra	\ExitChooseAndSet
;\slave:
;	move.b	#$AE,d0
;	bsr	SendByte
;	move.b	#SLAVE,Link
;	move.b	#$A0,d0
;	bsr	SendByte
;	bsr	Send
;\ExitChooseAndSet:
;\ExitChoose:
;	moveq	#20,d0
;	bra	SpriteInit
;;	clr.b	Link
;	rts

;WaitingReport:
; move.l	#MAX_DELAI,d3
;\Wait:
; subq.l	#1,d3
; beq	\LinkError
; bsr	ReceiveByte
; cmp.b	#$AD,d0
; bne	\NOAD
; move.b	#LEVEL_COMPLETED,Mort
; bra	\Exit
;\NOAD:
; cmp.b	#$AB,d0
; bne	\NOAB
; clr.b	Mort	; You die
; bra	\Exit
;\NOAB:
; cmp.b	#$A0,d0
; bne	\Wait
; bsr	Receive
;\LinkError:
; move.b	#$A0,d0
; bsr	SendByte
; bsr	Send
;\Exit:
; rts
;WaitingReport:
; bsr	Receive
; move.b	#$A0,d0
;bsr	SendByte
;move.l	#MAX_DELAI,d3
;\Wait:
; subq.l	#1,d3
; beq	\LinkError
; bsr	ReceiveByte
; cmp.b	#$A0,d0
; bne	\Wait
;\LinkError:
; rts

;SendByte:
; movem.l d0-d1/a0-a1,-(a7)
; lea	LinkBuf(PC),a0
; move.b	d0,(a0)
; move.w	#1,-(a7)
; move.l	a0,-(a7)
; jsr	tios::transmit
;; addq	#6,a7
 ;movem.l (a7)+,d0-d1/a0-a1
 ;rts;

;ReceiveByte:
; movem	d1/a0-a3,-(a7)
; lea	LinkBuf(PC),a3
; clr.b	(a3)
; move.w	#1,-(a7)
; move.l	a3,-(a7)
; jsr	tios::receive
; addq	#6,a7
;; moveq	#0,d0
;move.b	(a3),d0
; movem	(a7)+,d1/a0-a3
 ;rts

;Send:
; movem	d0-d1/a0-a2,-(a7)       
; move.l	SpriteADR,a2
; lea	LinkBuf(PC),a0
; move.l	a1,a0
;; move.w	Xj(a2),(a0)+ 
 ;move.w	Yj(a2),(a0)+
; move.w	Dessin(a2),d0
; add.w	F_Sens(a2),d0
; move.b	d0,(a0)+
; move.b	v+1,(a0)
; move.w	#6,-(a7)
; move.l	a1,-(a7)
; jsr	tios::transmit
; addq.l	#6,a7
; movem	(a7)+,d0-d1/a0-a2
; rts


;Receive:                
;; movem	d1/a0-a1,-(a7)  
; move.w	#6,-(a7)
; pea	LinkBuf(PC)     
; jsr	tios::receive   
; addq.l	#6,a7
; cmp.w	#6,d0		; All has been received ?
; bgt	\Ok
; addq.b	#1,Frame_Time	;No, decrease the speed...
;\Ok:
; movem	(a7)+,d1/a0-a1  
; rts

;LinkBuf  ds.b 10

Sprite_Link_Gestion:
; lea	LinkBuf(PC),a0
; move.w (a0)+,d0
; move.w	(a0)+,d1
; moveq	#0,d2
; move.b	(a0)+,d2
; bsr	PutSprite
; tst.b	(a0)+
; beq	\Skip
; moveq	#BULLE,d2
; bsr	PutSprite
;\Skip:
; lea	Link_Gestion_End(a5),a5
; rts


; *********************************************************
;
;			Gestion du SCROLLING
;
; *********************************************************


fer3c@000A:
; Le scrolling se concentre sur D0,D1
UpDateScrollVar:
 clr.w  XsNew
 cmpi.w #SCROLLX,d0
 bls    NS1
 cmpi.w #(128*32-SC_X*8+SCROLLX),d0
 bhi	  SupX
 subi.w #SCROLLX,d0
 move.w d0,XsNew
NS1:
 clr.w  YsNew
 cmpi.w #SCROLLY,d1
 bls    NS2
 cmpi.w #(32*32-SCREEN_Y+SCROLLY),d1
 bhi	  SupY
 subi.w #SCROLLY,d1
 move.w d1,YsNew
NS2:
 rts
SupX:
 move.w #(128*32-SC_X*8),XsNew
 bra    NS1
SupY:
 move.w #(32*32-SCREEN_Y),YsNew
 rts

fer3c@0009:
Scrolling:
 ifeq	SCROLL_FILE
  include "SplitS.s"
 endif
 ifeq	SCROLL_FILE-1
  include "FullScr.s"
 endif

ChangeScreen:
;	rts		; For Debug only.
	lea    Table(PC),a0
	moveq	#0,d0
	move.b Phase,d0			; N of the current screen
	move.w 0(a0,d0.w),$10(a6)	; Write the adress of the current screen
	eori.b #2,d0
	move.b d0,Phase
	move.w 0(a0,d0.w),d0
	lsl.l  #3,d0
	move.l d0,Screen		; New current Screen
	rts

; *****************************************************************
;
;				DATAS
;
; *****************************************************************

fer3c@0001:

Vitesse:
VirtualScreen	dc.w 0		; ADR of virtual screen		+0
TaillePhase	dc.w 0		; Or Speed of the boss and height of one phase

Screen		dc.l 0		; ADR of current screen		+4
Table		dc.w 0,0	; Table of ADR of the 2 screens	+8
Phase		dc.b 0		; Must be NULL ( Current screen = 0 or 2 ?)	;12
Mort		dc.b 0		; Fernando dies ?		+13

LevelADR	dc.l 0		; ADR of the graph-level file	+14
LevelTestADR	dc.l 0		; ADR of the test-level file	+18

SpriteADR	dc.l 0		; ADR of sprite's buffer	+22
SpriteADREnd	dc.l 0		; ADR of the end of the sprite's buffer

Phase2ADR:			; ADR of Phase 2 (Boss)
GraphADR	dc.l 0		; Or ADR of the graph-file	+30

Phase1ADR:			; ADR of phase 1 (Boss)
StartX		dc.w 0		; X_Start			+34
StartY		dc.w 0		; Y_Start			+36

NbrElement:			; Number of the elements of the boss
XsOld		dc.w 0		; (X_Scrolling_Old / 32) *32	+38
NbrPhase:			; Number of the phases of the boss
YsOld		dc.w 0		; Or (Y_Scrolling_Old / 32) *32

Xs		dc.w 0		; X_Scrolling			+42
Ys		dc.w 0		; Y_Scrolling
XsNew		dc.w 0		; New X_Scrolling		+46
YsNew		dc.w 0		; New Y_Scrolling

Frame_Time	dc.b 23		; Time of one frame (23 * processor clock rate = 1/60 s)	+50
Link		dc.b 0		; Link flag
Clock		dc.w 0		; Clock (Long)			+52
Time		dc.w 0		; Time  (Word)			+54

ExecAddOnADR	dc.l 0		; Adress of the exec AddOn	+56
InitAddOnADR	dc.l 0		; Adress of the init AddOn	+60

Turbo		dc.w 1		; Turbo (2 or not (1) ?		+64

NbrJoueur	dc.w 0		; Number of players - 1		+66

Refresh:
BoutON		dc.b 0		; Switch ON / OFF		+68
Plan		dc.b 0		; Current plan = 0 / 1		+69
BossLife:			; Life of the boss
Cf		dc.w 0		; Or number of Keys		+70
Vi		dc.w 0		; Lifes				+72
Bj		dc.w 0		; Power				+74
Coins		dc.w 0		; Coins collected		+76
v		dc.w 0		; Invulnerable ?		+78
Phase1:				; No of phase 1
ComptBj		dc.w 0		; Or Max Power			+80
Phase2:				; No of Phase 2
ComptVi		dc.w 0		; Or Max one-up			+82

Diff		dc.w 20		; How much power will be dec (Easy Mode)
Diff2		dc.w 500	; How much time perso = invulnerable (")

str		ds.b  9		; String for "Convert number to string"
strend		dc.b  0

Power_Str	dc.b "POWER ",0
Secret_Str	dc.b "Secret  "
Life_Str	dc.b "LIFE  ",0
Key_Str		dc.b "KEY(S)",0
Boss_Str	dc.b "BOSS ",0
Switch_Str	dc.b "SWITCH",0
ON_Str		dc.b " ON  ",0
OFF_Str		dc.b " OFF ",0
Time_Str	dc.b "Time ",0

Level_Str	dc.b "LEVEL COMPLETED!",0
Thats_all_Str	dc.b "THE END!",0
Game_Over_Str	dc.b "GAME OVER",0
Slash_Str	dc.b "/",0


Intro_Text
	INTRO_MACRO

Level_Completed_Text:
	dc.w	GRAS,LEVEL1_X,10
	dc.l	Level_Str
	dc.w	NORMAL,LEVEL_X,LEVEL2_Y
	dc.l	Power_Str
	dc.w	NORMAL,LEVEL_X,LEVEL5_Y
	dc.l	Coins_Str
	dc.w	NORMAL,SLASH_X,SLASH_Y
	dc.l	Slash_Str
	dc.w	NORMAL,LEVEL_X,LEVEL3_Y
	dc.l	Secret_Str
	dc.w	NORMAL,LEVEL_X,LEVEL4_Y
	dc.l	Time_Str

Statut_Text:
	dc.w	STAT_FONT,NUMBER_X-4,STAT_Y1
	dc.l	Power_Str
	dc.w	STAT_FONT,NUMBER_X-4,STAT_Y2
	dc.l	Life_Str
	dc.w	STAT_FONT,NUMBER_X-4,STAT_Y3
	dc.l	Key_Str
	dc.w	STAT_FONT,NUMBER_X-4,STAT_Y4
	dc.l	Switch_Str

Boss_Text:
	dc.w	STAT_FONT,NUMBER_X-4,STAT_Y3
	dc.l	Boss_Str

Fernand		INCBIN Fernand.S16	; Fernand Graph (Format 16*16)
		INCBIN Enm0.S16		; Enemy 0 Graph
		INCBIN Enm1.s16		; " 1
		INCBIN Enm2.s16		; " 2
Save:
	ds.b	16			; Save

Title:	
	dc.b "Fernando 3C v0.29",0
Menu_Str:
	dc.b "F1:Easy F2:Normal F3:Hard",0
Menu2_Str:
	dc.b "F4:Link F5:Load",0
Player_Menu_Str:
	dc.b "F1-1  F2-2  F3-3  F4-4  "
Player_Str:
	dc.b "Player",0
Speed_Str:
	dc.b "Frame ",17,18,":",0
Keyboard_Str:
	dc.b "Press Up, Down, Left, Right and Jump",0
Memory_Str:
	dc.b "MEMORY",0
Save_Str:
	dc.b "SAVE ?",0
Coins_Str:
	dc.b "COINS",0
Turbo_Str:
	dc.b "TURBO"
Vide_Str:
	dc.b 0
Copyright:
	dc.b 169,"1999 Plissier Patrick",0
	ifeq	LIBRARYOK-1
_library:	dc.b "fer3c",0
	endif

	end
