{Boss.PAS}
{$M 8192,0,0}           { Leave memory for child process }

uses Crt,dos;

const
 MAXx = 240;
 MAXy = 180;
 TailleX = 10;
 TailleY = 6;
 Start = 64;
 MAXgx = 16;
 MAXgy = 16;
 MAXDRAW = 60;
 MAXgD = 2;

 MAXPhase = 100;
 MAXElement = 50;

type
 Tab = ARRAY [0..MAXPhase-1] of array [0..MAXElement-1] of array [0..1] of byte;
 Tab2 = ARRAY [0..MAXPhase-1] of byte;
 Tab3 = ARRAY [0..MAXElement-1] of ARRAY [0..1] of byte;
 GraphTab = ARRAY [0..MAXgD-1] of array [0..MAXgy-1] of array [0..MAXDRAW-1] of byte;

var
 C: Char;
 NbrElement,NbrPhase: byte;
 i,j,k,Phase,Element,Pixel: byte;

 Anim: Tab;
 Temp: Tab3;
 Vitesse: Tab2;
 Mem: GraphTab;
 Ch: Char;
 s,s2,tmp : String;
 Continuer : BOOLEAN;
 xresolution,yresolution,video_seg,MouseX,MouseY,Button:word;
 OrigMode :Integer;

function DestroyExt(s:string):string;
var
   i:integer;

begin
    i:=Pos('.',s);
    if i>0 then DestroyExt:=Copy(s,1,i-1) else DestroyExt:=s;
end;

function FileExists(FileName: String): Boolean;
var
 F: file;
begin
 {$I-}
 Assign(F, FileName);
 FileMode := 0;  { Set file access to read only }
 Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
end;  { FileExists }



procedure SaveFile(FileName: String);
var
 F: Text;
 i,j,k: Integer;
 Ch: char;

begin
 Assign(F,FileName);
 ReWrite(F);
 Write(F,chr(0)+chr(2));
 Write(F,chr(NbrElement));
 Write(F,chr(NbrPhase));
 for j := 0 to NbrPhase do
     begin
     Write(F,Chr(Vitesse[j]));
     for i := 0 to NbrElement do
           for k :=0 to 1 do
               Write(F, Chr(Anim[j][i][k]));
     end;
 for k := 0 to NbrElement do
  begin
       for j := 0 to MAXgy - 1 do
        for i := 0 to (MAXgD - 1) do
            Begin
            Ch := chr(Mem[i][j][k]);
            Write(F, Ch);
            end;
  end;
 Close(F);
end;



procedure OpenFile(FileName: String);
var
 F: Text;
 i,j,k: Integer;
 Ch: char;

begin
 Assign(F,FileName);
 Reset(F);
 Read(F,Ch);
 Read(F,ch);
 Read(F,Ch); NbrElement:=ord(ch);
 Read(F,Ch); NbrPhase:=ord(ch);

 for j := 0 to NbrPhase do
     begin
     Read(F,Ch);
     Vitesse[j]:=ord(ch);
     for i := 0 to NbrElement do
            for k :=0 to 1 do
            begin
            read(F,Ch);
            Anim[j][i][k]:=ord(Ch);
            end;
     end;

 for k := 0 to NbrElement do
  begin
       for j := 0 to MAXgy - 1 do
        for i := 0 to (MAXgD - 1) do
            Begin
            read(F,Ch);
            Mem[i][j][k]:=ord(Ch);
            end;

  end;
end;

procedure OpenFileGraph(FileName: String);
var
 F: Text;
 i,j,k: Integer;
 Ch: char;

begin
 Assign(F,FileName);
 Reset(F);
 k:=0;
 while (not Eof(F)) and (k<MAXDRAW) do
  begin
    for j := 0 to MAXgy - 1 do
        for i := 0 to (MAXgD - 1) do
            Begin
            Read(F, Ch);
            Mem[i][j][k] := ord(Ch);
            end;
    k:= k + 1;
  end;
 NbrElement:=k-1;
end;

procedure init_Mcga;
begin
yresolution:=200;
xresolution:=320;
video_seg:=$A000;
asm
mov xresolution,320d
mov ax,13h
int 10h
end
end;

procedure DrawMouse; assembler;
asm
mov ax,1
int $33
end;

procedure MaskMouse; assembler;
asm
mov ax,2
int $33
end;

procedure ReadMouse; assembler;
asm
mov ax,3
int $33
mov MouseX,cx
mov MouseY,dx
mov Button,bx
end;

procedure sp(xl,yl,coul:word); assembler;
asm
 mov ax,yl
 mul xresolution
 mov bx,xl
 add bx,ax
 mov es,video_seg
 mov ax,coul
 mov es:[bx],al
end;

procedure box(xl,yl,xl1,yl1,coul:word);assembler;
var i:word;
label a,b;
asm
 mov es,video_seg
 mov dx,xl
 mov i,dx
 a:
 mov Cx,yl
 b:
 mov ax,cx
 mul xresolution
 mov bx,i
 add bx,ax

 mov ax,coul
 mov es:[bx],al
 inc cx
 cmp cx,yl1
 jbe b
 inc i
 mov dx,i
 cmp dx,xl1
 jbe a
end;

procedure PrintGraph(No,xj,yj:integer);
var i,j:integer;
c:byte;

label Boucle,B18;

begin
    for j:=0 to MAXgy-1 do
        for i:=0 to MAXgd-1 do
            begin
                  c:=Mem[i][j][No];
                  asm
                   mov ax,j
                   add ax,yj
                   mul xresolution
                   mov bx,ax
                   mov ax,i
                   add ax,ax
                   add ax,ax
                   add ax,ax
                   add bx,xj
                   add bx,ax
                   mov ah,c
                   mov es,video_seg
                   mov cx,7
Boucle:
                   mov al,18
                   mov dx,1
                   sal dx,cl
                   and dl,ah
                   je  B18
                   mov al,75
                   mov es:[bx],al
B18:
                   inc bx
                   dec cx
                   cmp cx,-1
                   jne Boucle
                  end;
              end;
end;

procedure SaveFileText(FileName: String);
var
 F: Text;
 Str: string;
 FileName2: string;

begin
 Writeln('Comment: ?');
 readln(Str);
 FileName2:=FileName+'.ASM';

 Assign(F,FileName2);
 ReWrite(F);
 Writeln(F,'	xdef	_main');
 Writeln(F,'	xdef	_comment');
 Writeln(F,'_main:	lea        Start(PC),a0');
 Writeln(F,'            jmp        fer3c@0000');
 Writeln(F,'Start:      dc.w       1');
 Write(F,'	INCBIN	');
 Write(F,FileName);
 Writeln(F,'.p92');
 Write(F,'_comment:	dc.b	"');
 Write(F,Str);
 Writeln(F,'",0');
 Writeln(F,'	end');
 Close(F);
end;

procedure PrintScreen(Phase: integer);

var
  i: integer;
begin
BOX(0,0,6*32,128,20);
for i:=0 to NbrElement do
    PrintGraph(i,Anim[Phase][i][0],Anim[Phase][i][1]);
end;

Procedure CopyPhase;

var
 i,j:integer;

 begin
 for i:=0 to NbrElement do
     for j:=0 to 1 do
         Temp[i][j]:=Anim[Phase][i][j];
 end;

Procedure PastePhase;

var
 i,j:integer;

 begin
 for i:=0 to NbrElement do
     for j:=0 to 1 do
         Anim[Phase][i][j]:=Temp[i][j];
 end;


begin
  { Get file to read from command line : ParamStr(1) }

  OrigMode := LastMode;

  clrscr;
  Writeln('FERNANDO 3-C Boss Editor (C) 1998 HD Developement');
  writeln;

  Write('Enter Boss File Name (without ''.???''): ');
  if ParamStr(1)='' then Readln(s) else s:=ParamStr(1);
  Writeln('You typed: ',s);
  s2:=DestroyExt(s);
  s:=s2 + '.BSS';

  if FileExists(s) then
   begin
   Writeln('File exists');
   OpenFile(s);
  end
 else
   Begin
   Writeln('File not found');
   writeln('New files:',s2,'.Bss');
   Writeln('Please enter Graph File (S16):');
   readln(tmp);
   OpenFileGraph(tmp);
   NbrPhase:=0;
   while 2*int(NbrPhase/2)=NbrPhase do
    begin
    Writeln('Please enter Number of Phase (Not 2,4,6,8,10,...):');
    readln(NbrPhase);
    end;

   end;
 writeln;
 writeln('Use the PAD to move the cursor');
 writeln('Use Sace to change the speed');
 writeln('Use F1:Info F2:Save F3:Copy F4:Paste F5:NbrPhase F6:92P-File');
 writeln;
 writeln('Press A B ...(Ascii table) to choose an element');
 writeln;
 writeln('Press ENTER to start and ESC TO QUIT');
 readln;

 init_Mcga;
 Phase:=0;
 Element:=0;
 Pixel:=1;

 Continuer:=TRUE;

 while continuer do
 begin
  PrintScreen(Phase);
  DrawMouse;
  while Not(Keypressed) do
                begin
                     ReadMouse;
                     if Button=1 then
                        begin
                             asm
                             mov ax,MouseX
                             sar ax,1
                             mov MouseX,ax
                             end;
                             for i:=NbrElement downto 0 do
                                 if (Anim[Phase][i][0]<=MouseX) and
                                    (Anim[phase][i][1]<=MouseY) and
                                    (Anim[phase][i][0]+16>=MouseX) and
                                    (Anim[phase][i][1]+16>=MouseY) then
                                       begin
                                           j:=Anim[Phase][i][0]-MouseX;
                                           k:=Anim[Phase][i][1]-MouseY;
                                           While Button=1 do
                                           begin
                                           ReadMouse;
                                           asm
                                           mov ax,MouseX
                                           sar ax,1
                                           mov MouseX,ax
                                           end;
                                           Anim[Phase][i][0]:=MouseX+j;
                                           Anim[Phase][i][1]:=MouseY+k;
                                           MaskMouse;
                                           PrintGraph(i,Anim[Phase][i][0],Anim[Phase][i][1]);
                                           DrawMouse;
                                           end;
                                       MaskMouse;
                                       PrintScreen(Phase);
                                       DrawMouse;
                                       end;
                         end;
                end;
  MaskMouse;

  C := Readkey;
  i := Anim[Phase][Element][0];
  j := Anim[Phase][Element][1];

  if c=chr(0) then
              begin
                c:=ReadKey;
                if (c = 'K') and (i >= Pixel) then
                                begin
                                i:= i - Pixel;
                                end
                else if (c = 'M') and (i<= (MAXx - Pixel)) then begin
                                        i:= i + Pixel;
                                        end
                else if (c = 'H') and (j>=Pixel) then
                         begin
                         j:=j-Pixel;
                         end
                else if (c = 'P') and (j<(MAXy - Pixel)) then
                            begin
                             j:=j + Pixel;
                            end
                else if (c = '<') then SaveFile(s)
                else if c='=' then CopyPhase
                else if c='>' then
                              begin
                              PastePhase;
                              i := Anim[Phase][Element][0];
                              j := Anim[Phase][Element][1];
                              end
                else if c=';' then
                              begin
                                  TextMode(OrigMode);
                                  writeln('Position   :',i,'/',MAXx-1,',',j,'/',MAXy-1);
                                  writeln('Phase No   :',Phase,' / ',NbrPhase);
                                  writeln('Element No :',Element,' / ',NbrElement);
                                  writeln('Speed      :',Vitesse[Phase]);
                                  writeln('Press ENTER to continue...');
                                  readln;
                                  Init_Mcga;
                                  end
               else if (c = '?') then
                                 begin
                                 TextMode(OrigMode);
                                 Writeln('Please enter Number of Phase (Not 2,4,6,8,10,...):');
                                 Writeln('NbrPhase:',NbrPhase);
                                 Write('New:');
                                 readln(NbrPhase);
                                 while 2*int(NbrPhase/2)=NbrPhase do
                                    begin
                                       Writeln('Please enter Number of Phase (Not 2,4,6,8,10,...):');
                                       Writeln('NbrPhase:',NbrPhase);
                                       Write('New:');
                                       readln(NbrPhase);
                                    end;
                                 Init_Mcga;
                                 end
               else if (c = '@') then
                                  begin
                                  TextMode(OrigMode);
                                  writeln('Make 92p File...');
                                  SaveFileText(s2);
                                  SwapVectors;
                                  Exec(GetEnv('COMSPEC'), '/C packer92 -n '+s+' '+s+' '+s2+'.P92');
                                  Exec(GetEnv('COMSPEC'), '/C fargo '+s2);
                                  Exec(GetEnv('COMSPEC'), '/C del '+s2+'.ASM');
                                  Exec(GetEnv('COMSPEC'), '/C del '+s2+'.P92');
                                  Exec(GetEnv('COMSPEC'), '/C del '+s2+'.INC');
                                  SwapVectors;
                                  if DosError <> 0 then
                                  WriteLn('Could not execute COMMAND.COM, DosError :',DosError);
                                  writeln('Press Enter to continue');
                                  readln;
                                  Init_Mcga;
                                  end;


                Anim[Phase][Element][0]:=i;
                Anim[Phase][Element][1]:=j;

              end
  else if c = ' ' then Pixel:=5-Pixel
  else if c = chr(27) then Continuer := FALSE
  else if (c = '+') and (Phase<NbrPhase) then
                    begin
                    Phase:=Phase+1;
                    Box(0,0,320,200,0);
                    end
  else if (c = '-') and (Phase>0) then
                    begin
                    Phase:=Phase-1;
                    Box(0,0,320,200,0);
                    end
  else if (ord(c)>Start) and (ord(c)<Start+NbrElement+2) then
          begin
            Element:=ord(c)-Start-1;
          end
  else if (c>='0') and (c<='9') then Vitesse[Phase]:=Ord(c)-48;

  end;
  TextMode(OrigMode);
  writeln('Save ? (Yes / No / Cancel)');
  c:=' ';
  while ((c<>'Y') and (c<>'N') and (c<>'C')) do
        c:=upcase(readkey);
  if c='Y' then SaveFile(s);

end.
