 include "tios.h"

 xdef _ti89
 xdef _main
 xdef _comment

shiftperrow equ 3
numperrow   equ 8
numpercol   equ 15

_main:
  lea blockarea,a0
  lea playarea(pc),a1
  move.l a0,(a1)

  ;Install interrupt
;  move.w #$0700,d0
;  trap #1
  move.l  ($64),oldint
;  bclr.b #2,$600001
  move.l  #int_handler,($040064)
;  bset.b #2,$600001
;  trap #1

  lea level(pc),a0
  clr.w (a0)+                   ;Level = 0
  move.w #1,(a0)                ;Speed = 1


m_showintro:
  ;Show the intro
  bsr intro_screen

  cmp.w #264,d0
  bne.b m_dontquitgame

m_quitgame:

  ;Uninstall interrupt
;  move.w #$0700,d0
;  trap #1
;  bclr.b #2,$600001
  move.l oldint(pc),($040064)
;  bset.b #2,$600001
;  trap #1
  rts

m_dontquitgame:

  ;Calc the falldowncounter and score

  lea speed(pc),a0
  move.w (a0)+,d0               ;Speed

  move.w d0,d1
  add.w #1,d1                   
  mulu.w #10,d1                 
  move.w d1,(a0)+               ;basescore = (speed+1)*10

  lea spdtable(pc),a1
  add.w d0,d0
  move.w 0(a1,d0.w),(a0)

  ;Draw screen
  bsr zap_screen

  bsr draw_pipes

  moveq #10,d0
  moveq #8,d1
  moveq #7,d2
  moveq #3,d3
  bsr draw_circ 

  moveq #4,d1
  moveq #3,d2
  moveq #2,d3
  bsr draw_circ 

  moveq #0,d1
  moveq #9,d2
  moveq #2,d3
  bsr draw_circ

  moveq #3,d1
  moveq #4,d3
  bsr draw_circ

  lea addscore(pc),a0
  clr.l (a0)+                    ;Clear addscore & score
  clr.w (a0)                     ;Clear exitdata

m_kbd_startlevel:
  move.w level(pc),d0
  add.w #1,d0
  asl.w #2,d0

  lea vir1frame(pc),a0
  clr.l (a0)+
  clr.l (a0)+
  clr.l (a0)+

  bsr init_level
  bsr random_block
  bsr random_block
  bsr repaint_screen
  bsr put_score
  bsr new_block

m_kbd_set:

  lea ignore_anim(pc),a0        
  clr.w (a0)+                   ;Turn on all animation
  move.b #255,(a0)                ;Prevent kbd interrupts

m_kbdagain:
  lea falldown_cnt(pc),a0
  tst.w (a0)
  bgt.b m_dontdown
    bsr movedown_block
m_dontdown:
  moveq #1,d2
  bsr do_delay
  bsr.b kbd_proc
  tst.w d0
  beq m_kbdagain

  lea ignore_anim(pc),a3
  not.b 1(a3)                   ;Turn off block anim

  sub #2,d0             ;Exitcode 2 = game won
  beq.b m_gamewon

m_gamelost:
  move.w #16,d0
  lea vir1frame(pc),a2
  move.w d0,(a2)+
  clr.w (a2)+
  move.w d0,(a2)+
  clr.w (a2)+
  move.w d0,(a2)+
  clr.w (a2)+

  lea sorrystr(pc),a2
  bsr.b show_msg

  not.b 2(a3)           ;Turn on keyb interrupt

  bsr check_add_highscore

  not.b (a3)            ;Turn off 3 virus animation
  bra m_showintro

m_gamewon:

  lea wonstr(pc),a2
  bsr.b show_msg
  not.b 2(a3)           ;Turn on keyb interrupt
  bsr idle_loop

  lea level(pc),a0
  add.w #1,(a0)

  not.b (a3)            ;Turn off 3 virus animation
  bra m_kbd_startlevel


show_msg:

  moveq #8,d0
  bsr blackgamescr
 
  moveq #1,d0
  bsr set_font

  moveq #10,d0
  moveq #60,d1
  moveq #0,d2
  move.l a2,a0
  bsr put_string

  bsr wait_until_key_release
  rts


kbd_proc:
  lea kbdsync(pc),a1
  lea keystatus(pc),a2

  bsr get_key_stat

  lea keystat(pc),a0

  clr.w d0
  clr.w d1

  btst.b #0,(a0)
  beq.b kbd_turnpiece
  btst.b #4,(a0)
  beq.b kbd_turnpiece
  btst.b #5,(a0)
  beq.b kbd_turnpiece_otherway
  and.b #%11111011,(a2)
  btst.b #1,(a0)
  beq.b kbd_left
  btst.b #3,(a0)
  beq.b kbd_right
  btst.b #6,(a0)      ;Diamond
  beq.b kbd_muchdown
  btst.b #0,5(a0)
  beq.b kbd_pause       ;Pause
  btst.b #6,5(a0)     ;Home = APD
  beq.b kbd_apd
  btst.b #2,(a0)
  beq.b kbd_down

  btst.b #0,6(a0)
  beq.b kbd_exitkey     ;ESC

  clr.w (a2)

kbd_nokey:
  lea exitdata(pc),a0
  move.w (a0),d0
  clr.w (a0)
kbd_exitproc:
  rts


kbd_apd:
  trap #4
  bra kbd_nokey

kbd_exitkey:
  add #3,d0
  bra kbd_exitproc

kbd_turnpiece_otherway:
  not.w d0
kbd_turnpiece:
  btst.b #2,(a2)
  bne.b kbd_ignoreturnpiece
  or.b #4,(a2)

  bsr turn_block

kbd_ignoreturnpiece:
  btst.b #1,(a0)
  beq.b kbd_left
  btst.b #3,(a0)
  beq.b kbd_right

  bra kbd_nokey

kbd_left:
  sub #2,d0
kbd_right:
  add #1,d0

  cmp.w #50,(a1)
  bcs kbd_nokey
  clr.w (a1)

  bsr move_block
  bra kbd_nokey

kbd_muchdown:
  btst.b #1,(a2)
  bne kbd_nokey

kbd_muchdown_again:
  bsr movedown_block
  tst.w d7
  bne kbd_muchdown_again

  bra kbd_nokey

kbd_down:
  btst.b #1,(a2)
  bne kbd_nokey

  cmp.w #20,(a1)
  bcs kbd_nokey
  clr.w (a1)

  bsr movedown_block
  bra kbd_nokey

kbd_pause:
  bsr.b wait_until_key_release
  lea ignore_anim(pc),a3
  not.l (a3)                    ;Turn off animations, Turn on keyb interrupt

  moveq #0,d0
  bsr.b blackgamescr

  moveq #20,d0
  moveq #40,d1
  moveq #0,d2
  lea pausetext(pc),a0
  bsr put_string

  bsr idle_loop
  bsr repaint_screen
  bsr.b wait_until_key_release

  not.l (a3)                    ;Turn on animations, Turn off keyb interrupt

  bra kbd_nokey


;*******
; Delays until all keys are released
;*******
wait_until_key_release:

wukr_again:
  bsr get_key_stat

  lea keystat(pc),a6
  clr.l d6
  not.l d6

  cmp.l (a6)+,d6
  bne wukr_again
  cmp.l (a6)+,d6
  bne wukr_again

  rts


;******
; Makes the gamearea black from d0.w - 15
;******

blackgamescr:
  move.l #LCD_MEM+1,a6
  move.w d0,d6
  mulu.w #30*6,d6
  add.w d6,a6

  not.w d0
  move.w d0,d6
  add.w d0,d0
  add.w d6,d0
  add.w d0,d0
  add.w #16*6-1,d0

  clr.l d6
  not.l d6

bgs_again:
  move.b d6,(a6)+
  move.l d6,(a6)+
  move.w d6,(a6)+
  move.b d6,(a6)+
  add.w #30-8,a6
  dbra d0,bgs_again

  rts


;*********
; Delay
;*********
; d2.w - amount
;*********
do_delay:
  lea sync(pc),a6

  clr.w (a6)

dd_again:
  cmp.w (a6),d2
  bcc dd_again

  rts

;********
; Move down the block
;********
movedown_block:
  lea falldown_cnt(pc),a0
  move.w basefalldowntimer(pc),(a0)

  clr.l d0
  moveq #1,d1
  bsr move_block
  tst.w d7
  bne.b mdb_exit

  bsr fixblock

  lea addscore(pc),a1
  move.w basescore(pc),(a1)

mdb_findpairs:
  bsr find_pairs
  tst.w d7
  beq.b mdb_exitloops
mdb_foundpairs:
  bsr put_score

  bsr repaint_screen

  moveq #80,d2
  bsr do_delay

  bsr remove_pair_img
  bsr repaint_screen
mdb_falldown:
  bsr fall_down
  tst.w d7
  beq mdb_findpairs
  bsr.b repaint_screen

  moveq #60,d2
  bsr do_delay

  bra mdb_falldown
mdb_exitloops:
  bsr.b new_block
  clr.w d7

mdb_exit:
  rts

new_block:
  move.w basefalldowntimer(pc),d0
  lea falldown_cnt(pc),a0
  move.w d0,(a0)
  add.w d0,(a0)

  lea keystatus(pc),a0
  or.b #2,(a0)

  lea curx(pc),a0

  moveq #3,d0
  move.w d0,(a0)+               ;CurX = 3
  clr.l (a0)+                   ;CurY=0 Vert=0

  clr.w d1
  clr.w d2
  bsr block_fits
  tst.w d7
  bne.b nb_gamenotover
  lea exitdata(pc),a6
  or.w #3,(a6)

nb_gamenotover:

  bsr random_block
  bsr.b register_move_block
  bsr.b repaint_screen
  bsr draw_next_image

  rts


;********
; Move block d0.w steps to the right, and d1.w steps down
; Returns status in d7  (0=err, 1=ok)
;********
move_block:
  movem.l d0-d2/a0,-(a7)
  lea curx(pc),a0
  add.w (a0)+,d0        ;Load X coord
  add.w (a0)+,d1        ;Load Y coord
  move.w (a0),d2        ;Load vert/horiz

  bsr block_fits        ;Does the block fit here?
  tst.w d7
  beq.b mb_err            ;No, err
  bsr.b unregister_move_block
  move.w d1,-(a0)
  move.w d0,-(a0)
  bsr.b register_move_block

  bsr.b repaint_screen
  moveq.w #1,d7
  bra.b mb_exit
mb_err:
  clr.w d7
mb_exit:
  movem.l (a7)+,d0-d2/a0
  rts


;********
; Repaints the whole screen with blocks, destroys d0,d1
;********

repaint_screen:
  moveq #14,d1
m_again1:
  moveq #7,d0
m_again2:

  bsr draw_item

  dbra d0,m_again2
  dbra d1,m_again1

  rts


;********
; Registers a moving block
;********
register_move_block:
  movem.l d0-d1/a0-a1,-(a7)

  lea curx(pc),a1
  move.w (a1)+,d0
  move.w (a1)+,d1

  asl.w #shiftperrow,d1
  add.w d0,d1
  move.l playarea(pc),a0
  add.w d1,a0

  tst.w (a1)+
  beq.b rmb_horiz

rmb_vert:
  move.b (a1)+,(a0)
  add.b #128+8,(a0)+
  add #numperrow-1,a0
  move.b (a1)+,(a0)
  add.b #128+16,(a0)
  bra.b rmb_end

rmb_horiz:
  move.b (a1)+,(a0)
  add.b #128+4,(a0)+
  move.b (a1)+,(a0)
  add.b #128+12,(a0)

rmb_end:
  movem.l (a7)+,d0-d1/a0-a1
  rts

;********
; Unregisters a moving block
;********
unregister_move_block:
  movem.l d0-d1/a0-a1,-(a7)

  lea curx(pc),a1
  move.w (a1)+,d0
  move.w (a1)+,d1
  asl.w #shiftperrow,d1
  add.w d0,d1
  move.l playarea(pc),a0
  
  add.w d1,a0

  clr.b (a0)+           ;Clear item
  tst.w (a1)            ;Is a horiz or vert?
  beq.b umb_horiz
  add #7,a0
umb_horiz:
  clr.b (a0)

umb_end:
  movem.l (a7)+,d0-d1/a0-a1
  rts

;********
; Fixblock
;********
fixblock:
  movem.l d0-d1/a0-a1,-(a7)

  lea curx(pc),a1
  move.w (a1)+,d0
  move.w (a1)+,d1
  asl.w #shiftperrow,d1
  add.w d0,d1
  move.l playarea(pc),a0
  add.w d1,a0

  and.b #%01111111,(a0)+
  tst.w (a1)
  beq.b fb_horiz
  add #7,a0
fb_horiz
  and.b #%01111111,(a0)+

fb_end:
  movem.l (a7)+,d0-d1/a0-a1
  rts

;********
; Check if the blocks fits at d0.w,d1.w with a vert/horiz as d2.w
; Returns in d7
;********
block_fits:
  clr.w d7

  tst.w d0              ;Check bounds
  blt.b bf_err
  tst.w d1
  blt.b bf_err

  move.l playarea(pc),a6       ;Make sure the holes are empty
  move.w d1,d6
  asl.w #shiftperrow,d6
  add.w d0,d6
  add.w d6,a6
  tst.b (a6)
  bgt.b bf_err

  tst.w d2
  beq.b bf_horiz

bf_vert:
  cmp.w #8,d0
  bge.b bf_err
  cmp.w #14,d1
  bge.b bf_err

  tst.b numperrow(a6)
  bgt.b bf_err
  bra.b bf_ok

bf_horiz:
  cmp.w #7,d0
  bge.b bf_err
  cmp.w #15,d1
  bge.b bf_err
  tst.b 1(a6)
  bgt.b bf_err
bf_ok:
  add #1,d7
bf_err:
  rts


;********
; Sets col1, col2, nextcol1, nextcol2
;********

random_block:
  lea col1(pc),a0

  move.w 2(a0),(a0)

  add #2,a0

  moveq #3,d0
  bsr.b random
  add.w #1,d0
  move.b d0,(a0)+

  moveq #3,d0
  bsr.b random
  add.w #1,d0
  move.b d0,(a0)+

  rts


;*******
; Generate a random value between 0 and d0.w-1, place it in d0.w
;*******
random:
  lea rand_seed(pc),a6
  move.w  (a6),d6
  mulu.w  #31471,d6
  add.w   #6927,d6
  mulu.w  d6,d0
  move.w  d6,(a6)
  clr.w   d0
  swap    d0
  rts


drVirusStart equ 21

;********
; Inits a new game, places d0.w viruses
;********
init_level:
  move.w d0,d5

  lea vir1num(pc),a2
  clr.l (a2)
  clr.w 4(a2)

  moveq #3,d0
  bsr random
  move.w d0,d1

  move.l playarea(pc),a0

  moveq.w #15*8/4-1,d0
il_clear:
  clr.l (a0)+
  dbra.w d0,il_clear

  moveq.w #100,d4
  asl.w #3,d4

il_next:
  sub #1,d4            ;Num check counter
  blt.b il_novirus
  tst.w d5             ;Num placed viruses counter
  ble.b il_novirus

il_virus:
  moveq #48,d0
  bsr random
  move.w d0,d2
  moveq #48,d0
  bsr random
  add.w d2,d0          ;Where to place virus

  add.w #8*3+1,d0        ;Add for start position

  add.w #drVirusStart,d1        ;Virus color
  bsr.b allow_virus_place
  sub.w #drVirusStart,d1
  tst.w d7             ;Result
  beq il_next

  move.w d1,d0
  add.w d0,d0
  add.w #1,0(a2,d0.w)

  sub.w #1,d1
  bge.b il_noreset
    moveq.w #2,d1
il_noreset:

  sub.w #1,d5
  bra il_next

il_novirus:
  rts

;*********
; Checks if a virus is allowed to be placed here, and places it
;*********
; d0.w - I
; d1.w - VirusValue
;*********

allow_virus_place:
  clr.w d7

  move.l playarea(pc),a0

  add.w d0,a0
  move.l a0,a1

  move.w d0,d2

  tst.b (a1)
  bne.b avp_invalid

  move.b d1,(a1)

avp_loop1_start:
  tst.w d0
  ble.b avp_loop1_end
  cmp.b -1(a1),d1
  bne.b avp_loop1_end
  sub.w #1,d0
  sub.w #1,a1
  bra avp_loop1_start
avp_loop1_end:

  moveq #2,d3
avp_loop2_start
  cmp.w #15*8,d0
  bge.b avp_loop2_end
  cmp.b (a1),d1
  bne.b avp_loop2_end
  add.w #1,d0
  add.w #1,a1
  dbra d3,avp_loop2_start
  bra.b avp_exit_false
avp_loop2_end:

  move.l a0,a1

avp_loop3_start:
  tst.w d2
  ble.b avp_loop3_end
  cmp.b -8(a1),d1
  bne.b avp_loop3_end
  sub.w #8,d2
  sub.w #8,a1
  bra avp_loop3_start
avp_loop3_end:

  moveq #2,d3
avp_loop4_start
  cmp.w #15*8,d2
  bge.b avp_loop4_end
  cmp.b (a1),d1
  bne.b avp_loop4_end
  add.w #8,d2
  add.w #8,a1
  dbra d3,avp_loop4_start
;  bra avp_exit_false

avp_exit_false:
  clr.b (a0)
avp_invalid:
  sub.w #1,d7

avp_loop4_end:

  add.w #1,d7

  rts



;********
; Turn block
;********
turn_block:
  movem.l a0/d0-d3/d7,-(a7)

  move.w d0,d3

  lea curx(pc),a0

  move.w (a0)+,d0       ;X
  move.w (a0)+,d1	;Y
  move.w (a0),d2        ;Vert

  add #1,d1
  tst.w d2
  bne.b tb_vert
  sub #2,d1
tb_vert:

  not.w d2
  bsr block_fits
  tst.w d7
  bne.b tb_ok

  sub #1,d0
  bsr block_fits
  tst.w d7
  bne.b tb_ok

  add #1,d0
  add #1,d1
  bsr block_fits
  tst.w d7
  beq.b tb_err
tb_ok:

  bsr unregister_move_block
  move.w d2,(a0)        ;global vert=vert
  move.w d1,-(a0)       ;cury=y
  move.w d0,-(a0)       ;curx=x

  eor.w d2,d3
  bne.b tb_dontswap

tb_swap:
  add #6,a0
  move.b (a0),d0
  move.b 1(a0),(a0)
  move.b d0,1(a0)

tb_dontswap:
  bsr register_move_block
  bsr repaint_screen

tb_err:
  movem.l (a7)+,a0/d0-d3/d7
  rts


minpair equ 4

;********
; Find pairs, d7.w > 0 if pairs were found
;********

find_pairs:
  movem.l a0-a2/d0-d4,-(a7)

  clr.w d7

  ;Find horiz pairs first
  move.l playarea(pc),a2

  moveq.w #15-1,d3
fp_h_nextrow:
  move.l a2,a0
  clr.w d2
fp_h_nextcol:
  move.b (a0),d0
  and.b #3,d0
  beq.b fp_h_next

  move.w d2,d4
  lea 1(a0),a1

fp_h_finddups:
  cmp.w #numperrow-1,d4
  bge.b fp_h_fd_end
  move.b (a1),d1
  and.b #3,d1
  cmp.b d0,d1
  bne.b fp_h_fd_end
  add #1,d4
  add #1,a1
  bra fp_h_finddups
fp_h_fd_end:

  sub.w d2,d4
  cmp.w #minpair-1,d4
  blt.b fp_h_next

fp_h_doit:
  add.w #1,d7
fp_h_removenext:
  bsr.b remove_block
  add #1,a0
  add #1,d2
  sub #1,d4
  bge fp_h_removenext

fp_h_next:
  add #1,d2
  add #1,a0

  cmp.w #numperrow-(minpair-1),d2
  blt fp_h_nextcol
  add #numperrow,a2

  dbra d3,fp_h_nextrow

  ;Find vert pairs
  move.l playarea(pc),a2

  move.w #numperrow-1,d2
fp_v_nextcol:
  move.l a2,a0
  clr.w d3
fp_v_nextrow:
  move.b (a0),d0
  and.b #3,d0
  beq.b fp_v_next

  move.w d3,d4
  lea 8(a0),a1

fp_v_finddups:
  cmp.w #numpercol-1,d4
  bge.b fp_v_fd_end
  move.b (a1),d1
;  cmp.b #drVirusEnd,d1
;  bgt fp_v_fd_end
  and.b #3,d1
  cmp.b d0,d1
  bne.b fp_v_fd_end
  add #1,d4
  add #8,a1
  bra fp_v_finddups
fp_v_fd_end:

  sub.w d3,d4
  cmp.w #minpair-1,d4
  blt.b fp_v_next

fp_v_doit:
  add.w #1,d7
fp_v_removenext:
  bsr.b remove_block
  add #8,a0
  add #1,d3
  sub #1,d4
  bge fp_v_removenext

fp_v_next:
  add #8,a0
  add #1,d3

  cmp.w #numpercol-(minpair-1),d3
  blt fp_v_nextrow
  add #1,a2

  dbra d2,fp_v_nextcol

  movem.l (a7)+,a0-a2/d0-d4
  rts

drBlockRemoveImg equ 28
drVirusRemoveImg equ 32
;********
; Perform things in order to remove block ptd to by a0
; It draws a removing image instead
;********
remove_block:
  clr.w d6

  move.b (a0),d6
  asr.b #2,d6
  beq.b rb_ignore
  cmp.b #4,d6
  bgt.b rb_ignore

  lea removeblockdata-1(pc),a6
  move.b 0(a6,d6.w),d6
  ext.w d6
  and.b #3,0(a0,d6.w)

rb_ignore:

  cmp.b #drVirusStart,(a0)
  blt.b rb_isblock
  cmp.b #drVirusEnd,(a0)
  ble.b rb_isvirus

rb_isblock:
  and.b #3,(a0)
  add.b #drBlockRemoveImg,(a0)
;  clr.b (a0)
  rts

rb_isvirus:
  move.b (a0),d6
  and.w #3,d6

  add.w d6,d6
  lea vir1num-2(pc),a6
  sub.w #1,0(a6,d6.w)

  add.w d6,d6
  lea vir1frame-4(pc),a6
  add.w d6,a6
  move.w #8,(a6)+
  move.w #16,(a6)+
  and.b #3,(a0)
  add.b #drVirusRemoveImg,(a0)

  ;Add to score
  lea addscore(pc),a6
  lsl.w (a6)
  move.w (a6)+,d6
  add.w d6,(a6)

;  clr.b (a0)
  rts



;********
;Remove Pair Images, drawn by find_pairs
;********
remove_pair_img:
  move.l d0,-(a7)

  move.l playarea(pc),a6
  moveq #15*8-1,d6

rpi_again:
  clr.w d0
  move.b (a6),d0

  cmp.w #drBlockRemoveImg,d0
  blt.b rpi_dontremove
  cmp.w #drBlockRemoveImg+8,d0
  bge.b rpi_dontremove

  clr.b (a6)
rpi_dontremove:
  add.w #1,a6
  dbra d6,rpi_again

  move.l (a7)+,d0
  rts


drBlockStart equ 1
drBlockEnd   equ 19

;********
; falldown, moves down any possible blocks one step, returns num in d7.w
;********
fall_down:
  movem.l d0/d2-d3/a0,-(a7)

  clr.w d7

  move.l playarea(pc),a0
  add.w #numperrow*(numpercol-1)-1,a0

  moveq #numpercol-2,d3                 ;The last row can't be moved down

fd_nextrow:
  moveq #7,d2
fd_nextcol:
  move.b (a0),d0

  cmp.b #drBlockStart,d0
  blt.b fd_next
  cmp.b #drBlockEnd,d0
  bgt.b fd_next
  tst.b numperrow(a0)
  bne.b fd_next

  asr.b #2,d0
  cmp.b #3,d0
  bne.b fd_notright

fd_right:
  tst.b numperrow-1(a0)
  bne.b fd_next
  move.b (a0),numperrow(a0)
  clr.b (a0)
  sub #1,d2
  sub #1,a0
  bra.b fd_movedown

fd_notright:
  cmp.b #1,d0
  beq.b fd_next

fd_movedown:
  move.b (a0),numperrow(a0)
  clr.b (a0)
  add.w #1,d7

fd_next:
  sub #1,a0
  sub #1,d2
  bge fd_nextcol

  dbra d3,fd_nextrow

  movem.l (a7)+,d0/d2-d3/a0
  rts

;*********
; Draw item at (d0.w, d1.w)
;*********
draw_item:
  movem.l d0-d3/a0-a1,-(a7)

  move.w d1,d2
  asl.w #shiftperrow,d2
  add.w d0,d2
  move.l playarea(pc),a0
  clr.w d3
  move.b 0(a0,d2.w),d3
  and.b #127,d3
  lea imgreloc(pc),a0
  move.b 0(a0,d3.w),d3

  lea SpriteStart(pc),a0
  move.w d3,d2
  add.w d2,d2
  add.w d3,d2
  add.w d2,d2

  add.w d2,a0
  add.w #1,d0
  bsr put_sprite_8x6

  movem.l (a7)+,d0-d3/a0-a1
  rts


virleft equ 11
virtop equ 9


;*********
; Animate the three viruses to the bottom
;*********
anim_virus:
  movem.l a0-a4/d0-d3,-(a7)

  lea vir1frame(pc),a2
  lea 12(a2),a3    ;Vir1Fdata
  lea VirusImages(pc),a4

  moveq #virleft,d0

  moveq #2,d3
av_again:
  move.w (a2),d2
  move.w d2,d1
  add.w #1,d1
  and.b #%00000111,d1
  and.b #%11111000,d2
  add.w d1,d2
  move.w d2,(a2)+

  tst.w (a2)
  beq.b av_ignoreanimchange
  sub.w #1,(a2)
  bne.b av_ignoreanimchange
av_animchange:
  clr.w d2

  lea vir1num+4(pc),a0
  sub.w d3,a0
  sub.w d3,a0
  tst.w (a0)
  bne.b av_noempty
   move.w #24,d2
av_noempty:
  move.w d2,-2(a2)
av_ignoreanimchange:
  add #2,a2

  move.b 0(a3,d2.w),d2           ;Lookup offset to sprite in the virfdata table

  lea Empty16x16Img(pc),a0
  cmp.w #255,d2
  beq.b av_ignoreit
    lea 0(a4,d2.w),a0
av_ignoreit:

  moveq #virtop,d1
  bsr put_sprite_8x8

  add.w #1,d0
  bsr put_sprite_8x8

  add.w #1,d1
  sub.w #1,d0
  bsr put_sprite_8x8

  add.w #1,d0
  bsr put_sprite_8x8

  add.w #1,d0
  add.w #8*4*6,a4

  dbra d3,av_again

  movem.l (a7)+,a0-a4/d0-d3
  rts

;********
; Draw next image
;********
draw_next_image:
  clr.w d0

  lea nextcol1(pc),a2
  move.b (a2)+,d0
  move.w d0,d1

  add.w d0,d0
  add.w d1,d0
  add.w d0,d0

  lea LWBlock-6(pc),a0
  add.w d0,a0

  moveq #16,d0
  moveq #52,d1
  bsr put_sprite_8x6r

  move.b (a2),d0
  move.w d0,d1
  add.w d0,d0
  add.w d1,d0
  add.w d0,d0

  lea RWBlock-6(pc),a0
  add.w d0,a0

  moveq #17,d0
  moveq #52,d1

  bsr put_sprite_8x6r

  rts


;drVirusStart equ 21
drVirusEnd   equ 27

curvirusanim dc.w 0

;********
; Animates the viruses in the blocks
;********
anim_blockvirus:
  movem.l d0-d4/a0,-(a7)

  moveq #drVirusStart-1,d3
  lea curvirusanim(pc),a0
  not.w (a0)
  bne.b abv_noaddanim
    add.w #4,d3
abv_noaddanim:

  move.l playarea(pc),a0
  moveq #15*8-1,d2

  clr.w d4

abv_again:
  move.b (a0),d0
  cmp.b #drVirusStart,d0
  blt.b abv_next
  cmp.b #drVirusEnd,d0
  bgt.b abv_next
abv_processvirus:
  and.b #3,d0
  add.b d3,d0
  move.b d0,(a0)

  move.w d4,d0
  and.w #7,d0
  move.w d4,d1
  asr.w #3,d1
  bsr draw_item

abv_next:
  add.w #1,d4
  add.w #1,a0
  dbra d2,abv_again

  movem.l (a7)+,d0-d4/a0
  rts



;*********
; Draw the pipes around the game area
;*********

draw_pipes:

  moveq #15-1,d2
dp_leftright_again:
  clr.w d0
  lea LVPipeBlock(pc),a0
  move.w d2,d1
  bsr put_sprite_8x6
  moveq.w #numperrow+1,d0
  lea RVPipeBlock(pc),a0
  move.w d2,d1
  bsr put_sprite_8x6
  dbra d2,dp_leftright_again

  moveq #numperrow-1,d2
dp_bottom_again:
  move.w d2,d0
  add.w #1,d0
  lea HPipeBlock(pc),a0
  moveq.w #numpercol,d1
  bsr put_sprite_8x6

  dbra d2,dp_bottom_again

  clr.w d0
  moveq.w #numpercol,d1
  lea TRPipeBlock(pc),a0
  bsr put_sprite_8x6

  moveq.w #numpercol,d1
  moveq.w #numperrow+1,d0
  lea LTPipeBlock(pc),a0
  bsr put_sprite_8x6

  moveq.w #11,d1
dp_chess_row:
  moveq.w #9,d2
dp_chess_col:
  move.w d2,d0
  add.w #10,d0
  lea ChessPattern(pc),a0
  bsr put_sprite_8x8

  dbra.w d2,dp_chess_col
  dbra.w d1,dp_chess_row

  rts

;**********
; Draw a circular area
;*****
; d0.w - Left
; d1.w - Top
; d2.w - W
; d3.w - H
;**********

draw_circ:
 movem.l d0-d5/a0-a1,-(a7) 
 ;Draw the corners
 lea TLCircular(pc),a0
 bsr put_sprite_8x8
 add.w d2,d0
 bsr put_sprite_8x8
 add.w d3,d1
 bsr put_sprite_8x8
 sub.w d2,d0
 bsr put_sprite_8x8
 sub.w d3,d1       

 ;Draw the vertical lines
 move.w d3,d4
 move.w d1,d5

 sub.w #2,d4
 blt.b dc_ignorev
dc_nextv:
 lea LVCircular(pc),a0
 add.w #1,d1
 bsr put_sprite_8x8
 add.w d2,d0
 bsr put_sprite_8x8
 sub.w d2,d0
 dbra.w d4,dc_nextv
dc_ignorev:
 move.w d5,d1

 sub.w #2,d2
 blt.b dc_ignorehandfill

 ;Draw the horizontal lines
 move.w d2,d4
 move.w d0,d5

dc_nexth:
 lea THCircular(pc),a0
 add.w #1,d0
 bsr put_sprite_8x8

 add.w d3,d1
 bsr put_sprite_8x8
 sub.w d3,d1

 dbra.w d4,dc_nexth
dc_ignoreh:

 sub.w #2,d3
 blt.b dc_ignorefill

 ;Fill the inner
dc_fillinner_row:
  add.w #1,d1
  move.w d5,d0
  move.w d2,d4
dc_fillinner_col:
  add #1,d0
  lea MiddleCircular(pc),a0
  bsr put_sprite_8x8

  dbra.w d4,dc_fillinner_col
  dbra.w d3,dc_fillinner_row
dc_ignorefill:
dc_ignorehandfill:
 movem.l (a7)+,d0-d5/a0-a1
 rts

;*********
; Put current score
;*********
put_score:
  movem.l d0-d3/a0-a1,-(a7)

  moveq #1,d0
  bsr set_font

  moveq #87,d0
  moveq #9,d1
  moveq #4,d2

  lea scorestr(pc),a0
  bsr put_string

  moveq #122,d0
  move.w score(pc),d3
  bsr put_int

  lea levelstr(pc),a0
  moveq #87,d0
  moveq #32,d1
  bsr put_string

  moveq #127,d0
  move.w level(pc),d3
  add.w #1,d3
  bsr put_int


  lea virusstr(pc),a0
  moveq #87,d0
  moveq #41,d1
  bsr put_string

  lea vir1num(pc),a0
  move.w (a0)+,d3
  add.w (a0)+,d3
  add.w (a0)+,d3
  bne.b ps_gamenotover

  lea exitdata(pc),a0
  or.w #2,(a0)

ps_gamenotover:

  moveq #127,d0
  bsr put_int

  lea nextstr(pc),a0
  moveq #87,d0
  moveq #50,d1
  bsr put_string

  movem.l (a7)+,d0-d3/a0-a1

  rts


;**********
; Draw a sprite at (X,Y)
;**********
; d0.w - X
; d1.w - Y
; a0 - Ptr to sprite, ptr to next sprite at the end
; a1 - Destroyed
;**********

put_sprite_8x8:
  move.w d1,d6
  mulu.w #30*8,d6
  add.w d0,d6
  move.l #LCD_MEM,a1
  add.w d6,a1
  moveq.w #3,d6
ps8x8_loop:
  move.b (a0)+,(a1)
  add #30,a1
  move.b (a0)+,(a1)
  add #30,a1
  dbra.w d6,ps8x8_loop
ps8x8_err:
  rts




;*********
; Clear screen
;*********

zap_screen:

  lea LCD_MEM,a6
  move.l #3840/4-1,d6

zs_next:
  clr.l (a6)+
  dbra d6,zs_next

  rts


;********
; Wait for a keypress
;********

idle_loop:
  movem.l a0-a6/d1-d7,-(a7)

il_wait_start:
  move.l #650000,d7
il_wait:
  sub.l #1,d7
  blt.b il_apd

  moveq #100,d0
il_delay:
   dbra d0,il_delay

  lea tios::kb_globals+$1c,a0
  tst.w (a0)
  beq il_wait
  move.w tios::kb_globals+$1E,d0
  clr.w (a0)

  cmp.w #KEY_DIAMOND+$10B,d0
  beq.b il_apd

  movem.l (a7)+,a0-a6/d1-d7
  rts

il_apd:
  trap #4
  bra il_wait_start

;*********
;Set Font to d0.w
;*********
set_font:
  movem.l d0-d2,-(a7)
  move.w d0,-(a7)
  jsr tios::FontSetSys
  add #2,a7
  movem.l (a7)+,d0-d2
  rts


;********
; Put int d3 at (d0.w,d1.w) with style d2
;********

put_int:
  movem.l d0-d2,-(a7)
  move.w d3,-(a7)
  pea toint(pc)
  pea buf(pc)
  jsr tios::sprintf
  add #10,a7
  movem.l (a7)+,d0-d2
put_buf:
  lea buf(pc),a0
;  bra put string               ;Removed as it jumps to below


;*********
; Put string a0 at (d0.w,d1.w) with style d2    
;*********
put_string:
  movem.l d0-d2/a0,-(a7)
  move.w d2,-(a7)
  move.l a0,-(a7)
  move.w d1,-(a7)
  move.w d0,-(a7)
  jsr tios::DrawStrXY
  add #10,a7
  movem.l (a7)+,d0-d2/a0
  rts

;*********
; Show the intro screen
;*********
intro_screen:
  bsr zap_screen

  moveq #2,d0
  bsr set_font

  moveq #20,d0
  moveq #2,d1
  moveq #4,d2
  lea txt_title(pc),a0
  bsr.b put_string

  moveq #1,d0
  bsr set_font

  moveq #48,d0
  moveq #15,d1
  lea txt_name(pc),a0
  bsr put_string

  moveq #32,d0
  moveq #25,d1
  lea txt_email(pc),a0
  bsr put_string

  
  moveq #20,d0
  moveq #54,d1
  lea highscorecaption(pc),a0
  bsr put_string


  ;Draw the highscores
  lea hsname1(pc),a2
  moveq #4-1,d4
  moveq #4,d2
  moveq #64,d1

is_next_highscore:
  moveq #30,d0
  move.l a2,a0
  bsr put_string

  add.w #4,a2

  moveq #90,d0
  move.w (a2)+,d3
  bsr put_int

  add #8,d1

  dbra d4,is_next_highscore

  lea level(pc),a2
  lea speed(pc),a3
is_putlevel:

  moveq #4,d2
  moveq #20,d0
  moveq #36,d1
  lea levelmsg(pc),a0
  bsr put_string

  moveq #44,d1
  lea speedmsg(pc),a0
  bsr put_string

  clr.w d2
  moveq #66,d0
  moveq #36,d1
  move.w (a2),d3
  add.w #1,d3
  bsr put_int

  move.w (a3),d1
  asl.w #2,d1
  lea spd1(pc),a0
  add.w d1,a0
  moveq #60,d0
  moveq #44,d1
  bsr put_string

is_idle:
  bsr idle_loop

  cmp.w #338,d0                 ;Left
  beq.b PrevLevel
  cmp.w #344,d0                 ;Right
  beq.b NextLevel
  cmp.w #337,d0                 ;Up
  beq.b NextSpeed
  cmp.w #340,d0                 ;Down
  beq.b PreviousSpeed
  cmp.w #13,d0
  beq.b is_ok
  cmp.w #264,d0
  bne.b is_idle
is_ok:

  lea rand_seed(pc),a0
  tst.w (a0)
  bne.b is_end
    move.w sync(pc),(a0)
is_end:
  rts

PrevLevel:
  sub.w #1,(a2)
  bge is_putlevel

  move.w #19,(a2)
  bra is_putlevel

NextLevel:
  add.w #1,(a2)
  cmp.w #19,(a2)
  ble is_putlevel
  clr.w (a2)
  bra is_putlevel

PreviousSpeed:
  sub.w #1,(a3)
  bge is_putlevel
  move.w #2,(a3)
  bra is_putlevel

NextSpeed:
  add.w #1,(a3)
  cmp.w #2,(a3)
  ble is_putlevel
  clr.w (a3)
  bra is_putlevel

get_key_stat:
  movem.l d0-d1,-(a7)
  lea keystat(pc),a6
  move.w #$FFFE,d0
  moveq #6,d1
gk_next:
  move.w  d0,$600018

  moveq #10,d6
gk_small_delay:
  dbra.w d6,gk_small_delay

  rol.w  #1,d0
  move.b  $60001B,(a6)+
  dbra d1,gk_next
  movem.l (a7)+,d0-d1
  rts


;**********
; Put a 8x6 sprite on screen
;**********
; d0.w - X
; d1.w - Y
; a0 - Ptr to sprite
; a1 - Destroyed
;**********


put_sprite_8x6r:
  mulu.w #30,d1
  bra.b ps86_cont
put_sprite_8x6:
  mulu.w #30*6,d1
ps86_cont:
  add.w d0,d1
  move.l #LCD_MEM,a1
  add.w d1,a1
  moveq.l #5,d1
ps_loop:
  move.b (a0)+,(a1)
  add #30,a1
  dbra.l d1,ps_loop
ps_err:
  rts


;*******
; Interrupt handler
;*******

int_handler:
  movem.l d0-d7/a0-a6,-(a7)

  lea anim_cnt(pc),a6
  sub.w #1,(a6)
  bge.b ih_noviranim
    move.w #48,(a6)
    tst.b 4(a6)
    bne.b ih_noviranim
    bsr anim_virus
ih_noviranim:

  lea vanim_cnt(pc),a6
  sub.w #1,(a6)
  bge.b ih_nobviranim
    move.w #96,(a6)
    tst.b 3(a6)
    bne.b ih_nobviranim
    bsr anim_blockvirus
ih_nobviranim:

  lea sync(pc),a6
  add.w #1,(a6)+
  sub.w #1,(a6)+
  add.w #1,(a6)

  movem.l (a7)+,d0-d7/a0-a6

  tst.b intflag
  bne.b int_end
  move.l oldint(pc),-(a7)
  rts
int_end:
  rte


 even

;*********
; Check if to add highscore
;*********

check_add_highscore:
  lea hsname1+4(pc),a6
  move.w score(pc),d4

  moveq #4-1,d3         ;Number of highscores in table
cah_checknext:
  cmp.w (a6),d4
  bgt.b cah_foundscore
  add.w #6,a6
  dbra.w d3,cah_checknext
  bra.b cah_nohiscore

cah_foundscore:

  lea entername(pc),a0
  moveq #10,d0
  moveq #70,d1
  moveq #0,d2
  bsr put_string

  lea buf(pc),a0
  bsr.b input_name
  tst.w d7
  bne.b cah_nohiscore

  lea hsname1+(4-1)*6,a6

  sub #1,d3
  blt.b cah_dontmovedown

cah_movedown:
  move.l -6(a6),(a6)
  move.w -2(a6),4(a6)
  sub #6,a6
  dbra.w d3,cah_movedown

cah_dontmovedown:
  move.l (a0),(a6)+
  move.w d4,(a6)
  bra.b ca_exit

cah_nohiscore:
  moveq #120,d2
  bsr do_delay
  bsr idle_loop
ca_exit:
  rts


;**********
; Get a name for the highscore, max 3 chars + one zero
; The buffer is a0, which has to be aligned
;**********
input_name:
  movem.l d0-d2,-(a7)
  move.l #$20202000,(a0)
  clr.w d7      ;Ptr in str

in_loop:
  moveq #50,d0
  moveq #70,d1
  moveq #4,d2
  bsr put_string

  bsr idle_loop
  cmp.w #13,d0
  beq.b in_finished
  cmp.w #257,d0
  beq.b in_backspace
  cmp.w #264,d0
  beq.b in_esc
  cmp.w #32,d0
  bcs.b in_loop
  cmp.w #256,d0
  bcc.b in_loop

  cmp.w #3,d7
  bge.b in_loop
  move.b d0,0(a0,d7.w)
  add #1,d7
  bra.b in_loop

in_backspace:
  tst.w d7
  beq.b in_loop
  sub.w #1,d7
  move.b #32,0(a0,d7.w)
  bra.b in_loop

in_esc:
  moveq #1,d7
  bra.b in_quit

in_finished:
  tst.w d7
  beq in_loop
  clr.w d7

in_quit:
  movem.l (a7)+,d0-d2
  rts

anim_cnt dc.w 0
vanim_cnt dc.w 0

ignore_anim dc.b 255            ;No anims at start
ignore_vanim dc.b 255           ;No anims at start
intflag dc.b 0
        dc.b 0
oldint dc.l 0
sync dc.w 0
falldown_cnt dc.w 0
kbdsync dc.w 0

 even

keystat dc.b 255,255,255,255,255,255,255,255

toint dc.b        "%d",0

scorestr  dc.b    "Score:     ",0
levelstr  dc.b    "Level:     ",0
virusstr  dc.b    "Virus:     ",0
nextstr   dc.b    "Next:",0
levelmsg   dc.b   "Level:     (",17,18,")",0
speedmsg   dc.b   "Speed:     (",19,20,")",0
sorrystr   dc.b    "Game Over!",0
wonstr     dc.b    "Success!",0
txt_title  dc.b    "Dr Mario v1.0",0
txt_name   dc.b    "By Ludde",0
txt_email  dc.b    "luddes@usa.net",0
highscorecaption dc.b "Highscore Table:",0
pausetext  dc.b    "PAUSED",0
entername dc.b "Name:",0

;These have to be 4 bytes each for coding reasons
spd1       dc.b    "Low",0
spd2       dc.b    "Med",0
spd3       dc.b    "Hi ",0

 even
buf:              ds.b   10

vir1num:        dc.w 0
vir2num:        dc.w 0
vir3num:        dc.w 0

vir1frame:      dc.w 0
vir1leftofanim: dc.w 0
vir2frame:      dc.w 0
vir2leftofanim: dc.w 0
vir3frame:      dc.w 0 
vir3leftofanim: dc.w 0
virfdata:       dc.b 0,0,1*32,1*32,0,0,2*32,2*32
                dc.b 4*32,5*32,4*32,5*32,4*32,5*32,4*32,5*32
                dc.b 0,0,3*32,3*32,0,0,3*32,3*32
                dc.b 255,255,255,255,255,255,255,255

 even
removeblockdata dc.b 1,8,-1,-8
 even

spdtable dc.w 280,140,80

hsname1 dc.b "Lud",0
hsscore1 dc.w 800
hsname2 dc.b "Vik",0
hsscore2 dc.w 600
hsname3  dc.b "Ant",0
hsscore3 dc.w 400
hsname4 dc.b "Bir",0
hsscore4 dc.w 200

rand_seed dc.w 0

;The order of the following items is important
curx dc.w 0
cury dc.w 0
vert dc.w 0
col1 dc.b 0
col2 dc.b 0
nextcol1 dc.b 0
nextcol2 dc.b 0

addscore dc.w 0
score dc.w 0
exitdata dc.w 0
level dc.w 0
speed dc.w 0

basescore dc.w 10               ;Score is (speed+1)*10
basefalldowntimer dc.w 200      
;End of order

keystatus dc.b 0
 even



playarea dc.l 0

imgreloc:
  dc.b 0,1,2,3       ;Single
  dc.b 1,4,5,6       ;Left
  dc.b 1,7,8,9       ;Top
  dc.b 1,10,11,12    ;Right
  dc.b 1,13,14,15    ;Bottom
  dc.b 1,16,17,18    ;Virus 1
  dc.b 1,19,20,21    ;Virus 2
  dc.b 1,22,22,22    ;Removeblock images
  dc.b 1,23,23,23
 even

 include drmcn.asm

_comment dc.b "Dr Mario v1.0 by Ludde",0


 BSS
blockarea ds.b 8*15

 end
