// C Source File
// Created 22/12/01
// by Guillaume LEROY  glr@mageos.com
// (c) GLR Programs 2001-2002

#define USE_TI89              // Compile for TI-89
//#define USE_TI92PLUS          // Compile for TI-92 Plus
//#define USE_V200              // Compile for V200

#define MIN_AMS 200
#define OPTIMIZE_ROM_CALLS    // Use ROM Call Optimization
#define SAVE_SCREEN           // Save/Restore LCD Contents
#define NO_EXIT_SUPPORT
#define NO_CALC_DETECT
#include <tigcclib.h>         // Include All Header Files


//#define francais              // Compile en franais
#define english             // Compile in English

#define VERSION 1.4
#define JOUR 20
#define MOIS 07
#define ANNEE 2003
#define NBCAR 18
#define NIVEAUX 10

#if defined(francais)
	#define DATE1 JOUR
	#define DATE2 MOIS
#elif defined(english)
	#define DATE1 MOIS
	#define DATE2 JOUR
#endif


typedef struct {
		char name[NBCAR];
		unsigned int score;
	} SCORES;


// Dessin d'un carre de queue de serpent de 3x3 pixels
void carre(short x, short y)
{
	short a=0,b=0;
	for (a=0; a<3; a++){
	for (b=0; b<3; b++){
	DrawPix (x+a, y+b, A_XOR );}}
}


// Dessin d'un carre de bouffe de 3x3 pixels
void bouffe(short x, short y)
{
	DrawPix (x, y, A_XOR );
	DrawPix (x+2, y, A_XOR );
	DrawPix (x, y+2, A_XOR );
	DrawPix (x+2, y+2, A_XOR );
	DrawPix (x+1, y+1, A_XOR );
}


//Fonction Line
void line(short x1, short y1, short x2, short y2)
{
	DrawLine ( x1, y1, x2, y2, A_NORMAL);
}


// Saisie du nom du joueur
void input_str(char *str)
{
  short i=0,key=0;
  WINDOW w;

  WinOpen (&w, MakeWinRect (32, 32, 126, 70), WF_SAVE_SCR);
	WinActivate (&w);
	WinFont (&w, F_4x6);
		#if defined(francais)
	WinStrXY (&w, 4, 4, "Tu as tabli un record !" );
	WinStrXY (&w, 4, 14, "Entre ton nom:" );
		#elif defined(english)
	WinStrXY (&w, 4, 4, "You made a high score !" );
	WinStrXY (&w, 4, 14, "Enter Your Name:" );
		#endif
	WinAttr (&w, A_REPLACE );
  while (key!=KEY_ENTER)
	{
		str[i]='_';
		str[i+1]=' ';
		str[i+2]=' ';
		str[i+3]=0;
		WinStrXY (&w, 10, 22, str );
		key=ngetchx();
		if (key>=0 && key<='~' && key!=KEY_ENTER && i<NBCAR-3 )
			str[i++]=key;
		if (key==KEY_BACKSPACE && i )
			i--;
	}
	str[i]=0;
	WinClose (&w);
}


// Lecture du fichier
void readfile(SCORES *sp)
{
	FILE *fp;
	short i=0;

	fp = fopen( "nibhs", "rb");
	fseek( fp, 0, SEEK_END);
	switch (ftell(fp))
	{
		case 18://fichier version 1.1
			rewind(fp);
			for (i=0;i<6;i++)
				fread( &(sp[i].score), sizeof(short), 1, fp);
		break;
		case 126://fichier version 1.3
			rewind(fp);
				fread( sp, 6*sizeof(*sp), 1, fp);
	}
	fclose(fp);
}


// Ecriture du fichier
void writefile(SCORES *sp)
{
	FILE *fp;
	EM_moveSymFromExtMem (SYMSTR("nibhs"), HS_NULL);//Dsarchivage du fichier
	fp = fopen("nibhs","wb");
	fwrite(sp, 6*sizeof(*sp), 1, fp);
	fputc(0, fp);	//      Cration de
	fputs("HSC", fp);//   la nouvelle
	fputc(0, fp);//       extension
	fputc(OTH_TAG, fp);//	de fichier
	fclose(fp);
	EM_moveSymToExtMem (SYMSTR("nibhs"), HS_NULL);//Rarchivage du fichier
}


// Initialisation du niveau
void niveau(short lvl, short scr, short vie)
{
	WINDOW w;

//----------Initialisation de l'cran
	ClrScr();
	DrawClipRect (MakeWinRect (0, 0, 158, 98), &(SCR_RECT){{0, 0, 159, 99}}, A_NORMAL);
	DrawClipRect (MakeWinRect (1, 1, 157, 97), &(SCR_RECT){{0, 0, 159, 99}}, A_NORMAL);

	//----------Message du niveau
	WinOpen (&w, MakeWinRect(40, 28, 118, 63) , WF_SAVE_SCR | WF_ROUNDEDBORDER);
	WinActivate (&w);
	WinFont (&w, F_6x8);
		#if defined(francais)
	printf_xy ( 56, 34, "Niveau %i", lvl);
	WinFont (&w, F_4x6);
	printf_xy ( 56, 45, "Vie(s): %i", vie);
	printf_xy ( 56, 53, "Score: %i", scr);
		#elif defined(english)
	printf_xy ( 56, 34, "Level %i", lvl);
	WinFont (&w, F_4x6);
	printf_xy ( 56, 45, "Life(s): %i", vie);
	printf_xy ( 56, 53, "Score: %i", scr);
		#endif
	while(!(_keytest (RR_ENTER))) ;//Attente que [Enter] soit presse
	WinClose (&w);

//------------Dessin du niveau
	switch((lvl+7)%8+1)
	{
		case 2://niveau 2
		line ( 25, 31, 133, 31);
		line ( 25, 67, 133, 67);
		break;
		case 3://niveau 3
		DrawClipRect (MakeWinRect (25, 22, 133, 76), ScrRect, A_NORMAL);
		DrawLine ( 62, 22, 96, 22, A_REVERSE);
		DrawLine ( 62, 76, 96, 76, A_REVERSE);
		break;
		case 4://niveau 4
		line ( 25, 22, 25, 76);
		line ( 133, 22, 133, 76);
		line ( 25, 49, 133, 49);
		break;
		case 5://niveau 5
		DrawClipRect (MakeWinRect (25, 22, 133, 76), ScrRect, A_NORMAL);
		DrawLine ( 71, 22, 87, 22, A_REVERSE);
		break;
		case 6://niveau 6
		line ( 25, 22, 133, 22);
		line ( 25, 49, 133, 49);
		line ( 25, 76, 133, 76);
		break;
		case 7://niveau 7
		DrawClipRect (MakeWinRect (25, 22, 133, 76), ScrRect, A_NORMAL);
		DrawLine ( 62, 22, 96, 22, A_REVERSE);
		DrawLine ( 62, 76, 96, 76, A_REVERSE);
		line ( 52, 37, 106, 37);
		line ( 52, 61, 106, 61);
		break;
		case 8://niveau 8
		line ( 25, 25, 25, 73);
		line ( 133, 25, 133, 73);
		line ( 25, 49, 133, 49);
		line ( 43, 22, 115, 22);
		line ( 43, 76, 115, 76);
		break;
		case 9://niveau 9
		DrawClipRect (MakeWinRect (25, 22, 133, 76), ScrRect, A_NORMAL);
		DrawLine ( 71, 22, 87, 22, A_REVERSE);
		line ( 52, 37, 106, 37);
		line ( 52, 61, 106, 61);
		break;
		case 10://niveau 10
		DrawClipRect (MakeWinRect (28, 22, 130, 76), ScrRect, A_NORMAL);
		DrawLine ( 29, 22, 60, 22, A_REVERSE);
		DrawLine ( 98, 76, 129, 76, A_REVERSE);
		line ( 61, 22, 61, 64);
		line ( 97, 34, 97, 76);
	}
}



//=============Main Function
void _main(void)
{
	unsigned short x=9,y=9,xb=6,yb=6,vs=2,p=0,score=0,level=1,life=3,list_x[66],list_y[66];
	short l=6,n=0,t=0,v=9,dx=3,dy=0;
		#if defined(francais)
	char *vitesses[6]={"Trs lent","Lent","Normal","Rapide","Trs rapide","Turbo!"};
		#elif defined(english)
	char *vitesses[6]={"Very slow","Slow","Normal","Fast","Very fast","Turbo!"};
		#endif
	SCORES records[6]={{"...",0},{"...",0},{"...",0},{"...",0},{"...",0},{"...",0}};
	BOOL lost=FALSE;
	SYM_ENTRY *SymPtr = SymFindPtr(SYMSTR("nibhs"),0);
	WINDOW w;
	INT_HANDLER save_int_1 = GetIntVec(AUTO_INT_1);//sauvegarde de l'AUTO_INT_1
	INT_HANDLER save_int_5 = GetIntVec(AUTO_INT_5);//sauvegarde de l'AUTO_INT_5


//----------Prsentation
	ClrScr();
	DrawClipRect (MakeWinRect (0, 0, 158, 98), &(SCR_RECT){{0, 0, 159, 99}}, A_NORMAL);
	FontSetSys(F_8x10);
	DrawStr(50, 4, "Nibbles", A_NORMAL);
	FontSetSys(F_4x6);
	printf_xy( 36, 20, "Version %f , %i/%i/%i", VERSION, DATE1, DATE2, ANNEE);
	for (t=0;t<6;t++)
		printf_xy( 56, 34+6*t,"%i. %s", t+1, vitesses[t]);
		#if defined(francais)
	DrawStr( 32, 76, "Programm en C avec TIGCC", A_NORMAL);
	DrawStr( 43, 83, "par Guillaume LEROY", A_NORMAL);
		#elif defined(english)
	DrawStr( 38, 76, "Written in C using TIGCC", A_NORMAL);
	DrawStr( 44, 83, "by Guillaume LEROY", A_NORMAL);
		#endif
	DrawStr( 36, 90, "e-mail: glr@mageos.com", A_NORMAL);

	if (SymPtr)
		readfile(records);//lecture du fichier si existant
	else
		writefile(records);//cration du fichier si inexistant

	t=ngetchx();//attente de fin de prsentation

//----------Rglage de la vitesse
	vs=t-49;

	switch(t)
	{
		case 264: return;
		case 49: v=750; break;//	 750
		case 50: v=600; break;//	-150
		//Normal v=450				//	-150
		case 52: v=290; break;//	-160
		case 53: v=160; break;//	-130
		case 54: v=70; break;//		-90
		default: v=450; vs=2;
	}

	randomize();//initialisation du hasard
	SetIntVec( AUTO_INT_1, DUMMY_HANDLER);//dsactivation des AUTO_INT_1 et 5
	SetIntVec( AUTO_INT_5, DUMMY_HANDLER);// pour pouvoir utiliser rowread()

//----------Debut du jeu
	for(level=1;;level++)
	{
//----------Debut du niveau
		l=6; x=9; y=9; dx=3; dy=0; n=0;	lost=FALSE;
		for(t=0;t<66;t++)//remplissage initial du tableau
		{
			list_x[t]=0;
			list_y[t]=200;
		}
		niveau(level, score, life);

		for(p=0;p<10;p++)
		{
//----------Debut du point

			do{
				xb=(3*random(51))+3;//random entre 0 et n-1
				yb=(3*random(31))+3;//random entre 0 et n-1
			} while (GetPix(xb+1,yb+1)==1);//tirage de coordonnes jusqu' ce que l'emplacement soit libre

			bouffe(xb,yb);//dessine la bouffe

			while (GetPix(x+1,y+1)==0)
			{
//----------Debut marche du serpent

				carre(x, y);//dessine le carr de tte
				carre(list_x[n], list_y[n] );//efface le carr de queue
				list_x[n]=x;//sauvegarde de l'abscisse...
				list_y[n]=y;//...et de l'ordonne

				for(t=0;t<v;t++)//boucle de bridage
				{
					if (_keytest (RR_LEFT)) { dx=-3; dy=0; }	//Gauche
					if (_keytest (RR_RIGHT)) { dx=3; dy=0; }	//Droite
					if (_keytest (RR_DOWN)) { dx=0; dy=3; }		//Bas
					if (_keytest (RR_UP)) { dx=0; dy=-3; }		//Haut
				}
				if (_keytest (RR_2ND))		// Extinction de la calc
					off();
				if (_keytest (RR_ESC))		// Abandon de la partie
				{
					life=1;
					lost=TRUE;
					break;
				}
	//-----Pause
				if (_keytest (RR_CLEAR))	// Pause
				{
						WinOpen (&w, MakeWinRect (40, 28, 118, 70), WF_SAVE_SCR | WF_ROUNDEDBORDER);
						WinActivate (&w);
						WinFont (&w, F_6x8);
						WinStrXY (&w, 14, 4, " Pause! " );
						WinFont (&w, F_4x6);
							#if defined(francais)
						printf_xy ( 62, 46, "Niveau %i", level);
						printf_xy ( 62, 53, "Vie(s): %i", life);
						printf_xy ( 62, 60, "Score: %i", score);
							#elif defined(english)
						printf_xy ( 62, 46, "Level %i", level);
						printf_xy ( 62, 53, "Life(s): %i", life);
						printf_xy ( 62, 60, "Score: %i", score);
							#endif
						while(!(_keytest (RR_ENTER))) ; //Attente que [Enter] soit presse
						WinClose (&w);
				}
	//-----Fin de la pause

				x+=dx; y+=dy;
				n=((n+1)%l);
//----------Fin marche du serpent
			}

			bouffe(xb,yb);//Efface la bouffe
			if (GetPix (x+1,y+1)==1)//Si pixel toujours allum alors perdu!
			{
				lost=TRUE;
				break;
			}													//Sinon bouffe mange => point gagn

			//---- Dcalage des tableaux pour agrandissement immdiat de la taille du serpent
			for (t=l-1;t>=n;t--)
			{
				list_x[t+6]=list_x[t];
				list_y[t+6]=list_y[t];
			}
			for (t=0;t<6;t++)
			{
				list_x[(n+t)%(l+6)]=200;
				list_y[(n+t)%(l+6)]=0;
			}

			l+=6;//Augmentation du nombre de cases utilises pour mmoriser la queue du serpent
			score++;
//----------Fin du point
		}

		if (lost==TRUE)//Si perdu (ou [ESC])
		{
			life--;
			if (life<=0)
				break;//plus de vie ou sortie aprs avoir appuy sur [ESC]
			level--;
		}
		if ((level%NIVEAUX==0) && (v>70) && (lost==FALSE))//Si tous les niveaux ont t faits
			v-=50;//augmentation de la vitesse

//----------Fin du niveau
	}
//----------Fin du jeu

	SetIntVec(AUTO_INT_1, save_int_1); // Restaure l'AUTO_INT_1
	SetIntVec(AUTO_INT_5, save_int_5); // Restaure l'AUTO_INT_5
	clrscr();
	DrawClipRect (MakeWinRect (0, 0, 158, 98), &(SCR_RECT){{0, 0, 159, 99}}, A_NORMAL);

//--------Debut criture du fichier des high scores si nouveau record
	if(score>records[vs].score)
	{
			#if defined(francais)
		DrawStr(36, 6, " Record battu! ", A_REVERSE);
			#elif defined(english)
		DrawStr(30, 6, " New high score! ", A_REVERSE);
			#endif
		records[vs].score=score;//mise  jour du record dans le tableau
		input_str(records[vs].name);//mise  jour du nom dans le tableau
		DrawLine(0,98,158,98,A_NORMAL);
		writefile(records);//mise  jour du fichier des high scores
	}
	else
	{
			#if defined(francais)
		DrawStr(54, 8, " Perdu! ", A_REVERSE);
			#elif defined(english)
		DrawStr(43, 8, " Game over! ", A_REVERSE);
			#endif
	}

		#if defined(francais)
	printf_xy ( 50, 24, "Niveau: %i", level);
	printf_xy ( 50, 34, "Score: %i", score);
		#elif defined(english)
	printf_xy ( 50, 24, "Level: %i", level);
	printf_xy ( 50, 34, "Score: %i", score);
		#endif

//---------Tableau des high scores
	FontSetSys(F_4x6);
	for (t=0;t<6;t++)
	{
		printf_xy (26, 52+7*t, "%s", vitesses[t]);
		printf_xy (72, 52+7*t, "%i", records[t].score);
		printf_xy (92, 52+7*t, "%s", records[t].name);
	}

	do{	t=ngetchx(); } while ((t!=KEY_ENTER) && (t!=KEY_ESC));//Attente pour quitter
}
