****************************************************************************
****************************************************************************
**                                                               
**  Allecto (Scrolling side routines)
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated April 25, 2000
**
****************************************************************************
****************************************************************************

******************************************** DISPLAY SIDES OF SCREEN BUFFER

Display_Screen_Sides:
        LEA     642(A5),A0      
        LEA     LCD_MEM+$1E,A1  
        MOVEQ   #119,D0 
_LAB_0124:
        MOVE.L  (A0)+,(A1)+     
        lea     20(a0),a0       
        lea     20(a1),a1       
        MOVE.L  (A0)+,(A1)+     
        ADDQ.L  #4,A0   
        ADDQ.L  #2,A1   
        DBF     D0,_LAB_0124    
        RTS     

******************************************** SCROLL SIDES OF SCREEN

Scroll_Side:
        move.w  bpos(a5),d0     
        addq.w  #1,d0   
        cmp.w   #8*sects,d0     
        bne.s   skip_1  
        moveq   #0,d0   
skip_1:
        move.w  d0,bpos(a5)     
        and.w   #7,d0   
        bne.s   not_on_boundary 
        move.w  bpos(a5),d1     
        lsr.w   #3,d1   
        add.w   d1,d1   
        add.w   d1,d1   
        lea     Sides_Pattern(pc),a1    
        add.w   d1,a1   
        moveq   #14,d3  
        lea     sides_data+60(a5),a2    
Slide_Up_Sides:
        move.l  -4(a2),(a2)     
        subq.l  #4,a2   
        dbra    d3,Slide_Up_Sides       
        move.l  (a1),(a2)       
not_on_boundary:

        lea     sides_data+64(a5),a2
        lea     Blk0(a5),a1
        lsl.w   #5,d0   
        lea     2+640-(32*7)+(128*32)-4(a5),a0  
        add.w   d0,a0   
        move.b  inv(a5),d0      
        ext.w   d0      
        ext.l   d0      
        move.l  d0,d2   
        move.l  d0,d4   
        move.l  d0,d5   
        move.l  d0,d6   
        moveq   #15,d1  
Draw_Blox:
        move.w  -(a2),d3        
        lea     0(a1,d3.w),a3
        move.w  -(a2),d3        
        lea     0(a1,d3.w),a4
        moveq   #7,d7   
Draw_Line:
        move.l  (a3)+,-(a0)     
        movem.l d0/d2/d4/d5/d6,-(a0)    
        move.l  (a4)+,-(a0)     
        subq.l  #4,a0   
        dbra    d7,Draw_Line    
        dbra    d1,Draw_Blox    
        rts     

******************************************** SCREEN SIDE BLOCKS
*
* This loop generates the block data used for the maps of the scrolling
* screen sides.  The block number (kept in D0) is interpreted as follows:
*
* Bit 4 is the side (1 - right side, 0 - left side)
* Bits 3-2 encodes the position of the top end of the block in format
*       (left side: 24 - 8x, right side: 8 + 8x)
* Bits 0-1 encode the position of the bottom end of the block (as above)
*
* Block number N is at N*32 bytes from the start of the array (at Blk0)
*
********

Build_Side_Data:
        lea     Blk0+512(a5),a0
        moveq   #15,d0
left_side_build_loop:
        move.w  d0,d1
        not.w   d1
        and.w   #3,d1                   ; D1 = 3 - (bottom bits)
        lsl.w   #3,d1                   ; D1 = 24 - 8(bottom bits) = bottom X
        moveq   #1,d2
        lsl.l   d1,d2                   ; D2 = 1 << (bottom X)
        neg.l   d2                      ; D2 = mask at bottom
        move.w  d0,d1
        and.w   #3,d1                   ; D1 = bottom bits
        move.w  d0,d3
        lsr.w   #2,d3                   ; D3 = top bits

        moveq   #7,d4
        sub.w   d1,d3                   ; D3 = top - bottom = right shift
        blt.s   going_left

going_right:
        asr.l   d3,d2
        move.l  d2,-(a0)
        dbra    d4,going_right
        bra.s   left_side_end

going_left:
        neg.w   d3
going_left_l:
        lsl.l   d3,d2
        move.l  d2,-(a0)
        dbra    d4,going_left_l

left_side_end:
        dbra    d0,left_side_build_loop

        lea     Blk0+1056(a5),a1        ; A1 -> end of bottom block,
                                        ; A0 -> inverse block from top
        moveq   #15,d0                  ; D0 counts # of bricks         
right_side_build_loop:

        lea     -64(a1),a1              ; A1 -> start of bottom block
        moveq   #7,d1                   ; D1 counts # of lines
right_side_block_loop:
        move.l  (a0)+,d2                ; D2 = longword being reversed

        moveq   #31,d3                  ; D3 = # of bits to reverse
right_side_reverse_loop:
        roxl.l  #1,d2                 
        roxr.l  #1,d4
        dbra    d3,right_side_reverse_loop

        move.l  d4,(a1)+                ; D4 = reversed data
        dbra    d1,right_side_block_loop        

        dbra    d0,right_side_build_loop

        tst.b   inv(a5)
        beq.s   sdone

        lea     Blk0(a5),a1
        move.w  #255,d0
invl:   not.l   (a1)+
        dbra    d0,invl

sdone:  rts
               
******************************************** SCREEN SIDE DESCRIPTIONS

sects   set     0       
_sect   MACRO   
sects   set     sects+1 
        dc.w    \1*32,\2*32     
        ENDM    

Sides_Pattern:
        _sect   9,25    
        _sect   6,23    
        _sect   9,30    
        _sect   4,26    
        _sect   1,26    
        _sect   4,24    
        _sect   0,16    
        _sect   0,17    
        _sect   3,20    
        _sect   14,17   
        _sect   10,23   
        _sect   10,30   
        _sect   10,26   
        _sect   11,24   
        _sect   15,16   
        _sect   15,17   
        _sect   15,21   
        _sect   13,20   
        _sect   6,18    
        _sect   10,25   
        _sect   10,23   
        _sect   9,30    
        _sect   4,26    
        _sect   2,26    
        _sect   9,26    
        _sect   7,24    
        _sect   14,16   
        _sect   11,17   
        _sect   12,20   
        _sect   0,19    
        _sect   0,30    
        _sect   1,25    
        _sect   5,23    
        _sect   6,25    
        _sect   10,21   
        _sect   10,20   
        _sect   11,18   
        _sect   12,27   
        _sect   2,29    
        _sect   10,22   
        _sect   11,27   
        _sect   14,30   
Sides_Pattern_End:
