****************************************************************************
****************************************************************************
**                                                               
**  Allecto (Shop routines)
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated February 5, 2001
**
****************************************************************************
****************************************************************************

    IFD ti89d   
K_CHEAT     set     120     
SPACING     set     180     
L_SHIELD    set     99
LINE_HEIGHT set     6
ITEM_FONT   set     0
ITEMS_Y     set     14
PRICE_X     set     120
    ENDIF   

    IFND ti89d   
K_CHEAT     set     262     
SPACING     set     240     
L_SHIELD    set     121
LINE_HEIGHT set     8
ITEM_FONT   set     1
ITEMS_Y     set     16
PRICE_X     set     200
    ENDIF   

******************************************** PURCHASE ITEMS

Allecto_Shop:
        cmp.w   #50,cash(a5)    
        bmi     Status_Prepare  

        bsr     Clear_Screen    
        moveq   #ITEM_FONT,d0   
        bsr     Set_Font        

        moveq   #0,d0                   ; Enable interrupts
        trap    #1      

        moveq   #num_i-1,d7             ; number of items remaining
        moveq   #16,d6                  ; Y-coordinate
        lea     Shop_Items(pc),a4       ; A4 -> item table
        lea     (a4),a3                 ; A3 -> item table
PSI_ITEMS:
        moveq   #12,d1                  ; X-coordinate for description
        move.l  d6,d0                   ; Y-coordinate for this line
        move.l  (a4)+,d4                ; Load data about this item
                                        ; and advance A4 to point to
                                        ; next item.
        lea     0(a3,d4.w),a0           ; Get ptr to info string in A0
        bsr     Display_String          ; Display item info

        swap    d4                      ; Get price offset in D4
        move.w  0(a3,d4.w),-(sp)        ; Push price on stack
        pea     price_template(pc)      ; Push template of price
        pea     _string_buffer(a5)      ; Push string buffer
        jsr     ____sprintf             ; sprintf(buffer, template, price)
        lea     10(sp),sp
   IFD ti89d
        moveq   #120,d1                 ; X-coordinate for price
   ENDIF
   IFND ti89d
        move.w  #180,d1                 ; X-coordinate for price
   ENDIF
        move.l  d6,d0                   ; Y-coordinate for this line
        lea     _string_buffer(a5),a0   ; text of price
        bsr     Display_String          ; display price

        addq.l  #LINE_HEIGHT,d6         ; Calc next Y-coordinate
        dbra    d7,PSI_ITEMS            ; Next item or finish

        moveq   #0,D5                   ; D5 = item selected
Allecto_Shop_Loop:
        cmp.w   #50,cash(a5)    
        bmi     Status_Prepare
        bsr     Shield_Update

    IFD ti89d
        lea     LCD_MEM+30,a0           ; Clear shop title area
        moveq   #59,d1   
        moveq   #0,d0   
PSL_CLS:
        move.l  d0,(a0)+        
        dbra    d1,PSL_CLS
    ENDIF
    IFND ti89
        lea     LCD_MEM+30,a0
        moveq   #7,d1
        moveq   #0,d0
PSL_CLS:
        moveq   #13,d2
PSL_CLL:
        move.w  d0,(a0)+
        dbra    d2,PSL_CLL
        addq.w  #2,a0
        dbra    d1,PSL_CLS
    ENDIF

        moveq   #LINE_HEIGHT*num_i+ITEMS_Y-8,d1   
PSL_CLC:                                ; Clear left side (arrow area)
        move.b  d0,(a0) 
        lea     30(a0),a0       
        dbra    d1,PSL_CLC      

    IFND ti89d   
        pea     _shop_title(pc)         ; Display shop title
        jsr     ST_showHelp       
    ENDIF   
    IFD ti89d   
        moveq   #1,d0                   ; Set font to normal
        bsr     Set_Font        
    ENDIF   

        lea     _string_buffer(a5),a4   ; A4 -> string buffer
        move.w  cash(a5),-(sp)          ; Push amount of cash
        pea     _shop_info(pc)          ; Push format string
        pea     (a4)                    ; Push buffer address
        jsr     ____sprintf             ; Write string into buffer
        lea     (a4),a0 
        moveq   #1,d0   
        moveq   #0,d1
        bsr     Display_String          ; Print Title message

    IFND ti89d   
        lea     14(sp),sp       
    ENDIF   
    IFD ti89d   
        lea     10(sp),sp       
    ENDIF   

        move.w  d5,d4   
        mulu    #SPACING,d4     
        lea     LCD_MEM+30*ITEMS_Y,a0  
        add.w   d4,a0   
        lea     arrow(pc),a1    
        moveq   #7,d0   
loop_draw_arrow:
        move.b  (a1)+,(a0)      
        lea     30(a0),a0       
        dbra    d0,loop_draw_arrow      

        bsr     Get_Key                 ; Wait for keypress

        cmp.w   #K_CHEAT,d0     
        bne.s   no_cheating     
        swap    d5
        move.w  #-1000,d5       
        bsr     Player_Damage   
        swap    d5      
        st      cheated(a5)     
no_cheating:

        cmp.w   #264,d0                 ; Test ESC key
        beq     Status_Prepare

    IFND ti89    
        sub.w   #338,d0                 ; Test up arrow
        beq.s   shop_go_up      
        subq.w  #4,d0                   ; = 342 ? 
        beq.s   shop_go_up      
        addq.w  #3,d0                   ; = 339 ?
        beq.s   shop_go_up      
        subq.w  #5,d0                   ; Test down arrow (= 344 ?)
        beq.s   shop_go_down    
        subq.w  #1,d0                   ; = 345 ? 
        beq.s   shop_go_down    
        subq.w  #3,d0                   ; = 348 ?
        beq.s   shop_go_down    
        cmp.w   #13-348,d0  
    ENDIF   

    IFD ti89    
        sub.w   #337,d0                 ; Test up arrow
        beq.s   shop_go_up      
        subq.w  #3,d0                   ; Test down arrow
        beq.s   shop_go_down    
        cmp.w   #13-340,d0  
    ENDIF   

        bne     Allecto_Shop_Loop       

        move.w  d5,d4   
        add.w   d4,d4   
        add.w   d4,d4                   ; D4 = offset of table entry
        move.w  Shop_Items(pc,d4.w),d0  
        lea     Shop_Items(pc,d0.w),a0  
        move.w  cash(a5),d6             ; D0 = current cash
        sub.w   (a0)+,d6                ; D0 = cash left
        bmi     Allecto_Shop_Loop       ; Cancel purchase if < 0
        jsr     (a0)                    ; Call activation routine
        bne     Allecto_Shop_Loop
        move.w  d6,cash(a5)             ; Save new amount of money
        bra     Allecto_Shop_Loop

shop_go_up:
        tst.w   d5      
        beq     Allecto_Shop_Loop       
        subq.w  #1,d5   
        bra     Allecto_Shop_Loop       

shop_go_down:
        cmp.w   #num_i-1,d5     
        beq     Allecto_Shop_Loop       
        addq.w  #1,d5   
        bra     Allecto_Shop_Loop       

******************************************** SHOP ITEMS LIST
*
* This macro is used to create a table of shop items.  Each item must have
* labels psd_<name> for the data and code controlling it, and psd_<name> for
* the description defined.  The description is simply a string which will
* be displayed in the list of items.
*
* The data/code first has one word which is the price of the item.  If the
* player tries to buy it (and has enough money) then the code beginning
* immediately after it will be called.  The code should then do whatever is
* needed to handle the player's purchase.  It should return with the zero
* flag set if the player should be charged, and clear when the player should
* not be charged (that is, if the user already has the item, or the maximum
* amount possible of something that you can buy multiple instances of).
*
* The amount of money that the player will have after purchasing the item
* is kept in D6, so D6 should not be changed unless you want to change this.
*
********

num_i   set     0

ITEM    MACRO   
        dc.w    psd_\1-Shop_Items       
        dc.w    psn_\1-Shop_Items       
num_i   set     num_i+1 
        ENDM    

Shop_Items:
        ITEM    Exit_Shop       
        ITEM    Shield_Boost    
        ITEM    Extra_Bullet    
        ITEM    Double_Shoot    
        ITEM    Triple_Shoot    
        ITEM    Quadruple_Shoot 
        ITEM    Rapid_Fire      
        ITEM    Dual_Plasma_Cannon      
        ITEM    Ship_2  
        ITEM    Golden_Arches   
        ITEM    Ship_3  
        ITEM    Triple_Plasma_Cannon    
        ITEM    Ultimate_Weapon 

******************************************** SHOP ITEMS DATA AND CODE

psd_Shield_Boost:
        dc.w    50      
        move.w  player_dmg(a5),d0       
        cmp.w   #31,d0  
        beq.s   return_no_charge  
        addq.w  #1,player_dmg(a5)       

return_charge:                              ; Set flags to equal (charge)           
        moveq   #0,d0
        rts

return_no_charge:                           ; Set flags to != (no charge)
        moveq   #1,d0
        rts     

psd_Extra_Bullet:
        dc.w    100     
        move.w  num_b(a5),d0    
        cmp.w   #23,d0  
        beq.s   return_no_charge 
        addq.w  #1,num_b(a5)
        bra.s   return_charge

psd_Rapid_Fire:
        dc.w    1000
        cmp.w   #-3,fire_delay(a5)
        beq.s   return_no_charge
        move.w  #-3,fire_delay(a5)      
        bra.s   return_charge 

psd_Ship_2:
        dc.w    1500
        cmp.w   #1,player_ship(a5)
        bne.s   yes2
        cmp.w   #31,player_dmg(a5)
        beq.s   return_no_charge
yes2:   move.w  #1,player_ship(a5)      
        bsr     New_Ship
        bra.s   return_charge

psd_Ship_3:
        dc.w    2000
        cmp.w   #2,player_ship(a5)
        bne.s   yes3
        cmp.w   #31,player_dmg(a5)
        beq.s   return_no_charge
yes3:   move.w  #2,player_ship(a5)      
        bsr     New_Ship
        bra.s   return_charge

psd_Golden_Arches:
        dc.w    1750    
        bset    #5,weapons_available(a5)        
        rts

psd_Double_Shoot:
        dc.w    250     
        bset    #1,weapons_available(a5)        
        rts     

psd_Triple_Shoot:
        dc.w    400     
        bset    #2,weapons_available(a5)        
        rts     

psd_Quadruple_Shoot:
        dc.w    500     
        bset    #3,weapons_available(a5)        
        rts     

psd_Dual_Plasma_Cannon:
        dc.w    1250    
        bset    #4,weapons_available(a5)        
        rts     
psd_Triple_Plasma_Cannon:
        dc.w    2500    
        bset    #6,weapons_available(a5)        
        rts     

psd_Ultimate_Weapon:
        dc.w    3000    
        bset    #7,weapons_available(a5)        
        rts     

******************************************** EXIT THE SHOP

psd_Exit_Shop:
        dc.w    0       
        addq.l  #4,sp   
        bra     Status_Prepare  

******************************************** SHOP MESSAGES

    IFND ti89d
_shop_title:
        dc.b    'If you find a better price anywhere '  
        dc.b    'I''ll eat a bucket of crabs!',0        
_shop_info:
        dc.b    ALLECTO,' Shop - Credits : $%d',0        
    ENDIF

    IFD ti89
_shop_info:
        dc.b    'All89 Shop - %d Credits',0
    ENDIF

psn_Exit_Shop:
        dc.b    'Exit',THE,'shop!',0      
psn_Shield_Boost:
        dc.b    '1-point shield recharge',0    
psn_Extra_Bullet:
        dc.b    'Extra bullet',0    
psn_Double_Shoot:
        dc.b    'Double',CANNON,'(F2)',0    
psn_Triple_Shoot:
        dc.b    'Triple',CANNON,'(F3)',0    
psn_Quadruple_Shoot:
        dc.b    'Quadruple',CANNON,'(F4)',0    
psn_Rapid_Fire:
        dc.b    'Rapid-Fire Unit',0    
psn_Dual_Plasma_Cannon:
        dc.b    'Dual Plasma',CANNON,'(F5)',0    
psn_Ship_2:
        dc.b    'New Ship : Heavy Destroyer',0    
psn_Golden_Arches:               
        dc.b    'Golden Arches (F6)',0    
psn_Ship_3:
        dc.b    'New Ship : The Allecto',0    
psn_Triple_Plasma_Cannon
        dc.b    'Triple',PLASMA,'(F7)',0    
psn_Ultimate_Weapon:
        dc.b    'Deluxe',PLASMA,'(F8)',0

price_template:
        dc.b    '%5d',0

        EVEN

*********************************************

arrow:  dc.b    %00011000       
        dc.b    %00001100       
        dc.b    %00000110       
        dc.b    %11111111       
        dc.b    %11111111       
        dc.b    %00000110       
        dc.b    %00001100       
        dc.b    %00011000       
