****************************************************************************
****************************************************************************
**                                                               
**  Allecto (Player handling routines)
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated April 25, 2001
**
****************************************************************************
****************************************************************************

    IFD     ti89    
KF_DOWN set     2       
KF_RIGHT set    3       
KF_UP   set     0       
KF_LEFT set     1       
    ENDIF

    IFD     ti89d   
MAX_X   set     207     
MIN_X   set     48      
MAX_Y   set     121     
MIN_Y   set     96      
    ENDIF

    IFND    ti89    
KF_DOWN set     7       
KF_RIGHT set    6       
KF_UP   set     5       
KF_LEFT set     4       
    ENDIF

    IFND    ti89d   
MAX_X   set     239     
MIN_X   set     16      
MAX_Y   set     140     
MIN_Y   set     96      
    ENDIF   

******************************************** DRAW THE PLAYER'S SHIP

Draw_Player:
        move.w  #$fffe,$18(a6)          ; Key mask for arrows
        move.w  #MAX_X+1,d6             ; Calculate max X in D6
        sub.w   player_width(a5),d6     
        move.w  #MAX_Y+1,d7             ; Calculate max Y in D7
        sub.w   player_height(a5),d7    

        move.w  player_xc(a5),d0        ; Load coordinates
        move.w  player_yc(a5),d1        
        move.w  $1a(a6),d2              ; Read keypad

        btst    #KF_DOWN,d2             ; Move down
        bne.s   player_notgoingdown     
        add.w   player_speed(a5),d1     
        cmp.w   d7,d1   
        ble.s   player_notgoingdown     
        move.w  d7,d1   
player_notgoingdown:

        btst    #KF_RIGHT,d2            ; Move right
        bne.s   player_notgoingright    
        add.w   player_speed(a5),d0     
        cmp.w   d6,d0   
        ble.s   player_notgoingright    
        move.w  d6,d0   
player_notgoingright:

        btst    #KF_UP,d2               ; Move up
        bne.s   player_notgoingup       
        sub.w   player_speed(a5),d1     
        cmp.w   #MIN_Y,d1       
        bge.s   player_notgoingup       
        moveq   #MIN_Y,d1       
player_notgoingup:

        btst    #KF_LEFT,d2             ; Move left
        bne.s   player_notgoingleft     
        sub.w   player_speed(a5),d0     
        cmp.w   #MIN_X,d0       
        bge.s   player_notgoingleft     
        moveq   #MIN_X,d0       
player_notgoingleft:

        move.w  d0,player_xc(a5)        
        move.w  d1,player_yc(a5)        

        tst.b   slow_flag(a5)
        bne.s   nodispl 

        move.w  player_image(a5),d2     
        bsr     Test_Xor_Sprite 
        tst.l   d3      
        bne.s   Player_Died     

nodispl:
        rts     

Player_Died:
        moveq   #0,d5   
        bra     Player_Damage   

******************************************** LOAD SHIP DEFINTIONS

Load_Player:
        move.w  player_ship(a5),d0      
        mulu    #12,d0  
        lea     Ship_Definitions(pc,d0.w),a2    
        move.w  (a2)+,player_image(a5)  
        move.w  (a2)+,player_width(a5)  
        move.w  (a2)+,player_height(a5) 
        move.w  (a2)+,player_armor(a5)  
        move.w  (a2)+,player_weaponx(a5)        
        move.w  (a2)+,player_speed(a5)  
        bra     Shield_Update   

Ship_Definitions:
        dc.w    in_Player_Ship_Normal   
        dc.w    13,8,0,6,2      
        dc.w    in_Player_Ship_II       
        dc.w    15,8,5,7,2      
        dc.w    in_Player_Ship_III      
        dc.w    11,7,0,5,3      

******************************************** TESTING SPRITE-PLOTTER

Test_Xor_Sprite:
        lea     image_table(pc),a0      
        add.w   d2,a0   
        moveq   #0,d3   
        move.w  d0,d2                   ;D0 = X coordinate
        and.w   #15,d0  
        lsl.w   #5,d1                   ;D1 = Y coordinate
        lea     0(a5,d1.w),a1   
        lsr.w   #4,d2   
        add.w   d2,d2   
        add.w   d2,a1   

        move.w  (a0)+,d2                ;A0 -> Sprite data

        tst.b   inv(a5) 
        bne.s   reversed        

        subq.w  #8,d0   
        bgt.s   txs_ShiftRight  
        beq.s   txs_alignedOK   

txs_ShiftLeft:
        neg.w   d0      
txs_ShiftLeft_:
        move.l  (a0)+,d1        
        lsl.l   d0,d1   
        move.l  (a1),d4 
        and.l   d1,d4   
        or.l    d4,d3   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,txs_ShiftLeft_       
        rts     

txs_alignedOK:
        move.l  (a0)+,d1        
        move.l  (a1),d4 
        and.l   d1,d4   
        or.l    d4,d3   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,txs_alignedOK        
        rts     

txs_ShiftRight:
        move.l  (a0)+,d1        
        lsr.l   d0,d1   
        move.l  (a1),d4 
        and.l   d1,d4   
        or.l    d4,d3   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,txs_ShiftRight       
        rts     

reversed:
        subq.w  #8,d0   
        bgt.s   txsr_ShiftRight 
        beq.s   txsr_alignedOK  

txsr_ShiftLeft:
        neg.w   d0      
txsr_ShiftLeft_:
        move.l  (a0)+,d1        
        lsl.l   d0,d1   
        move.l  (a1),d4 
        not.l   d4      
        and.l   d1,d4   
        or.l    d4,d3   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,txsr_ShiftLeft_      
        rts     

txsr_alignedOK:
        move.l  (a0)+,d1        
        move.l  (a1),d4 
        not.l   d4      
        and.l   d1,d4   
        or.l    d4,d3   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,txsr_alignedOK       
        rts     

txsr_ShiftRight:
        move.l  (a0)+,d1        
        lsr.l   d0,d1   
        move.l  (a1),d4 
        not.l   d4      
        and.l   d1,d4   
        or.l    d4,d3   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,txsr_ShiftRight      
ret1:   rts     

