****************************************************************************
****************************************************************************
**                                                               
**  Allecto (Enemy bullets)
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated April 25, 2001
**
****************************************************************************
****************************************************************************

******************************************** HANDLE ENEMY BULLETS
*
* This routines processes each bullet in the enemy bullet array.  It tests
* each bullet for a collision with the player, and if a collision is
* detected the bullet is eliminated and the player damaged.  Both objects are
* approximated as rectangles for this collision detection.  Refer to the
* description of player-bullet-to-enemy collisions in 'BULLETS.ASM' for
* details of how that works.
*
* For each bullet which does not hit the player, the enemy movement routine
* is then called.  The bullet's type is the word offset of the routine.  The
* bullet routine is called with A4 pointing to the bullet structure, and D7
* holding the number of items remaining in the array.  It must preserve these
* two registers, and should update the coordinates and other data as needed,
* but not draw the bullet.
*
* This routine itself draws each bullet, using the coordinates and image
* specified in tis structure, before doing other processing on it.
*
********

Enemy_Bullets:
        lea     enemy_bullets(a5),a4    ; A4 -> Enemy bullet entry
        moveq   #15,d7  
loop_draw_enemy_bullets:
        move.w  (a4),d6                 ; Test for bullet's presence
        beq.s   ebd_no_bullet_here      

        move.w  eb_x(a4),d0             ; Draw the bullet
        move.w  eb_y(a4),d1     
        move.w  eb_image(a4),d2 
        bsr     Xor_Sprite_D2   

        lea     player_ship(a5),a3      
        bsr     Test_Collision  
        beq.s   ebd_no_collision        

        clr.w   (a4)    
        move.w  eb_dmg(a4),d5   
        bsr     Player_Damage   
        bra.s   ebd_no_bullet_here      
ebd_no_collision:

        lea     eb_y(a4),a3             ; Move enemy bullets
        jsr     Enemy_Bullets(pc,d6.w)  

ebd_no_bullet_here:
        lea     b_size(a4),a4   
        dbra    d7,loop_draw_enemy_bullets      
        rts     

******************************************** ENEMY BULLET SUBROUTINES

ebx_arrow:
        move.w  (a3),d4     
        addq.w  #2,d4
        bra.s   ebx_y_finished

ebx_radar_locked:
        cmp.w   #1,player_ship(a5)      
        beq.s   ebx_no_radar    
ebx_guided_godown:
        move.w  #EB_NORMAL,(a4) 
        move.w  #in_Guided_Down,e_image(a4)     
ebx_normal_bullet:
        move.w  (a3),d4     
        addq.w  #1,d4
ebx_y_finished: 
        cmp.w   #140,d4 
        bge.s   ebx_kill        
        move.w  d4,(a3)     
ebx_no_radar:
        rts     

ebx_guided_left:
        addq.w  #1,(a3)     
        cmp.w   #140,(a3)   
        bge.s   ebx_kill
        subq.w  #1,e_x(a4)  
        cmp.w   #20,e_x(a4)    
        beq.s   ebx_guided_godown       
        move.w  e_x(a4),d0     
        subq.w  #6,d0   
        cmp.w   player_xc(a5),d0        
        blt.s   ebx_radar_locked        
        rts     

ebx_guided_right:
        addq.w  #1,(a3)     
        cmp.w   #140,(a3)   
        bge.s   ebx_kill
        addq.w  #1,e_x(a4)     
        cmp.w   #215,e_x(a4) 
        beq.s   ebx_guided_godown       
        move.w  e_x(a4),d0     
        subq.w  #6,d0   
        cmp.w   player_xc(a5),d0        
        bgt.s   ebx_radar_locked        
        rts     
ebx_kill:
        clr.w   (a4)    
        rts     

ebx_aimed_bullet:
        move.b  eb_data+1(a4),d2        
        ext.w   d2
        bsr     Div_D2_By_4
        move.w  d2,d1
        move.b  eb_data(a4),d2  
        ext.w   d2
        bsr     Div_D2_By_4

        add.w   (a3),d2     
        move.w  d2,(a3)     
        cmp.w   #140,d2 
        bgt.s   ebx_kill        

        subq.w  #4,a3
        add.w   (a3),d1     
        move.w  d1,(a3)     
        blt.s   ebx_kill        
        cmp.w   #222,d1 
        bgt.s   ebx_kill        
        rts     

********************************************** ENEMY BULLET TYPES
*
* The EBULLET macro assigns an enemy bullet type to each type of enemy bullet
* used in the game.  The first argument is the symbol that is created for the
* type, and the second is the bullet's code.  The enemy bullet type is a
* relative pointer, and is used in the type field of the enemy bullet array.
*
* As this table is only used to set symbols to equal the offsets, this table
* takes absolutely no space in the executable code.
*
*******

EBULLET MACRO   
\1      equ     \2-Enemy_Bullets        
        ENDM    

        EBULLET EB_ARROW,ebx_arrow      
        EBULLET EB_NORMAL,ebx_normal_bullet     
        EBULLET EB_AIMED,ebx_aimed_bullet       
        EBULLET EB_RIGHT,ebx_guided_right       
        EBULLET EB_LEFT,ebx_guided_left 
