****************************************************************************
****************************************************************************
**                                                               
**  Allecto (Player bullet movement/display code)
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated April 25, 2001
**
****************************************************************************
****************************************************************************

swinging_bullet:
        addq.b  #1,b_data(a4)
        move.b  b_data(a4),d4
        cmp.b   #-9,1(a4)
        beq.s   shallow_swing
        btst    #1,d4
        beq.s   bullet_draw
        bra.s   bullet_move_x
shallow_swing:
        and.w   #6,d4
        bne.s   bullet_draw
        bra.s   bullet_move_x

Player_Bullets:
        lea     bullets_data(a5),a4     
        move.w  num_b(a5),d7    
loop_player_bullets:
        tst.w   (a4)                            ;Skip if doesn't exist
        beq.s   no_bullet_here
        cmp.w   #$1868,(a4)
        beq.s   guided_bomb                     ;Special bullet type
        
        move.b  1(a4),d0                        ;Move in Y direction
        ext.w   d0
        asr.w   #1,d0
        add.w   b_y(a4),d0
        ble.s   kill_bullet
        move.w  d0,b_y(a4)
        
        cmp.b   #2,b_data+1(a4)                 ;Test for "arch" bullet
        bne.s   not_arch_bullet
        subq.b  #1,1(a4)                        ;If so, adjust velocity
not_arch_bullet:        
        
        cmp.b   #1,b_data+1(a4)                 ;Test for "swinging" bullets
        beq.s   swinging_bullet

bullet_move_x:
        move.b  (a4),d0
        ext.w   d0
        add.w   b_x(a4),d0
        ble.s   kill_bullet
        move.w  d0,b_x(a4)
        cmp.w   #240,d0
        bge.s   kill_bullet
                
bullet_draw:            
        move.w  b_x(a4),d0      
        move.w  b_y(a4),d1      
        move.w  b_image(a4),d2  
        bsr     Xor_Sprite_D2
           
no_bullet_here:
        lea     b_size(a4),a4                   ;Move on to next bullet   
        dbra    d7,loop_player_bullets     
        rts

kill_bullet:                                    ;Destory this bullet
        clr.w   (a4)                            ;Mark its entry as unused
        bra.s   no_bullet_here

forward:
        subq.w  #5,b_y(a4)
        ble.s   kill_bullet
        bra.s   bullet_draw
              
guided_bomb:
        lea     enemies_data(a5),a3     
        add.w   e_data(a4),a3           ; A3 -> target enemy
        tst.w   (a3)    
        ble.s   forward       
        tst.w   e_dmg(a3)       
        ble.s   forward       
        move.w  e_y(a3),d0      
        ble.s   forward       
        sub.w   b_y(a4),d0              ; D0 = DeltaY
        bge.s   forward     

        move.w  e_w(a3),d1      
        lsr.w   #1,d1   
        add.w   e_x(a3),d1      
        subq.w  #3,d1   
        sub.w   player_xc(a5),d1        ; D1 = DeltaX
        slt     d2                      ; D2 = DeltaX negative flag
        ble.s   guidedpos       
        neg.w   d1      
guidedpos:
                                        ; D1 = -Abs(DeltaX)
        mulu    #3,d1   
        add.w   d0,d0   
        cmp.w   d1,d0                   ; If 3 * DeltaX < 2 * DeltaY,
        ble     forward                 ; go straight

        moveq   #-4,d3                  ; D3 = Y-Velocity
        moveq   #-3,d4                  ; D4 = X-Velocity
        add.w   d0,d0   
        cmp.w   d1,d0                   ; If 3 * DeltaX < 4 * DeltaY,
        ble.s   no_high_angle           ; less diagonal
        exg     d3,d4   
no_high_angle:

        tst.b   d2      
        bne.s   no_negate       
        neg.w   d4      
no_negate:

        add.w   d3,e_y(a4)      
        add.w   d4,e_x(a4)      
        bra     bullet_draw
