****************************************************************************
****************************************************************************
**                                                               
**  Allecto for TI-89, TI-92, and TI-92 Plus : Data Structure Definitons
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated April 25, 2001
**
****************************************************************************
****************************************************************************

******************************************** BULLET STRUCTURE

b_type  equ     0                       ;word offset into jump table
b_dmg   equ     2                       ;number of damage points
b_x     equ     4                       ;X-coordinate
b_w     equ     6                       ;width
b_y     equ     8                       ;Y-coordinate
b_h     equ     10                      ;height
b_image equ     12                      ;offset into image table
b_data  equ     14                      ;2 bytes for other data
b_size  equ     16      

******************************************** ENEMY BULLET STRUCTURE

eb_type equ     0                       ;offset into jump table
eb_dmg  equ     2                       ;number of damage points
eb_x    equ     4                       ;X-coordinate
eb_w    equ     6                       ;width
eb_y    equ     8                       ;Y-coordinate
eb_h    equ     10                      ;height
eb_image equ    12                      ;offset into image table
eb_data equ     14                      ;2 bytes for other data
eb_size equ     16      

******************************************** ENEMY DATA STRUCTURE

num_en  equ     26      

e_type  equ     0                       ;offset into enemy table
e_dmg   equ     2                       ;strength of the enemy
e_x     equ     4                       ;X-coordinate
e_w     equ     6                       ;width
e_y     equ     8                       ;Y-coordinate
e_h     equ     10                      ;height
e_image equ     12                      ;offset into image table
e_data  equ     14                      ;2 bytes for other data
e_dstry equ     16                      ;destruction code offset
e_size  equ     18      

******************************************** MAIN VARIABLES
*
* This defines the game's main variables.  The 'rs' macro reserves the
* specified amount of space by incrementing the offset counter.  Overall,
* this section serves to calculate the offsets of each variable.  This
* system allows variables to be easily added, removed, or resized, as the
* offsets themselves are not hard-coded.  Near the bottom, data_end is
* defined with a size of zero to set that equal to the length of the data
* so far.  At the end, 'offset' is the total size of all this data.
*
********

offset  set     0       

rs      MACRO   
\1      set     offset  
offset  set     offset+\2       
        ENDM    

        rs      s,5120                  ; Screen buffer
        rs      cdt,160*8               ; Collision detection test are

        rs      data_start,0            ; Start of data to be saved

        rs      sides_data,64   

        rs      bullets_data,b_size*24  ; All data for player bullets
        rs      enemy_bullets,eb_size*16        ; All data for enemy bullets
        rs      enemies_data,e_size*26  ; All data for enemies
        rs      enemies_data_end,0      

        rs      bpos,2  
        rs      cash,2                  ; Amount of credits
        rs      num_b,2                 ; Number of player's bullets
        rs      fire_delay,2            ; -(Time Between Shots)

        rs      player_ship,2           ; Player's ship (0, 1, 2)
        rs      player_dmg,2            ; Condition of player's ship
        rs      player_xc,2             ; Player X coordinate
        rs      player_width,2          ; Width of player's ship
        rs      player_yc,2             ; Player Y coordinate
        rs      player_height,2         ; Hieght of player's ship
        rs      player_image,2          ; Sprite for player's ship

        rs      player_armor,2          ; Amount of player's armor
        rs      player_weaponx,2        ; X-Offset of gun in ship
        rs      player_speed,2          ; Pixels per frame

        rs      weapon_selected,2       ; Selected weapon (*2)
        rs      lock_status,2           ; Count-up to fire ready

        rs      cycle_counter,4         ; Incremented every frame
        rs      time_bonus,4            ; Bonus points for quick finish

        rs      enemies_remaining,2     ; Number of enemies left

        rs      difficulty,2            ; Difficulty level (1-4)
        rs      level_number,2          ; Level number
        rs      xy_pointer,4            ; Pointer to coordinate table

        rs      weapons_available,1     ; Bit mask for avail. weapons
        rs      game_finished,1         ; Game has been finished
        rs      Game_Started,1          ; Game is running (not on title)
        rs      cheated,1               ; Set if player has cheated
        rs      flags,1                 ; Flags for miscellaneous use
        rs      inv,1                   ; -1 if inverse display, 0 o/w
        rs      slow_flag,1             ; set if game running too slow
        rs      pad,1       

        rs      special_weapon_delay,2  ; Special weapon delay
        rs      special_countdown,2     ; Countdown to second shot

        rs      speed,2 

        rs      data_end,0              ; End of data to be saved

        rs      left_list_size,2        ; Lists of enemies from each
        rs      left_list_data,4*num_en ; section of the screen for
        rs      center_list_size,2      ; collision detection
        rs      center_list_data,4*num_en       
        rs      right_list_size,2       
        rs      right_list_data,4*num_en        

        rs      _string_buffer,40       ; String buffer (for sprintf)
        rs      _unpack_buffer,40       ; String buffer (for unpacker)

        IFND    ti89d
        rs      Blk0,1024               ; screen side images
        ENDIF
