****************************************************************************
****************************************************************************
**                                                               
**  Allecto for TI-92, TI-92 Plus, and TI-89
**
**  This software is in the public domain.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated April 25, 2001
**
****************************************************************************
****************************************************************************

********************************************* CALCULATOR SELECTION
*
* Edit the file "which.h" to select which calculator the program will be
* assembled for.  Enter "ti89 set 1" for the TI-89, "ti92 set 1" for the
* TI-92, and "ti92plus set 1" for the TI-92 Plus.  This one line is the only
* calculator to run it.  For the other calculators, the generated program
* thing that should be in that file.  Since this program is distributed in
* all three configurations, simply selecting a different calculator in that
* file is not considered making a modified version.  For the TI-92, you need
* to use use the Fargo II toolkit to assemble it, and have Fargo II on the
* calculator to run it.  For the other calculators, the generated program
* does not need any kernel; necessary build tools are supplied with TEOS,
* DoorsOS, and PlusShell.
*
********

        INCLUDE which.h    

    IFD ti89    
ti89d   set     1                       ; Use a small display.  Move
                                        ; this outside this condition
                                        ; to test TI-89 display on
                                        ; other calculators, while
                                        ; keeping TI-92(+) key map.
_ti89:
        XDEF    _ti89          
    ENDIF   

    IFD ti92plus
_ti92plus:
        XDEF    _ti92plus
    ENDIF

    IFD ti92
        INCLUDE tios.h  
    ENDIF

    IFND ti92
_nostub:
        XDEF    _nostub
LCD_MEM equ     $4c00
    ENDIF

        XDEF    _main   
        XDEF    _comment        

        INCLUDE version.h
        INCLUDE allecto.h       

******************************************** INITIALIZATION

        INCLUDE init.asm

        INCLUDE savegame.asm    

        lea     -offset(a7),a7          ; Allocate variables on stack
        lea     (a7),a5                 ; Set pointer to variables
        lea     $600000,a6              ; Allow relative port addressing

        bsr     Data_Initialize         ; Set up initial data
        bsr     Initialize_Stuff        ; Set up initial screen

        lea     trigger(pc),a0
        move.l  a0,($74).w

        bsr     Allecto_Title_Screen    
        bsr     Data_Initialize_2

******************************************** MAIN LOOP

Pre_Main_Loop:
        move.w  #$400,d0                ; Shut off unneeded interrupts
        trap    #1      
    IFND ti89d   
        move.w  #$d1,d0                 ; Set timer interrupt frequency
    ENDIF   
    IFD ti89d   
        move.w  speed(a5),d0            ; Set timer interrupt frequency
    ENDIF
        bsr     Set_Speed

    IFND ti89d
        bsr     Build_Side_Data         ; Prepare side data
    ENDIF

        bsr     Status_Prepare          ; Re-initialize status bar

    ;    move.w  #20000,cash(a5)
    ;    bsr     Allecto_Shop

Main_Loop:
                                        ; Decrement time bonus
        sf      flags(a5)       
        addq.l  #1,cycle_counter(a5)
        tst.l   time_bonus(a5)  
        beq.s   time_ran_out    
        subq.l  #5,time_bonus(a5)       
time_ran_out:
    IFND ti89d                          ; On calculators other than
        BSR     Scroll_Side             ; TI-89, redraw screen sides and
    ENDIF                               ; clear rest of screen
    IFD ti89d   
        bsr     Clear_Screen_Main       ; On TI-89, clear screen
    ENDIF   
        bsr     Timer_Delay             ; Wait for next 30th of second
        bsr     Move_Enemies            ; Move enemy ships
        bsr     Draw_Enemies            ; Draw enemy ships
        bsr     Player_Weapon_Select    ; Allow player to select weapon
        bsr     Draw_Player             ; Draw/handle player's ship
        bsr     Enemy_Bullets           ; Everything with enemy bullets
        bsr     Player_Bullets_Shoot    ; Fire player bullets
        bsr     Special_Weapon_Shoot    
        bsr     Player_Bullets          ; Move/draw player bullets
        BSR     Display_Screen          ; Copy buffer toe actual screen
        bsr     Enemy_Collisions        ; Check enemy-to-bullet hits
    IFND ti89    
        MOVE    #$FEFF,$18(a6)          ; Load key mask for testing ESC
    ENDIF   
    IFD ti89    
        move.w  #$fff7,$18(a6)          ; Load key mask for testing .
    ENDIF   
        tst.w   player_dmg(a5)          ; End the game if the player
        blt.s   Game_Lose               ; has been destroyed.
        tst.w   enemies_remaining(a5)   ; Go to the next level if no
        bne.s   level_not_done          ; enemies remain.
        bsr     Next_Level      
        move.w  #$400,d0        
        trap    #1
        bsr     Timer_Delay
        clr.w   slow_flag(a5)
        bra.s   Main_Loop       
level_not_done:
    IFD ti89    
        BTST    #0,$1b(a6)              ; Test status of . key and
        BNE.S   Main_Loop               ; continue game if not pressed.
    ENDIF   
    IFND ti89    
        BTST    #6,$1b(a6)              ; Test status of ESC key and
        BNE.S   Main_Loop               ; continue game if not pressed.
        BTST    #5,$1b(a6)              ; Test status of MODE key and
        BNE.S   Main_Loop               ; continue game if not pressed.
    ENDIF   

******************************************** GAME OVER

Game_Over:
        lea     offset(a5),a7
Wait_No_Key:
        MOVE    #$0000,$18(a6)          ; Mask to read all keys

        nop     
        nop     
        nop     
Wait_Key:
                                        ; Wait for all keys to be
        MOVE.B  $1b(a6),D0              ; released
        CMPI.B  #$FF,D0
        BNE.S   Wait_Key
        RTS     

Game_Lose:
        moveq   #0,d0                   ; Re-activate all interrupts
        trap    #1      
        bsr     Display_High_Scores     
        bra.s   Game_Over       

******************************************** DAMAGE TO PLAYER'S SHIP (D5+1)

Player_Damage:
        tst.w   d5                      ; If damage is negative, go to
        blt.s   player_cash             ; money adding

        move.w  player_dmg(a5),d0       ; D0 = shield status
    IFND ti89d   
        lea     LCD_MEM+121*30,a0       ; A0 = bar address on screen
    ENDIF   

Player_Damage_Loop:
                                        ; Erase bar, decrement status
        subq.w  #1,d0   
        bge.s   not_dead
        tst.w   player_armor(a5)        
        beq.s   not_dead        
        subq.w  #1,player_armor(a5)     
        moveq   #0,d0   
not_dead:
    IFND ti89d   
        sf      -1(a0,d0.w)      
    ENDIF   
        dbra    d5,Player_Damage_Loop   
        move.w  d0,player_dmg(a5)       ; Store new status
    IFD ti89d   
        bra     Status_Prepare  
    ENDIF   
    IFND ti89d   
        rts     
    ENDIF   

player_cash:
        sub.w   d5,cash(a5)             ; Add to current money
        cmp.w   #25000,cash(a5) 
        bmi.s   cash_ok 
        move.w  #25000,cash(a5)         ; Limit max money to 25000
cash_ok:
        rts     

******************************************** INITIALIZE DATA

Data_Initialize:
        lea     (a5),a4                 ; Clear the memory area
        move.w  #((data_end)/4)-1,d0    
        moveq   #0,d1   
loop_clear:
        move.l  d1,(a4)+        
        dbra    d0,loop_clear
        clr.w   trigger_flag
    IFND ti89d   
        lea     sides_data(a5),a4       ; Initialize side data
        moveq   #15,d0  
        lea     Sides_Pattern_End,a1    
loop_side_gen:
        move.l  -(a1),(a4)+     
        dbra    d0,loop_side_gen        
    ENDIF   
        rts     

Data_Initialize_2:
        move.w  #0,weapon_selected(a5)  
        cmp.w   #4,difficulty(a5)       
        bne.s   not_too_hard    
        move.w  #15,player_dmg(a5)      
not_too_hard:

        tst.b   cheated(a5)
        bne.s   cheater
        move.w  #-10,fire_delay(a5)     
        move.b  #%00000001,weapons_available(a5)     
cheater:   
        clr.w   cash(a5)        
        move.w  #15,num_b(a5)   
        move.l  #144000,time_bonus(a5)  

New_Ship:
        move.w  #31,player_dmg(a5)      
        moveq   #100,d0 
        move    d0,player_yc(a5)        ; Set up game statistics
        move    d0,player_xc(a5)        
        bra     Load_Player             ; Load ship specifications

******************************************** INCLUDE SUBROUTINE FILES

        INCLUDE lib.asm 
        INCLUDE sprites.asm     
    IFND ti89d   
        INCLUDE sides.asm       
    ENDIF   
        INCLUDE player.asm      
        INCLUDE shop.asm        
        INCLUDE display.asm     
        INCLUDE title.asm       
        INCLUDE endgame.asm     
        INCLUDE collide.asm     
        INCLUDE enemies.asm     
        INCLUDE edestroy.asm    
        INCLUDE eshoot.asm      
        INCLUDE levels.asm      
        INCLUDE shoot.asm       
        INCLUDE bullets.asm     
        INCLUDE ebullets.asm    
        INCLUDE freeship.asm    

******************************************* DISPLAY TIMING VARIABLES

trigger_flag:                           ; Set on int5
        dc.w    0

        END     
