// C Source File
// Created 4/6/04; 10:22:21 AM

// Delete or comment out the items you do not need.
#define COMMENT_STRING         "Breakdown game"
#define COMMENT_PROGRAM_NAME   "BreakDown"
#define COMMENT_VERSION_STRING "Version 1.3"
#define COMMENT_VERSION_NUMBER 0,0,0,0 /* major, minor, revision, subrevision */
#define COMMENT_BW_ICON \
	{0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
0b0000000000000000}
#define COMMENT_GRAY_ICON \
	{0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000}, \
	{0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
	0b0000000000000000, \
0b0000000000000000}

#include <tigcclib.h>
#include "Sprites.h"
#include "extgraph.h"

int ball_x=80;
int ball_y=86;
int paddle_x=75;
int paddle_y=89;
static int balldir=0;
int gamespeed=1;
int hitpix_x;
int hitpix_y;
int launchdir=3;
static int ballcnt=5;
static int score=0;
static int highscore=0;
int exit_prog=0;
int toughgame=0;
int exitgame=0;
int paddlewidth=24;
int launchdold=3;
int xmove=1;
int ymove=1;
int blockx[]={5,27,49,71,93,115,137,5,27,49,71,93,115,137,5,27,49,71,93,115,137,5,27,49,71,93,115,137,5,27,49,71,93,115,137,5,27,49,71,93,115,137,5,27,49,71,93,115,137};
//int blockx[]={2,22,42,62,82,102,122,142,2,22,42,62,82,102,122,142,2,22,42,62,82,102,122,142,2,22,42,62,82,102,122,142,2,22,42,62,82,102,122,142,2,22,42,62,82,102,122,142};
int blocky[]={5,5,5,5,5,5,5,20,20,20,20,20,20,20,35,35,35,35,35,35,35,50,50,50,50,50,50,50,65,65,65,65,65,65,65};
//int blocky[]={5,5,5,5,5,5,5,5,15,15,15,15,15,15,15,15,25,25,25,25,25,25,25,25,35,35,35,35,35,35,35,35,45,45,45,45,45,45,45,45,55,55,55,55,55,55,55,55,65,65,65,65,65,65,65,65};
//int showblock[]={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2};
static int showblock[]={3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3};
INT_HANDLER OldInt1 = NULL;
volatile int Counter = 0;



//prototypes
void AboutAuthor();
void Autoshift();
void CheckColide();
void DirMask(int x, int y);
void DrawControlsHlp();
void EraseBlock(int x, int y);
void Help(void);
void InputStr (char *buffer, short maxlen,char *message);
char *IntToStr (unsigned long an_integer);
void LArrows(int x, int y);
void MoveBall();
void MovePaddle();
void RedrawScreen(void);
int ReadFile(void);//returns 0 on error or 1 if ok.
void ShowSplashScreen();
void StartGame();
CALLBACK void Tics (void);



DEFINE_INT_HANDLER(MyInt1)
{
	Tics();
	ExecuteHandler (OldInt1);
}


// Main Function
void _main(void)
{	
	exitgame=0;
	ShowSplashScreen();
	ReadFile();
	 	 RedrawScreen();
		 OldInt1 =  GetIntVec (AUTO_INT_1);
		 
		 SetIntVec (AUTO_INT_1, MyInt1);
		 GKeyFlush ();	 
		 while(exitgame!=1)
		 {
			 if(_keytest(RR_ESC))
				 if(_keytest(RR_ESC))
					 exitgame=1;
				 while(Counter<gamespeed){};
				 
				 
				 Counter=0;
				 MovePaddle();
				 MoveBall();
				 CheckColide();		
				 
				 
				 FontSetSys (F_4x6);
				 printf_xy(5,95,"HighScore: %d Score: %d",highscore,score);
				 printf_xy(110,95,"Ball: %d",ballcnt);
				 if(_keytest(RR_CLEAR))
				 {
					 StartGame();
					 balldir=0;
					 ballcnt=5;
					 
				 }
				 else if(_keytest(RR_F1))
					 DrawControlsHlp();
				 else if(_keytest(RR_F2))
					 Help();	
		 } 
		 
		 GKeyFlush ();	 
		 SetIntVec (AUTO_INT_1, OldInt1);
		 clrscr();
		 
		 FILE *f = fopen ("BDwnDB", "w");
		 fputs (IntToStr (highscore), f);
		 fclose (f);
		 
		 
		 
		 
}

CALLBACK void Tics (void)
{
	Counter++;
	if(Counter>350)
		Counter=0;
	
}

char *IntToStr (unsigned long an_integer)
{
	static char result [] = "          \0";    // 10 spaces and \0
	char *ptr = result + 10;
	while (an_integer)
	{
		*ptr-- = an_integer % 10 + '0';
		an_integer/=10;
	}
	return ptr;
}
void Autoshift()
{
	int loop=0;
	DrawLine (0,0, 159, 0, A_REVERSE);
	DrawLine (0,1, 159, 1, A_REVERSE);
	score+=100;
	for(loop=27;loop>6;loop--)//shift the showblock 7 counts
	{
		showblock[loop]=showblock[loop-7];
	}
	for(loop=0;loop<15;loop++)//erase the ball and scroll 15 lines
	{
		Sprite8(ball_x,ball_y+loop,8,ballmask, LCD_MEM,SPRT_AND);
		ScrollDown160(LCD_MEM,76);
		
		
	}
	for(loop=0;loop<7;loop++)//draw top row of blocks
	{
		showblock[loop]=1;
		Sprite16(blockx[loop],blocky[loop],4,blocklong, LCD_MEM,SPRT_XOR);
		
	}
	
	//redraw frame
	DrawLine (0,0, 159, 0, A_THICK1);
	DrawLine(158,0,158,90,A_THICK1);
	DrawLine(0,0,0,99,A_THICK1);
	//show ball
	Sprite8(ball_x,ball_y,8,ball, LCD_MEM,SPRT_XOR);
	
}
void EraseBlock(int x, int y)
{
	int loop=0;
	int check=0;
	int cnt=0;	
	check=0;
	cnt=0;
	for(loop=0;loop<28;loop++)
	{
		if(x>=blockx[loop]&&x<=blockx[loop]+15&&y>=blocky[loop]&&y<blocky[loop]+4&&showblock[loop]>0)
		{
			showblock[loop]-=1;
			if(showblock[loop]==0)
			{
				Sprite16(blockx[loop],blocky[loop],4,blocklong, LCD_MEM,SPRT_XOR);
				score+=10;	
			}
			
			
			loop=100;
			
		}
	}
	
	
	for(check=21;check<28;check++){
		if(showblock[check]>0)	
			cnt++;
	}			
	if(cnt==0)
		Autoshift();				
	
}

void CheckColide()
{
	int dir=0;
	if(balldir!=0)
	{
		
		if(balldir<4)
		{
			if(GetPix(ball_x,ball_y)&&balldir<4){//upper left corner hit
				dir=1;
				hitpix_x=ball_x;
				hitpix_y=ball_y;
			}
			if(GetPix(ball_x+4,ball_y-1)&&balldir<4){//top middle hit
				dir=2;
				hitpix_x=ball_x+4;
				hitpix_y=ball_y-1;
			}
			if(GetPix(ball_x+8,ball_y)&&balldir<4){//upper right corner hit
				dir=3;
				hitpix_x=ball_x+8;
				hitpix_y=ball_y;
			}
			if(GetPix(ball_x-1,ball_y+4)){//left side hit
				dir=7;
				hitpix_x=ball_x-1;
				hitpix_y=ball_y+4;
			}
			if(GetPix(ball_x+9,ball_y+4)){//right side hit
				dir=8;	
				hitpix_x=ball_x+9;
				hitpix_y=ball_y+4;
			}
			EraseBlock(hitpix_x,hitpix_y);
			
		}
		else
		{
			if(GetPix(ball_x,ball_y+8)){//bottom left hit
				dir=4;
				hitpix_x=ball_x;
				hitpix_y=ball_y+8;
			}
			if(GetPix(ball_x+4,ball_y+8)){//bottom middle hit
				dir=5;
				hitpix_x=ball_x+4;
				hitpix_y=ball_y+8;
			}
			if(GetPix(ball_x+8,ball_y+8)){//bottom right hit
				dir=6;
				hitpix_x=ball_x+8;
				hitpix_y=ball_y+8;
			}
			if(GetPix(ball_x-1,ball_y+4)){//left middle hit
				dir=7;
				hitpix_x=ball_x-1;
				hitpix_y=ball_y+4;
			}
			if(GetPix(ball_x+9,ball_y+4)){//right middle hit
				dir=8;	
				hitpix_x=ball_x+9;
				hitpix_y=ball_y+4;
			}
			EraseBlock(hitpix_x,hitpix_y);
			
			
		}
		
		
		
		
		switch(dir)
		{
		case 0:
			break;
		case 1://ball moving up/left
		case 2://ball moving up
		case 3://ball moving up/right
			if(balldir<4)
				balldir+=3;
			
			break;
		case 4://ball moving down/left
		case 5://ball moving down
		case 6://ball moving down/right
			if(balldir>3)
				balldir-=3;
			
			break;
		case 7:
			
			if(balldir==1)
				balldir=3;
			if(balldir==4)
				balldir=6;
			if(balldir==2)
				balldir=5;
			break;		
		case 8:
			if(balldir==3)
				balldir=1;
			
			if(balldir==6)
				balldir=4;
			if(balldir==5)
				balldir=2;
			break;
		}
		
		
		
		
		//check for paddle hit	
		if(ball_y+8>=paddle_y-1&&ball_y+8<paddle_y+5&&ball_x>=paddle_x-2&&ball_x+2<paddle_x+paddlewidth&&launchdir==0)
		{
			if(ball_x+4<paddle_x+(paddlewidth/2))//ball hit left
			{
				if(_keytest(RR_LEFT))
					xmove=2;
					else xmove=1;
				balldir=1;
					
			}
			else if(ball_x+4>paddle_x+(paddlewidth/2))//ball hit right
			{
				if(_keytest(RR_RIGHT))	
					xmove=2;
					else xmove=1;
					
				balldir=3;
				
			}
			else if(ball_x+4==paddle_x+(paddlewidth/2)) //if(ball_x+4>paddlewidth/3*2&&ball_x+4<paddle_x+paddlewidth)//ball hit middle
			{
				balldir=2;
				
			}
			
		}
		
	}	
	
}

void MoveBall()
{
	Sprite8(ball_x,ball_y,8,ball, LCD_MEM,SPRT_XOR);//erase ball first before move
	switch(balldir)
	{
	case 0://ball on paddle
		ball_x=paddle_x+(paddlewidth/2-4);
		ball_y=paddle_y-8;
		if(_keytest(RR_UP)&&ballcnt>0)
		{
			balldir=launchdir;
			xmove=1;
			ymove=1;
			LArrows(paddle_x, paddle_y);
			if(launchdir==3&&paddlewidth==16)
			{
				if(paddlewidth==16)
					Sprite16(paddle_x,paddle_y,5,right, LCD_MEM,SPRT_XOR);
				else
					Sprite32(paddle_x,paddle_y,5,right32,LCD_MEM,SPRT_XOR);
				
			}
			else if(launchdir==1&&paddlewidth==16)
			{
				if(paddlewidth==16)
					Sprite16(paddle_x,paddle_y,5,left, LCD_MEM,SPRT_XOR);
				else
					Sprite32(paddle_x,paddle_y,5,left32,LCD_MEM,SPRT_XOR);
				
			}		
			launchdold=launchdir;	
			launchdir=-1;
			
		}
		if(_keytest(RR_DOWN))
		{
			LArrows(paddle_x,paddle_y);
			if(launchdir==3)
			{
				launchdir=1;
			}
			else
			{
				launchdir=3;
			}
			LArrows(paddle_x,paddle_y);
		
			while(_keytest(RR_DOWN))
			{
				
			}
		}
		
		
		break;
	case 1://ball moving up/left
		if(ball_x>=xmove)
			ball_x-=xmove;
		else 
		{
		balldir=3;
		}
		if(ball_y>=ymove)
			ball_y-=ymove;
		else balldir=4;
		break;
	case 2://ball moving up
		if(ball_y>ymove)
			ball_y-=ymove;
		else {
			ball_y+=ymove;
			balldir=5;
		}
		break;
	case 3://ball moving up/right
		if(ball_x<151-xmove)
			ball_x+=xmove;
		else balldir=1;
		if(ball_y>ymove)
			ball_y-=ymove;
		else balldir=6;
		break;
	case 4://ball moving down/left
		if(ball_x>=xmove)
			ball_x-=xmove;
		else balldir=6;
		if(ball_y<110-ymove)
			ball_y+=ymove;
		else balldir=1;
		break;
	case 5://ball moving down
		if(ball_y<110-ymove)
			ball_y+=ymove;
		else balldir=2;
		break;
	case 6://ball moving down/right
		if(ball_x<151-xmove)
			ball_x+=xmove;
		else balldir=4;
		if(ball_y<110-ymove)
			ball_y+=ymove;
		else balldir=3;
		break;
	case 7:
		break;
	case 8:
		break;
	}
	
	if(ball_y<75&&launchdir==-1)
		launchdir=0;
	Sprite8(ball_x,ball_y,8,ball, LCD_MEM,SPRT_XOR);
	if(ball_y>paddle_y-4)//ball half way down paddle is lost
	{
		ballcnt-=1;
		Sprite8(ball_x,ball_y,8,ball, LCD_MEM,SPRT_XOR);//erase old one
		balldir=0;
		launchdir=launchdold;
		ball_y=paddle_y-8;
		ball_x=paddle_x+4;
		Sprite8(ball_x,ball_y,8,ball, LCD_MEM,SPRT_XOR);
		LArrows(paddle_x,paddle_y);
	}
	
}
void DirMask(int x, int y)
{
	if(paddlewidth==16)
	{
		
	}
	else
	{
		Sprite16(x+1,y,5,dirmask,LCD_MEM,SPRT_AND);
		Sprite16(x+7,y,5,dirmask,LCD_MEM,SPRT_AND);
		
	}
	
}
void LArrows(int x, int y)
{
	if(launchdir==3&&balldir==0)
	{
		if(paddlewidth==16)
			Sprite16(x,y,5,right, LCD_MEM,SPRT_XOR);
		else
			Sprite32(x,y,5,right32,LCD_MEM,SPRT_XOR);
		
	}
	else if(launchdir==1&&balldir==0)
	{
		if(paddlewidth==16)
			Sprite16(x,y,5,left, LCD_MEM,SPRT_XOR);
		else
			Sprite32(x,y,5,left32,LCD_MEM,SPRT_XOR);
		
	}
	else if(balldir>0)
	{
		
		DirMask(x,y);
	}
	
	
}

void MovePaddle(void)
{
	int y=paddle_y;
	int x=paddle_x;
	if( _keytest (RR_LEFT))
	{
		if(paddlewidth==16)
			Sprite16(x,y,5,paddle, LCD_MEM,SPRT_XOR);
		else
			Sprite32(x,y,5,paddle32,LCD_MEM,SPRT_XOR);
		LArrows(x,y);
		if(x>6)
			x-=4;
			else x=2;
		
		LArrows(x,y);
		
		if(paddlewidth==16)
			Sprite16(x,y,5,paddle, LCD_MEM,SPRT_XOR);
		else
			Sprite32(x,y,5,paddle32,LCD_MEM,SPRT_XOR);
	}
	
	if( _keytest (RR_RIGHT))
	{
		
		if(paddlewidth==16)
			Sprite16(x,y,5,paddle, LCD_MEM,SPRT_XOR);
		else
			Sprite32(x,y,5,paddle32,LCD_MEM,SPRT_XOR);
		
		LArrows(x,y);
		if(x<155-paddlewidth)
			x+=4;
			else x=158-paddlewidth;
		
		LArrows(x,y);
		if(paddlewidth==16)
			Sprite16(x,y,5,paddle, LCD_MEM,SPRT_XOR);
		else
			Sprite32(x,y,5,paddle32,LCD_MEM,SPRT_XOR);
	}
	
	paddle_x=x;
	paddle_y=y;
	

	
}


int ReadFile()
{
	char str[18]="  ";	
	FILE *f;
	
	f = fopen ("BDwnDB", "r");
	
	if(!f)
	{
		
		return 0;	
	}
	
	fread (str, 1,9, f);
	if(highscore==0&&atoi(str)>0)
	{
		clrscr();
		printf_xy(5,40,"Restoring highgame from file...");	
		highscore=atoi(str);
		ngetchx();
	}
	
	fclose (f);
	return 1;
}

void ShowSplashScreen()
{
	FontSetSys (F_8x10);
	clrscr();
	printf_xy(10,5,"    BreakDown");
	printf_xy(10,15,"   Version 1.3");
	FontSetSys (F_4x6);
	printf_xy(50,30,"<--  - Paddle left");
	printf_xy(50,40,"-->  - Paddle right");
	printf_xy(50,50,"CLEAR- Start new game");
	printf_xy(50,60,"ESC  - EXIT game!");
	printf_xy(50,70,"UP   - Launch Ball");
	printf_xy(50,80,"DWN  - Aim ball");
	printf_xy(40,90,"By: Danny H. Newport");
	
	ngetchx();	
}

void RedrawScreen(void)
{
	clrscr();
	int loop=0;
	
	Sprite8(ball_x,ball_y,8,ball, LCD_MEM,SPRT_XOR);
	if(paddlewidth==16)
		Sprite16(paddle_x,paddle_y,5,paddle, LCD_MEM,SPRT_XOR);
	else
		Sprite32(paddle_x,paddle_y,5,paddle32,LCD_MEM,SPRT_XOR);
	LArrows(paddle_x, paddle_y);
	DrawLine (0,0, 159, 0, A_THICK1);
	DrawLine(158,0,158,99,A_THICK1);
	DrawLine(0,0,0,99,A_THICK1);
	
	//draw a few blocks
	for(loop=0;loop<28;loop++)	{
		if(showblock[loop]>0)
			Sprite16(blockx[loop],blocky[loop],4,blocklong, LCD_MEM,SPRT_XOR);
		
	}
	FontSetSys (F_4x6);
	printf_xy(5,95,"HighScore: %d Score: %d",highscore,score);
	printf_xy(110,95,"Ball: %d",ballcnt);
	
}
void StartGame()
{
	int loop=0;
	launchdir=3;
	for(loop=0;loop<28;loop++)
		showblock[loop]=1;
	if(highscore<score)
		highscore=score;
	score=0;
	
	RedrawScreen();
	
}


void AboutAuthor()
{
	clrscr();		//clear the screen
	printf_xy(0, 0, "      BreakDown" );   // display the string
	printf_xy(0,10,"   by: Danny H. Newport");
	printf_xy(0,20,"     ");				
	printf_xy(0,30,"Homepage:");
	printf_xy(0,40,"www.danny-newport.com");				
	printf_xy(0,70,"Email:");
	printf_xy(0,80,"dannynewp@aol.com");
	printf_xy(0,90,"press any key to cont.!");	
	ngetchx();
	clrscr();		//clear the screen	
	
}

/*
*get string from keyboard for answers
*/
void InputStr (char *buffer, short maxlen,char *message)
{
	SCR_STATE ss;
	short key, i = 0;
	buffer[0] = 0;
	SaveScrState (&ss);
	ss.CurX=5;
	ss.CurY=40;
	do
    {
		MoveTo (ss.CurX, ss.CurY);
		printf ("%s %s_  ", message, buffer);
        // Two spaces are required if F_4x6 font is used
		key = ngetchx ();
		if(key== KEY_ESC)
		{
			key=KEY_ENTER;
			exit_prog=1;
		}
		if (key >= ' ' && key <= '~' && i < maxlen) buffer[i++] = key;
		if (key == KEY_BACKSPACE && i) i--;
		buffer[i] = 0;
    } while (key != KEY_ENTER);
}


void DrawControlsHlp()
{
	clrscr();
	printf_xy(0,0, "F1    -This help");
	printf_xy(0,10,"F2    -Program Options");
	printf_xy(0,20,"UP    -Launch Ball   ");
	printf_xy(0,30,"DOWN  -Aim Ball on Paddle");
	printf_xy(0,40," ");
	printf_xy(0,50,"Clear -Start a New game"); 
	printf_xy(0,60,"ESC   -Exit Game");
	printf_xy(0,70,"");
	printf_xy(0,80,"Arrow keys - control paddle");
	printf_xy(0,90,"Press a key to continue...");
	ngetchx();
}



void Help(void)
{
	char buffer[25]="6  ";
	clrscr();
	
	HANDLE handle = PopupNew ("Options", 80);
	PopupAddText (handle, -1, "View Author Info", 1);
	PopupAddText (handle, 0, "Options:", 2);
	PopupAddText (handle, 0, "Help:", 3);
	PopupAddText (handle, -1, "Exit Game", 12);
	PopupAddText (handle, 2, "Reset HighScore", 4);
	PopupAddText (handle, 2, "Set Game Speed", 5);
	PopupAddText (handle, 2, "Easy Game", 10);
	PopupAddText (handle, 2, "Hard Game", 11);
	PopupAddText (handle, 3, "Controls", 7);
	short result = PopupDo (handle, CENTER, CENTER, 0);
	GKeyFlush ();	 
	switch(result)
	{
	case 0:
		
		break;
	case 1:
		AboutAuthor();
		break;
	case 2:
		
		break;
	case 3:
		
		break;
	case 4:
		highscore=0;
		break;
	case 5:
		InputStr (buffer, 3,(char*)"Game Speed(0-20): ");
		gamespeed=20-atoi(buffer);
		break;
	case 6:
		//	gamespeed=6;
		
		break;
   	case 7:	
		DrawControlsHlp();
		break;
		
	case 8:
		
		break;
	case 9:
		
		break;
	case 10:
		toughgame=0;
		paddlewidth=24;
		break;
	case 11:
		toughgame=1;
		paddlewidth=16;
		break;
	case 12:
		exitgame=1;
		break;	
	}
	HeapFree (handle);
	
	RedrawScreen();
	
}

