#ifndef __tiletools__
#define __tiletools__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   tiletools.h                                                           *
*			Description:  			                  *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/



#define tiles_non_solid_low									  0
#define tiles_non_solid_high								101

#define tiles_solid_low											102
#define tiles_solid_high										255

#define tiles_liquid_low										58
#define tiles_liquid_high										63

#define tiles_hostile_low										72
#define tiles_hostile_high									101

#define tiles_hostile_shootable_low						73
#define tiles_hostile_shootable_high					81

#define tiles_hostile_bush_low								80
#define tiles_hostile_bush_high								81

#define tiles_solid_bombable_low							237		
#define tiles_solid_bombable_high							244

#define tiles_solid_shootable_low							243			
#define tiles_solid_shootable_high						246

#define tiles_solid_shootable_respawn_low			247			
#define tiles_solid_shootable_respawn_high		248

#define tiles_solid_missile_shootable_low			249			
#define tiles_solid_missile_shootable_high		255

#define tile_lava															98
#define tile_lava2														101



#define NrOfRespawnTiles											6

#define TileRespawnTime												180

#define TileRespawnAnimTime										6

//#define RespawnTileIdxDist										132
#define RespawnTileIdxDist										152
#define WhiteRespawnTile											248


typedef struct{
	//To be used for tiles than can be shot and then reappears after some time
	short X;
	short Y;
	short ActiveTimer;
	unsigned char OriginalTile;
}respawningTile;

extern respawningTile RespawningTiles[NrOfRespawnTiles];

void RespawnTiles();

//void ReplaceTile(unsigned char OldTile,unsigned char NewTile);

void RemoveLavaAndDoors();

void ReplaceNonSolidByLava();


unsigned char GetTile(short X,short Y);

void PutTile(short X,short Y,unsigned char Tile);

short FreeLeft(short X,short Y,short Height);

short FreeRight(short X,short Y,short Height);

short FreeUp(short X,short Y,short Width);

short FreeDown(short X,short Y,short Width);


void InitializeTilemap();



#endif