#ifndef __starfield__
#define __starfield__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   starfield.h                                                           *
*                                                                                   *
*			Description:                                                                  *
*			This file contains functions and definitions to render the starfield effect 	*
*			used in the titlescreen and menu screens of Metroid 68K.											*
*																																										*
*			It is based on the "starfield effect demo" made by TICT (tict.ticalc.org)			*
*			Some modifications have been done to suit the needs for Metroid 68K:					*
*				-Inverted colors: Displaying white and gray stars on black background, 			*
*				 instead of the opposite																										*
*				-Stripped down the code to remove unneeded stuff like:											*
*				-Removal of stars before redrawing them: This is not necessarry 						*
*				 in this case, because the screen is filled with black each frame. 					*
*				 This is slower, but speed is not essential in this case.										*
*				-Deleted code for adjustment of contrast: Metroid 68K 											*
*				 already have it's own contrast adjustment.																	*
*				-Deleted code for adjustment of speed and number of stars.									*
*																																										*
*                                                                                   *
*                                                                                   *
************************************************************************************/


#define XOFFSET      (screen_width>>1)
#define YOFFSET      (screen_height>>1)
#define ZOFFSET      254
#define MAX_STAR_X   (RAND_MAX)
#define MAX_STAR_Y   (RAND_MAX)
#define MAX_STARX2   (MAX_STAR_X>>1)
#define MAX_STARY2   (MAX_STAR_Y>>1)
#define BORDER_BLACK 90
#define BORDER_GRAY  140


#ifdef MakeTI89
#define MAX_NUMBER_STARS 		750
#define MIN_NUMBER_STARS   	100
#define number_stars				500
#endif
#ifdef MakeTI92Plus
#define MAX_NUMBER_STARS 		1000
#define MIN_NUMBER_STARS   	140
#define number_stars				750
#endif
#ifdef MakeV200
#define MAX_NUMBER_STARS 		1000
#define MIN_NUMBER_STARS   	140
#define number_stars				750
#endif

#define NUMBER_STARS_INCREMENT  20                 // number of stars changed by each keypress

#define MAX_ZDECREMENT            9   // maximum "speed" in forward direction
#define MIN_ZDECREMENT           -9   // maximum "speed" in backward direction


#define zdecrement			4




/*---------------------------------------------------------------------------*/
/* structure which stores a star's location                                  */
/*---------------------------------------------------------------------------*/
typedef struct {
    short offset;  // offset of old location for cleanup
    unsigned char bitnumber;    // inverted mask of old location for cleanup
    unsigned char z;
    short x,y;
} star_type;


extern star_type* stars;


void CreateStar(star_type *ptr);

void InitStarField();

void DrawStars(void);

void StarFieldAnim();







#endif