
#include "all.h"

void StarFieldAnim(){
	// Draw black screen
		memset(GrayDBufGetHiddenPlane(LIGHT_PLANE),0xFFFF,LCD_SIZE);
		memset(GrayDBufGetHiddenPlane(DARK_PLANE),0xFFFF,LCD_SIZE);
	
		// Run 1 iteration of the starfield effect
		DrawStars();
};

star_type* stars;

void CreateStar(star_type *ptr) {
    ptr->x = random(RAND_MAX)-(RAND_MAX>>1);
    ptr->y = random(RAND_MAX)-(RAND_MAX>>1);
    if (zdecrement > 0) {
        ptr->z = ZOFFSET;
    }
    else {
        ptr->z = random(ZOFFSET-10)+1;
    }
};

void InitStarField(){
	
	stars = FgPlane.p.big_vscreen;
	
	short i;
	// setup initial star positions

	star_type *ptr=&stars[0];
	for (i=0;i<MAX_NUMBER_STARS;i++) {
		ptr->x = random(MAX_STAR_X)-(MAX_STARX2);
		ptr->y = random(MAX_STAR_X)-(MAX_STARY2);
		ptr->z = random(ZOFFSET-1)+1;
		ptr->offset = -1;
		ptr++;
	};
	
};

void DrawStars(void) {
    short         offset;
    unsigned char bitnumber;
    short         drawx;
    short         drawy;
    short         i;
    star_type    *ptr;
    void         *light;
    void         *dark;
		
	//	#define ClearBitClip(addr,bit)  (if(adr<LCD_SIZE) poke_bclr(addr,bit))
		
    ptr = &stars[0];
    light = GrayDBufGetHiddenPlane(LIGHT_PLANE);//GrayGetPlane(LIGHT_PLANE);
    dark = GrayDBufGetHiddenPlane(DARK_PLANE);//GrayGetPlane(DARK_PLANE);

    for (i=0;i<number_stars;i++) {
        // offset can't be > 32768, so checking for < 0 is enough.
        /* // Removed: No need to remove the stars in this case. 
        if (ptr->offset >= 0) {
            poke_bset(((unsigned char *)light)+ptr->offset,ptr->bitnumber);
            poke_bset(((unsigned char *)dark)+ptr->offset,ptr->bitnumber);
            ptr->offset = -1;
        }*/

        // calculate new drawing x position
        // and check if it out of screen
        drawx  = ptr->x / ptr->z + XOFFSET;
        if (drawx < 0 || drawx >= screen_width) {
            goto _CREATESTAR_;
        }

        // calculate new drawing y position
        // and check if it out of screen
        drawy  = ptr->y / ptr->z + YOFFSET;
        if (drawy < 0 || drawy >= screen_height) {
            goto _CREATESTAR_;
        }

        // calculate byte offset of pixel
        // We use this construct, because -Os will generate a mulu.w if we use *30.
        offset = (((((drawy)+(drawy))<<4)-((drawy)+(drawy)))+((drawx)>>3));

        // calculate bit number
        bitnumber = (~(drawx));

        // set pixel in plane 1 and/or plane2
        // depending on z value
        /*if (ptr->z < BORDER_GRAY) {
            poke_bclr(((unsigned char *)dark)+offset,bitnumber);
            if (ptr->z < BORDER_BLACK) {
                poke_bclr(((unsigned char *)light)+offset,bitnumber);
            }
        }
        else {
            poke_bclr(((unsigned char *)light)+offset,bitnumber);
        }*/
        if (ptr->z < BORDER_GRAY) {
            poke_bclr(((unsigned char *)dark)+offset,bitnumber);
            poke_bclr(((unsigned char *)light)+offset,bitnumber);
            if (ptr->z < BORDER_BLACK) {
                         	
            	poke_bclr(((unsigned char *)dark)+offset,bitnumber+1);
            	poke_bclr(((unsigned char *)dark)+offset,bitnumber-1);
            	
            	if(offset<(LCD_SIZE-30))	poke_bclr(((unsigned char *)dark)+offset+30,bitnumber);
            	if(offset>=30) 						poke_bclr(((unsigned char *)dark)+offset-30,bitnumber);
            }
        }
        else {
            poke_bclr(((unsigned char *)dark)+offset,bitnumber);
        }
        
        
        

        // store offset and bit number so that we can remove the pixel easily
        /* // Removed: No need to remove the stars in this case. 
        ptr->bitnumber = bitnumber;
        ptr->offset = offset;
				*/
				
        // decrement z and check if we must
        // generate a new star
        ptr->z -= zdecrement;
        if (ptr->z <= 0 || ptr->z > ZOFFSET) {
            _CREATESTAR_:
            CreateStar(ptr);
        }

        ptr++;
    };
    
    // Draw URL	
		DrawGrayStrExt2B(1,screen_height-6,URL,A_REVERSE|A_CENTERED,F_4x6,GrayDBufGetHiddenPlane(DARK_PLANE),GrayDBufGetHiddenPlane(LIGHT_PLANE));

}