
#include "all.h"




short SaveGame(short Slot){
	/*
	
	Saves a game to a given slot. 0-2 is valid slots
	
	Returns 0 if save is successfull.
	Returns an error code if save is unsuccessfull.
	
	*/
	
	#define RawBuffer				(FgPlane.p.big_vscreen+4096)
	#define BriefLZWorkMem	(FgPlane.p.big_vscreen)
	#define CompBuffer			(RawBuffer+4096)
	
	FgPlane.p.force_update = 1;
	
	short RawSize,CompSize;
	
	if( (Slot<0) || (Slot>2) ){
		return SaveLoadErrIndexOutOfBounds;
	};
	
	
	// Prepare data to be saved:
	// Using FgPlane.p.big_vscreen as temporary buffer for uncompressed data
	
	// -Player struct
	
	memcpy(RawBuffer,&Player,sizeof(player));
	
	// -All room data:
	//   -Room struct		
	//   -Enemies
	//   -Items
	//   -Tilemap
	
	#define RoomSize  ( sizeof(room)+Room->NrOfEnemies*sizeof(enemy)+Room->NrOfItems*sizeof(item)+max(16,Room->Height)*max(16,Room->Width) )
	
	
	memcpy(RawBuffer+sizeof(player),LevelArray,RoomSize);
 

	// -Visited rooms indicator 
	memcpy(RawBuffer+sizeof(player)+RoomSize,VisitedRooms,TotalNrOfRooms*sizeof(char));
 
	// -Global data:
	//   -Event array
	//   -Gamedata
	
	memcpy(RawBuffer+sizeof(player)+RoomSize+TotalNrOfRooms*sizeof(char),EventArray,NrOfEvents*sizeof(short));
	
	memcpy(RawBuffer+sizeof(player)+RoomSize+TotalNrOfRooms*sizeof(char)+NrOfEvents*sizeof(short),&Gamestate,sizeof(gamestate));
	
	RawSize = sizeof(player) + RoomSize + TotalNrOfRooms*sizeof(char) + NrOfEvents*sizeof(short) + sizeof(gamestate);
	
	// Compress data using CompBuffer as temporary buffer	
	CompSize = blz_pack(RawBuffer,CompBuffer,RawSize,BriefLZWorkMem);
	
		
	// Save to file: 
	HANDLE OldFile;
	short Fail = 0;
	
	retry:	
	
	if( (OldFile = File_get_pointer_and_lock(SaveFileName)) == H_NULL){
		// File not found: Generate blank save file and retry (try to find the newly generated file) 			
		// Only allow 2 failures before giving up. Prevents possible infinite loop.
		
		Fail++;
		savefile SaveFileData;	
		memset(&SaveFileData,0,sizeof(savefile));	
		SaveFileData.MagicNumber = SaveFileMagicNumber;	
		FILES NewFile;		
		FOpen (SaveFileName, &NewFile, FM_WRITE, "MSAV")!=FS_OK;	
		FWrite(&SaveFileData,sizeof(savefile),&NewFile);	
		FClose (&NewFile); 			
		
		if(Fail>=2){
			goto failure;
		}
		else{
			goto retry;
		};		
	};
	
	void* RawOld = HeapDeref(OldFile) + 2;// If we cone here, OldFile must be valid
	
	FILES NewFile;
	
	
	if(FOpen (TempSaveFileName, &NewFile, FM_WRITE, "MSAV")!=FS_OK){
		goto failure;
	};
	
	// Load old SaveFile header
	savefile SaveFileData,OldSaveFileData;
	memcpy(&SaveFileData,RawOld,sizeof(savefile));
	memcpy(&OldSaveFileData,RawOld,sizeof(savefile));
	
	// Modify offsets:
	short C,CurrOffset = sizeof(savefile);
	for(C=0;C<=2;C++){
		
		if(C!=Slot){
			if(OldSaveFileData.SlotOffset[C]>0){
				SaveFileData.SlotOffset[C] = CurrOffset;
				CurrOffset += OldSaveFileData.CompSize[C];
			}
		}
		else{
			SaveFileData.SlotOffset[C] = CurrOffset;
			CurrOffset += CompSize;
			SaveFileData.Roomsize[C] = RoomSize;
			SaveFileData.CompSize[C] = CompSize;
			SaveFileData.RawSize[C] = RawSize;
		};
	
	};
/*	
	DispNum(CompSize,RawSize,RoomSize,1);
	DispNum(SaveFileData.SlotOffset[0],SaveFileData.SlotOffset[1],SaveFileData.SlotOffset[2],10);
	DispNum(SaveFileData.Roomsize[0],SaveFileData.Roomsize[1],SaveFileData.Roomsize[2],20);
	DispNum(SaveFileData.CompSize[0],SaveFileData.CompSize[1],SaveFileData.CompSize[2],30);
	DispNum(SaveFileData.RawSize[0],SaveFileData.RawSize[1],SaveFileData.RawSize[2],50);
//	DispNum(short Num1,short Num2,short Num3,60);
	
	
	memset(GrayDBufGetActivePlane(LIGHT_PLANE),0,LCD_SIZE);
	memset(GrayDBufGetActivePlane(DARK_PLANE),0,LCD_SIZE);	
	
	DispNum(Player.X,Player.Y,GetTile(16*4,16*4),1);
	DispNum(Room->Height,Room->Width,GetTile(16*8,16*8),10);
	DispNum(EventArray[10],EventArray[10],Gamestate.FgX,20);
	*/
	
	// Write file header
	FWrite(&SaveFileData,sizeof(savefile),&NewFile);
	
	for(C=0;C<=2;C++){
		
		if(C!=Slot){
			
			if(OldSaveFileData.SlotOffset[C]){
				FWrite(RawOld+OldSaveFileData.SlotOffset[C],SaveFileData.CompSize[C],&NewFile);
			};
			
		}
		else{
			
			FWrite(CompBuffer,CompSize,&NewFile);
			
		};
		
	};	
	
	FClose (&NewFile); 	
	
	HeapUnlock (OldFile);
	
	// Unarchive old file
	if( !EM_moveSymFromExtMem ( SYMSTR(SaveFileName), HS_NULL ) ){
		goto failure;
	};
	
	// Delete old file
	SymDel ( SYMSTR (SaveFileName) );	
	
	// Rename new file
	SymMove (SYMSTR(TempSaveFileName), SYMSTR (SaveFileName));
	
	short FileSize = sizeof(savefile)+100;
	
	for(C=0;C<=2;C++){
		FileSize += SaveFileData.CompSize[C];
	};
	
	// Archive new file
	ArchiveFile(FileSize, SaveFileName);
	Load_GFX();
	
	// If we come here, the saving was successfull
	return 0;	
	
	#undef RawBuffer
	#undef BriefLZWorkMem
	#undef CompBuffer
	
	
	failure:
	
	#ifdef MakeTI89	
	#define TY			40	
	#endif
	#ifdef MakeTI92Plus		
	#define TY			54	
	#endif
	#ifdef MakeV200		
	#define TY			54	
	#endif
	
	
	// Draw Frame and white rect inside
/*	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),22,20,138,80,COLOR_DARKGRAY);
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),23,21,137,79,COLOR_DARKGRAY);

	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),24,22,136,78,COLOR_WHITE);//  COLOR_LIGHTGRAY  COLOR_WHITE
	*/
/*	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX,RY,RX+RW,RY+RH,COLOR_DARKGRAY);
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX+1,RY+1,RX+RW-1,RY+RH-1,COLOR_DARKGRAY);

	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX+2,RY+2,RX+RW-2,RY+RH-2,COLOR_WHITE);//  COLOR_LIGHTGRAY  COLOR_WHITE
*/
	
	DispFramedRectangle();
	
	// Draw text
	DrawGrayStrExt2B(0,TY,"Saving failed!",A_REPLACE|A_SHADOWED|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	
	WaitForKeyPress();
	
	
	return 5;		
	
	#undef TY

};

short LoadGame(short Slot){
	/*
	
	Loads a game from a given slot. 0-2 is valid slots
	
	Returns 0 if load is successfull.
	Returns an error code if load is unsuccessfull.
	
	*/	
	
	#define RawBuffer				(FgPlane.p.big_vscreen+4096)
	#define BriefLZWorkMem	(FgPlane.p.big_vscreen)
	
	
	memset(Blocks,0,max_nr_of_blocks*sizeof(block));	
	memset(Enemyshots,0,nr_of_enemy_shots*sizeof(shot));
	memset(PlayerShots,0,nr_of_player_shots*sizeof(shot));	
	memset(Objects,0,NrOfObjectSlots*sizeof(object));
	memset(RespawningTiles,0,NrOfRespawnTiles*sizeof(respawningTile));
	
	savefile SaveFileData;
	
	if( (Slot<0) || (Slot>2) ){
		return SaveLoadErrIndexOutOfBounds;
	};
	
	HANDLE SFile;
	if( (SFile = File_get_pointer_and_lock(SaveFileName)) ==H_NULL ){
		return SaveLoadErrInvalidSave;
	}
	
	void* RawData = HeapDeref(SFile) + 2;
	
	// Retrieve save file header	
	memcpy(&SaveFileData,RawData,sizeof(savefile));
	
	if(SaveFileData.SlotOffset[Slot]<=0){
		return SaveLoadErrInvalidSave;
	};
	
	/*
	DispNum(SaveFileData.SlotOffset[0],SaveFileData.SlotOffset[1],SaveFileData.SlotOffset[2],10);
	DispNum(SaveFileData.Roomsize[0],SaveFileData.Roomsize[1],SaveFileData.Roomsize[2],20);
	DispNum(SaveFileData.CompSize[0],SaveFileData.CompSize[1],SaveFileData.CompSize[2],30);
	DispNum(SaveFileData.RawSize[0],SaveFileData.RawSize[1],SaveFileData.RawSize[2],50);
	*/
	// Decompress data
	blz_depack(RawData+SaveFileData.SlotOffset[Slot],RawBuffer,SaveFileData.RawSize[Slot]);
		
	
//	memcpy(dest,src,len);
	
	memcpy(&Player,RawBuffer,sizeof(player));
	memcpy(LevelArray,RawBuffer+sizeof(player),SaveFileData.Roomsize[Slot]);
	memcpy(VisitedRooms,RawBuffer+sizeof(player)+SaveFileData.Roomsize[Slot],TotalNrOfRooms*sizeof(char));
	memcpy(EventArray,RawBuffer+sizeof(player)+SaveFileData.Roomsize[Slot]+TotalNrOfRooms*sizeof(char),NrOfEvents*sizeof(short));
	memcpy(&Gamestate,RawBuffer+sizeof(player)+SaveFileData.Roomsize[Slot]+TotalNrOfRooms*sizeof(char)+NrOfEvents*sizeof(short),sizeof(gamestate));
	

	
	HeapUnlock (SFile);
	
	
	Room = LevelArray;
	
	Enemies = LevelArray + sizeof(room);
	Items = ((void*)Enemies) + Room->NrOfEnemies*sizeof(enemy);
	FgPlane.p.matrix = ((void*)Items) + Room->NrOfItems*sizeof(item);
	
	FgPlane.p.width = Room->Width;	
	FgPlane.p.force_update = 1;
	
	short C;
	for(C=0;C<Room->NrOfEnemies;C++){
		if(Enemies[C].Life==1000){
			Enemies[C].Life = 0;
		};
	};
	if(EventArray[MBrainEventIndex]==0){
		for(C=0;C<Room->NrOfEnemies;C++){		
			Enemies[C].Life = 0;
		};
	};
	
	/*if( (EventArray[MBrainEventIndex]==0) && ((Index-ArchiveStartOfRooms)==BrainRoomIndex) ){
		SetMBrainKilledEnvironment();
	};*/
	
	/*
	memset(GrayDBufGetActivePlane(LIGHT_PLANE),0,LCD_SIZE);
	memset(GrayDBufGetActivePlane(DARK_PLANE),0,LCD_SIZE);
	
	
	
	DispNum(Player.X,Player.Y,GetTile(16*4,16*4),1);
	DispNum(Room->Height,Room->Width,GetTile(16*8,16*8),10);
	DispNum(EventArray[10],EventArray[10],Gamestate.FgX,20);
	*/
	
	// If we come here, the loading was successfull
	return 0;
	
	#undef RawBuffer
	#undef BriefLZWorkMem
	
};