#ifndef __render__
#define __render__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   render.h                                                              *
*			Description:                    *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/


#ifdef MakeTI89

#define FGDrawMode TM_GRPLC89

#define scroll_limit_left		70
#define scroll_limit_right	90
#define scroll_limit_up			34
#define scroll_limit_down		66

#define screen_width			 160
#define screen_height			 100
#define statbar_offset		 2760

#endif


#ifdef MakeTI92Plus

#define FGDrawMode TM_GRPLC

#define scroll_limit_left		110
#define scroll_limit_right	130
#define scroll_limit_up			44
#define scroll_limit_down		76

#define screen_width			 240
#define screen_height			 128
#define statbar_offset		 3600

#endif


#ifdef MakeV200

#define FGDrawMode TM_GRPLC

#define scroll_limit_left		110
#define scroll_limit_right	130
#define scroll_limit_up			44
#define scroll_limit_down		76

#define screen_width			 240
#define screen_height			 128
#define statbar_offset		 3600

#endif

#define scrollbuffersize ((screen_height-8)*30)


//extern Plane FgPlane;
extern AnimatedPlane FgPlane;

extern char* StatBar;

void AdjustRenderCoordinates();

void DispFramedRectangle();

void DrawSprite(short X,short Y,short Index,short Effect);

void RenderLevel(short Display);

void DrawPlayer();

void DrawPlayerShots();

void DrawEnemyShots();

short GetEnemySprite(short Idx);

void DrawEnemies();

void DrawItems();

void UpdateStatbar(short ForceUpdate);

void DrawStatbar();

void ClipInvertRect(void* plane, unsigned short x1, unsigned short y1, unsigned short x2, unsigned short y2);



#endif