
#include "all.h"


AnimatedPlane FgPlane;

char* StatBar;

void DispFramedRectangle(){
	#ifdef MakeTI89
	
	#define RX			22
	#define RY			20
	#define SX			75
	#define SY			27
	#define TY			50
	
	#endif
	#ifdef MakeTI92Plus
	
	#define RX			62
	#define RY			34
	#define SX			112
	#define SY			41
	#define TY			64
	
	#endif
	#ifdef MakeV200
	
	#define RX			62
	#define RY			34
	#define SX			112
	#define SY			41
	#define TY			64
	
	#endif
	
	#define RW			116
	#define RH			60
	
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX,RY,RX+RW,RY+RH,COLOR_DARKGRAY);
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX+1,RY+1,RX+RW-1,RY+RH-1,COLOR_DARKGRAY);

	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX+2,RY+2,RX+RW-2,RY+RH-2,COLOR_WHITE);//  COLOR_LIGHTGRAY  COLOR_WHITE
	
//	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),SX-2,SY-3,SX+17,SY+19,COLOR_BLACK);//  COLOR_LIGHTGRAY  COLOR_WHITE
	
	#undef RX
	#undef RY
	#undef SX
	#undef SY
	#undef TY
	#undef RW
	#undef RH
};

void ClipInvertRect(void* plane , unsigned short x1 , unsigned short y1 , unsigned short x2 , unsigned short y2 ){
	
	if( (x1<0) || (x1>(screen_width-1)) || (x2<0) || (x2>(screen_width-1)) || 
		(y1<0) || (y1>(screen_height-1)) || (y2<0) || (y2>(screen_height-1)) ){
		
		return;
	}
	else{
		FastFilledRect_Invert_R(plane ,  x1, y1 , x2 ,  y2 );
	};

};

void AdjustRenderCoordinates(){
	// Sets the render coordinates for each frame.
	// Basicly it handles the scrolling
	
	short PlayerX = Player.X + 8;
	
	// X Scrolling	
	if( ((PlayerX-Gamestate.FgX) < scroll_limit_left)  ){
		Gamestate.FgX = Gamestate.FgX-(scroll_limit_left+Gamestate.FgX-(PlayerX));
		
	}
	else{
		if((PlayerX-Gamestate.FgX) > scroll_limit_right ){
			Gamestate.FgX = Gamestate.FgX+(PlayerX-Gamestate.FgX-scroll_limit_right);
		};
	};
	// Don't scroll across Borders
	if(Gamestate.FgX<0){
		Gamestate.FgX = 0;
	}
	else{
		if(Gamestate.FgX>(FgPlane.p.width*16-screen_width)){
			Gamestate.FgX = FgPlane.p.width*16-screen_width;
		};
	}
	
	// Y Scrolling	
	if( ((Player.Y-Gamestate.FgY) < scroll_limit_up) ){
		Gamestate.FgY = Gamestate.FgY - ((Gamestate.FgY + scroll_limit_up) - Player.Y);
		
	}
	else{
		if((Player.Y+Player.Height)>(Gamestate.FgY+scroll_limit_down)){
			Gamestate.FgY = Gamestate.FgY+((Player.Y+Player.Height)-(Gamestate.FgY+scroll_limit_down));
	  }
/*		if( ((Player.Y-Gamestate.FgY) > scroll_limit_down) ){
			Gamestate.FgY = Gamestate.FgY + ((Player.Y)-(Gamestate.FgY+scroll_limit_down));
		}*/
	}
	// Don't scroll across Borders
	if(Gamestate.FgY<0){
		Gamestate.FgY = 0;
	}
	else{
		if( Gamestate.FgY>(Room->Height*16+8-screen_height) ){
			Gamestate.FgY = (Room->Height*16+8-screen_height);
		}
	}
	
	if(Player.ShakeCounter){
		if(Gamestate.Count2%2){
			Gamestate.FgY += 2;
		}
	}
	
};

void DrawSprite(short X,short Y,short Index,short Effect){
	// Draws a sprite in any drawmode  at x,y.

	// Parameters:
	// X and Y	:	Level coordinates
	// Index		: Which sprite in SpriteTab to draw
	// Effect:
	// b0 set: Brighter. Hurtanim + frozen
	// b1 set: Draw sprite upside down (width 16 sprites only)
	
	
	short H = SpriteTab[Index].Height;
	short Xoff = SpriteTab[Index].Xoff;
	short Yoff = SpriteTab[Index].Yoff;
		
	if(SpriteTab[Index].DrawMode==width32){
		
		unsigned long* Sprite = Sprites32 + SpriteTab[Index].Offset;
		unsigned long* Sprite2 = (Effect&0b00000001?blank_spr:Sprite+H);
		
		GrayClipSprite32_SMASK_R(X+Xoff-Gamestate.FgX,Y+Yoff-Gamestate.FgY,H,Sprite,Sprite2,Sprite+H*2,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	}
	else{
		
		if(SpriteTab[Index].DrawMode==width48){
			
			unsigned short* Sprite = Sprites16 + SpriteTab[Index].Offset;	
			unsigned short* Sprite2 = (Effect&0b00000001?(unsigned short*)blank_spr:Sprite+H);
			unsigned short* Mask = Sprite + SpriteTab[Index].Height*2*3;
			short Height = SpriteTab[Index].Height;
			
			short C;			
			for(C=0;C<3;C++){
				
		//		GrayClipSprite16_SMASK_R(X+16*C+Xoff-Gamestate.FgX,Y+Yoff-Gamestate.FgY,Height,Sprite+C*Height*2,Sprite2+C*Height*2,Mask+C*Height,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
				GrayClipSprite16_SMASK_R(X+16*C+Xoff-Gamestate.FgX,Y+Yoff-Gamestate.FgY,Height,Sprite+C*Height*2,(Effect&0b00000001?(unsigned short*)blank_spr:Sprite2+C*Height*2),Mask+C*Height,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		//		Sprite2+(Effect&0b00000001?0:C*Height*2)
			};
			
		}
		else{			
			
			unsigned short* Sprite = Sprites16 + SpriteTab[Index].Offset;	
			unsigned short* Sprite2 = (Effect&0b00000001?(unsigned short*)blank_spr:Sprite+H);
			unsigned short* Mask;
			short Height = SpriteTab[Index].Height;
		
			if(SpriteTab[Index].DrawMode==width16){
				Mask = Sprite + SpriteTab[Index].Height*2;
			}
			else{//width16_ball
				Mask = Sprites16+32*4;
			}
		
			if(Effect&0b00000010){
				UpsideDownGrayClipSprite16_MASK_R(X+Xoff-Gamestate.FgX,Y+Yoff-Gamestate.FgY,Height,Sprite,Sprite2,Mask,Mask,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
			}
			else{			
				GrayClipSprite16_SMASK_R(X+Xoff-Gamestate.FgX,Y+Yoff-Gamestate.FgY,Height,Sprite,Sprite2,Mask,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
			};		
	
		};
		
	};
	
};

void RenderLevel(short Display){
// 
// This function draws everything in the level
// 
// 
	if(Display)
		AdjustRenderCoordinates();

	//Draw Foreground
	DrawGrayAnimatedPlane(Gamestate.FgX,Gamestate.FgY,&FgPlane,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE),FGDrawMode,TM_GA16B);
	//DrawGrayAnimatedPlane(Gamestate.FgX,Gamestate.FgY,&FgPlane,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE),TM_GRPLC89,TM_GA16B);
//	DrawGrayPlane(Gamestate.FgX,Gamestate.FgY,&FgPlane,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE),TM_GRPLC,TM_G16B);
	
	
	
	DrawItems();
	//Draw player
	DrawPlayer();
	
	//Draw enemies
	DrawEnemies();
	
	//Draw bullets
	DrawPlayerShots();
	
	DrawEnemyShots();
	
	//DrawSprite(Gamestate.FgX+10,Gamestate.FgY+10,266+Gamestate.TwoAnimStep,0);
	
	RenderObjects();
	
	UpdateStatbar(0);	
	
	if(Display){
		GrayDBufToggleSync();
	};	
	
};

void DrawEnemyShots(){
	short Curr;
	
	for(Curr=0;Curr<nr_of_enemy_shots;Curr++){
		if(Enemyshots[Curr].Active){
			DrawSprite(Enemyshots[Curr].X,Enemyshots[Curr].Y,Enemyshots[Curr].Sprite,0);
		};
	};
	
};

void DrawPlayer(){
	// This function draws the player
	
	if(Player.Energy>0){
		short Effect = (Player.Immortal?1:0);
		DrawSprite(Player.X,Player.Y,Player.Sprite,Effect);
	};
	
};

void DrawPlayerShots(){
	
	short C;
	for(C=0;C<nr_of_player_shots;C++){
		
		if(PlayerShots[C].Active){			
			DrawSprite(PlayerShots[C].X,PlayerShots[C].Y,PlayerShots[C].Sprite,0);
		};		
	};
	
};

short GetEnemySprite(short Idx){	
	short SpriteOffset=0;

	switch(Enemies[Idx].Anim){
		case AnimByDirAndFrame2Step:
		case AnimByFrame2Step:
		case AnimByFrame2StepAndUpsideDown:
			SpriteOffset += Gamestate.TwoAnimStep;
		break;
		case AnimByFrame3Step:
			SpriteOffset += Gamestate.ThreeAnimStep;
		break;
	};
		
	if((Enemies[Idx].Anim==AnimByDir) || (Enemies[Idx].Anim==AnimByDirAndUpsideDown)){
		if(Enemies[Idx].Dir>0)
			SpriteOffset = 1;
	}
	if(Enemies[Idx].Anim==AnimByDirAndFrame2Step){
		if(Enemies[Idx].Dir>0){
			SpriteOffset += 2;
		};
	};
			
	return Enemies[Idx].Sprite + SpriteOffset;	
	
};

void DrawEnemies(){
		
	short Curr;
	
	for(Curr=0;Curr<Room->NrOfEnemies;Curr++){
				
		if(Enemies[Curr].Life){			
			
			short Sprite = (Enemies[Curr].Frozen?Enemies[Curr].Misc:GetEnemySprite(Curr));
			
			short Effect = (Enemies[Curr].Frozen?0b00000001:0);			
			
			if(Enemies[Curr].HurtAnim)
				Effect = 0b00000001;
			
			if( (Enemies[Curr].Anim==AnimByDirAndUpsideDown) || (Enemies[Curr].Anim==AnimByFrame2StepAndUpsideDown) || (Enemies[Curr].Anim==UpsideDown) )
				Effect = Effect|0b00000010;
			
			DrawSprite(Enemies[Curr].X,Enemies[Curr].Y,Sprite,Effect);
			
		};
				
	};	
	
}

void DrawItems(){
	short C;
	
	for(C=0;C<Room->NrOfItems;C++){
		if(Items[C].Active){
			short Sprite = (Items[C].Active==1?Items[C].Type+Gamestate.TwoAnimStep:184);
			if(Items[C].Type==game_end)	Sprite = Items[C].Type;
			DrawSprite(Items[C].X,Items[C].Y,Sprite,0);
		}
	}
	
}

#ifdef MakeTI89
	#define MissX 52
	#define AWX   112
#endif
#ifdef MakeTI92Plus
	#define MissX 92
	#define AWX   192
#endif
#ifdef MakeV200
	#define MissX 92
	#define AWX   192
#endif


void DrawStatbar(){
	
	memset(StatBar,0,480);
	
	DrawGrayStrExt2B(1,1,"ENERGY:",A_REPLACE,F_4x6,StatBar,StatBar+240);
	
	// 52
	DrawGrayStrExt2B(MissX,1,"MISSILES: ",A_REPLACE,F_4x6,StatBar,StatBar+240);
		
	UpdateStatbar(1);
	
};

void UpdateStatbar(short ForceUpdate){
	
	static short PrevEnergy = -1;
	static short PrevMissiles = -1;
	static short PrevActiveWeapon = -1;
	static short PrevBeamWeapon = -1;
	static short PrevCountDown = -1;
	char String[5];
	
	if(ForceUpdate){
		PrevEnergy = -1;PrevMissiles = -1;PrevActiveWeapon = -1;PrevBeamWeapon = -1;PrevCountDown = -1;
	};
	
	/*String[2]=' ';
	String[3]=0;*/
	
	if(Player.Energy != PrevEnergy){
		
		//itoa_ushort_10(String, Player.Energy);
		itoa_ushort_10_extended(String, Player.Energy, 3, TRUE);		
		PrevEnergy = Player.Energy;
		DrawGrayStrExt2B(28,1,String,A_REPLACE,F_4x6,StatBar,StatBar+240);
	};
	
	#ifdef SpeedTest
	
	if(UpdateFrameCounter){
		// Display the measured frame rate
		//itoa_ushort_10_extended(String, UpdateFrameCounter, 2, TRUE);
		itoa_ushort_10(String, UpdateFrameCounter);
		//itoa_ushort_10(String, Player.AX);
		
		//itoa_ushort_10(String, Player.Test);//Player.Test   EventArray[1]
		DrawGrayStrExt2B(120,1,String,A_REPLACE,F_4x6,StatBar,StatBar+240);
		UpdateFrameCounter = 0;
	};
	
	#endif
	
	#ifndef SpeedTest
	
	if(Player.Missiles != PrevMissiles){
		itoa_ushort_10_extended(String, Player.Missiles, 3, TRUE);
		PrevMissiles = Player.Missiles;
		// 86
		DrawGrayStrExt2B(MissX+34,1,String,A_REPLACE,F_4x6,StatBar,StatBar+240);
	}
	
	/*itoa_ushort_10(String, Player.Test);//Player.Test   EventArray[1]
		
	DrawGrayStrExt2B(120,1,String,A_REPLACE,F_4x6,StatBar,StatBar+240);*/
	
	#endif
	
	if(Gamestate.FinalCountDown){
		
		if((Gamestate.FinalCountDown/6) != PrevCountDown){
			PrevCountDown = Gamestate.FinalCountDown/6;
			itoa_ushort_10_extended(String, Gamestate.FinalCountDown/6, 3, TRUE);
			// 112
			DrawGrayStrExt2B(AWX,1,"Time:                    ",A_REPLACE,F_4x6,StatBar,StatBar+240);
			// 134
			DrawGrayStrExt2B(AWX+22,1,String,A_REPLACE,F_4x6,StatBar,StatBar+240);
		};
		
	}
	else{
	
		if( (Player.ActiveWeapon != PrevActiveWeapon) || (Player.BeamWeapon != PrevBeamWeapon) ){
		
			// Display name of active weapon		
			short TxtId;
			if(Player.ActiveWeapon == beam_active){			
				TxtId = Player.BeamWeapon;			
			}
			else{
				TxtId = 5;
			};
			
			const char *WeaponTxt[6]={"BEAM","ICE BEAM","WAVE BEAM","SPAZER BEAM","PLASMA BEAM","MISSILE"};
			// 112
			DrawGrayStrExt2B(AWX,1,"                       ",A_REPLACE,F_4x6,StatBar,StatBar+240);
			DrawGrayStrExt2B(AWX,1,WeaponTxt[TxtId],A_REPLACE,F_4x6,StatBar,StatBar+240);
		
			PrevActiveWeapon = Player.ActiveWeapon;
			PrevBeamWeapon = Player.BeamWeapon;
		};
	
	};
	
//	Player.Test = (((0x0F21)>>8)&0b00001111);// &0b11110000)
/*	itoa_ushort_10(String, Player.Test);//Player.Test);		
	DrawGrayStrExt2B(120,1,String,A_REPLACE,F_4x6,StatBar,StatBar+240);*/
	
	
	memcpy (GrayDBufGetHiddenPlane(LIGHT_PLANE)+statbar_offset, StatBar, 240);//2760
	memcpy (GrayDBufGetHiddenPlane(DARK_PLANE)+statbar_offset, StatBar+240, 240);

	
};

#undef MissX
#undef AWX

