
#include "all.h"

short Exit;


void PlayLoop(){
	
	FgPlane.p.force_update = 1;
	//memset(RespawningTiles,0,NrOfRespawnTiles*sizeof(respawningTile));
	
	
	// Draw statusbar before starting the play
	DrawStatbar();
	
	//Reset counters to make sure they all start on 0.
	Gamestate.Count1 = 0;
	Gamestate.Count2 = 0;
	Gamestate.TwoAnimStep = 0;
	Gamestate.SpeedCounter = 0;
	
	#ifdef watchdog			
		WatchDog.Enable = 1;
		WatchDog.FrameId = WatchDog.PrevFrameId = 0;
	#endif
	
		
	
	while(!Exit){
	
		#ifdef watchdog
			WatchDog.FrameId++;
			WatchDog.Code1 = 1;
		#endif
		//UpdateTimers();		
		
		if(Player.RoomUpdate){
			SwitchMap();			
		};
		
		HandleAdditionalControls();
		
		#ifdef watchdog
		 WatchDog.Code1 = 2;
		#endif
		
		#ifdef SpeedTest
			Fps++;
		#endif
		#ifdef missile_unlimited
			Player.Missiles = 100;
		#endif		
		
		RenderLevel(1);
		
		#ifdef watchdog
		 WatchDog.Code1 = 3;
		#endif
		
		PreviousKeyState = KeyState;
		
		#ifdef watchdog
		 WatchDog.Code1 = 4;
		#endif
		
		ScanKeys();	
		
		#ifdef watchdog
		 WatchDog.Code1 = 5;
		#endif
		
		if(Player.Energy>0)
			HandlePlayer();
		
		#ifdef watchdog
		 WatchDog.Code1 = 6;
		#endif
		
		HandlePlayerShots();
		
		#ifdef watchdog
		 WatchDog.Code1 = 7;
		#endif
		
		HandleBlockedLocations();
		
		#ifdef watchdog
		 WatchDog.Code1 = 8;
		#endif
		
		HandleEnemies();
		
		#ifdef watchdog
		 WatchDog.Code1 = 9;
		#endif
		
		HandleEnemyShots();
		
		#ifdef watchdog
		 WatchDog.Code1 = 10;
		#endif
		
		HandleItems();
		
		#ifdef watchdog
		 WatchDog.Code1 = 11;
		#endif
		
		/*if(Exit==0)
			HandleAdditionalControls();*/
		
		#ifdef watchdog
		 WatchDog.Code1 = 12;
		#endif
		
		UpdateTimers();
		
		#ifdef watchdog
		 WatchDog.Code1 = 13;
		#endif
		
		RespawnTiles();		
		
		#ifdef watchdog
		 WatchDog.Code1 = 14;
		#endif
		
		
//#define 
//#define 
		
		#ifdef small_delay
		
			short Delay;
			#ifdef MakeTI89
				#define delay_time 10000
			#endif 
			#ifdef MakeTI92Plus
				#define delay_time 7000
			#endif
			#ifdef MakeV200
				#define delay_time 7000
			#endif
			for(Delay=0;Delay<delay_time;Delay++);
		
		#endif
		
		#ifdef freeze		
		
		if( (_rowread(0b01111110) & 0b10000000) ){// Alpha key pressed
			
			//while(_rowread(0));//wait until key released
			while( (_rowread(0b1111110) & 0b10000000) );//wait until Alpha key released
			
			while( !(_rowread(0b1111110) & 0b10000000) );// Wait until Alpha key pressed
			while( (_rowread(0b1111110) & 0b10000000) );//wait until Alpha key released
			
		};
		
		#endif
		
		#ifdef SpeedAdjust
		
		while(Gamestate.SpeedCounter<Config.Speed){
			//idle();// Save batteries while waiting
			// This function interferes with grayscale, and slow
		};
	//	Player.Test = Gamestate.SpeedCounter;
		//Player.Missiles = Gamestate.SpeedCounter;
		Gamestate.SpeedCounter = 0;		
		
		#endif
		
	};	
	
	#ifdef watchdog			
		WatchDog.Enable = 0;
	#endif
	
};

void SwitchMap(){	
	
	// This function loads the room the player is about to enter. 
	// Also handles room transition animation.
	

	//   Lower end reached
	if( (Player.AY>=Area->Height)){
		
		// Load next area
		Player.CurrArea++;
		if( (ErrorCode = LoadArea(Player.CurrArea)) ){
			Exit = 1;
			return;
		};
		Player.AX = Area->StartXUpper;
		Player.AY = Area->StartYUpper;
		Player.RoomUpdate = ADown;		
		
	}
	else{
		//   Upper end reached
		if( (Player.AY<0)){
			
			// Load next area
			Player.CurrArea--;
			//LoadArea(Player.CurrArea);			
			if( (ErrorCode = LoadArea(Player.CurrArea)) ){
				Exit = 1;
				return;
			};
			
			Player.AX = Area->StartXLower;
			Player.AY = Area->StartYLower;			
			Player.RoomUpdate = AUp;
		}
		else{
			// Next area marker reached:
			// Down
			if( *(AreaMap+Player.AY*Area->Width+Player.AX)==254 ){
				
				// Load next area
				Player.CurrArea++;
				//LoadArea(Player.CurrArea);
				if( (ErrorCode = LoadArea(Player.CurrArea)) ){
					Exit = 1;
					return;
				};				
				Player.AX = Area->StartXUpper;
				Player.AY = Area->StartYUpper;
				Player.RoomUpdate = ADown;
			}
			else{
				// Up
				if( *(AreaMap+Player.AY*Area->Width+Player.AX)==255 ){
					// Load next area
					Player.CurrArea--;
					//LoadArea(Player.CurrArea);
					if( (ErrorCode = LoadArea(Player.CurrArea)) ){
						Exit = 1;
						return;
					};
					Player.AX = Area->StartXLower;
					Player.AY = Area->StartYLower;
					Player.RoomUpdate = AUp;
				};
			};
		};
	};

	
	if(LoadRoom( *(AreaMap+Player.AY*Area->Width+Player.AX)-1 )!=0){
		Player.RoomUpdate = 0;
		ErrorCode = 4;Exit = 1;
		return;//while(1);
	};
	
	short C;
	// Disable all respawning tiles
	for(C=0;C<NrOfRespawnTiles;C++){
		RespawningTiles[C].ActiveTimer = 0;
	};
	
	short XCorr = 0,YCorr = 0;
	short CorrX = 0;
			
	switch(Player.RoomUpdate){
		case XLeft:
			Player.X = Room->Width*16-16;
			YCorr = 1;
		break;
		case XRight:
			Player.X = 0;
			YCorr = 1;
		break;
		case YUp:
			Player.Y = Room->Height*16-8;
			XCorr = 1;
		break;
		case YDown:
			Player.Y = 0;//-Player.Height/2;
			XCorr = 1;
		break;
		case ADown:
			Player.Y = 0;
			Player.X += (Area->XoffsetUpper*16);//Player.X -= 34*16;////Area->XoffsetUpper;
			CorrX = (Area->XoffsetUpper*16);
		break;
		case AUp:			
			Player.Y = Room->Height*16-8;
			Player.X += (Area->XoffsetLower*16);
			CorrX = (Area->XoffsetLower*16);
		break;
	};

	
	if(XCorr){
		
		short CY = Player.AY - (Player.RoomUpdate==YDown?1:0);
	//	short CorrX = 16*XCorrMap[CY][Player.AX];
		CorrX = 16*( *(XCorrMap+CY*Area->Width+Player.AX) );
		
		if(Player.RoomUpdate==YUp)
			CorrX = -CorrX;			
		
		Player.X += CorrX;
		
	}
	else{// Ycorr
		
		if(YCorr){
			
			short CX = Player.AX - (Player.RoomUpdate==XRight?1:0);
			//short CorrY = 16*XCorrMap[Player.AY][CX];
			short CorrY = 16*( *(YCorrMap+Player.AY*(Area->Width-1)+CX) );
								
			if(Player.RoomUpdate==XLeft)
				CorrY = -CorrY;						
							
			Player.Y += CorrY;
		};
	};			
	
//	Player.Test = FgPlane.p.width;
	
	if( (Player.RoomUpdate==YUp) || (Player.RoomUpdate==YDown) || (Player.RoomUpdate==AUp) || (Player.RoomUpdate==ADown) ){
		
		// Animate
	
		// buffer = big_v_screen
	
		//1. Draw new screen in hiddenbuffer
		//2. Copy hiddenbuffer to buffer
		//3. Copy visiblebuffer to buffer
		//4. Scroll up/down
	
		// void* Buffer = FgPlane.p.big_vscreen + GRAY_BIG_VSCREEN_SIZE + 480;
		void* Buffer = FgPlane.p.big_vscreen;// + GRAY_BIG_VSCREEN_SIZE + 480;
		
		// Draw new screen in hiddenbuffer		
		FgPlane.p.force_update = 1;
		//AdjustRenderCoordinates();		
		
		// This code gives exactly the same result as AdjustRenderCoordinates(); in many cases
		Gamestate.FgX += CorrX;
		
		if( (Player.RoomUpdate==YUp) || (Player.RoomUpdate==AUp) ){
			Gamestate.FgY = (Room->Height)*16-screen_height-8+16;
		}
		else{
			Gamestate.FgY = 0;
		};
		
		if(Gamestate.FgX<0){
			Gamestate.FgX = 0;
		}
		else{
			if(Gamestate.FgX>((short)(FgPlane.p.width*16-screen_width))){
				Gamestate.FgX = FgPlane.p.width*16-screen_width;
			};
		};
		
		if(Gamestate.FgY<0){
			Gamestate.FgY = 0;
		}
		else{
			if( Gamestate.FgY>(Room->Height*16+8-screen_height) ){
				Gamestate.FgY = (Room->Height*16+8-screen_height);
			};
		};		
		
		AdjustRenderCoordinates();
		
		RenderLevel(0);
	
		// 1: New    2: Old
		
		#define subbufsize ((screen_height-8)*30)
		
		short NewOffSet,OldOffSet,SY,DY;
		
		if( (Player.RoomUpdate==YUp) || (Player.RoomUpdate==AUp) ){
			OldOffSet = subbufsize;
			NewOffSet = 0;
			SY = subbufsize;
			DY = -2;
		}
		else{
			OldOffSet = 0;
			NewOffSet = subbufsize;
			SY = 0;
			DY = 2;
		};		
		
		//Copy "Old" screen
		// Light data
		memcpy(Buffer+OldOffSet,GrayDBufGetActivePlane(LIGHT_PLANE),subbufsize);
		// Dark data
		memcpy(Buffer+2*subbufsize+OldOffSet,GrayDBufGetActivePlane(DARK_PLANE),subbufsize);
		
		//Copy "New" screen
		// Light data
		memcpy(Buffer+NewOffSet,GrayDBufGetHiddenPlane(LIGHT_PLANE),subbufsize);
		// Dark data
		memcpy(Buffer+2*subbufsize+NewOffSet,GrayDBufGetHiddenPlane(DARK_PLANE),subbufsize);

		short C,D;
		for(C=0;C<((screen_height-8)/2);C++){
			
		#ifdef watchdog
			WatchDog.FrameId++;
		#endif
			/*
			long Delay;
			for(Delay=0;Delay<40000;Delay++);
			*/
			
			memcpy(GrayDBufGetHiddenPlane(LIGHT_PLANE),Buffer+SY,subbufsize);
			memcpy(GrayDBufGetHiddenPlane(DARK_PLANE),Buffer+2*subbufsize+SY,subbufsize);
					
			GrayDBufToggleSync();
			
			SY += 30*DY;
			
		};		
		
	};
	
	FgPlane.p.force_update = 1;
	Player.RoomUpdate = 0;
	
};

void UpdateTimers(){
	// This func handles the counters that is used in animations. 
		
	#define counter1steps			8
	#define counter2steps			8
	
	if( (++Gamestate.Count1)>=(counter1steps) ){
		Gamestate.Count1 = 0;
		if( (++Gamestate.Count2)>=(counter2steps) ){
			Gamestate.Count2 = 0;
		}							
		if( (Gamestate.Count2%2)==0){
			Gamestate.TwoAnimStep = 1;
		}
		else{
			Gamestate.TwoAnimStep = 0;
		}	
		if(Gamestate.ThreeAnimStep>=2){
			Gamestate.ThreeAnimStepDir = -1;
		}
		else{
			if(Gamestate.ThreeAnimStep<=0){
				Gamestate.ThreeAnimStepDir = 1;
			};		
		};
		Gamestate.ThreeAnimStep += Gamestate.ThreeAnimStepDir;
	};
	
	if(Gamestate.FinalCountDown){
		// Mother Brain destroyed. Samus trying to reach the exit in time
				
		if( (--Gamestate.FinalCountDown)<=0){
			//Time up
			GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),24,22,136,78,COLOR_BLACK);
			
			DrawGrayStrExt2B(0,35,"TIME UP!",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
			DrawGrayStrExt2B(0,45,"TRY AGAIN!",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						
			// wait for keypress	
			WaitForKeyPress();
			
			//reload room
			if( LoadRoom(BrainRoomIndex) ){
				ErrorCode = 4;Exit = 1;
				return;
			};
			
			SetMBrainKilledEnvironment();
			
			// Reset player position 
			Player.X = 4*16;Player.Y = 7*16;Player.AX = 2;Player.AY = 3;
						
		}
		else{
			if(Gamestate.FinalCountDown<(EventArray[EscapeCountEIndex]/4) ){
				Player.ShakeCounter = 2;
			}
		};
		
	}
	else{
		if(Gamestate.MotherBrainIsDestroyed){			
			
			if(Player.ShakeCounter==0){
				Gamestate.FinalCountDown = EventArray[EscapeCountEIndex];
				// Display text and wait for Keypress
				GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),24,22,136,78,COLOR_BLACK);
			
				DrawGrayStrExt2B(0,30,"TIME BOMB SET!",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
				DrawGrayStrExt2B(0,40,"GET OUT FAST!",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
				DrawGrayStrExt2B(0,50,"TIME: 1000",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
			
				// wait for keypress	
				WaitForKeyPress();
				
			};
		};
	};	
	
};

void TheEnd(){
	//GREAT !!!
	//YOU FULFILLED YOUR MISSION
	//IT WILL REVIVE PEACE IN SPACE
	//BUT, IT MAY BE INVADED BY OTHER METROIDS
	//PRAY FOR A TRUE PEACE IN SPACE!
	//
	#ifdef MakeTI89
	#define T1Y		20
	#define T2Y		40
	#define T3Y		60
	#endif
	#ifdef MakeTI92Plus
	#define T1Y		40
	#define T2Y		60
	#define T3Y		80
	#endif
	#ifdef MakeV200
	#define T1Y		40
	#define T2Y		60
	#define T3Y		80
	#endif
	
	
	InitStarField();
	
//	while(Run){
	while(!_rowread(0)){
		
		StarFieldAnim();
		
		DrawGrayStrExt2B(0,T1Y,"CONGRATULATIONS !!!",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		DrawGrayStrExt2B(0,T2Y,"YOU FULFILLED YOUR MISSION",A_REVERSE|A_CENTERED,F_4x6,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		DrawGrayStrExt2B(0,T3Y,"IT WILL REVIVE PEACE IN SPACE",A_REVERSE|A_CENTERED,F_4x6,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
//		DrawGrayStrExt2B(0,60,"BUT, IT MAY BE INVADED BY OTHER METROIDS",A_REVERSE|A_CENTERED,F_4x6,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
//		DrawGrayStrExt2B(0,70,"PRAY FOR A TRUE PEACE IN SPACE!",A_REVERSE|A_CENTERED,F_4x6,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		
		
		// Toggle
		GrayDBufToggleSync();
		
	};
	
	#undef T1Y
	#undef T2Y
	#undef T3Y
};

void GameOver(){
	
	InitStarField();
	
	while(!_rowread(0)){		
		
		StarFieldAnim();
		
		DrawGrayStrExt2B(0,screen_height/2-4,"GAME OVER",A_REVERSE|A_CENTERED,F_8x10,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	
		// Toggle
		GrayDBufToggleSync();
		
	};
	
};

void DoStatScreen(){
	
	#ifdef MakeTI89
	#define T1Y		15
	#define T2Y		35
	#define T3Y		55
	#define T4Y		75
	#endif
	#ifdef MakeTI92Plus
	#define T1Y		40
	#define T2Y		60
	#define T3Y		80
	#define T4Y		100
	#endif
	#ifdef MakeV200
	#define T1Y		40
	#define T2Y		60
	#define T3Y		80
	#define T4Y		100
	#endif
	
	char String[28];
	short Sum,C,Return = 0;
	InitStarField();
	
	//while(_rowread(0));
	
	while(!Return){
		
		StarFieldAnim();
			
		sprintf(String,"Area %d",Player.CurrArea+1);			
		DrawGrayStrExt2B(0,T1Y,String,A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
				
		short ExploredCount = 0,C;
		
		for(C=0;C<Area->NrOfRooms;C++){
			if(VisitedRooms[AreaOffsets[Player.CurrArea]+C]!=-1){
				ExploredCount++;
			};
		};
		short Ratio = ((100*ExploredCount)/Area->NrOfRooms);
				
		sprintf(String,"%d%% explored",Ratio);			
		DrawGrayStrExt2B(0,T2Y,String,A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));

		sprintf(String,"Metroids left in Area: %d",EventArray[Player.CurrArea+1]);			
		DrawGrayStrExt2B(0,T3Y,String,A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));

		Sum = 0;
		for(C=1;C<=8;C++){
			Sum += EventArray[C];
		};

		sprintf(String,"Metroids left total: %d",Sum);			
		DrawGrayStrExt2B(0,T4Y,String,A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	
		// Toggle
		GrayDBufToggleSync();
		
		ScanKeys();
		
		if(KeyState.Enter || KeyState.Esc){
			Return = 1;
		};
		
	};
	
	while(_rowread(0));
	FgPlane.p.force_update = 1;
	
	#undef T1Y
	#undef T2Y
	#undef T3Y
	
};
