
#include "all.h"


player Player;
shot PlayerShots[nr_of_player_shots];

const short PlayerAnimTab[14][8]={
	{  9, 11,  9, 11, 13,  9, 11, 13},//walk left
	{  8, 10,  8, 10, 12,  8, 10, 12},//walk right	
	{  4,  7,  6,  4,  5,  6,  7,  5},//morph left
	{  4,  7,  6,  4,  5,  6,  7,  5},//morph right
	{ 16, 19, 18, 16, 17, 18, 19, 17},//spring ball left
	{ 16, 19, 18, 16, 17, 18, 19, 17},//spring ball right
	{ 20, 23, 22, 20, 21, 22, 23, 21},//spider ball left
	{ 20, 23, 22, 20, 21, 22, 23, 21},//spider ball right
	{ 28, 29, 30, 31, 28, 29, 30, 31},//Spim jump normal left
	{ 24, 25, 26, 27, 24, 25, 26, 27},//Spim jump normal right	
	{202,204,202,204,210,202,204,210},//walk left, aim up
	{201,203,201,203,209,201,203,209},//walk right, aim up	
	
	{258,259,260,261,258,259,260,261},//screw attack right	
	{261,260,259,258,261,260,259,258},//screw attack right
	
};


const short VariaPlayerAnimTab[14][8]={
	{215,217,215,217,219,215,217,219},//walk left
	{216,218,216,218,220,216,218,220},//walk right
	{  4,  7,  6,  4,  5,  6,  7,  5},//morph left
	{  4,  7,  6,  4,  5,  6,  7,  5},//morph right
	{ 16, 19, 18, 16, 17, 18, 19, 17},//spring ball left
	{ 16, 19, 18, 16, 17, 18, 19, 17},//spring ball right
	{235,238,237,235,236,237,238,236},//spider ball left
	{235,238,237,235,236,237,238,236},//spider ball right
	{239,245,241,243,239,245,241,243},//Spim jump normal left
	{240,246,242,244,240,246,242,244},//Spim jump normal right
	{229,231,229,231,233,229,231,233},//walk left, aim up
	{230,232,230,232,234,230,232,234},//walk right, aim up	
	
	{258,259,260,261,258,259,260,261},//screw attack right	
	{261,260,259,258,261,260,259,258},//screw attack right
	
};



void PlayerInit(){
	
	memset(&Player,0,sizeof(player));
	
	Player.Energy = InitialEnergyLevel;//600;//
	Player.MaxEnergyLevel = InitialEnergyLevel;//600;//
	Player.State = normal;
	Player.IsJumping = 0;
	Player.IsFalling = 0;
	Player.IsBounchingBall = 0;
	
	Player.IsInWater = 0;
	
	//  beam  ice_beam  wawe_beam  spazer_lazer_beam  plasma_beam
	Player.ActiveWeapon = beam_active;
	Player.BeamWeapon = InitialBeamWeapon;//spazer_lazer_beam;//
	//InitialBeamWeapon  ice_beam  wawe_beam  ice_beam  spazer_lazer_beam  plasma_beam
	Player.ShootTimer = 0;
	Player.Missiles = InitialMissileLoad;//150;//
	Player.MaxMissileLoad = InitialMissileLoad;//150;//
	
	
	Player.HasHighJump = 0;
	Player.HasSpringBall = 0;
	Player.HasSpiderBall = 0;
	Player.HasSpaceJump = 0;
	Player.HasScrewAttack = 0;
	Player.HasVariaSuit = 0;
	Player.HasBomb = 0;
	
	Player.Sprite = 0;
	Player.Height = 32;
	
	Player.ForceXMove = 0;
	Player.Blocked = 0;
	
	Player.Dir = 2;
	Player.Aim = aim_right;	
	
	Player.Immortal = 0;
	
	Player.Test = 0;
	Player.SpiderStateLeftTimer = 0;
	Player.PreventSpiderCount = 0;
	 
	Player.X = 16*18+8;
	Player.Y = 16*15;
	Player.AX = 2;
	Player.AY = 0;
	Player.CurrArea = 0;
	
	
	/*
	// Area 1 
	Player.X = 16*10;
	Player.Y = 16*15;
	Player.AX = 2;
	Player.AY = 0;
	Player.CurrArea = 0;
	*/
	#ifdef demo1
		Player.X = 16*10;
		Player.Y = 16*15;
		Player.AX = 2;
		Player.AY = 0;
		Player.CurrArea = 0;
	#endif
	#ifdef demo2
		Player.X = 16*10;
		Player.Y = 16*15;
		Player.AX = 2;
		Player.AY = 0;
		Player.CurrArea = 0;
	#endif
	/*
		Player.X = 16*10;
		Player.Y = 16*15;
		Player.AX = 2;
		Player.AY = 0;
		Player.CurrArea = 0;
	*/
	
	/*
	// Area 2 room 1
	Player.X = 16*7;
	Player.Y = 16*1;
	Player.AX = 0;
	Player.AY = 2;
	Player.CurrArea = 1;
	*/
	
	/*
	// Area 2 room 2
	Player.X = 16*1;
	Player.Y = 16*4;
	Player.AX = 1;
	Player.AY = 2;
	Player.CurrArea = 1;
	*/
	
	/*
	// Area 3 room 1
	Player.X = 9*16;
	Player.Y = 103*16;
	Player.AX = 10;
	Player.AY = 1;
	Player.CurrArea = 2;
	*/
	
	
	// Area 4 room 1
	/*
	Player.X = 7*16;
	Player.Y = 1*16;
	Player.AX = 7;
	Player.AY = 1;
	Player.CurrArea = 3;
	*/
	// Area 4 room x
	/*
	Player.X = 24*16;
	Player.Y = 13*16;
	Player.AX = 6;
	Player.AY = 2;
	Player.CurrArea = 3;
	*/
	/*
	// Area 4 Underground
	Player.X = 4*16;
	Player.Y = 6*16;
	Player.AX = 6;
	Player.AY = 3;
	Player.CurrArea = 3;
	*/
	/*
	// Area 5 room 1	
	Player.X = 10*16;
	Player.Y = 2*16;
	Player.AX = 0;
	Player.AY = 2;
	Player.CurrArea = 4;
	*/
	/*
	// Area 5 ruins
	Player.X = 1*16;
	Player.Y = 8*16;
	Player.AX = 7;
	Player.AY = 2;
	Player.CurrArea = 4;
	*/
	
	/*
	// Area 6 
	Player.X = 7*16;//7*10;
//	Player.Y = 60*16;//3*15;
	Player.Y = 2*16;
	Player.AX = 0;
	Player.AY = 2;
	Player.CurrArea = 5;
	*/
	/*
	Player.X = 4*16;//7*10;
	Player.Y = 1*16;//3*15;
	Player.AX = 1;
	Player.AY = 2;
	Player.CurrArea = 5;
	*/
	/*
	// Area 7 room 1	
	Player.X = 7*16;
	Player.Y = 0*16;
	Player.AX = 4;
	Player.AY = 3;
	Player.CurrArea = 6;
	*/
	/*
	// Area 8 room 12	
	Player.X = 7*16;
	Player.Y = 0*16;
	Player.AX = 4;
	Player.AY = 3;
	Player.CurrArea = 7;*/
	
	
	// End of Test initializations
	
	
};



void ExitSpiderBallMode(){
	
	Player.State = (Player.HasSpringBall?spring_ball:morph_ball);
	
	Player.Y -= 2;
	
	// This one fixes a bug where you could enter ducking mode through solid roof 
	// when pressing Up and Jump simultaniously in spider ball mode
	Player.SpiderStateLeftTimer = 4;
	
	// x adjust
	if( (GetTile(Player.X,Player.Y+4)>=tiles_solid_low) || (GetTile(Player.X,Player.Y+15)>=tiles_solid_low) ){
		Player.X += 2;
	}
	else{
		if( (GetTile(Player.X+15,Player.Y+4)>=tiles_solid_low) || (GetTile(Player.X+15,Player.Y+15)>=tiles_solid_low) ){
			Player.X -= 2;
		};
	};	
	
	Player.SpiderPrevKeyLeft = 0;
	Player.SpiderPrevKeyRight = 0;
	Player.SpiderPrevKeyUp = 0;
	Player.SpiderPrevKeyDown = 0;
	
};

short PlayerFreeLeft(short X,short Y,short Height){
	short Dist = FreeLeft(X,Y,Height);

	short C;
	for(C=0;C<max_nr_of_blocks;C++){
		if(Blocks[C].Active){
			if( abs((Blocks[C].X+Blocks[C].Width)-(X))<=2 ){
				if(YOverlap(Blocks[C].Y,Blocks[C].Height,Y,Player.Height)){
					Dist = 0;
				};
			};
		};		
	};
	
	return Dist;

	/*
	if(Player.BlockedLeftByfrozen){
		return 0;
	}
	else{
		return FreeLeft(X,Y,Height);
	};
	*/
};

short PlayerFreeRight(short X,short Y,short Height){

	short Dist = FreeRight(X,Y,Height);

	short C;
	for(C=0;C<max_nr_of_blocks;C++){
		if(Blocks[C].Active){
			if( abs(Blocks[C].X-(X))<=2 ){
				if(YOverlap(Blocks[C].Y,Blocks[C].Height,Y,Player.Height)){
					Dist = 0;
				};
			};
		};		
	};
	
	return Dist;
/*
	if(Player.BlockedRightByfrozen){
		return 0;
	}
	else{
		return FreeRight(X,Y,Height);
	};
	*/
};

short PlayerFreeUp(short X,short Y,short Width){
	
	short Dist = FreeUp(X,Y,Width);

	short C;
	for(C=0;C<max_nr_of_blocks;C++){
		if(Blocks[C].Active){
			if( abs(Y-(Blocks[C].Y+Blocks[C].Height-1))<=4 ){
				if(XOverlap(Blocks[C].X,Blocks[C].Width,X,16)){
					Dist = 0;
					Player.IsJumping = 0;
				};
			}
		}
	}
	
	return Dist;
	
	/*
	if(Player.BlockedUpByfrozen){
		return 0;
	}
	else{
		return FreeUp(X,Y,Width);
	};
	*/
};

short PlayerFreeDown(short X,short Y,short Width){
	
	short Dist = FreeDown(X,Y,Width);

	short C;
	for(C=0;C<max_nr_of_blocks;C++){
		if(Blocks[C].Active){
			if( abs(Blocks[C].Y-Y)<=4 ){
				if(XOverlap(Blocks[C].X,Blocks[C].Width,X,16)){
					Dist = 0;
				};
			}
		}
	}
	
	return Dist;
	
	/*
	if(Player.BlockedDownByfrozen){
		return 0;
	}
	else{
		return FreeDown(X,Y,Width);
	};
		*/
};

short PlayerWrapAroundUp(){
	short Return = 0;
	
	//if(Player.X%16>0){
		if( ((Player.X%16) >= 12) && !KeyState.Left){
			if(GetTile(Player.X+4,Player.Y-15)<tiles_solid_low){
				Player.X += (16-(Player.X%16));
				Return = 1;
			};	
		}
		else{
			if( ((Player.X%16)<=4)  && !KeyState.Right ){
				if(GetTile(Player.X+15-4,Player.Y-15)<tiles_solid_low){
					Player.X -= (Player.X%16);
					Return = 1;
				};
			};
		};
	//};
	return Return;
	
}

void HandlePlayer(){
	// This function handles all player movement, gravity, weapons etc.
	
	/*
	// Test code for tilemap navigation functions

	if(KeyState.Left){
		if(FreeLeft(Player.X,Player.Y,16)){
			Player.X --;
		};		
	}
	if(KeyState.Right){
		if(FreeRight(Player.X+15,Player.Y,16)){
			Player.X ++;
		}
	}
	if(KeyState.Up){
		if(FreeUp(Player.X,Player.Y,16)){
			Player.Y --;
		};		
	}
	if(KeyState.Down){
		if(FreeDown(Player.X,Player.Y+15,16)){
			Player.Y ++;
		};		
	}
	*/	
	/*
	if(KeyState.ToggleWeapon && !PreviousKeyState.ToggleWeapon){
		Player.HasVariaSuit = (Player.HasVariaSuit?0:1);
	};
	*/
	
	
	
	
	// end of Test code
	
	if(Player.BlockBombJump){
		Player.BlockBombJump--;
	};
	
	if(Player.ShakeCounter>0){
		Player.ShakeCounter--;
	};
	if(Player.Immortal>0){
		Player.Immortal--;
	};
	
	if(Player.SpiderStateLeftTimer>0){
		// This one fixes a bug where you could enter ducking mode through solid roof 
		// when pressing Up and Jump simultaniously in spider ball mode
		Player.SpiderStateLeftTimer--;
	};	
	if(Player.PreventSpiderCount>0){
		// This one prevents a bug that bounches samus through solid tiles if she enters
		// spider ball mode while in contact with enemy
		Player.PreventSpiderCount--;
	};
	
	Player.IsWalking = 0;
	
	if(KeyState.ToggleWeapon && !PreviousKeyState.ToggleWeapon){
		Player.ActiveWeapon = (Player.ActiveWeapon==beam_active?missile_active:beam_active);
	};
	
	if(Player.State==normal){//Start of normal mode
		
		/*if(KeyState.ToggleWeapon && !PreviousKeyState.ToggleWeapon){
			Player.ActiveWeapon = (Player.ActiveWeapon==beam_active?missile_active:beam_active);
		};*/
						
		if(KeyState.Left){
			if(Player.Dir<0){//already facing left
				if(PlayerFreeLeft(Player.X,Player.Y,32)){
					Player.X -= Player.WalkSpeed;
					if( (++Player.WalkAnimTimer)>=4){
						Player.WalkAnimTimer=0;
						if( (++Player.WalkAnimStep)>=8 ){
							Player.WalkAnimStep = 0;
						}
					}
					short Idx = (Player.Aim==aim_up?10:1);
					//Player.Sprite = PlayerAnimTab[Idx][Player.WalkAnimStep];
					//Player.Sprite = (Player.HasVariaSuit?VariaPlayerAnimTab[Idx][Player.WalkAnimStep]:PlayerAnimTab[Idx][Player.WalkAnimStep]);
					Player.IsWalking = 1;
				}
				else{					
					/*if(Player.HasVariaSuit){
						Player.Sprite = (Player.Aim==aim_up?221:211);
					}
					else{
						Player.Sprite = (Player.Aim==aim_up?206:1);
					};*/
				}				
			}
			else{//facing right 
				//Set dir left
				Player.Dir = -2;
				/*if(Player.HasVariaSuit){
					Player.Sprite = (Player.Aim==aim_up?221:211);
				}
				else{
					Player.Sprite = (Player.Aim==aim_up?206:1);
				};*/
			}
		}
		else{
			if(KeyState.Right){
				
				if(Player.Dir>0){//already facing right
					
					if(PlayerFreeRight(Player.X+15,Player.Y,32)){
						Player.X += Player.WalkSpeed;
						if( (++Player.WalkAnimTimer)>=6){
							Player.WalkAnimTimer=0;
							if( (++Player.WalkAnimStep)>=8 ){
								Player.WalkAnimStep = 0;
							}
						}
						short Idx = (Player.Aim==aim_up?11:0);
						//Player.Sprite = PlayerAnimTab[Idx][Player.WalkAnimStep];
						//Player.Sprite = (Player.HasVariaSuit?VariaPlayerAnimTab[Idx][Player.WalkAnimStep]:PlayerAnimTab[Idx][Player.WalkAnimStep]);
						Player.IsWalking = 1;
					}
					else{
						// Varia, aim up
						/*if(Player.HasVariaSuit){
							Player.Sprite = (Player.Aim==aim_up?222:212);
						}
						else{
							Player.Sprite = (Player.Aim==aim_up?205:0);
						};*/
					}					
				}
				else{//facing left 
					//Set dir right
					Player.Dir = 2;
					/*if(Player.HasVariaSuit){
						Player.Sprite = (Player.Aim==aim_up?222:212);
					}
					else{
						Player.Sprite = (Player.Aim==aim_up?205:0);
					};*/
				}				
			}
		}
		
		if( (!KeyState.Left) && (!KeyState.Right) ){
			Player.WalkAnimTimer = Player.WalkAnimStep = 0;
			//Player.Sprite = (Player.Dir>0?0:1);
			// aim up?
			/*if(Player.Aim==aim_up){
				Player.Sprite += (Player.HasVariaSuit?221:205);//205;
			};*/
		}
		if(KeyState.Up){
			Player.Aim = aim_up;
		}
		else{
			Player.Aim = Player.Dir;
			if(Player.IsJumping || Player.IsFalling){
				if(KeyState.Down){
					Player.Aim = aim_down;
				}
			}
		}
		if(KeyState.Jump){
						
			if( !PreviousKeyState.Jump && !PlayerFreeDown(Player.X,Player.Y+31,16) ){
				Player.IsJumping = (Player.HasHighJump?player_hijump_jumpheight:player_normal_jumpheight);  		
			
				if(KeyState.Left || KeyState.Right){//Spin jump
					Player.IsSpinJumping = 1;
				}	
			
			}
			else{
				//Spacejump
				if(Player.HasSpaceJump && Player.IsSpinJumping && !Player.SpaceJumpFailed && !PreviousKeyState.Jump){
					
					if( (Player.IsFalling>16) ){
						Player.IsJumping = (Player.HasHighJump?player_hijump_spacejumpheight:player_spacejumpheight);
						//Player.IsJumping = player_spacejumpheight;
					}
					else{//Player failed with the timing of the jump
						//Player.IsSpinJumping = 0;			
						Player.SpaceJumpFailed = 1;	
					}					
				}
			}
		}
		else{
			Player.IsJumping = 0;
		}
		
		/*if(Player.IsJumping){
			Player.Sprite = (Player.Dir>0?14:15);
			if(Player.Aim==aim_up){
				Player.Sprite += 185;
			}
			else{
				if(Player.Aim==aim_down){
					Player.Sprite += 193;
				};
			};
						
		}*/
		
		if(KeyState.Fire && !Player.IsSpinJumping){
			PlayerShoot();
		}
		
		if(KeyState.Down && !PlayerFreeDown(Player.X,Player.Y+Player.Height-1,16)/*!Player.IsJumping && !Player.IsFalling*/){
			//Set state: Ducking
			Player.State = ducking;
			Player.Y += 10;
			Player.Height = 22;
			//Player.Sprite = (Player.Dir>0?2:3);
		}
		
		


		
		
	}//end of normal mode
	else{
		
		if(Player.State==ducking){
			if(KeyState.Left){
				Player.Dir = -2;
				//Player.Sprite = 3;
				
				if(!KeyState.Down){
					Player.State = normal;
					Player.Y -= 10;
					Player.Height = 32;
				};	
			}
			if(KeyState.Right){
				Player.Dir = 2;
				//Player.Sprite = 2;
				
				if(!KeyState.Down){
					Player.State = normal;
					Player.Y -= 10;
					Player.Height = 32;
				};				
			}
			if( (KeyState.Up && !PreviousKeyState.Up) || KeyState.Jump ){
				Player.State = normal;
				//Player.Sprite = (Player.Dir>0?0:1);
				Player.Y -= 10;
				Player.Height = 32;
				KeyState.Jump = 0;
			}
			if(KeyState.Down && !PreviousKeyState.Down){
				Player.State = (Player.HasSpringBall?spring_ball:morph_ball);
				Player.Height = 16;
				//Player.Y += 6;
			}			
			/*if(KeyState.ToggleWeapon && !PreviousKeyState.ToggleWeapon){
				Player.ActiveWeapon = (Player.ActiveWeapon==beam_active?missile_active:beam_active);
			};*/
			
			Player.Aim = Player.Dir;
			
			if(KeyState.Fire){
				PlayerShoot();
			}
			
		}//end of ducking mode
		else{
			
			if( (Player.State==morph_ball) || (Player.State==spring_ball) ){
				
				//Player.Sprite = 4;
				
				short AnimSequense = 2;
				switch(Player.State){
					case morph_ball:	AnimSequense = 2;		
					break;
					case spring_ball:	AnimSequense = 4;			
					break;
				}
				
				//Player.Sprite = PlayerAnimTab[AnimSequense][Gamestate.Count2];
				Player.Sprite = (Player.HasVariaSuit?VariaPlayerAnimTab[AnimSequense][Gamestate.Count2]:PlayerAnimTab[AnimSequense][Gamestate.Count2]);
				
				if(KeyState.Left){
					if(PlayerFreeLeft(Player.X,Player.Y,16)){
						Player.X -= Player.WalkSpeed;
					}
				}
				else{
					if(KeyState.Right){
						if(PlayerFreeRight(Player.X+15,Player.Y,16)){
							Player.X += Player.WalkSpeed;
						}
					}
				}//end of Left
				if(KeyState.Down && !PreviousKeyState.Down && Player.HasSpiderBall && !KeyState.Jump && !Player.PreventSpiderCount){
					Player.State = spider_ball;
					Player.SpiderCurrXDir = 0;
					Player.SpiderCurrYDir = 0;
					Player.SpiderPrefXDir = 0;
					Player.SpiderPrefYDir = 0;
				}
				/*if(KeyState.Up && PlayerFreeUp(Player.X,Player.Y,16)>=6){// Replaceb by code below for improvement
					Player.State = ducking;
					Player.Sprite = (Player.Dir>0?2:3);
					Player.Y -= 6;
					Player.Height = 22;
				}*/
				
				void DuckUp(){
					
					if(Player.SpiderStateLeftTimer<=0){// This one fixes a bug where you could enter ducking mode through solid roof when pressing Up and Jump simultaniously in spider ball mode
						// Enter ducking mode from morph ball / spring ball mode
						Player.State = ducking;
						//Player.Sprite = (Player.Dir>0?2:3);
						Player.Y -= 6;
						Player.Height = 22;
					}
				};
				
				if(KeyState.Up){
					
					if(PlayerFreeUp(Player.X,Player.Y,16)>=6){
						DuckUp();
						/*Player.State = ducking;
						Player.Sprite = (Player.Dir>0?2:3);
						Player.Y -= 6;
						Player.Height = 22;*/
					}
					else{
						if(PlayerWrapAroundUp()){
							DuckUp();
							/*Player.State = ducking;
							Player.Sprite = (Player.Dir>0?2:3);
							Player.Y -= 6;
							Player.Height = 22;*/
						};
					};
					
				};
				
				
				
				
				if( (Player.State==spring_ball) && KeyState.Jump ){

					if( /*!PreviousKeyState.Jump &&*/ !PlayerFreeDown(Player.X,Player.Y+15,16) ){
						Player.IsJumping = (Player.HasHighJump?springball_hijump_jumpheight:springball_normal_jumpheight);  		
					}
				}
				else{
					
					if(!Player.IsBounchingBall)
						Player.IsJumping = 0;
				}
				
				/*if(Player.IsJumping){
					short Dist = FreeUp(Player.X,Player.Y,16);
					if(Dist>0){
								
						short JumpSpeed = (Player.IsJumping>=player_normal_jumpheight/2?player_jumpspeed:player_jumpspeed/2);
				
						Player.Y -= min(Dist,JumpSpeed);
						Player.IsJumping -= min(Dist,JumpSpeed);
				
				
				
					}
					else{
						// in a jump, but not free up anymore:
						// Abort jump
						Player.IsJumping = 0;
					};
				};//End of jump code
				*/
				
			}//end of morph_ball mode
			else{
				
				//Spider ball
				if( Player.State==spider_ball && Gamestate.Count1%2 ){					
					
					//Player.Sprite = PlayerAnimTab[(Player.SpiderCurrXDir>0?7:6)][Gamestate.Count2];	
					//short I1 = (Player.SpiderCurrXDir>0?7:6);
					//Player.Sprite = (Player.HasVariaSuit?VariaPlayerAnimTab[I1][Gamestate.Count2]:PlayerAnimTab[I1][Gamestate.Count2]);
					
					
					short Hold = 0;
					
					if(KeyState.Jump){
						//Player.State = (Player.HasSpringBall?spring_ball:morph_ball);
						//Player.Y -= 2;
						ExitSpiderBallMode();
					};
					
					
					/*if( (KeyState.Left && PreviousKeyState.Left) || (KeyState.Right && PreviousKeyState.Right) ||
							(KeyState.Up && PreviousKeyState.Up)  ||  (KeyState.Down && PreviousKeyState.Down) ){
					*/
					if( (KeyState.Left && Player.SpiderPrevKeyLeft) || (KeyState.Right && Player.SpiderPrevKeyRight) ||
							(KeyState.Up && Player.SpiderPrevKeyUp)  ||  (KeyState.Down && Player.SpiderPrevKeyDown) ){

					
						Hold = 1;						
					};
					
					Player.SpiderPrevKeyLeft = KeyState.Left;
					Player.SpiderPrevKeyRight = KeyState.Right;
					Player.SpiderPrevKeyUp = KeyState.Up;
					Player.SpiderPrevKeyDown = KeyState.Down;
					
					if( (Player.SpiderPrefXDir==0) && (Player.SpiderPrefYDir==0) ){
						// Has just entered spider ball mode. Not clinging to wall yet
						if(!PlayerFreeLeft(Player.X,Player.Y+2,16-4)){
							Player.SpiderCurrXDir = 0;
							Player.SpiderCurrYDir = 2;//
							Player.SpiderPrefXDir = -2;
							Player.SpiderPrefYDir = 2;//
							Player.X -= 2;
						}
						else{
							if(!PlayerFreeRight(Player.X+15,Player.Y+2,16-4)){
								Player.SpiderCurrXDir = 0;
								Player.SpiderCurrYDir = 2;//
								Player.SpiderPrefXDir = 2;
								Player.SpiderPrefYDir = 2;//
								Player.X += 2;
							}
							else{
								if(!PlayerFreeUp(Player.X+2,Player.Y,16-4)){
									Player.SpiderCurrXDir = 2;//
									Player.SpiderCurrYDir = 0;
									Player.SpiderPrefXDir = 2;//
									Player.SpiderPrefYDir = -2;	
									Player.Y -= 2;								
								}
								else{
									if(!PlayerFreeDown(Player.X+2,Player.Y+15,16-4)){
										Player.SpiderCurrXDir = 2;//
										Player.SpiderCurrYDir = 0;
										Player.SpiderPrefXDir = 2;//
										Player.SpiderPrefYDir = 2;
										Player.Y += 2;
									}
									else{
										//Fall down until something to stick to has been reached
										
										short FallSpeed = (Player.IsFalling>=player_normal_jumpheight/2?player_fallspeed:player_fallspeed/2);
										//short FallSpeed = (Player.IsFalling>=player_normal_jumpheight?player_fallspeed:player_fallspeed);
		
										if(Player.IsInWater && !Gamestate.Count1%2){
											FallSpeed = 0;
										};
		
										short Dist = PlayerFreeDown(Player.X+2,Player.Y+Player.Height-1-2,16-4);
									
										Player.Y += min(Dist,FallSpeed);
										Player.IsFalling += min(Dist,FallSpeed);
										
									}
								}
							}
						}
					}
					else{								
						
						Player.IsFalling = 0;														
					
						if( (Player.SpiderCurrXDir>0) ){
							if(PlayerFreeRight(Player.X+15-2,Player.Y+2,16-4)){
								// move right			
							}
							else{
								Player.SpiderCurrXDir = 0;
								Player.SpiderPrefYDir = -Player.SpiderPrefYDir;
								Player.SpiderCurrYDir = Player.SpiderPrefYDir;
							//	Player.Y += Player.SpiderCurrYDir;
							};
						};
	
						if( (Player.SpiderCurrXDir<0) ){
							if(PlayerFreeLeft(Player.X+2,Player.Y+2,16-4)){
								// move left
							}
							else{
								Player.SpiderCurrXDir = 0;
								Player.SpiderPrefYDir = -Player.SpiderPrefYDir;
								Player.SpiderCurrYDir = Player.SpiderPrefYDir;
							//	Player.Y += Player.SpiderCurrYDir;
							};
						};
					
						if( (Player.SpiderCurrYDir>0) ){
							if(PlayerFreeDown(Player.X+2,Player.Y+15-2,16-4)){
								// Move down
							}
							else{
								Player.SpiderCurrYDir = 0;
								Player.SpiderPrefXDir = -Player.SpiderPrefXDir;
								Player.SpiderCurrXDir = Player.SpiderPrefXDir;
								//Player.X += Player.SpiderCurrXDir;
							};
						};
	

						if( (Player.SpiderCurrYDir<0) ){
							if(PlayerFreeUp(Player.X+2,Player.Y+2,16-4)){
								// Move up
							}
							else{
								Player.SpiderCurrYDir = 0;
								Player.SpiderPrefXDir = -Player.SpiderPrefXDir;
								Player.SpiderCurrXDir = Player.SpiderPrefXDir;
								//Player.X += Player.SpiderCurrXDir;
							};
						};
	
	
						if(Player.SpiderCurrXDir){
							//new: if
							if( ((Player.SpiderCurrXDir>0) && KeyState.Right) || ((Player.SpiderCurrXDir<0) && KeyState.Left) || Hold ){
							
							Player.X += Player.SpiderCurrXDir;
							if(Player.SpiderPrefYDir<0){
								if(PlayerFreeUp(Player.X+2,Player.Y+2,16-4)){
									Player.SpiderCurrXDir = 0;
									Player.SpiderPrefXDir = -Player.SpiderPrefXDir;
									Player.SpiderCurrYDir = Player.SpiderPrefYDir;
								};
							}
							else{
								if(PlayerFreeDown(Player.X+2,Player.Y+15-2,16-4)){
									Player.SpiderCurrXDir = 0;
									Player.SpiderPrefXDir = -Player.SpiderPrefXDir;
									Player.SpiderCurrYDir = Player.SpiderPrefYDir;								
								};
							};
							}
							else{//new: else
								if( (Player.SpiderCurrXDir>0) ){
									if(KeyState.Left){
										Player.SpiderCurrXDir = -2;
										Player.SpiderPrefXDir = -2;
									};
								}
								else{// (Player.SpiderCurrXDir<0)
									if(KeyState.Right){
										Player.SpiderCurrXDir = 2;
										Player.SpiderPrefXDir = 2;
									};
								}
							};//new: }
						}
						else{
	
							if(Player.SpiderCurrYDir){
								//new: if
								if( ((Player.SpiderCurrYDir>0) && KeyState.Down) || ((Player.SpiderCurrYDir<0) && KeyState.Up)  || Hold ){
	
								Player.Y += Player.SpiderCurrYDir;
								if(Player.SpiderPrefXDir>0){
									if(PlayerFreeRight(Player.X+15-2,Player.Y+2,16-4)){
										Player.SpiderCurrYDir = 0;
										Player.SpiderPrefYDir = -Player.SpiderPrefYDir;
										Player.SpiderCurrXDir = Player.SpiderPrefXDir;
									};
								}
								else{
									if(PlayerFreeLeft(Player.X+2,Player.Y+2,16-4)){
										Player.SpiderCurrYDir = 0;
										Player.SpiderPrefYDir = -Player.SpiderPrefYDir;
										Player.SpiderCurrXDir = Player.SpiderPrefXDir;
									};
								};
								}
								else{//new: else
									if( (Player.SpiderCurrYDir>0) ){
										if(KeyState.Up){
											Player.SpiderCurrYDir = -2;
											Player.SpiderPrefYDir = -2;
										};
									}
									else{// (Player.SpiderCurrYDir<0)
										if(KeyState.Down){
											Player.SpiderCurrYDir = 2;
											Player.SpiderPrefYDir = 2;
										};
									}
								};//new: }			
							};	
						};	
					
					};
				
				};// End of spider ball mode
				
			}
		}
	};
	
	if(KeyState.Fire && !PreviousKeyState.Fire && Player.HasBomb && ( (Player.State==morph_ball) || (Player.State==spider_ball) || (Player.State==spring_ball) ) ){
		AddBomb();
	};
	
	if(Player.IsJumping){
		short Dist = PlayerFreeUp(Player.X,Player.Y,16);
		Player.IsFalling = 0;
		if(Dist>0){
								
			short JumpSpeed = (Player.IsJumping>=player_normal_jumpheight/2?player_jumpspeed:player_jumpspeed/2);
			
			if(Player.IsInWater && Gamestate.Count1%2){
				JumpSpeed = 0;
			};
			
			Player.Y -= min(Dist,JumpSpeed);
			Player.IsJumping -= min(Dist,JumpSpeed);
				
				
				
		}
		else{
			
			if(!PlayerWrapAroundUp()){
				// in a jump, but not free up anymore:
			// Abort jump
				Player.IsJumping = 0;
			};
			
			//Player.IsJumping = 0;
			
			/*if( (Player.X%16) >= 12){
				if(GetTile(Player.X+4,Player.Y-15)<tiles_solid_low){
					Player.X += (16-(Player.X%16));
				}
				else{
					Player.IsJumping = 0;
				};				
			}
			else{
				if( (Player.X%16)<=4 ){
					if(GetTile(Player.X+15-4,Player.Y-15)<tiles_solid_low){
						Player.X -= (Player.X%16);
					}
					else{
						Player.IsJumping = 0;
					};
				}
				else{
					// in a jump, but not free up anymore:
					// Abort jump
					Player.IsJumping = 0;
				};
			};*/
			
			
		};
	};
	
	if(!Player.IsJumping && (Player.State!=spider_ball) ){
		// Gravity
		
		short FallSpeed = (Player.IsFalling>=player_normal_jumpheight/2?player_fallspeed:player_fallspeed/2);
		
		if(Player.IsInWater && Gamestate.Count1%2){
			FallSpeed = 0;
		};
		
		short Dist = PlayerFreeDown(Player.X,Player.Y+Player.Height-1,16);
		if(Dist>0){
			Player.Y += min(Dist,FallSpeed);
			Player.IsFalling += min(Dist,FallSpeed);
			
			/*if(Player.State==normal){
				//Player.Sprite = (Player.Dir>0?14:15);
				if(Player.Aim==aim_up){
					//Player.Sprite += 185;
				}
				else{
					if(Player.Aim==aim_down){
						//Player.Sprite += 193;
					};
				};
			};*/
				
			if( ( (Player.State==morph_ball) || (Player.State==spring_ball) ) ){
				//	(Dist<=FallSpeed) &&
				
				if( !Player.IsBounchingBall ){
					if( !PlayerFreeDown(Player.X,Player.Y+16-1,16) && (Player.IsFalling>player_ball_bounceheight) ){
						Player.IsBounchingBall = 1;
						Player.IsJumping = player_ball_bounceheight;
						Player.IsFalling = 0;
					};
					
				}
				else{
					Player.IsBounchingBall = 0;
				}
					
				
			};
				
		}
		else{
			Player.IsFalling = 0;
			Player.IsSpinJumping = 0;
			Player.SpaceJumpFailed = 0;
		}
	}
	
	/*if(Player.IsJumping || Player.IsFalling){
		if(KeyState.Down){
			Player.Aim = aim_down;
		}
	}*/
	
	
	if(Player.IsSpinJumping){
		//Player.Sprite = PlayerAnimTab[(Player.Dir>0?8:9)][Gamestate.Count2];		
		//short I1 = (Player.Dir>0?8:9);
		//Player.Sprite = (Player.HasVariaSuit?VariaPlayerAnimTab[I1][Gamestate.Count2]:PlayerAnimTab[I1][Gamestate.Count2]);
		
		Player.ForceXMove = (Player.Dir>0?1:-1);
		Player.ForceXMoveSpeed = 2;
	}
	
	if(Player.ForceXMove){
		
		if( !(Player.IsInWater && Gamestate.Count1%2) ){
		
		short Dist = 0;
		
//		if( (!KeyState.Left || !KeyState.Right) && !Player.Blocked   )
//		if(Player.Blocked)
		if( ((!KeyState.Left && !KeyState.Right) && !Player.Blocked) || Player.Blocked ){
		
			if(Player.ForceXMove>0){//Right
				Dist = PlayerFreeRight(Player.X+15,Player.Y,32);
				Dist = min(abs(Player.ForceXMoveSpeed),Dist);
				Player.ForceXMove--;
			}
			else{//Left
				Dist = PlayerFreeLeft(Player.X,Player.Y,32);
				Dist = -min(abs(Player.ForceXMoveSpeed),Dist);
				Player.ForceXMove++;
			}		
			
			Player.X += Dist;	
			if(Dist==0){
				Player.ForceXMove = 0;
				Player.Blocked = 0;
			};
			if(Player.Blocked)
				Player.Blocked --;
			
		}	
		
		}//End Blocking detection
				
	}//End ForceXMove
	
	Player.IsInWater = 0;
	Player.WalkSpeed = 2;
	// Check for collisions with hostile tiles or water
	short Xoff,Yoff;
	
	for(Xoff=0;Xoff<=15;Xoff+=15){
		
		for(Yoff=0;Yoff<=Player.Height;Yoff+=15){
			
			unsigned char Tile = GetTile(Player.X+Xoff,Player.Y+Yoff);
			
			if( (Tile>=tiles_hostile_low) && (Tile<=tiles_hostile_high) ){				
				
				short Damage = hostile_tile_damage;
				if( (Tile>=94) && (Tile<=97) ){
					Damage = respawn_tile_damage;
				}
				
				PlayerWounded(Damage);
				
				if( (Tile>=tiles_hostile_bush_low) && (Tile<=tiles_hostile_bush_high) ){
					// Bounche
					
					Player.ForceXMove = (Xoff==0?4:-4);
					Player.ForceXMoveSpeed = 4;
					Player.Blocked = 4;
					
				};
				
				if( (Tile==tile_lava) || (Tile==tile_lava2)){
					Player.IsInWater = 1;
					if(Gamestate.Count1%2){
						Player.WalkSpeed = 0;
					};
				};
				
				break; // Only execute once per frame						
						
			}
			else{
				if( (Tile>=tiles_liquid_low) && (Tile<=tiles_liquid_high) ){
					Player.IsInWater = 1;
					if(Gamestate.Count1%2){
						Player.WalkSpeed = 0;
					};
				};
			};			
		};		
	};	
	
	// Set sprite:	
	
	short UseAnimTab = 0;
	short Index,SubIndex;
	
	if(Player.State==morph_ball){
		UseAnimTab = 1;
		Index = 2;
		SubIndex = Gamestate.Count2;
	}
	else{
		if(Player.State==spider_ball){
			UseAnimTab = 1;
			Index = 6;
			SubIndex = Gamestate.Count2;
		}
		else{
			if(Player.State==spring_ball){
				UseAnimTab = 1;
				Index = 4;
				SubIndex = Gamestate.Count2;
			}
			else{
				if(Player.State==ducking){
					Player.Sprite = (Player.HasVariaSuit?213:2);
					if(Player.Dir>0)
						Player.Sprite++;
				}
				else{
					// Normal
					
					if(Player.IsSpinJumping){
						/* Old code: No screw attack
						UseAnimTab = 1;
						Index = 8;
						SubIndex = Gamestate.Count2;
						*/
						if(Player.HasScrewAttack){
							UseAnimTab = 1;
							Index = 12;
							SubIndex = Gamestate.Count2;
						}
						else{
							UseAnimTab = 1;
							Index = 8;
							SubIndex = Gamestate.Count2;
						};						
					}
					else{
						if(Player.IsJumping || Player.IsFalling){
							
							if(Player.Aim==aim_up){
								Player.Sprite = (Player.HasVariaSuit?225:199);
							}
							else{
								if(Player.Aim==aim_down){
									Player.Sprite = (Player.HasVariaSuit?227:207);
								}
								else{
									Player.Sprite = (Player.HasVariaSuit?223:14);
								}
							}
							if(Player.Dir>0)
								Player.Sprite++;
								
						}
						else{
							if(Player.IsWalking){
								UseAnimTab = 1;
								Index = (Player.Aim==aim_up?10:0);
								SubIndex = Player.WalkAnimStep;
								/*if(Player.Dir)
									Index++;*/
							}
							else{
								// Standing
								if(Player.Aim==aim_up){
									Player.Sprite = (Player.HasVariaSuit?221:205);
								}
								else{
									Player.Sprite = (Player.HasVariaSuit?211:0);
								};								
								if(Player.Dir>0)
									Player.Sprite++;								
								
							}
						}
					};					
				}
			}
		}
	}	
		
	if(UseAnimTab){
		
		if(Player.Dir>0)
			Index++;
		
		if(Player.HasVariaSuit){			
			Player.Sprite = VariaPlayerAnimTab[Index][SubIndex];
		}
		else{
			Player.Sprite = PlayerAnimTab[Index][SubIndex];			
		};
		
	};	
	
	
	// Check if it is time to load a new map
	
	if( (Player.X < (-8)) /*&& (KeyState.Left)*/ ){
		Player.AX -= 1;
		Player.RoomUpdate = XLeft;
	};
	if( (Player.X > (Room->Width*16-8)) /*&& (KeyState.Right)*/ ){
		Player.AX += 1;
		Player.RoomUpdate = XRight;
	};
	
	if( (Player.Y < (-8)) /*&& (KeyState.Up)*/ ){
		Player.AY -= 1;
		Player.RoomUpdate = YUp;
	};
	if( (Player.Y > (Room->Height*16-8)) /*&& (KeyState.Right)*/ ){
		Player.AY += 1;
		Player.RoomUpdate = YDown;
	};	
	
	if(Player.ShootTimer)
		Player.ShootTimer--;
		
};

short FindFreePlayerShotSlot(){
	
	short C;
	for(C=0;C<nr_of_player_shots;C++){
		if(PlayerShots[C].Active==0){
			return C;
		};
	};
	return -1;
	
};

void AddBomb(){
	
	if(Player.ShootTimer)
		return;
	
	if(/*Player.HasBomb &&*/ (Player.ShootTimer==0) ){
		short SlotNr = FindFreePlayerShotSlot();
		
		if(SlotNr>=0){
			Player.ShootTimer = player_bomb_interval;
		
			PlayerShots[SlotNr].X = Player.X+8;
			PlayerShots[SlotNr].Y = Player.Y+9;
			PlayerShots[SlotNr].Handler = 4;
			PlayerShots[SlotNr].Sprite = 91;
			PlayerShots[SlotNr].Active = bomb_countdown_time;
			PlayerShots[SlotNr].Type = BTbomb;
		};
	};
	
	
};

void PlayerShoot(){
	
	if(Player.ShootTimer)
		return;
	
	short SlotNr = FindFreePlayerShotSlot();
	// -1 == error
	if(SlotNr<0)
		return;
	
	Player.ShootTimer = player_fire_interval;
	
	// Assign position 
	short Xoff=0,Yoff=0;
	switch(Player.Aim){
		case aim_up:
			Xoff = (Player.Dir>0?7:2);
			Yoff = -3;
		break;
		case aim_down:
			Xoff = (Player.Dir>0?7:2);
			Yoff = 20;
		break;
		case aim_left:
			Xoff = 0;
			Yoff = 8;
		break;
		case aim_right:
			Xoff = 16;
			Yoff = 8;
		break;
	}
	
	PlayerShots[SlotNr].X = Player.X + Xoff;// + (Player.Aim==aim_right?16:0);
	PlayerShots[SlotNr].Y = Player.Y + Yoff;//+8;
	
	// Set up direction:
	PlayerShots[SlotNr].Dx = 0;
	PlayerShots[SlotNr].Dy = 0;
	
	PlayerShots[SlotNr].D0 = 0;
	PlayerShots[SlotNr].D1 = 0;
	
	switch(Player.Aim){
		case aim_up:
			PlayerShots[SlotNr].Dy = -4;
		break;
		case aim_down:
			PlayerShots[SlotNr].Dy = 4;
		break;
		case aim_left:
			PlayerShots[SlotNr].Dx = -4;
		break;
		case aim_right:
			PlayerShots[SlotNr].Dx = 4;
		break;
	}
	
	if(Player.ActiveWeapon == beam_active){
	
		switch(Player.BeamWeapon){
			case beam:
				PlayerShots[SlotNr].Handler = 1;
				PlayerShots[SlotNr].Type = BTnormalBeam;
				if( (Player.Aim==aim_left) || (Player.Aim==aim_right) ){
					PlayerShots[SlotNr].Sprite = 32;
				}
				else{
					PlayerShots[SlotNr].Sprite = 33;
				}			
				//PlayerShots[SlotNr].Dx	= (Player.Dir>0?4:-4);
				PlayerShots[SlotNr].Active = 60;
			break;
			case ice_beam:
				PlayerShots[SlotNr].Handler = 1;
				PlayerShots[SlotNr].Type = BTiceBeam;
				PlayerShots[SlotNr].Sprite = 34;
				//PlayerShots[SlotNr].Dx	= (Player.Dir>0?4:-4);
				PlayerShots[SlotNr].Active = 60;
			break;
			case wawe_beam:
				PlayerShots[SlotNr].Sprite = 35;
				PlayerShots[SlotNr].Handler = 2;
				PlayerShots[SlotNr].Type = BTwaveBeam;
				if(PlayerShots[SlotNr].Dx){
					PlayerShots[SlotNr].Dy = 4;
					PlayerShots[SlotNr].D0 = 1;
				}
				else{
					PlayerShots[SlotNr].Dx = 4;				
				}
				PlayerShots[SlotNr].Active = 60;
			break;
			case spazer_lazer_beam:
				if(PlayerShots[SlotNr].Dx){
					PlayerShots[SlotNr].Sprite = 181;
				}
				else{
					PlayerShots[SlotNr].Sprite = 182;
				};
				PlayerShots[SlotNr].Type = BTspazerBeam;
				PlayerShots[SlotNr].Handler = 1;
				PlayerShots[SlotNr].Active = 60;
			break;
			case plasma_beam:
				if(PlayerShots[SlotNr].Dx){
					PlayerShots[SlotNr].Sprite = 116;
				}
				else{
					PlayerShots[SlotNr].Sprite = 183;
				};
				PlayerShots[SlotNr].Type = BTplasmaBeam;
				PlayerShots[SlotNr].Handler = 3;
				PlayerShots[SlotNr].Active = 60;
			break;
		};
	}
	else{// Player.ActiveWeapon == missile_active
		
		
		if(Player.Missiles>0){
			// Add a missile
			Player.Missiles--;
		
			PlayerShots[SlotNr].Handler = 5;
		
			short SpriteNr;
			if(PlayerShots[SlotNr].Dy>0){//Down			
				SpriteNr = 90;
			}
			else{
				if(PlayerShots[SlotNr].Dy<0){//Up			
					SpriteNr = 71;
				};
			};
			if(PlayerShots[SlotNr].Dx>0){//Right			
				SpriteNr = 88;
			}
			else{
				if(PlayerShots[SlotNr].Dx<0){//Left			
					SpriteNr = 89;
				};
			};
			PlayerShots[SlotNr].Sprite = SpriteNr;
			PlayerShots[SlotNr].Active = 8;
	 		PlayerShots[SlotNr].Type = BTmissile;
	 		
		};
	};
		
};

void ShotHandler1(shot* Shot){
	// Handles shot that travels in a straight line in x and/or y direction.
	// Lives for a given number of frames or until it collides with terrain.
	
	// Configuration:
	// Dx				:	Speed in X dir
	// Dy				:	Speed in Y dir
	// Active		: Nr of frames to live
	
	
	Shot->Active--;
	
	if(Shot->Dx > 0){//Right
		if(FreeRight(Shot->X-Shot->Dx,Shot->Y,8)>=Shot->Dx){
			Shot->X += Shot->Dx;
		}
		else{
			Shot->Active = 0;
		}
	}
	else{
		if(Shot->Dx < 0){//Left
			if(FreeLeft(Shot->X+8-Shot->Dx,Shot->Y,8)>=abs(Shot->Dx)){
				Shot->X += Shot->Dx;
			}
			else{
				Shot->Active = 0;
			}
		}
	}
	
	if(Shot->Dy > 0){//Down
		if(FreeDown(Shot->X,Shot->Y-Shot->Dy,8)>=Shot->Dy){
			Shot->Y += Shot->Dy;
		}
		else{
			Shot->Active = 0;
		}
	}
	else{
		if(Shot->Dy < 0){//Up
			if(FreeUp(Shot->X,Shot->Y-Shot->Dy,8)>=abs(Shot->Dy)){
				Shot->Y += Shot->Dy;
			}
			else{
				Shot->Active = 0;
			}
		}
	}	
	
};

#define wavebeam_width	8

void ShotHandler2(shot* Shot){
	// Handles shot that travels in a waveform pattern, travel direction can be x or y.
	// Lives for a given number of frames or until it collides with terrain.
	
	// Configuration:
	// Dx				:	Speed in X dir
	// Dy				:	Speed in Y dir
	// Active		: Nr of frames to live
	// Handler	: 2
	// D0				:	Travel direction: 0 = X , 1 = Y
	// D1				:	Counter, initialized to 0

	
	if( (++Shot->D1)>=wavebeam_width ){
	
		if(!Shot->D0){// X = travel direction
			Shot->Dx = -Shot->Dx;
		}
		else{// Y = travel direction
			Shot->Dy = -Shot->Dy;
		}
		Shot->D1 = 0;
	}
	
	
//	ShotHandler1(Shot);

	Shot->Active--;
	
	if(Shot->Dx > 0){//Right
		Shot->X += Shot->Dx;
	}
	else{
		Shot->X += Shot->Dx;
	}
	
	if(Shot->Dy > 0){//Down
		Shot->Y += Shot->Dy;
	}
	else{
		if(Shot->Dy < 0){//Up
			Shot->Y += Shot->Dy;
		}
	}

	
};

void ShotHandler3(shot* Shot){
	// Handles plasma beam. Travels in a straight line through any material
		
	// Handles missiles that travels in a straight line in x and/or y direction.
	// Lives for a given number of frames or until it collides with terrain.
	
	// Configuration:
	// Dx				:	Speed in X dir
	// Dy				:	Speed in Y dir
	// Active		: Nr of frames to live

	Shot->X += Shot->Dx;
	Shot->Y += Shot->Dy;
	
	Shot->Active--;
	
};

void ShotHandler4(shot* Shot){
	// Handles bomb. Counts down, then explodes.
	
	if((--Shot->Active)<=0){
		short Dx[4]={-12,12,0,0},Dy[4]={0,0,-12,12},C;
		
		for(C=0;C<4;C++){
			// Kill nearby bobmable and shootable tiles
			
			unsigned char Tile = GetTile(Shot->X+Dx[C],Shot->Y+Dy[C]);
			
			if( (Tile>=tiles_solid_bombable_low) && (Tile<=tiles_solid_bombable_high) ){
				PutTile(Shot->X+Dx[C],Shot->Y+Dy[C],0);
			}
			else{
				
				KillShootableTiles(Shot->X+Dx[C],Shot->Y+Dy[C],4,4);
								
			};
			
			// Make player bombjump if she is close enough
			if( !Player.IsBounchingBall && BoundsCollide2HW(Player.X-8,Player.Y-8,Player.Height+16,16,Shot->X+4-8,Shot->Y-8,8+16,8+16) ){
				
				if(Player.BlockBombJump==0){	
					Player.IsBounchingBall = 1;
					Player.IsJumping = 40;
					Player.IsFalling = 0;
				};
				if(Player.State==spider_ball){
					
					ExitSpiderBallMode();	
										
					if(!PlayerFreeUp(Player.X,Player.Y,16)<4){
						Player.IsBounchingBall = 0;
						Player.IsJumping = 0;
						Player.BlockBombJump = 20;
					};				
										
				};
			};
			
		};
		
	};
	
	
	if(Shot->Active<=8){
		Shot->Type = BTexplosion;
		if(Shot->Active<=4){
			Shot->Sprite = 94;
		}
		else{
			Shot->Sprite = 93;	
		};	
	}
	else{
		if(Gamestate.TwoAnimStep){
			Shot->Sprite = 91;
		}
		else{
			Shot->Sprite = 92;
		};
	};
	
};

void ShotHandler5(shot* Shot){
	// Handles missiles. Explodes when hit something.
	
	if(Shot->Type==BTmissile){//!=BTexplosion){
		Shot->Active = 8;// Prevents ShotHandler1 from terminating the shot 
		Shot->X += Shot->Dx;//ShotHandler1(Shot);
		Shot->Y += Shot->Dy;
		
		#ifdef watchdog
		 WatchDog.Code4 = 1;
		#endif
		
		#define range 6
		
		short RX,RY;
		
		for(RX=Shot->X/*-Shot->Dx*/;RX<=(Shot->X/*-Shot->Dx*/+range);RX+=range){
			for(RY=Shot->Y/*-Shot->Dy*/;RY<=(Shot->Y/*-Shot->Dy*/+range);RY+=range){
				
				#ifdef watchdog
		 			WatchDog.Code4 = 2;
		 			WatchDog.Code5 = Shot->X;
		 			WatchDog.Code6 = Shot->Y;
		 			WatchDog.Code7 = RX;
		 			WatchDog.Code8 = RY;
				#endif
				
				unsigned char Tile = GetTile(RX,RY);
				
				if(Tile>=tiles_solid_low){
					//Explode		
					Shot->Type = BTexplosion;
					Shot->Sprite = 93;		
				};
				
			};
		};
		
		#ifdef watchdog
		 	WatchDog.Code4 = 3;
		#endif
		
		#undef range
		
		/*unsigned char Tile = GetTile(Shot->X-Shot->Dx,Shot->Y-Shot->Dy+4);
	
		if(Tile>=tiles_solid_low){
			//Explode		
			Shot->Type = BTexplosion;
			Shot->Sprite = 93;		
		};*/
	
	}
	else{
		
		#ifdef watchdog
		 WatchDog.Code4 = 4;
		#endif
		
		if( (--Shot->Active)<=0 ){
			
			/*unsigned char Tile = GetTile(Shot->X-Shot->Dx,Shot->Y-Shot->Dy);
			
			if( (Tile>=tiles_solid_shootable_low) && (Tile<=tiles_solid_shootable_high) ){
			//Kill shootable tiles
				PutTile(Shot->X,Shot->Y,0);
			};	
				
			if( (Tile>=tiles_solid_shootable_respawn_low) && (Tile<=tiles_solid_shootable_respawn_high) ){
				// Kill, respawn tile
			};*/	
			
			#ifdef watchdog
			 WatchDog.Code4 = 5;
			#endif
			
			short DX = (Shot->Dx>0?8:0);
			
		//	for(DX=0;DX+=8;DX<=8){
			
			unsigned char Tile = GetTile(Shot->X+DX/*-Shot->Dx*/,Shot->Y/*-Shot->Dy*/);
			
			if( (Tile>=tiles_solid_missile_shootable_low) && (Tile<=tiles_solid_missile_shootable_high) ){
				//Kill missile shootable tiles
//				Shot->Active = 0;
				if( ( --EventArray[Room->Event] )<=0 ){// (--Room->MissileDoorCount)
					
					short Y;
					
					if( (Tile==249) || (Tile==252) ){
						Y = (Shot->Y/16)*16;
					};
					if( (Tile==250) || (Tile==253) ){
						Y = (Shot->Y/16)*16-16;
					};
					if( (Tile==251) || (Tile==254) ){
						Y = (Shot->Y/16)*16-32;
					};
					
					if(Tile==255){
						PutTile(Shot->X,Shot->Y,0);						
					}
					else{
						AddSeriesExplosion(((Shot->X+DX)/16)*16,Y,16*3,16,-1);
					};					
					
					#ifdef watchdog
					 WatchDog.Code4 = 6;
					#endif
					
					/*short Dy;
					for(Dy=-32;Dy<=32;Dy+=16){
						if(GetTile(Shot->X+DX,Shot->Y+Dy)>=tiles_solid_missile_shootable_low){
							PutTile(Shot->X+DX,Shot->Y+Dy,0);
							
						};
						#ifdef watchdog
						 WatchDog.Code4 = 7;
						#endif
					};*/
				
					// Add animation
//					return;
				};
			};
			
		//	};
			#ifdef watchdog
		 		WatchDog.Code4 = 8;
			#endif
			
			KillShootableTiles(Shot->X/*-Shot->Dx*/,Shot->Y/*-Shot->Dy*/,16,16);
			#ifdef watchdog
		 		WatchDog.Code4 = 9;
			#endif
		}
		else{
			if(Shot->Active<=4){
				Shot->Sprite = 94;
			};
		};				
	};
	
};

void HandlePlayerShots(){
	
	short C;
	for(C=0;C<nr_of_player_shots;C++){
		
		#ifdef watchdog
		 WatchDog.Code2 = 1;
		#endif
		
		if(PlayerShots[C].Active){
					
			#ifdef watchdog
				WatchDog.Code2 = 2;
			#endif
			
			if( (PlayerShots[C].X>(Gamestate.FgX+screen_width+active_area_dist)) || (PlayerShots[C].X<(Gamestate.FgX-active_area_dist)) || 
			(PlayerShots[C].Y>(Gamestate.FgY+screen_height+active_area_dist)) || (PlayerShots[C].Y<(Gamestate.FgY-active_area_dist))	){
				
				PlayerShots[C].Active = 0;
				return;
			}			
			else{
				
				switch(PlayerShots[C].Handler){
					case 1:
						#ifdef watchdog
							WatchDog.Code3 = 1;
						#endif
						ShotHandler1( &PlayerShots[C] );					
					break;
					case 2:
						#ifdef watchdog
							WatchDog.Code3 = 2;
						#endif
						ShotHandler2( &PlayerShots[C] );
					break;
					case 3:
						#ifdef watchdog
							WatchDog.Code3 = 3;
						#endif
						ShotHandler3( &PlayerShots[C] );
					break;
					case 4:
						#ifdef watchdog
							WatchDog.Code3 = 4;
						#endif
						ShotHandler4( &PlayerShots[C] );
					break;
					case 5:
						#ifdef watchdog
							WatchDog.Code3 = 5;
						#endif
						ShotHandler5( &PlayerShots[C] );
					break;
					default:
						// Error
						#ifdef watchdog
							WatchDog.Code3 = 6;
						#endif
					break;
				};
			};
			
			#ifdef watchdog
				WatchDog.Code2 = 3;
			#endif
			
			if( (PlayerShots[C].Type!=BTbomb) && (PlayerShots[C].Type!=BTmissile) && (PlayerShots[C].Type!=BTexplosion) ){
				
				#ifdef watchdog
					WatchDog.Code2 = 4;
				#endif
				
				short Height = SpriteTab[PlayerShots[C].Sprite].Height;
				short Width = (PlayerShots[C].Type==BTspazerBeam?15:8);
				
				if( KillShootableTiles(PlayerShots[C].X,PlayerShots[C].Y,Width,Height) ){
					
					#ifdef watchdog
						WatchDog.Code2 = 5;
					#endif
					
					if(PlayerShots[C].Type!=BTplasmaBeam){
						PlayerShots[C].Active = 0;
						
						#ifdef watchdog
							WatchDog.Code2 = 6;
						#endif
						
					};
					
				};
				
			};
			
		};
		
	};
	
};

short KillShootableTiles(short X,short Y,short W,short H){
	
	short RX,RY,Res=0;
	//short Cnt = 0;
	
	for(RX=X;RX<=(X+W);RX+=(W)){
	
		for(RY=Y;RY<=(Y+H-1);RY+=(H-1)){
			//Cnt++;
			unsigned char Tile = GetTile(RX,RY);
	
			if( (Tile>=tiles_solid_shootable_low) && (Tile<=tiles_solid_shootable_high) ){
				PutTile(RX,RY,0);
				Res = 1;
			};
			
			if( (Tile>=tiles_hostile_shootable_low) && (Tile<=tiles_hostile_shootable_high) ){
				PutTile(RX,RY,0);
			};
			
			if( (Tile>=tiles_solid_shootable_respawn_low) && (Tile<=tiles_solid_shootable_respawn_high) ){
				// Kill tile, respawn
				short Offset = (Tile==WhiteRespawnTile?0:1);
		
			
				short D;
				for(D=0;D<NrOfRespawnTiles;D++){
					if(RespawningTiles[D].ActiveTimer==0){
						PutTile(RX,RY,Tile-RespawnTileIdxDist-Offset);
						RespawningTiles[D].ActiveTimer = TileRespawnTime;
						RespawningTiles[D].OriginalTile = Tile;
						RespawningTiles[D].X = RX/16;
						RespawningTiles[D].Y = RY/16;
						break;
					};
				};			
			
				Res = 1;		
			};
	
		};
	};
		
	return Res;
};

/*
short KillShootableTiles(short X,short Y){
	
	unsigned char Tile = GetTile(X,Y);
	
	if( (Tile>=tiles_solid_shootable_low) && (Tile<=tiles_solid_shootable_high) ){
		PutTile(X,Y,0);
		return 1;
	};
							
	if( (Tile>=tiles_solid_shootable_respawn_low) && (Tile<=tiles_solid_shootable_respawn_high) ){
		// Kill tile, respawn
		short Offset = (Tile==WhiteRespawnTile?0:1);
		
			
		short D;
		for(D=0;D<NrOfRespawnTiles;D++){
			if(RespawningTiles[D].ActiveTimer==0){
				PutTile(X,Y,Tile-RespawnTileIdxDist-Offset);
				RespawningTiles[D].ActiveTimer = TileRespawnTime;
				RespawningTiles[D].OriginalTile = Tile;
				RespawningTiles[D].X = X/16;
				RespawningTiles[D].Y = Y/16;
				break;
			};
		};			
			
		return 1;		
	};
	
	return 0;
};
*/

void PlayerWounded(short Damage){
	
	#ifdef immortal
	#warning "Immortal mode enabled"
	return;
	#endif
	
	Player.PreventSpiderCount = 8;
	
	if(Player.Immortal==0){
		
		if(Player.State==spider_ball){			
			ExitSpiderBallMode();
		};

		#ifdef immortal
		#warning "Immortal mode enabled"
		return;
		#endif
	
		if(Player.HasVariaSuit){
			Damage = Damage/2;
		};
		Player.Energy -= Damage;
	
		Player.Immortal = player_immortal_time;

		if( Player.Energy<=0 ){
			//Dead
			//GameOver();
			Player.Energy = 0;
			AddSamusKilledAnim();
			//Exit = 1;
		}
		else{// Not dead			
			
		};	
	
	};
	
};