#ifndef __minimap__
#define __minimap__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   minimap.h                                                             *
*			Description:                   *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

#define StartOfMiniMaps				(NrOfAreas+1+1)


#define NrOfMiniMaps					8



#define NrOfRoomsArea1				10
#define NrOfRoomsArea2				33
#define NrOfRoomsArea3				16
#define NrOfRoomsArea4				33
#define NrOfRoomsArea5				36
#define NrOfRoomsArea6				21
#define NrOfRoomsArea7				17
#define NrOfRoomsArea8				15

#define TotalNrOfRooms		(NrOfRoomsArea1+NrOfRoomsArea2+NrOfRoomsArea3+NrOfRoomsArea4+NrOfRoomsArea5+NrOfRoomsArea6+NrOfRoomsArea7+NrOfRoomsArea8)

extern short AreaOffsets[8];

extern char* VisitedRooms;



typedef struct{
	
	short X;
	short Y;
	
	short Height;
	short Width;
	
	short MapPosRunLength;
	
	short Format;
	
}map_segment;




enum MiniMapSpriteFormats{
	BlackWhite=0,
	GrayScale=1,
};


short IsVisited(short RunLengthPos);

void SetAsVisited(short RunLengthPos);

void DoMinimap(short AreaIdx);











#endif