#ifndef __level__
#define __level__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   level.h                                                               *
*			Description:                                                                  *
*     This file contains type definitions, functions, variables/pointers and 				*
*			constants that is used to access and load the room data and area data					*
*			which is stored in an external file, metromap.tta.														*
*			metromap.tta is generated by TTArchive by TICT.																*
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

// Nr of areas / "Levels"
#define NrOfAreas							8

// Defines which entry in metromap.tta is the first room
#define ArchiveStartOfRooms   (NrOfAreas+NrOfMiniMaps+1+1)

// Nr of frames to display shaking animation when an area is completed
#define area_completed_shaketime    (20*100)

#define BrainRoomIndex	173

typedef struct{
	// Contains info about a room. A room is a relatively small segment of an Area
	
	short Height;
	short Width;
	
	short NrOfEnemies;
	short NrOfItems;
	
	short Event;
	
	
}room;


typedef struct{
	// Contains header info about an Area. An area is divided in multiple rooms. 
	// 
	short NrOfRooms;
	
	short Height;
	short Width;
	
	short StartXUpper;
	short StartYUpper;
	short XoffsetUpper;
	
	short StartXLower;
	short StartYLower;
	short XoffsetLower;	
	
	short NextX;
	short NextY;
	short PrevX;
	short PrevY;
		
}area;

extern HANDLE Mapfile_sym_h;
extern void* MapArchive;
extern void* LevelArray;
extern void* AreaArray;
extern area* Area;
extern unsigned char* AreaMap;
extern char* YCorrMap;
extern char* XCorrMap;
extern room* Room;

// Load an area. 
short LoadArea(short Index);

// Load a room.
short LoadRoom(short Index);

void LoadEnemies(char* Raw);

void LoadItems(char* Raw);

short InitMapfilePointer();






#endif