
#include "all.h"

item* Items;

void HandleItems(){
	
		
	short C;
	
	for(C=0;C<Room->NrOfItems;C++){	
		
		// Only Items with Active==1 can be taken. Active==2 indicates that the item is encapsulated in a sphere
		if(Items[C].Active==1){
			
			// Collision check with player
			short PX = Player.X + SpriteTab[Player.Sprite].Xoff;
			short PY = Player.Y + SpriteTab[Player.Sprite].Yoff;
			short PW = (SpriteTab[Player.Sprite].DrawMode==width32?32:16);
			short PH = SpriteTab[Player.Sprite].Height;
			// All items will be within 16x16 and no drawing offset
			short IX = Items[C].X;// + SpriteTab[Items[C].Type].Xoff;
			short IY = Items[C].Y;// + SpriteTab[Items[C].Type].Yoff;
			short IW = 16;//(SpriteTab[Items[C].Type].DrawMode==width32?32:16);
			short IH = 16;//SpriteTab[Items[C].Type].Height;
	
			short Prompt = -1;
			short Cy;
			
			//	BOUNDS_COLLIDE2HW(x0,y0,x1,y1,w0,w1,h0,h1)
//			if( BOUNDS_COLLIDE2HW(PX,PY,IX,IY,PW,IW,PH,IH) ){
 			if( (Items[C].Active = 1) && BoundsCollide2HW(PX,PY,PH,PW,IX,IY,IH,IW) ){
//			if( BOUNDS_COLLIDE2HW_(PX,PY,IX,IY,PW,IW,PH,IH) ){
		
	 			switch(Items[C].Type){
 					case missile_pod_pu:
 						Player.MaxMissileLoad += 10;
 						Player.Missiles = Player.MaxMissileLoad;
 						Items[C].Active = 0;
 					break;
	 				case energy_tank_pu:
 						Player.MaxEnergyLevel += 100;
 						Player.Energy = Player.MaxEnergyLevel;
 						Items[C].Active = 0;
 					break;
 					case energy_ball_pu:
	 					Player.Energy = min(Player.Energy+1,Player.MaxEnergyLevel);
	 				break;
 					case spring_ball_pu:
 						Player.HasSpringBall = 1;
 						if(Player.State==morph_ball){
 							Player.State = spring_ball;
 						}
 						Items[C].Active = 0;
 						Prompt = 0;
 					break;
 					case high_jump_pu:
 						Player.HasHighJump = 1;
 						Items[C].Active = 0;
 						Prompt = 1;
 					break;
	 				case wave_beam_pu:
	 					Player.BeamWeapon = wawe_beam;
	 					Items[C].Active = 0;
	 					Prompt = 2;
 					break;
 					case ice_beam_pu:
 						Player.BeamWeapon = ice_beam;
 						Items[C].Active = 0;
 						Prompt = 3;
 					break;
 					case bomb_pu:
 						Player.HasBomb = 1;
 						Items[C].Active = 0;
 						Prompt = 4;
 					break;
 					case missile_battery_pu:
 						Player.Missiles = min(Player.Missiles+1,Player.MaxMissileLoad);
 					break;
 					case spider_ball_pu:
 						Player.HasSpiderBall = 1;
 						Items[C].Active = 0;
 						Prompt = 5;
 					break;
 					case space_jump_pu:
 						Player.HasSpaceJump = 1;
 						Items[C].Active = 0;
 						Prompt = 6;
 					break;
 					case screw_attack_pu:
 						Player.HasScrewAttack = 1;
 						Items[C].Active = 0;
 						Prompt = 7;
 					break;
 					case varia_Suit_pu:
 						Player.HasVariaSuit = 1;
 						Items[C].Active = 0;
 						Prompt = 8;
 					break;
 					case spazer_beam_pu:
 						Player.BeamWeapon = spazer_lazer_beam;
 						Items[C].Active = 0;
 						Prompt = 9;
 					break;
 					case plasma_beam_pu:
 						Player.BeamWeapon = plasma_beam;
 						Items[C].Active = 0;
 						Prompt = 10;
 					break;
 					case game_end: 						
 						
 						// Remove solid tiles above lift
 						for(Cy=0;Cy<4;Cy++){
 							PutTile(7*16,Cy*16,0);
 							PutTile(8*16,Cy*16,0);
 						};
 						
 						// Lift animation
 						while(Items[C].Y>-8){
 							Items[C].Y--;
 							Player.Y--;
 							RenderLevel(1); 							
 						};
 						
 						TheEnd();
 						Exit = 1;
 						
 					break;
	 			};// End of switch
 				
 				if(Prompt>=0){
 					DoPickUpPrompt(Prompt);
 				}; 				
 				
 				if(Items[C].Active==0){
 					// The item has been removed:
 					// Check if it has an event associated to itself
 					if(Items[C].Event){
 						// Remove the item from the event list: Mark it as taken.
 						EventArray[Items[C].Event] = 0;
 						
 					};
 					
 				};
 				
 				// Display something to tell that you picked up an item (not for energy ball or missile pod)
	
 		
			};// End of collision
		}// End of Active==1
		else{
			if(Items[C].Active==2){				
				// Check if Item collides with player shot
				
				short IX = Items[C].X;
				short IY = Items[C].Y;
				//short IW = 16;
				//short IH = 16;
				
				short S;
				
				for(S=0;S<nr_of_player_shots;S++){			
								
					if(PlayerShots[S].Active){
						
						short PSX = PlayerShots[S].X + SpriteTab[PlayerShots[S].Sprite].Xoff;
						short PSY = PlayerShots[S].Y + SpriteTab[PlayerShots[S].Sprite].Yoff;
						short PSW = (PlayerShots[S].Type==BTspazerBeam?15:8);
						short PSH = SpriteTab[PlayerShots[S].Sprite].Height;
						
						if( BoundsCollide2HW(PSX,PSY,PSH,PSW,IX,IY,16,16) ){
							Items[C].Active = 1;// Set as normal item, instead of sphere
						};						
						
					};					
				};				
			};
		};
	};
	
};


void DoPickUpPrompt(short Id){
	
	#ifdef MakeTI89	
	#define SX			75
	#define SY			27
	#define TY			50	
	#endif
	#ifdef MakeTI92Plus	
	#define SX			112
	#define SY			41
	#define TY			64	
	#endif
	#ifdef MakeV200	
	#define SX			112
	#define SY			41
	#define TY			64	
	#endif

	
	const char *PickUpTexts[11] = {
		"Spring Ball",
		"High Jump Boots",
		"Wave Beam",
		"Ice Beam",
		"Bomb",
		"Spider Ball",
		"Space Jump",
		"Screw Attack",
		"Varia Suit",
		"Spacer Lazer Beam",
		"Plasma Beam",
	};
	
	const short ISprite[11] = {
		78,
		80,
		82,
		84,
		86,
		185,
		187,
		189,
		191,
		193,
		195
	};
	
	unsigned short* ItemSprite = Sprites16 + SpriteTab[ISprite[Id]].Offset;	
	short H = SpriteTab[ISprite[Id]].Height;	
	
	// Draw Frame and white rect inside
/*
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),22,20,138,80,COLOR_DARKGRAY);
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),23,21,137,79,COLOR_DARKGRAY);

	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),24,22,136,78,COLOR_WHITE);//  COLOR_LIGHTGRAY  COLOR_WHITE
	
	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),73,24,92,46,COLOR_BLACK);//  COLOR_LIGHTGRAY  COLOR_WHITE
*/
/*	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX,RY,RX+RW,RY+RH,COLOR_DARKGRAY);
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX+1,RY+1,RX+RW-1,RY+RH-1,COLOR_DARKGRAY);

	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),RX+2,RY+2,RX+RW-2,RY+RH-2,COLOR_WHITE);//  COLOR_LIGHTGRAY  COLOR_WHITE
*/	
	DispFramedRectangle();

	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),SX-2,SY-3,SX+17,SY+19,COLOR_BLACK);//  COLOR_LIGHTGRAY  COLOR_WHITE

	// Draw sprite
//	GrayClipSprite16_SMASK_R(75,27,H,ItemSprite,ItemSprite+H,ItemSprite+H*2,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	GrayClipSprite16_SMASK_R(SX,SY,H,ItemSprite,ItemSprite+H,ItemSprite+H*2,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));

	// Draw text
	DrawGrayStrExt2B(0,TY,PickUpTexts[Id],A_REPLACE|A_SHADOWED|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));

		
	// wait for keypress
	WaitForKeyPress();
		
	#undef SX
	#undef SY
	#undef TY
	
};


