#ifndef __gamestate__
#define __gamestate__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   gamestate.h                                                           *
*			Description:                    *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

typedef struct{
	
	short Error;
	
	short FgX;
	short FgY;
	
	short Count1;
	short Count2;
	
	short TwoAnimStep;
	short ThreeAnimStep;
	short ThreeAnimStepDir;
	
	short Loop;
	
	short FinalCountDown;
	short MotherBrainIsDestroyed;
	
	volatile unsigned short SpeedCounter;
	
}gamestate;


typedef struct{

	short Speed;
	
	// Key configuration
	// {JumpKey,FireKey,ToggleWeaponKey,MapKey,StatKey}
	short KeyConfig[5];
		
}config;

extern config Config;

extern gamestate Gamestate;

// Load content of config file / user settings
void LoadConfig();

// Save current config / user settings to file
void SaveConfig();

void SetDefaultConfig();

void HandleAdditionalControls();

// Adjust contrast with +/- buttons
void ContrastAdjust();

void Wait();















#endif