#ifndef __enemies__
#define __enemies__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   enemies.h                                                             *
*			Description:                    *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

#define active_area_left		(16*4)
#define active_area_right		(16*4)
#define active_area_upper		(16*4)
#define active_area_lower		(16*4)

#define active_area_dist    (16*4)

#define frozen (-1000)
#define frozen_time	400
#define e_powerup (-999)
#define powerup_time 400
#define hurt_anim_time 8

#define nr_of_enemy_shots		6

#define MBrainEventIndex		94

#define BoundsCollide2HW(x0,y0,h0,w0,x1,y1,h1,w1)	( ((x0+w0)>x1) && ((x1+w1)>x0) && ((y0+h0)>y1) && ((y1+h1)>y0) )


typedef struct {
	short X;
	short Y;
	short Dir;
	short Height;// Effective height, not sprite height
	
	short Life;
	
	short Data0;
	short Data1;
	short Data2;
	short Data3;
	
	short HurtAnim;
	
	short Handler;
	short Sprite;
	short Anim;
	
	short Frozen;
	
	
	short TypeAttrib;
	// b0 : Set: The enemy is a Metroid
	// b1 : Set: This enemy turns into a energy portion when killed
	// b2 : Set: This enemy turns into a missile portion when killed
	// b3 : Respawning enemy. The handler shall be executed even if this enemy is dead.
	// b4 : Immortal.
	// b5 : Mother Brain
	// b6 : Energy Barrier
	// b7 : 
	// b8 : Damage b0
	// b9 : Damage b1
	// b10: Damage b2
	// b11: Damage b3
	// b12: 
	// b13: 
	// b14: 
	// b15: 
	
	short Misc;
	// Contains the event index if this enemy is a  metroid.
	// Used for misc purposes in other enemies.
	// If not metroid, this must be zero initially.

	
}enemy;

extern shot Enemyshots[nr_of_enemy_shots];

extern short EnemyDamages[16];


enum EDamages{
	EDamage1 = 5,
	EDamage2 = 10,
	EDamage3 = 15,
	EDamage4 = 20,
	EDamage5 = 25,
	EDamage6 = 30,
	EDamage7 = 35,
	EDamage8 = 40,
	EDamage9 = 45,
	EDamage10 = 50,
	EDamage11 = 55,
	EDamage12 = 60,
	EDamage13 = 65,
	EDamage14 = 70,
	EDamage15 = 75,
	EDamage16 = 80,	
};

enum EBulletTypes{
	EBTTurrett=1,
	EBTWallfire=2,
	EBTMetroid3Fireball=3,
	EBTAcid=4,
	EBTFireBolt=5,
	EBTArrowBullet=6,
	EBTTurretBullet=7,
	EBTMetroid4LightningBolt=8,
	EBTMetroid5Fireball=9,
};

enum EBulletDamages{
	EBDTurret=6,
	EBDWallfire=4,
	EBDMetroid3Fireball=12,
	EBDAcid=12,
	EBDFireBolt=8,
	EBDArrowBullet=10,
	EBDTurretBullet=16,
	EBDMetroid4LightningBolt=16,
	EBDMetroid5Fireball=16,
	
};

extern enemy* Enemies;





enum AnimationRules{
	NoAutoAnim=0,AnimByDir=1,AnimByFrame2Step=2,AnimByDirAndFrame2Step=3,
	AnimByDirAndUpsideDown=4,AnimByFrame3Step=5,AnimByFrame2StepAndUpsideDown=6,
	UpsideDown=7,
};

//Numbers are tentative will most likely change

#define handler1enemiesLow			Enemy1
#define	handler1enemiesHigh			Enemy24


/*
// The following definitions are not in use. Used during testing only
enum CrawlerStartConditions{
	RoofLeft=0,RoofRight=1,
	FloorLeft=2,FloorRight=3,
	CeilingLeftUp=4,CeilingLeftDown=5,
	CeilingRightUp=6,CeilingRightDown=7,
};

enum ScorpDirections{
	ScorpUp=0,
	ScorpDown=1,
	ScorpLeft=2,
	ScorpRight=3,
};

enum SmallTurretBlockDir{
	NoBlock=-99,
	BlockedUp=6,
	BlockedDown=2,
	BlockedLeft=0,
	BlockedRight=4,
};

enum SmallTurretShotDir{
	ShootUp=6,
	ShootDown=2,
	ShootLeft=0,
	ShootRight=4,
};
*/

short FindFreeEnemyShotSlot();

void HandleEnemies();

void HandleEnemy(enemy* Enemy);

void HandleEnemyShots();

void SetMBrainKilledEnvironment();

short EnemyMoveX(enemy* Enemy);


void EnemyHandler1(enemy* Enemy);
void EnemyHandler2(enemy* Enemy);
void EnemyHandler3(enemy* Enemy);
void EnemyHandler4(enemy* Enemy);
void EnemyHandler5(enemy* Enemy);
void EnemyHandler6(enemy* Enemy);
void EnemyHandler7(enemy* Enemy);
void EnemyHandler8(enemy* Enemy);
void EnemyHandler9(enemy* Enemy);
void EnemyHandler10(enemy* Enemy);
void EnemyHandler11(enemy* Enemy);
void EnemyHandler12(enemy* Enemy);
void EnemyHandler13(enemy* Enemy);
void EnemyHandler14(enemy* Enemy);
void EnemyHandler15(enemy* Enemy);
void EnemyHandler16(enemy* Enemy);
void EnemyHandler17(enemy* Enemy);
void EnemyHandler18(enemy* Enemy);
void EnemyHandler19(enemy* Enemy);
void EnemyHandler20(enemy* Enemy);
void EnemyHandler21(enemy* Enemy);
void EnemyHandler22(enemy* Enemy);
void EnemyHandler23(enemy* Enemy);
void EnemyHandler24(enemy* Enemy);


void EnemyShotHandler1(shot* Shot);
void EnemyShotHandler2(shot* Shot);
void EnemyShotHandler3(shot* Shot);


#endif