
#include "all.h"


enemy* Enemies;

shot Enemyshots[nr_of_enemy_shots];

short EnemyDamages[16]={
	EDamage1,
	EDamage2,
	EDamage3,
	EDamage4,
	EDamage5,
	EDamage6,
	EDamage7,
	EDamage8,
	EDamage9,
	EDamage10,
	EDamage11,
	EDamage12,
	EDamage13,
	EDamage14,
	EDamage15,
	EDamage16,
};


short FindFreeEnemyShotSlot(){
	short C;
	
	for(C=0;C<nr_of_enemy_shots;C++){
		if(Enemyshots[C].Active==0){
			return C;
		};
	};
	return -1;// No free slots found
};

void HandleEnemyShots(){
	short Curr;
	
	short BWP = (SpriteTab[Player.Sprite].DrawMode==width32?4:2);
	short HP = SpriteTab[Player.Sprite].Height;
	short PX = Player.X + SpriteTab[Player.Sprite].Xoff;
	short PY = Player.Y + SpriteTab[Player.Sprite].Yoff;
	short PO = SpriteTab[Player.Sprite].Offset;
	void* SprP = (BWP==4?(void*)(Sprites32+PO+HP*2):(void*)(Sprites16+PO+HP*2));
	
	
	for(Curr=0;Curr<nr_of_enemy_shots;Curr++){
		if(Enemyshots[Curr].Active){			

			switch(Enemyshots[Curr].Handler){
				case 0:
					Enemyshots[Curr].X += Enemyshots[Curr].Dx;
					Enemyshots[Curr].Y += Enemyshots[Curr].Dy;
				break;
				case 1:
					EnemyShotHandler1(&Enemyshots[Curr]);
				break;
				case 2:
					EnemyShotHandler2(&Enemyshots[Curr]);
				break;
				case 3:
					EnemyShotHandler3(&Enemyshots[Curr]);
				break;
			}
								
			// Collision detection with player			
			
			short BWEs = (SpriteTab[Enemyshots[Curr].Sprite].DrawMode==width32?4:2);			
			short HEs = SpriteTab[Enemyshots[Curr].Sprite].Height;			
			short EsX = Enemyshots[Curr].X + SpriteTab[Enemyshots[Curr].Sprite].Xoff;
			short EsY = Enemyshots[Curr].Y + SpriteTab[Enemyshots[Curr].Sprite].Yoff;			
			short EsO = SpriteTab[Enemyshots[Curr].Sprite].Offset;			
			//void* SprEs = (void*)(Sprites16+EsO+HEs*2);
			// Bug above: At least one case is this sprite32
			void* SprEs = (BWP==4?(void*)(Sprites32+EsO+HEs*2):(void*)(Sprites16+EsO+HEs*2));
			
			
			
							
			if( TestCollideX82w2h_invsprts_R(PX,PY,EsX,EsY,BWP,BWEs,HP,HEs,SprP,SprEs) ){
								
				short EBulletDamages[9]={
					EBDTurret,
					EBDWallfire,
					EBDMetroid3Fireball,
					EBDAcid,
					EBDFireBolt,
					EBDArrowBullet,
					EBDTurretBullet,
					EBDMetroid4LightningBolt,
					EBDMetroid5Fireball
				};		
				
				
				short Damage = EBulletDamages[Enemyshots[Curr].Type-1];
							
				PlayerWounded(Damage);
				
			};			
			
			Enemyshots[Curr].Active--;
		};		
	};
	
};

void HandleEnemy(enemy* Enemy){
	
	if(!Enemy->Frozen){
	
		//Execute the enemy's handler
		switch(Enemy->Handler){
			case 1:
				EnemyHandler1(Enemy);
			break;
			case 2:
				EnemyHandler2(Enemy);
			break;
			case 3:
				EnemyHandler3(Enemy);
			break;
			case 4:
				EnemyHandler4(Enemy);
			break;
			case 5:
				EnemyHandler5(Enemy);
			break;
			case 6:
				EnemyHandler6(Enemy);
			break;
			case 7:
				EnemyHandler7(Enemy);
			break;
			case 8:
				EnemyHandler8(Enemy);
			break;
			case 9:
				EnemyHandler9(Enemy);
			break;
			case 10:
				EnemyHandler10(Enemy);
			break;
			case 11:
				EnemyHandler11(Enemy);
			break;
			case 12:
				EnemyHandler12(Enemy);
			break;
			case 13:
				EnemyHandler13(Enemy);
			break;
			case 14:
				EnemyHandler14(Enemy);
			break;
			case 15:
				EnemyHandler15(Enemy);
			break;
			case 16:
				EnemyHandler16(Enemy);
			break;
			case 17:
				EnemyHandler17(Enemy);
			break;
			case 18:
				EnemyHandler18(Enemy);
			break;
			case 19:
				EnemyHandler19(Enemy);
			break;
			case 20:
				EnemyHandler20(Enemy);
			break;
			case 21:
				EnemyHandler21(Enemy);
			break;
			case 22:
				EnemyHandler22(Enemy);
			break;
			case 23:
				EnemyHandler23(Enemy);
			break;
			case 24:
				EnemyHandler24(Enemy);
			break;
		};
	
	};
	
};

void SetMBrainKilledEnvironment(){
	short X,Y,Ce;
	// Remove glass container tiles
	for(X=2;X<=6;X++){
		for(Y=5;Y<=8;Y++){
			PutTile(X*16,Y*16,0);
		};
	};
	// Disable all enemies
	for(Ce=0;Ce<Room->NrOfEnemies;Ce++){
		Enemies[Ce].Life = 0;
	};
	// Disable all enemy bullets
	for(Ce=0;Ce<nr_of_enemy_shots;Ce++){													
		Enemyshots[Ce].Active = 0;
	};
};

void HandleEnemies(){	
	
	short Curr;
		
	for(Curr=0;Curr<Room->NrOfEnemies;Curr++){
		
		#ifdef watchdog
		 WatchDog.Code2 = 1;
		#endif
		
		Gamestate.Loop = Curr;
		
		if(Enemies[Curr].Life){
			
			if(Enemies[Curr].HurtAnim)
				Enemies[Curr].HurtAnim--;
			
			//Check if enemy is within the Active area
			if( (Enemies[Curr].X>=(Gamestate.FgX-active_area_left)) && (Enemies[Curr].X<=(Gamestate.FgX+screen_width+active_area_right)) && 
			(Enemies[Curr].Y>=(Gamestate.FgY-active_area_upper)) && (Enemies[Curr].Y<=(Gamestate.FgY+screen_height+active_area_lower)) ){
				
				// Check if enemy is outside room boundaries
				if( (Enemies[Curr].X<-16) || (Enemies[Curr].Y<-16) || (Enemies[Curr].X>=(Room->Width*16)) || (Enemies[Curr].Y>=(Room->Height*16)) ){
					Enemies[Curr].Life = 0;
				};
				
				HandleEnemy(&Enemies[Curr]);
								
				short EHeight = SpriteTab[Enemies[Curr].Sprite].Height;//Enemies[Curr].Height; // 
				short EWidth = (SpriteTab[Enemies[Curr].Sprite].DrawMode==width16?14:28);	
				short EX = Enemies[Curr].X + SpriteTab[Enemies[Curr].Sprite].Xoff;
				short EY = Enemies[Curr].Y + SpriteTab[Enemies[Curr].Sprite].Yoff;
								
				//Collision check with player bullets
				
				if(Enemies[Curr].Life!=e_powerup){
					short C;
					for(C=0;C<nr_of_player_shots;C++){
						if(PlayerShots[C].Active && (PlayerShots[C].Type!=BTbomb) ){
							
							short PSX = PlayerShots[C].X + SpriteTab[PlayerShots[C].Sprite].Xoff;
							short PSY = PlayerShots[C].Y + SpriteTab[PlayerShots[C].Sprite].Yoff;
							short PSW = (PlayerShots[C].Type==BTspazerBeam?15:8);
							
						//	if(	BOUNDS_COLLIDE2HW(PlayerShots[C].X,PlayerShots[C].Y,Enemies[Curr].X,Enemies[Curr].Y,8,EWidth,SpriteTab[PlayerShots[C].Sprite].Height,EHeight) ){
						//	if(	BOUNDS_COLLIDE2HW(PSX,PSY,EX,EY,8,EWidth,SpriteTab[PlayerShots[C].Sprite].Height,EHeight) ){
							if(	BoundsCollide2HW(PSX,PSY,SpriteTab[PlayerShots[C].Sprite].Height,PSW,EX,EY,EHeight,EWidth) ){

								//Hit!
								if(PlayerShots[C].Type == BTmissile){
									PlayerShots[C].Type = BTexplosion;
									PlayerShots[C].Sprite = 93;	
																	
									// if metroid:	
									if( (Enemies[Curr].TypeAttrib & 0b0000000000000001) && /*!Enemies[Curr].HurtAnim &&*/ (Enemies[Curr].Life<1000) ){
										// Add damage
										Enemies[Curr].Life--;
										EventArray[Enemies[Curr].Misc] = Enemies[Curr].Life;
										Enemies[Curr].HurtAnim = hurt_anim_time;
										
										if(Enemies[Curr].Life==0){
											
											Enemies[Curr].Life = 1000;
											Enemies[Curr].Frozen = SeriesXPlosionLifeTime;
											AddSeriesExplosion(Enemies[Curr].X,Enemies[Curr].Y,Enemies[Curr].Height,36,Curr);
											
											//Decrement Metroid counter
											if( (--EventArray[Player.CurrArea+1])==0 ){
												
												// Area completed. Shake animation
												Player.ShakeCounter = area_completed_shaketime;
												
											};
											// Not needed:
											EventArray[Enemies[Curr].Misc] = 0;
											Enemies[Curr].Misc = Enemies[Curr].Sprite;
											
											if((Enemies[Curr].TypeAttrib & 0b0000000000100000)){
												// Mother brain is killed!
																	
												SetMBrainKilledEnvironment();
												Enemies[Curr].Life = 1000;
												
												
												// Shake for some time												
												Player.ShakeCounter = SeriesXPlosionLifeTime*2;
												Gamestate.MotherBrainIsDestroyed = 1;
												
												
											};
											
										};
										
										if( !(Enemies[Curr].TypeAttrib & 0b0000000000100000) ){
											// Not Mother Brain:
											// Push metroid back
											if(PlayerShots[C].Dx){
												Enemies[Curr].X += (PlayerShots[C].Dx>0?4:-4);
											};
											if(PlayerShots[C].Dy){
												Enemies[Curr].Y += (PlayerShots[C].Dy>0?4:-4);
											};
										};	
										
									}
									else{
										
										if(Enemies[Curr].TypeAttrib & 0b0000000001000000){
											// Energy Barrier
											Enemies[Curr].Life--;
											EventArray[Enemies[Curr].Misc] = Enemies[Curr].Life;
											
										}
										else{
											// Add damage on "regular" enemy, i.e not metroid
											Enemies[Curr].Life = max(0,Enemies[Curr].Life-missile_damage);
										};									
										
									};
								}
								else{// Not missile
									
									// Check if the enemy is a metroid or energy barrier: They don't take damage from beams 
									if( !(Enemies[Curr].TypeAttrib & 0b0000000001000001) ){									
									
										if( (PlayerShots[C].Type!=BTplasmaBeam) && (PlayerShots[C].Type!=BTexplosion) ){
											PlayerShots[C].Active = 0;// Remove shot, if not plasma beam or explosion 
										};									
								
										const short PlayerWeaponDamage[6]={
											beam_damage,ice_beam_damage,wawe_beam_damage,spazer_lazer_beam_damage,plasma_beam_damage,explosion_damage,
										};
															
										if( !(Enemies[Curr].TypeAttrib & 0b0000000000010000) ){// Not immortal
								
											if((Player.BeamWeapon==ice_beam) && (!Enemies[Curr].Frozen) ){// Freeze
												Enemies[Curr].Frozen = frozen_time;
												Enemies[Curr].Misc = GetEnemySprite(Curr);
												
												short C;
												for(C=0;C<max_nr_of_blocks;C++){
													if(Blocks[C].Active==0){
														Blocks[C].X = Enemies[Curr].X;
														Blocks[C].Y = Enemies[Curr].Y;
														Blocks[C].Height = SpriteTab[Enemies[Curr].Misc].Height;
														Blocks[C].Width = (SpriteTab[Enemies[Curr].Misc].DrawMode==width32?32:16);// 
														Blocks[C].Index = Curr;
														Blocks[C].Active = frozen_time;
														break;
													};													
												};
																								
											}
											else{
											
											//if( !(Enemies[Curr].TypeAttrib & 0b0000000000010000) ){// Not immortal
											
												//Enemies[Curr].Life -= PlayerWeaponDamage[Player.BeamWeapon];
												Enemies[Curr].Life -= PlayerWeaponDamage[PlayerShots[C].Type];
												Enemies[Curr].HurtAnim = hurt_anim_time;									
									
												if(Enemies[Curr].Life<=0){// Killed											
													
													AddSingleExplosion(Enemies[Curr].X,Enemies[Curr].Y);
																					
													if( !(Enemies[Curr].TypeAttrib & 0b0000000000001000) && Gamestate.Count1%2 ){
														// Not respawning enemy. 
														// Gamestate.Count1%2 ensures that there will appear a powerup in 50% of the cases
												
														Enemies[Curr].Handler = 0;
												
														if(Enemies[Curr].TypeAttrib & 0b0000000000000110){
															Enemies[Curr].Life = e_powerup;
															Enemies[Curr].Sprite = (Enemies[Curr].TypeAttrib & 0b0000000000000010?68:70);
															Enemies[Curr].Data0 = powerup_time;
															Enemies[Curr].Anim = AnimByFrame2Step;
															Enemies[Curr].Frozen = 0;
															Enemies[Curr].X += 4;
														}
														else{
															Enemies[Curr].Life = 0;
														};
												
													}
													else{
														Enemies[Curr].Life = 0;
													};								
											
												};
												//}
												/*else{
													// Immortal
													if((PlayerShots[C].Type!=BTplasmaBeam) && (PlayerShots[C].Type!=BTexplosion)){
														PlayerShots[C].Active = 0;
													};
													
												};*/
											};
										}
										else{
											// Immortal
											if((PlayerShots[C].Type!=BTplasmaBeam) && (PlayerShots[C].Type!=BTexplosion)){
												PlayerShots[C].Active = 0;
											};
												
										};
									};
								
								};								
							
								/*const short PlayerWeaponDamage[5]={
									beam_damage,ice_beam_damage,wawe_beam_damage,spazer_lazer_beam_damage,plasma_beam_damage
								};
								
								//if( PlayerShots[C].Type==BTmissile )
								//	add explosion
								
								// Also, use PlayerShots[C].Type instead of Player.BeamWeapon. 
								// Eliminates small possible bugs. (when hit by explosion for example)
								
								
								if((Player.BeamWeapon==ice_beam) && (Enemies[Curr].Life!=frozen) ){// Freeze
									Enemies[Curr].Life = frozen;
									Enemies[Curr].Handler = 0;
									Enemies[Curr].Data0 = frozen_time;
									Enemies[Curr].Anim = NoAutoAnim;
								}
								else{
									Enemies[Curr].Life -= PlayerWeaponDamage[Player.BeamWeapon];
									Enemies[Curr].HurtAnim = hurt_anim_time;
									
									
									if(Enemies[Curr].Life<=0){// Killed
										// Add ramdom stuff
										Enemies[Curr].Life = e_powerup;
										Enemies[Curr].Handler = 0;
										Enemies[Curr].Sprite = 68;
										Enemies[Curr].Data0 = powerup_time;
										Enemies[Curr].Anim = AnimByFrame2Step;
									};
								};*/		
						
							};				
						
						};
					
					};
				};
				
				short BWP = (SpriteTab[Player.Sprite].DrawMode==width32?4:2);
				short BWE = (SpriteTab[Enemies[Curr].Sprite].DrawMode==width16?2:4);
				short HP = SpriteTab[Player.Sprite].Height;
				short HE = SpriteTab[Enemies[Curr].Sprite].Height;
				short PX = Player.X + SpriteTab[Player.Sprite].Xoff;
				short PY = Player.Y + SpriteTab[Player.Sprite].Yoff;
				/*short*/ EX = Enemies[Curr].X + SpriteTab[Enemies[Curr].Sprite].Xoff;
				/*short*/ EY = Enemies[Curr].Y + SpriteTab[Enemies[Curr].Sprite].Yoff;				
				short PO = SpriteTab[Player.Sprite].Offset;
				short EO = SpriteTab[Enemies[Curr].Sprite].Offset;
// Most recent before mask collision detection:
//				void* SprP = (BWP==4?(void*)(Sprites32+PO):(void*)(Sprites16+PO));
//				void* SprE = (BWE==4?(void*)(Sprites32+EO):(void*)(Sprites16+EO));
				void* SprP = (BWP==4?(void*)(Sprites32+PO+HP*2):(void*)(Sprites16+PO+HP*2));
				void* SprE = (BWE==4?(void*)(Sprites32+EO+2*HE):(void*)(Sprites16+EO+2*HE));
				
				
				
		//		SprP += SpriteTab[Player.Sprite].Offset;
		//		SprE += SpriteTab[Enemies[Curr].Sprite].Offset;
				
				
		//		TestCollideX82w2h_R(PX,PY,EX,EY,BWP,BWE,HP,HE,SprP,SprE);
		//		TestCollideX82w2h_R(short x0 asm("%d0"),short y0 asm("%d1"),short x1 asm("%d2"),short y1,short bytewidth0,short bytewidth1,short height0,short height1,const void *data0 asm("%a0"),const void *data1 asm("%a1")) __attribute__((__stkparm__));

				
				//Collision check with player
				// BOUNDS_COLLIDE2HW(PX,PY,EX,EY,BWP*8,BWE*8,HP,HE)
			//	if( BOUNDS_COLLIDE2HW(Player.X+8,Player.Y,Enemies[Curr].X,Enemies[Curr].Y,16,EWidth,Player.Height,EHeight) ){
// Most recent before mask collision detection:
//				if( TestCollideX82w2h_R(PX,PY,EX,EY,BWP,BWE,HP,HE,SprP,SprE) || TestCollideX82w2h_R(PX,PY,EX,EY,BWP,BWE,HP,HE,SprP+HP,SprE+HE) ){
					
					
				if( TestCollideX82w2h_invsprts_R(PX,PY,EX,EY,BWP,BWE,HP,HE,SprP,SprE) ){
					
					
					
					if( (Enemies[Curr].Life<0) /*&& (Enemies[Curr].Life!=frozen)*/ ){
						// Enemy is dead and powerup
						
						if(Enemies[Curr].Life==e_powerup){
						
							if(Enemies[Curr].Sprite==68){// Energy portion
								Player.Energy = min(Player.Energy+5,Player.MaxEnergyLevel);								
							}
							else{// Missile portion
								Player.Missiles = min(Player.Missiles+5,Player.MaxMissileLoad);
							}
							Enemies[Curr].Life = 0;
							
						};
					}
					else{
						
						if(Enemies[Curr].Frozen==0){
							
							if( !(Enemies[Curr].TypeAttrib & 0b0000000001000001) && Player.IsSpinJumping && Player.HasScrewAttack){
								// Screw attack kill
								
								if( !(Enemies[Curr].TypeAttrib & 0b0000000000010000) ){
									Enemies[Curr].Life = 0;								
									AddFlyingFragments(Enemies[Curr].X,Enemies[Curr].Y);
								}
								else{
									short Index = ((Enemies[Curr].TypeAttrib>>8)&0b00001111);
									short Damage = EnemyDamages[Index];
														
									PlayerWounded(Damage);
								};								
								
								
							}
							else{
							
								// Add enemy specific damage
								//short Index = ((Enemies[Curr].TypeAttrib>>8)&0b11110000);
								short Index = ((Enemies[Curr].TypeAttrib>>8)&0b00001111);
								short Damage = EnemyDamages[Index];
														
								PlayerWounded(Damage);
					
								// Make player Move when hurt
								Player.ForceXMove = (Player.X>Enemies[Curr].X?4:-4);
								Player.ForceXMoveSpeed = 4;
								Player.Blocked = 4;
								// Also add y bounch
								
							};
							
						}
						else{
							// Frozen														
						};
					};
				};
				
			
			}
			else{
				
			};//End of Within Active area
			
			if(Enemies[Curr].Frozen){
				if( (--Enemies[Curr].Frozen)==0 ){
					Enemies[Curr].Misc = 0;
				};
			};
			
			if( (Enemies[Curr].Life<0) ){
				// Enemy is dead and powerup
				if( (--Enemies[Curr].Data0)<=0 ){
					Enemies[Curr].Life = 0;
				}				
			}
			
		}//End of Life
		else{
			// Enemy is dead. Check if it can respawn
			if( Enemies[Curr].TypeAttrib & 0b0000000000001000){
				HandleEnemy(&Enemies[Curr]);
			};			
		};
	};//End of for-loop
	
	
	
};

short EnemyMoveX(enemy* Enemy){
	// Checks if enemy is free to move |Dir| pixels in direction given by sign of Dir.
	// If free, then move enemy.
	// If not free, change direction.
	// Return: 0: No direction change
	//				 1: Direction changed
	
	
	if(Enemy->Dir > 0){// Dir == Right
		if(FreeRight(Enemy->X,Enemy->Y,Enemy->Height)>Enemy->Dir){// Free Right?
			Enemy->X += Enemy->Dir;
		}
		else{// Not Free Right
			Enemy->Dir = -Enemy->Dir; // Change Direction
			return -1;
		};
		
	}
	else{
		if(Enemy->Dir < 0){// Dir == Left
			if(FreeLeft( Enemy->X,Enemy->Y,Enemy->Height) > (-Enemy->Dir) ){// Free Left?
				Enemy->X += Enemy->Dir;
			}
			else{// Not Free Left
				Enemy->Dir = -Enemy->Dir;// Change Direction
				return 1;
			};
		};
	};
	return 0; // No direction Change
}




//  Enemy Handlers:
//  Those functions handles the movement and behavior of one or more type of enemy


void EnemyHandler1(enemy* Enemy){
	// Enemy travels a given distance in one direction, 
	// then turns and travels the same distance in the opposite direction.
	
	//Parameters: Data0: 0: Not limited
	//									 Non-zero: Limited to move |Data0| pixels in given direction before changing direction
	//
	//						Data1: Internal Counter. Initialized to same value as Data0
	//
	//						Dir: |Dir| = Motion speed (Pixels per frame)
	//								 Sign(Dir) = Direction
	 
	 
	EnemyMoveX(Enemy);
	
	if(Enemy->Data0){
		if(Enemy->Data1){			
			Enemy->Data1 -= abs(Enemy->Dir);			
		}
		else{//Data1 == 0, Change direction
			Enemy->Data1 = Enemy->Data0;
			Enemy->Dir = -Enemy->Dir;			
		};
	};
		
};

void EnemyHandler2(enemy* Enemy){
	// Enemy falls down until it hit something solid.
	// Restarts at original position, waits for some time, then falls again
	
	// Initialization: Data1 == Y
	
	// Data0 == counter: Manages delay before fall, delay before
	
	#define hangtime	100
	#define handler2_speed	2
	
	if( (++Enemy->Data0)>=hangtime ){
		// Fall
		if( FreeDown(Enemy->X,Enemy->Y+Enemy->Height-12,7)>=handler2_speed ){
			Enemy->Y += handler2_speed;
		}
		else{
			// Hit the ground. Restart
			Enemy->Y = Enemy->Data1-12;
			Enemy->Data0 = -12;
		}		
	}
	else{
		// New one coming out
		if(Enemy->Data0<0){
			Enemy->Y++;
		}
	};	
	
	#undef hangtime
	#undef handler2_speed
	
};
void EnemyHandler3(enemy* Enemy){
	// Orbiting enemy.
	// Initialization:
	// Data0 = 0
	// Data1 = 9
	
	
	//R=40
	//Step = 12 deg
	//static const char Motion[30]={4,4,4,4,4,4,3,3,2,3,2,1,1,1,0,0,-1,-1,-1,-2,-3,-2,-3,-3,-4,-4,-4,-4,-4,-4};

	//R=30
	//Step = 10 deg
	//OK, but large
	//static const char Motion[36]={5,5,5,4,4,3,2,1,1,-1,-1,-2,-3,-4,-4,-5,-5,-5,-5,-5,-5,-4,-4,-3,-2,-1,-1,1,1,2,3,4,4,5,5,5};
	
	//R=20
	//Step = 10 deg
	//static const char Motion[36]={3,4,3,3,2,2,2,1,0,0,-1,-2,-2,-2,-3,-3,-4,-3,-3,-2,-2,-2,-1,0,0,1,2,2,2,3,3,4,3};
	
	//R=18
	//Step = 10 deg
	//OK, small?
	//static const char Motion[36]={3,3,3,2,2,2,2,1,1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,1,1,2,2,2,2,3,3,3};

	//R=24
	//Step = 10 deg
	//OK
	static const char Motion[36]={4,4,4,3,3,3,2,1,1,-1,-1,-2,-3,-3,-3,-4,-4,-4,-4,-4,-4,-3,-3,-3,-2,-1,-1,1,1,2,3,3,3,4,4,4};

	
	if(Gamestate.Count1%2){ //Remove this to double speed
	
		Enemy->X += Motion[Enemy->Data0];
		Enemy->Y += Motion[Enemy->Data1];
		
		if( (++Enemy->Data0)>=36)
			Enemy->Data0 = 0;
		if( (++Enemy->Data1)>=36)
			Enemy->Data1 = 0;
	
	};
	
};
void EnemyHandler4(enemy* Enemy){
	// Handles the Chute Leech and the Octroll.
	// When player is close it jumps up, then falls down slowly, swinging from side to side.
	
	// Dir used as x Dir indicator
	// Data0 used as jump counter
	// Data1 used as swinging, or side drifting counter	
	// Data2: Jumpheight
	// Data3: Sprite indicator / config variable
	
	#define handler4_jumpspeed	2
	#define handler4_fallspeed	1
	#define handler4_jumpheight	24
	#ifdef MakeTI89
	#define handler4_distance_threshold	4*16
	#endif
	#ifndef MakeTI89
	#define handler4_distance_threshold	6*16
	#endif
	
	short Sprite = 0;
	
	//short DistDown = FreeDown(Enemy->X,Enemy->Y+8,24);
	short DistDown = FreeDown(Enemy->X,Enemy->Y+(Enemy->Data3?14:8),24);
	
	if( (DistDown > 0) || Enemy->Data0){
		
		if(Enemy->Data0>0){
			// Jumping
			Enemy->Data0--;			
			Enemy->Y -= handler4_jumpspeed;
		}
		else{
			// Falling
			Enemy->Y += min(handler4_fallspeed,DistDown);
			if(Enemy->Data1==0){
				
				Enemy->Dir = -Enemy->Dir;
				Enemy->Data1 = 16; //16=OK
				/*Enemy->*/Sprite = (Enemy->Dir>0?48:49);
				/*switch(Enemy->Dir){
					case 0:
						Enemy->Dir = 1;
					break;
					case 1:
						Enemy->Dir = -1;
					break;
					case -1:
						Enemy->Dir = 1;//2;
					break;
					case 2:
						Enemy->Dir = -2;
					break;
					case -2:
						Enemy->Dir = 2;
					break;	
				}*/				
			}
			else{
				Enemy->Data1--;
			}
			Enemy->X += Enemy->Dir;
		}		
	}
	else{// Not free down, i.e. lying on ground
		
		if( abs(Player.X-Enemy->X)<=handler4_distance_threshold ){
			Enemy->Data0 = Enemy->Data2;//handler4_jumpheight;
			Enemy->Dir = 1;
			Enemy->Data1 = 7; // 7=OK	
			/*Enemy->*/Sprite = 47;
		}
		else{
			/*Enemy->*/Sprite = 50;
		};		
	};
	
	if(Enemy->Data3){
		Enemy->Sprite = Enemy->Data3 + (Sprite!=50?1:0);
	}
	else{
		if(Sprite)
			Enemy->Sprite = Sprite;
	};
	
	/*
	notes:
	H=24
	d1=7 start
	d1 = 16 turn
	*/		
	
	#undef handler4_jumpspeed
	#undef handler4_fallspeed
	#undef handler4_jumpheight
	#undef handler4_distance_threshold
};
void EnemyHandler5(enemy* Enemy){
	/* Handles all Enemies that crawls up the walls and roofs
	
	Dir   : Current x dir
	Data0 : Current y dir	
	Data1 : preferred x dir 
	Data2 : preferred y dir
	
	Data3 : Spritebase, if the enemy is supposed to be animated by direction

	Misc : Used as an internal counter and indicator. 
	       >=0: Incremented by 2 each time the enemy turn. Decremented by 1 for each normal move.
	       >8:  Enter falling state. Nothing to stick to anymore.
	       <0:  Falling state
	*/		
	
	if(Enemy->Misc>=0){	
	
		if(Enemy->Dir>0){
			if(FreeRight(Enemy->X+15,Enemy->Y,16)){
				// move right			
			}
			else{
				Enemy->Dir = 0;
				Enemy->Data2 = -Enemy->Data2;
				Enemy->Data0 = Enemy->Data2;
				Enemy->Misc += 2;	
			};
		};
	
		if(Enemy->Dir<0){
			if(FreeLeft(Enemy->X,Enemy->Y,16)){
				// move left
			}
			else{
				Enemy->Dir = 0;
				Enemy->Data2 = -Enemy->Data2;
				Enemy->Data0 = Enemy->Data2;
				Enemy->Misc += 2;
			};
		};
	
		if(Enemy->Data0>0){
			if(FreeDown(Enemy->X,Enemy->Y+15,16)){
				// Move down
			}
			else{
				Enemy->Data0 = 0;
				Enemy->Data1 = -Enemy->Data1;
				Enemy->Dir = Enemy->Data1;
				Enemy->Misc += 2;
			};
		};
	

		if(Enemy->Data0<0){
			if(FreeUp(Enemy->X,Enemy->Y,16)){
				// Move up
			}
			else{
				Enemy->Data0 = 0;
				Enemy->Data1 = -Enemy->Data1;
				Enemy->Dir = Enemy->Data1;
				Enemy->Misc += 2;
			};
		};	
	
		if(Enemy->Dir){
			Enemy->X += Enemy->Dir;
		
			if(Enemy->Misc>0)
				Enemy->Misc -= 1;	
				
			if(Enemy->Data2<0){
				if(FreeUp(Enemy->X,Enemy->Y,16)){
					Enemy->Dir = 0;
					Enemy->Data1 = -Enemy->Data1;
					Enemy->Data0 = Enemy->Data2;
					Enemy->Misc += 2;
				};
			}
			else{
				if(FreeDown(Enemy->X,Enemy->Y+15,16)){
					Enemy->Dir = 0;
					Enemy->Data1 = -Enemy->Data1;
					Enemy->Data0 = Enemy->Data2;
					Enemy->Misc += 2;								
				};
			};		
		}
		else{
	
			if(Enemy->Data0){
				Enemy->Y += Enemy->Data0;
			
				if(Enemy->Misc>0)
					Enemy->Misc -= 1;	
			
				if(Enemy->Data1>0){
					if(FreeRight(Enemy->X+15,Enemy->Y,16)){
						Enemy->Data0 = 0;
						Enemy->Data2 = -Enemy->Data2;
						Enemy->Dir = Enemy->Data1;
						Enemy->Misc += 2;
					};
				}
				else{
					if(FreeLeft(Enemy->X,Enemy->Y,16)){
						Enemy->Data0 = 0;
						Enemy->Data2 = -Enemy->Data2;
						Enemy->Dir = Enemy->Data1;
						Enemy->Misc += 2;
					};
				};			
			};	
		};	
		
		if(Enemy->Misc>8){
			Enemy->Misc = -1;
		};
	
	} // End of Misc>=0
	else{
		// Falling state
		
		if(FreeDown(Enemy->X,Enemy->Y+15,16)){
			Enemy->Y++;
			
		}
		else{
			// Hit the ground
			
			Enemy->Dir = 1;
			Enemy->Data0 = 0;
			Enemy->Data1 = 1;
			Enemy->Data2 = 1;			
			
			Enemy->Misc = 0;
			
		};		
	};
	
	// Animation: Only used by 2 of 3 monsters using this function
	
	if(Enemy->Data3){		
		
		if(Enemy->Data0 != 0){
			Enemy->Sprite = (Enemy->Data1>0?Enemy->Data3+3:Enemy->Data3+2);
		}
		else{
			Enemy->Sprite = Enemy->Data3;
		};		
		
		if( (Enemy->Data0==1) || ( (Enemy->Data0==0) && (Enemy->Data2==-1) ) ){
			// Upside down
			Enemy->Anim = AnimByDirAndUpsideDown;
		}
		else{
			Enemy->Anim = AnimByDir;
		};		
		
	};	
	
};

void EnemyHandler6(enemy* Enemy){
	// Enemy jumps up, then flies in the player's direction
	// Restarts when killed or outside screen
	
	// Initialization:
	// Data1 = X
	// Data0 = 0
	
	// Data3: If non-zero: Indicates spritebase, if custom animation is to be used
	
	// Data0: Down Timer	
		
	#define downtime 50
	#define risedist 32
	#define yspeed	2
	#define xspeed	2
	#define threshold (downtime+risedist/yspeed)
	
	
	
	if((++Enemy->Data0)>=downtime){
		
		if(Enemy->Data0>threshold){
			Enemy->X += Enemy->Dir;
			
			if( (Enemy->X>=(Gamestate.FgX+screen_width)) || (Enemy->X<(Gamestate.FgX-16)) ){// Outside screen
				// Restart
				Enemy->Data0 = 0;
				Enemy->X = Enemy->Data1;
				Enemy->Y += (risedist);
				
				if(Enemy->Data3){
					Enemy->Sprite = Enemy->Data3;
				};
				
				/*if(Enemy->Sprite==NoAutoAnim){
					Enemy->Sprite--;
				}
				if(Enemy->Dir>0){// Dir compensation in sprite
					Enemy->Sprite -= 2;
				}*/					
			}			
		}
		else{
			if(Enemy->Data0==threshold){// Time to fly horizontally
				//Enemy->Dir = ((Player.X-Enemy->X)>0?xspeed:-xspeed);
								
				/*if(Enemy->Dir>0){// Dir compensation in sprite
					Enemy->Sprite += 2;
				}			
				
				if(Enemy->Sprite==NoAutoAnim){
					Enemy->Sprite++;					
				}*/	
				
				if(Enemy->Data3){
					Enemy->Sprite = Enemy->Data3+2;
				};
							
			}
			else{// Rising
				Enemy->Y -= yspeed;
			}
		}	
	}
	else{
		Enemy->Dir = ((Player.X-Enemy->X)>0?xspeed:-xspeed);
	}
	
	
	
	#undef downtime
	#undef risedist
	#undef yspeed
	#undef xspeed
	#undef threshold
	
};
void EnemyHandler7(enemy* Enemy){
	// Handles the Hornoad, the frog-like jumping enemy.
	// It does 3 jumps in the given direction, then turns and does 3 jumps in the other direction.
	//
	// Data0 is used as a counter/state variable during the jumps
	// Data1 is used as a jump counter
	
	#define jumpheight	16
	#define flylength		8
	#define nr_of_jumps	3
	
	switch(Enemy->Data0){
		case 0:
			Enemy->Data2 = -2;
			Enemy->Sprite += 1;
		break;
		case jumpheight:
			Enemy->Data2 = 0; 
		break;		
		case (jumpheight+flylength):
			Enemy->Data2 = 2;
			Enemy->Sprite -= 1;
		break;
/*		case (2*jumpheight+flylength):
			Enemy->Data2 = -2;
//			Enemy->Sprite += 1;
		break;	*/	
		
	};
	
	++Enemy->Data0;
	
//	if( (++Enemy->Data0)>(2*jumpheight+flylength) ){
	
	if( (Enemy->Data2>0) && (!FreeDown(Enemy->X,Enemy->Y+Enemy->Height-1,22)) ){
		Enemy->Data0 = 0;
		if( (++Enemy->Data1)>=nr_of_jumps ){
			Enemy->Data1 = 0;
			Enemy->Sprite = (Enemy->Dir>0?95:97);
			Enemy->Dir = -Enemy->Dir;
		};
	};
	
	Enemy->X += Enemy->Dir;
	Enemy->Y += Enemy->Data2;
	
		 
	#undef nr_of_jumps
	#undef flylength
	#undef jumpheight
};

void EnemyHandler8(enemy* Enemy){
	// Handles Autrack, the Bi-directional laser turrett.
	// When Samus comes closer than the defined threshold, the turrett rises and fires upon her.
	// There is a minimum amount of time (frames) between each fire cycle defined by resttime
	
	#define threshold	(16*8)
	#define	steptime	8
	#define resttime	16
	#define bullet_speed	3
	#define bullet_lifetime	(240/bullet_speed)
	
	short Dist = Enemy->X-Player.X;
	
	// Set direction.
	if(Dist>0){
		Enemy->Dir = -bullet_speed;
		Enemy->Data2 = 107;
	}
	else{
		Enemy->Dir = bullet_speed;
		Enemy->Data2 = 110;
	};
	
	if( (Enemy->Data1==0) && (abs(Dist)<=threshold) ){
		Enemy->Data1 = 1;// Initialize fire aequence
	};
		
	
	if(Enemy->Data1){
		
		short Slot;
		
		switch(Enemy->Data1){
			case 1:// Rise to step 1
				//Enemy->Y -= 8;
				Enemy->Sprite = Enemy->Data2 + 1;
			break;
			case steptime:// Rise to step 2
				//Enemy->Y -= 8;
				Enemy->Sprite = Enemy->Data2 + 2;
			break;
			case (2*steptime):// Shoot!				
				if( (Slot = FindFreeEnemyShotSlot())>=0){
					Enemyshots[Slot].Active = bullet_lifetime;
					Enemyshots[Slot].X = Enemy->X;
					Enemyshots[Slot].Y = Enemy->Y-14;
					Enemyshots[Slot].Dx = Enemy->Dir;
					Enemyshots[Slot].Handler = 0;
					Enemyshots[Slot].Sprite = 116;
					Enemyshots[Slot].Type = EBTTurrett;					
				};				
			break;
			case (3*steptime):// Go down to step 1
				//Enemy->Y += 8;
				Enemy->Sprite = Enemy->Data2 + 1;
			break;
			case (4*steptime):// Go down to step 0, and enter rest mode
				//Enemy->Y += 8;
				Enemy->Sprite = Enemy->Data2;
				Enemy->Data1 = -(1+resttime);
			break;
		};
		
		Enemy->Data1++;
	};
	
	#undef bullet_lifetime
	#undef bullet_speed
	#undef resttime
	#undef steptime
	#undef threshold	
};

void EnemyHandler9(enemy* Enemy){
	// Handles the Wallfire, the one-directional wall-mounted turret

	#define threshold	48
	#define	steptime	8
	#define resttime	96
	#define bullet_speed	3
	#define bullet_lifetime	(240/bullet_speed)
	
	short XDif = Player.X - Enemy->X;
	
	if( ((XDif<0) && (Enemy->Dir<0)) || ((XDif>0) && (Enemy->Dir>0)) ){
		if( (Enemy->Data1==0) && ( abs( (Enemy->Y+11)-(Player.Y+(Player.Height/2)) )<=threshold ) ){
			Enemy->Data1 = 1;
		};
	};	
	
	if(Enemy->Data1){
		short Slot;
		
		switch(Enemy->Data1){
			case 1:// Open mouth
				//Enemy->Y -= 8;
				Enemy->Sprite += 1;
			break;
			case steptime:// Shoot!				
				if( (Slot = FindFreeEnemyShotSlot())>=0){
					Enemyshots[Slot].Active = bullet_lifetime;
					Enemyshots[Slot].X = Enemy->X;
					Enemyshots[Slot].Y = Enemy->Y+4;
					Enemyshots[Slot].Dx = Enemy->Dir*bullet_speed;
					Enemyshots[Slot].Handler = 0;
					Enemyshots[Slot].Sprite = (Enemy->Dir>0?118:117);
					Enemyshots[Slot].Type = EBTWallfire;					
				};				
			break;
			case (2*steptime):
				Enemy->Sprite -= 1;
				Enemy->Data1 = -(1+resttime);
			break;
		};
		Enemy->Data1++;
	};
	
	#undef bullet_lifetime
	#undef bullet_speed
	#undef resttime
	#undef steptime
	#undef threshold
};
void EnemyHandler10(enemy* Enemy){
	// Handles metroid that moves towards player
	// Uses Dir to indicate direction, for animation purposes
	
	#define xmindist	12
	#define ymindist	8
	#define speed			1
	
	short Dist;
	Dist = (Player.X+8)-(Enemy->X+16);
	
	if(abs(Dist)>xmindist){
		if(Dist>0){
			if(FreeRight(Enemy->X+16,Enemy->Y,Enemy->Height-1)>=speed){
				Enemy->Dir = speed;
				Enemy->X += speed;	
			};		
		}
		else{
			if(FreeLeft(Enemy->X,Enemy->Y,Enemy->Height-1)>=speed){
				Enemy->Dir = -speed;
				Enemy->X -= speed;
			};
		};
	};
	
	Dist = (Player.Y+8)-(Enemy->Y+16);
	
	if(abs(Dist)>ymindist){
		if(Dist>0){
			if(FreeDown(Enemy->X+1,Enemy->Y+22,28)>=speed){
				Enemy->Y += speed;
			};
		}
		else{
			if(FreeUp(Enemy->X+1,Enemy->Y,28)>=speed){
				Enemy->Y -= speed;
			};
		};
	};
	
	#undef speed
	#undef xmindist
	#undef Ymindist
	
};
void EnemyHandler11(enemy* Enemy){
	// Handles Metroid 3, Weird creature with tale. Moves towards player for periods. Spits fireballs. 
	// Uses Data0 as a timer for fireballs
	
	#define shotinterval	60
	#define bullet_speed	3
	#define bullet_lifetime	(240/bullet_speed)
	
	EnemyHandler10(Enemy);
	
	short Slot;
	
	if( (++Enemy->Data0)>=shotinterval ){
		if( (Slot = FindFreeEnemyShotSlot())>=0){
			Enemyshots[Slot].Active = bullet_lifetime;			
			Enemyshots[Slot].Y = Enemy->Y+8;
			
			short DistX = Player.X-Enemy->X;
			short DistY = Player.Y-Enemy->Y;
			
		//	Enemy->Dir = (DistX>0?1:-1);
			
			Enemyshots[Slot].Dx = (DistX>0?3:-3);
			Enemyshots[Slot].X = Enemy->X + (DistX>0?18:-2);
			
			short Yspeed = 3;
			if( abs(DistY)<= (16*4) ){
				if( abs(DistY)<= (16*2) ){
					Yspeed = 1;
				}
				else{
					Yspeed = 2;
				};
			};
			Enemyshots[Slot].Dy = (DistY>0?Yspeed:-Yspeed);						
			Enemyshots[Slot].Handler = 0;
			Enemyshots[Slot].Sprite = (Enemyshots[Slot].Dx>0?118:117);
			Enemyshots[Slot].Type = EBTMetroid3Fireball;						
			Enemy->Data0 = 0;
		};
	};
	
	
	#undef bullet_lifetime
	#undef bullet_speed	
	#undef shotinterval
	
};
void EnemyHandler12(enemy* Enemy){
	// Handles the Ramulken, the jumping beast
	
	#define waittime 50	
	
	short OldData1 = Enemy->Data1;
	
	if(Enemy->Data3){
		Enemy->Data3--;
	}
	else{	
		EnemyHandler7(Enemy);	
		Enemy->Sprite = 134;
		// Not immortal to beams
		Enemy->TypeAttrib = 0b0000000000000100;
	};
	
	if(OldData1 != Enemy->Data1){
		Enemy->Data3 = waittime;
		Enemy->Sprite = 135;
		// Immortal to beams
		Enemy->TypeAttrib = 0b0000000000010100;
	};
	
	#undef waittime
	
};
void EnemyHandler13(enemy* Enemy){
	// Handles the Drivel. The bird that spits acid on the player
	
	#define threshold 16*3
	#define acidfallspeed	3
	#define mintime	50
	#define max_bullet_lifetime	100
	
	EnemyHandler1(Enemy);
	
	if(Enemy->Data3){
		Enemy->Data3--;
	}
	else{
		if( abs(Enemy->X-Player.X)<=threshold ){

			short Slot;
			if( (Slot = FindFreeEnemyShotSlot())>=0 ){
				Enemyshots[Slot].Active = max_bullet_lifetime;			
				Enemyshots[Slot].Y = Enemy->Y+6;
				Enemyshots[Slot].Dx = 0;
				Enemyshots[Slot].X = Enemy->X;						
				Enemyshots[Slot].Dy = acidfallspeed;						
				Enemyshots[Slot].Handler = 1;
				Enemyshots[Slot].Sprite = 146;
				Enemyshots[Slot].Type = EBTAcid;
				Enemyshots[Slot].D0 = 0;				
				Enemy->Data3 = mintime;
			};			
		};
	};
	
	
	#undef threshold
	#undef acidfallspeed
	#undef mintime
	#undef max_bullet_lifetime	
	
};
void EnemyHandler14(enemy* Enemy){
	// Handles the Autom, the robot that is armed with a flame thrower.
	
	#define fireinterval 50
	#define firelifetime 100
	
	EnemyHandler1(Enemy);
	
	if( (++Enemy->Data3)>=fireinterval ){
	
		short Slot;
			if( (Slot = FindFreeEnemyShotSlot())>=0 ){
				Enemyshots[Slot].Active = firelifetime;			
				Enemyshots[Slot].Y = Enemy->Y+24;
				Enemyshots[Slot].Dx = 0;
				Enemyshots[Slot].X = Enemy->X+5;						
				Enemyshots[Slot].Dy = 0;						
				Enemyshots[Slot].Handler = 2;
				Enemyshots[Slot].Sprite = 138;
				Enemyshots[Slot].Type = EBTFireBolt;
				Enemyshots[Slot].D0 = Gamestate.Loop;				
				Enemy->Data3 = -(fireinterval+firelifetime);
			};	
		
	};
	
	#undef firelifetime
	#undef fireinterval	
	
};
void EnemyHandler15(enemy* Enemy){
	// Handles the scorp.
	
	// Data0: Used as an internal counter/state variable
	// Dir: Dx, if any
	// Data1: Dy, if any
	
	// The time between each time it starts to crawl out
	#define idletime	20
	// The time to stay out
	#define dutytime	20	
	#define threshold	16*3
	
	short DistX = Player.X-Enemy->X;
	short DistY = Player.Y-Enemy->Y;
	
	if(Enemy->Data0){
		
		if( Enemy->Data0>(idletime + dutytime + 28) ){
			// out
			Enemy->X += Enemy->Dir;
			Enemy->Y += Enemy->Data1;
		};		
		if( (Enemy->Data0<=(idletime + 28)) && (Enemy->Data0>idletime) ){
			// in
			Enemy->X -= Enemy->Dir;
			Enemy->Y -= Enemy->Data1;
		};		
		Enemy->Data0--;
	}
	else{
		if( (abs(DistX)<=threshold) && (abs(DistY)<=threshold) ){
			Enemy->Data0 = idletime + dutytime + 28*2;
		};
	};	
	
	#undef idletime
	#undef dutytime
	#undef threshold
	
};
void EnemyHandler16(enemy* Enemy){
	// Handles the Skreek, the big "head" that rises, fires an arrow-like bullet, then goes down.
	
	//Data0: Y-direction
	//Data1: Y start position
	//Data2: Counter/state variable
	
	#define threshold	16*4
	#define min_idle_time 30
	#define fireYdist 0
	#define maxriseheight	16*5
	#define wait_time	20
	#define bulletlifetime	80
	#define yspeed	2
	
	Enemy->Dir = (Player.X<Enemy->X?-3:3);
	Enemy->Sprite = (Enemy->Data1?164:162);
	
	if(Enemy->Data1){
		
		if( (--Enemy->Data1)==(wait_time/2) ){
					
			short Slot;
			if( (Slot = FindFreeEnemyShotSlot())>=0 ){
				Enemyshots[Slot].Active = bulletlifetime;			
				Enemyshots[Slot].Y = Enemy->Y+4;
				Enemyshots[Slot].Dx = Enemy->Dir;
				Enemyshots[Slot].X = Enemy->X+(Enemy->Dir>0?12:8);//12;						
				Enemyshots[Slot].Dy = 0;						
				Enemyshots[Slot].Handler = 0;
				Enemyshots[Slot].Sprite = (Enemy->Dir<0?166:167);
				Enemyshots[Slot].Type = EBTArrowBullet;
			};			
		};	
			
		return;
	}
	
	if(Enemy->Data0){
		
		Enemy->Y += Enemy->Data0;
		Enemy->Data2 += Enemy->Data0;
		
		if(Enemy->Data0<0){
			if( (abs(Enemy->Y-Player.Y)<=fireYdist) || (Player.Y>Enemy->Y) ){				
				Enemy->Data0 = yspeed;					
				Enemy->Data1 = wait_time;			
			};
		}
		else{
			if(Enemy->Data2==0){
				Enemy->Data0 = 0;
				Enemy->Data2 = -min_idle_time;
			};
		};		
	}
	else{
		
		if(Enemy->Data2==0){
		
			short XDist = (Player.X+8)-(Enemy->X+16);
			short YDist = Player.Y-Enemy->Y;
			
			if( (abs(XDist)<threshold) && (abs(XDist)<threshold) ){
				Enemy->Data0 = -yspeed;
			};
			
		}
		else{
			Enemy->Data2++;
		};
		
	};
	
	#undef yspeed
	#undef bulletlifetime
	#undef wait_time
	#undef maxriseheight
	#undef fireYdist
	#undef min_idle_time
	#undef threshold
	
};
void EnemyHandler17(enemy* Enemy){
	// Handles the small turret that "spins" around a round tile
	// It spins around continously, and fires a shot when it reaches a given position.
	// One direction/position can be defined as blocked. It will not go to this position or 
	// The closest position on each side. Also, no blocked position can be defined. 
	// It will then spin around in a circle.
	
	// Data0: Current position
	// Data1: Shot position.
	// Data2: Step direction
	// Data3: Blocked position
	
	#define bulletlifetime 100
	
	if(Gamestate.Count1==0){		
	
		short SpriteTab[8]={
			170,173,172,174,171,175,176,177
		};
	
		short AnimTab[8]={
			NoAutoAnim,NoAutoAnim,NoAutoAnim,NoAutoAnim,NoAutoAnim,UpsideDown,UpsideDown,UpsideDown
		};
	
		short Next2Pos = (Enemy->Data0+2*Enemy->Data2);
	
		if(Next2Pos>7){
			Next2Pos -= 8;
		}
		else{
			if(Next2Pos<0){
				Next2Pos += 8;
			};
		};
	
		if( (Next2Pos==Enemy->Data3) ){
			Enemy->Data2 = -Enemy->Data2;
		};	
	
		Enemy->Data0 += Enemy->Data2;
	
		if(Enemy->Data0>7){
			Enemy->Data0 -= 8;
		}
		else{
			if(Enemy->Data0<0){
				Enemy->Data0 += 8;
			};
		};
			
		Enemy->Sprite = SpriteTab[Enemy->Data0];
		Enemy->Anim = AnimTab[Enemy->Data0];
	}
	else{
		
		if(Gamestate.Count1==3){
			if(Enemy->Data0==Enemy->Data1){
					
				char XDir[8]={-2,-1,0,1,2,1,0,-1};
				char YDir[8]={0,1,2,1,0,-1,-2,-1};
				char XOff[8]={-8,-8,0,9,9,9,0,-8};
				char YOff[8]={6,14,14,14,6,-3,-3,-3};
								
				short Slot;
				if( (Slot = FindFreeEnemyShotSlot())>=0 ){
					Enemyshots[Slot].Active = bulletlifetime;			
					Enemyshots[Slot].Y = Enemy->Y + YOff[Enemy->Data0];
					Enemyshots[Slot].Dx = XDir[Enemy->Data0];
					Enemyshots[Slot].X = Enemy->X + XOff[Enemy->Data0];						
					Enemyshots[Slot].Dy = YDir[Enemy->Data0];						
					Enemyshots[Slot].Handler = 0;
					Enemyshots[Slot].Sprite = 178;
					Enemyshots[Slot].Type = EBTTurretBullet;
				};				
			};
		};		
	};
	
	#undef bulletlifetime
	
};
void EnemyHandler18(enemy* Enemy){
	// Handles the Glow fly. Clings to a wall andf jumps over to the other side when samus is in range.
	
	// Dir: Direction. Always set properly for animation.
	// Data0: 
	//       Positive: Indicates that motion is initiated or in progress.
	//       Negative: Wait state, counting up to zero.
	
	// Min time between jumps
	#define min_idle_time	50
	#define speed	2
	
	if(Enemy->Data0>0){
		// jumping
		
		if(Enemy->Dir>0){
			if(FreeRight(Enemy->X,Enemy->Y,21)>=speed){
				Enemy->X += speed;
			}
			else{
				Enemy->Data0 = -min_idle_time;
				Enemy->Dir = -Enemy->Dir;
				Enemy->Anim = AnimByDirAndFrame2Step;
				Enemy->Sprite = 156;
			};
		}
		else{
			if(FreeLeft(Enemy->X,Enemy->Y,21)>=speed){
				Enemy->X -= speed;
			}
			else{
				Enemy->Data0 = -min_idle_time;
				Enemy->Dir = -Enemy->Dir;
				Enemy->Anim = AnimByDirAndFrame2Step;
				Enemy->Sprite = 156;
			};
		};		
		
	}
	else{
		
		if(Enemy->Data0<0){
			Enemy->Data0++;
		}
		else{			
			// check if player in range, initiate jump
			
			if( ((Player.Y+Player.Height)>=Enemy->Y) && ((Enemy->Y+20)>=Player.Y) ){
				
				if(Enemy->Dir>0){
					if(Player.X>Enemy->X){
						Enemy->Data0 = 1;
						Enemy->Sprite = 160;
						Enemy->Anim = AnimByDir;
					};
				}
				else{
					if(Player.X<Enemy->X){
						Enemy->Data0 = 1;
						Enemy->Sprite = 160;
						Enemy->Anim = AnimByDir;
					};
				};				
			};				
		};
		
	};	
	
	#undef min_idle_time
	#undef speed
	
};

void EnemyHandler19(enemy* Enemy){
	// Handles the Gravitt. It stays down under it's shell until samus comes within threshold.
	// Rises up, chases Samus. Goes back to initial position and goes down under it's shell again.
	
	// Data0 & Data1: Indicates the distance to run/chase Samus. See EnemyHandler1
	// Data3: Used as a counter/state variable. 
	//        >min_idle_time:      Chasing 
	//        <min_idle_time & >0: Waiting. Can not start chasing now.
	//        0:                   Idle
	
	#define threshold 16*4
	#define min_idle_time 40
	
	Enemy->Sprite = 179;
	
	if(Enemy->Data3){
		
		if(Enemy->Data3>min_idle_time){
			Enemy->TypeAttrib = 0b0000000000000010;
			EnemyHandler1(Enemy);
			Enemy->Sprite = 115;
		}
		else{
			Enemy->TypeAttrib = 0b0000000000010010;
		};
		Enemy->Data3--;
	}
	else{
		
		short Dist = Enemy->X-Player.X;
		
		if( abs(Dist)<=threshold ){
			Enemy->Data0 = Enemy->Data1 = abs(Dist);
			Enemy->Data3 = 2*abs(Dist) + min_idle_time;
			Enemy->Dir = (Dist>0?-1:1);
		};
	};	
	
	#undef min_idle_time
	#undef threshold
	
};

void EnemyHandler20(enemy* Enemy){
	// Handles the ring of fire.	
	
	// Dir:   X direction
	// Data0: Y direction
	// Data1: Start X Position
	// Data2: Start Y Position
	// Data3: Counter/State variable
	//        0:  In motion
	//        >0: Waiting to respawn
	
	#define min_idle_time 50
	#define life 20
	#define zero_band 16*2
	
	if(Enemy->Data3){
		// Waiting to respawn
		if( (--Enemy->Data3)==0 ){
			// Respawn			
			
			// Set position
			Enemy->X = Enemy->Data1;
			Enemy->Y = Enemy->Data2;
			
			// Find and set X & Y dir
			
			short DistX = (Player.X+Player.Height/2)-(Enemy->X+5);
			short DistY = Player.Y-Enemy->Y;
			
			Enemy->Dir = (DistX>0?1:-1);
			Enemy->Data0 = (DistY>0?1:-1);
			
			if(abs(DistY)<zero_band){
				Enemy->Data0 = 0;
			}
			else{
				if(abs(DistX)<zero_band){
					Enemy->Dir = 0;
				};
			};
			
			// Set Life
			Enemy->Life = life;	

		};
		
	}
	else{
		// In motion, or killed
		
		if(Enemy->Life<=0){
			Enemy->Data3 = min_idle_time;
			
		}
		else{
		
			Enemy->X += Enemy->Dir;
			Enemy->Y += Enemy->Data0;
		
			if( (Enemy->X<(Gamestate.FgX-16)) || (Enemy->X>(Gamestate.FgX+screen_width)) || 
			(Enemy->Y<(Gamestate.FgY-16)) || (Enemy->Y>(Gamestate.FgY+screen_height)) ){
		
				// Outside screen. Enter wait mode.
				Enemy->X = Enemy->Data1;
				Enemy->Y = Enemy->Data2;
				Enemy->Data3 = min_idle_time;
				Enemy->Life = 0;
			};		
		};		
	};
		
	#undef zero_band
	#undef life
	#undef min_idle_time
	
};

void EnemyHandler21(enemy* Enemy){
	// Handles the big Metroid that emits lightning bolts
	
	// Used Data0 as a timer for lightning bolts
	
	#define lightninginterval		40
	#define lightning_lifetime	10	
	#define zeroband  16
	
	EnemyHandler10(Enemy);
	
	if( (++Enemy->Data0)==lightninginterval ){
		// Add lightning
		short Slot;
		if( (Slot = FindFreeEnemyShotSlot())>=0){
			Enemyshots[Slot].Active = lightning_lifetime;
			Enemyshots[Slot].Dx = 0;
			Enemyshots[Slot].Dy = 0;
			Enemyshots[Slot].Handler = 3;
			Enemyshots[Slot].D0 = Gamestate.Loop;
			Enemyshots[Slot].Type = EBTMetroid4LightningBolt;
			
			short DistX = (Player.X+8)-(Enemy->X+20);
			short DistY = (Player.Y+Player.Height/2)-(Enemy->Y+19);
			short Xdir,Ydir = 1,Xoff = 0,Yoff = 0;
			
			if(DistX<0){
				Enemyshots[Slot].Sprite = 251;
				Xdir = 0;
				Xoff = -25;
			}
			else{
				Enemyshots[Slot].Sprite = 252;
				Xdir = 1;
			};
			if(abs(DistY)>=zeroband){				
			
				if(Xoff)
					Xoff = -15;
					
				if(DistY<0){
					Enemyshots[Slot].Sprite = 253 + Xdir;
					Ydir = 0;
					Yoff = -22;
				}
				else{
					Enemyshots[Slot].Sprite = 255 + Xdir;
					Ydir = 2;
				};
			};
			
			Enemyshots[Slot].X = Enemy->X + Xdir*40 + Xoff;
			Enemyshots[Slot].Y = Enemy->Y + Ydir*20 + Yoff;
			Enemyshots[Slot].D1 = Xdir*40 + Xoff;
			Enemyshots[Slot].D2 = Ydir*20 + Yoff;
		};	
		
	}
	else{
		if(Enemy->Data0>=(lightninginterval+lightning_lifetime)){
			Enemy->Data0 = 0;
		};
	};
	
	#undef lightninginterval
	#undef lightning_lifetime
	#undef zeroband
};


void EnemyHandler22(enemy* Enemy){
	// Handles the Huge Monster Metroid that spits some kind of bullets
	
	// Used Data0 as a timer for lightning bolts
	
	#define shotinterval	60
	#define bullet_speed	3
	#define bullet_lifetime	(240/bullet_speed)	
	
	EnemyHandler10(Enemy);
	
	short Slot;
	
	if( (++Enemy->Data0)>=shotinterval ){
		if( (Slot = FindFreeEnemyShotSlot())>=0){
			Enemyshots[Slot].Active = bullet_lifetime;			
			Enemyshots[Slot].Y = Enemy->Y+8;
			
			short DistX = Player.X-Enemy->X;
			short DistY = Player.Y-Enemy->Y;
			
			Enemyshots[Slot].Dx = (DistX>0?3:-3);
			Enemyshots[Slot].X = Enemy->X + (DistX>0?18:-2);
			
			short Yspeed = 3;
			if( abs(DistY)<= (16*4) ){
				if( abs(DistY)<= (16*2) ){
					Yspeed = 1;
				}
				else{
					Yspeed = 2;
				};
			};
			Enemyshots[Slot].Dy = (DistY>0?Yspeed:-Yspeed);						
			Enemyshots[Slot].Handler = 0;
			Enemyshots[Slot].Sprite = 257;
			Enemyshots[Slot].Type = EBTMetroid5Fireball;						
			Enemy->Data0 = 0;
		};
	};
	
	
	#undef shotinterval
	#undef bullet_speed
	#undef bullet_lifetime
	
};

void EnemyHandler23(enemy* Enemy){
	// Handles Mother brain.
	
	short GetNextSpriteNr(short CurrentSprite){		
		return (CurrentSprite==263?264:263);	
	};
	
	#define MaxLife	50
	
		
	if(++Enemy->Data0>=20)
		Enemy->Data0 = 0;
	if(++Enemy->Data1>=40)
		Enemy->Data1 = 0;
		if(++Enemy->Data2>=80)
		Enemy->Data2 = 0;
			
	
	if(Enemy->Life==(MaxLife)){
		if(Enemy->Data2==0){
			Enemy->Sprite = GetNextSpriteNr(Enemy->Sprite);
		};
	}
	else{		
		if( Enemy->Life<=10 ){
			Enemy->Anim = AnimByFrame2Step;
			Enemy->Sprite = 263;
		}
		else{
			//Life > 10
			Enemy->Anim = NoAutoAnim;
		
			if( Enemy->Life>=(MaxLife/2) ){			
				if(Enemy->Data1==0){
					Enemy->Sprite = GetNextSpriteNr(Enemy->Sprite);
				}			
			}
			else{
				// Life > 0 && Life<(MaxLife/2)						
				if(Enemy->Data0==0){
					Enemy->Sprite = GetNextSpriteNr(Enemy->Sprite);
				};			
			};		
		};		
	};	
	
	
	
	#undef MaxLife
};


void EnemyHandler24(enemy* Enemy){
	// Handles the energy Barriers
	
	if(Enemy->Life<=8){
		Enemy->Sprite = 267;
	};
	if(Enemy->Life<=4){
		Enemy->Sprite = 268;
	};
	
};


void EnemyShotHandler1(shot* Shot){
	// Handles the acid from the Drivel
	
	#define fallspeed 3
	#define	anim_step_length	4
	#define anim_lifetime	(anim_step_length*3)
	
	if(Shot->D0){
		switch(Shot->Active){
			case anim_step_length:
				Shot->Sprite = 149;
			break;
			case (anim_step_length*2):
				Shot->Sprite = 148;
			break;			
		};
	}
	else{

		if(FreeDown(Shot->X+4,Shot->Y+8,8)<fallspeed){
			Shot->Active = anim_lifetime;
			Shot->D0 = 1;
			Shot->Sprite = 147;
		}
		else{
			Shot->Y += fallspeed;
		};
	};
	
	#undef fallspeed
	#undef anim_step_length
	#undef anim_lifetime
	
};

void EnemyShotHandler2(shot* Shot){
	
	#define step_length  5
	#define firelifetime 100
	
	Shot->X = Enemies[Shot->D0].X+5;
	
	switch(Shot->Active){
		case (firelifetime-step_length):
		case 5:
			Shot->Sprite = 139;
		break;
		case 10:
		case (firelifetime-2*step_length):
			Shot->Sprite = 140;
		break;
		/*case (firelifetime-15):
			
		break;
		case :
			
		break;*/
	}
	
	if( (Shot->Active<=(firelifetime-3*step_length)) && (Shot->Active>=(3*step_length)) ){
		Shot->Sprite = 141 + Gamestate.TwoAnimStep;//(?:);
	};
	
	// Bug: 
	if(Enemies[Shot->D0].Life<=0){
		Shot->Active = 1;
	};
	
	#undef step_length
	#undef firelifetime
};

void EnemyShotHandler3(shot* Shot){
	// Handles the lightning bolts that are emitted from metroid 4
				
	Shot->X = Enemies[Shot->D0].X + Shot->D1;
	Shot->Y = Enemies[Shot->D0].Y + Shot->D2;	
	
};

