#ifndef __blocking__
#define __blocking__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   blocking.h                                                            *
*			Description:                   *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

#define max_nr_of_blocks  6
#define item_block_time (-1)

#define YOverlap(y0,h0,y1,h1) (((y0+h0)>y1) && ((y1+h1)>y0))
#define XOverlap(x0,w0,x1,w1) (((x0+w0)>x1) && ((x1+w1)>x0))


/*
This struct defines a small area that is blocked for the player.
Intended to use with enemies that are frozen with ice beam.
*/


typedef struct{
	short Active;
	short Index;
	short X;
	short Y;
	short Height;
	short Width;
}block;

extern block Blocks[max_nr_of_blocks];

void HandleBlockedLocations();














#endif