// C Source File
// Created 12/27/2001; 9:40:13 AM

//    Road 1.0
//    Copyright (C) 2000 Michael Chmutov
//
//    This program is free software; you can redistribute it and/or
//    modify it under the terms of the GNU General Public License
//    as published by the Free Software Foundation; either version 2
//    of the License, or (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#define USE_TI89              // Produce .89z File
#define USE_TI92PLUS          // Produce .9xz File

#define OPTIMIZE_ROM_CALLS    // Use ROM Call Optimization

#define SAVE_SCREEN           // Save/Restore LCD Contents

#include <tigcclib.h>         // Include All Header Files
#include "road.h"			// Include the road function  and global variable definitions

void play(void)
{
	int key=0;
	int count=1;
	int hor_line;
	while (key!=KEY_ESC)
	{
		key=ngetchx();
		// Move up
		if (key==KEY_UP)  
		{
			if (your_pos>upper_bound-1) // Unless at the beginning
			{
				Sprite8 (lcd_width-start_pos-1,your_pos,sprite_height,you,LCD_MEM,SPRT_XOR);		
				your_pos=your_pos-path_size;
				Sprite8 (lcd_width-start_pos-1,your_pos,sprite_height,you,LCD_MEM,SPRT_XOR);
			}
		}
		//Move down
		if (key==KEY_DOWN)
		{
			if (your_pos<lower_bound-1) // Unless at the end
			{
				Sprite8 (lcd_width-start_pos-1,your_pos,sprite_height,you,LCD_MEM,SPRT_XOR);		
				your_pos=your_pos+path_size;
				Sprite8 (lcd_width-start_pos-1,your_pos,sprite_height,you,LCD_MEM,SPRT_XOR);
			}
		}
		// Handle level change
		if (your_pos==lower_bound-1)
		{
			lev++;
			ClrScr();
			if (lev==win_level)  // If you beat the last level
			{
				printf_xy(10, lcd_height/2, "Congratulations!!! You won!", lev);
				next_level=FALSE;
			}
			else  // If you beat a regular level
			{
				printf_xy(lcd_width/2, lcd_height/2, "Prepare for Level %u", lev);
				next_level=TRUE;
			}
			ngetchx();
			break;
		}
		// Move cars
		for (hor_line=upper_bound+path_size;hor_line<=lower_bound-path_size;hor_line+=path_size)
		{
			int count1; // Used to handle multiple cars in the same lane
			for (count1=position[count-1]; count1>=0; count1-=(3*speed[count-1]+speed[count-1]/3))
			{
				Sprite8 (start_pos+count1*step_length-1,hor_line-1,sprite_height,car,LCD_MEM,SPRT_XOR);  // Erase it
			}
			if (position[count-1]+speed[count-1] < number_of_dots) // The car is not "near" the end of the screen
			{
				position[count-1]+=speed[count-1];
			}
			else
			{
				if (hor_line==your_pos+1)  // You happened to be in it's way :(
				{
					ClrScr();
					printf_xy(lcd_width/2, lcd_height/2, "You got hit :(");
					ngetchx();
					key=KEY_ESC;
				}
				position[count-1]-=(2*speed[count-1]+speed[count-1]/3); // Make it come out of the other side (sort of toroidal behavior)
			}
			if (number_of_dots-position[count-1]<=speed[count-1]) // The car has one turn left to get to the end
			{
				printf_xy(lcd_width-start_pos+2, hor_line-2, "LT");
			}
			else if (number_of_dots-position[count-1]>=10)  //  >=10 dots left
			{
				printf_xy(lcd_width-start_pos+2, hor_line-2, "%u", number_of_dots-position[count-1]);
			}
			else  // <10 dots left (gets very confusing otherwise because numbers from previous moves are left)
			{
				printf_xy(lcd_width-start_pos+2, hor_line-2,"0%u", number_of_dots-position[count-1]);
			}
			for (count1=position[count-1]; count1>=0; count1-=(3*speed[count-1]+speed[count-1]/3))
			{
				Sprite8 (start_pos+count1*step_length-1,hor_line-1,sprite_height,car,LCD_MEM,SPRT_XOR);  // Redraw the car
			}
			count++;
		}
		count=1;
	}
}

void create_road(void)
{

	int hor_line;
	int ver_line;
	int count=1, count1;
	number_of_dots=(lcd_width-2*start_pos)/step_length;
	your_pos=upper_bound-1;
	DrawLine (0,lower_bound,lcd_width,lower_bound,A_NORMAL);  // Draw the bounadries
	DrawLine (0,upper_bound,lcd_width,upper_bound,A_NORMAL);
	for (hor_line=upper_bound+path_size;hor_line<=lower_bound-path_size;hor_line+=path_size)
	{
		for (ver_line=start_pos;ver_line<=lcd_width-start_pos;ver_line+=step_length)
		{
			DrawPix (ver_line,hor_line,A_NORMAL); // Draw dots
		}
		printf_xy(0, hor_line-2, "%u", speed[count-1]);  // Print speeds on the left side of screen
		position[count-1]=number_of_dots-random(10);  // Randomly position cars within the last 10 dots
		for (count1=position[count-1]; count1>=0; count1-=(3*speed[count-1]+speed[count-1]/3))
		{
			Sprite8 (start_pos+count1*step_length-1,hor_line-1,sprite_height,car,LCD_MEM,SPRT_OR);  // Draw the cars
		}
		if (number_of_dots-position[count-1]<=speed[count-1]) // The car has one turn left to get to the end
		{
			printf_xy(lcd_width-start_pos+2, hor_line-2, "LT");
		}
		else if (number_of_dots-position[count-1]>=10)  //  >=10 dots left
		{
			printf_xy(lcd_width-start_pos+2, hor_line-2, "%u", number_of_dots-position[count-1]);
		}
		else  // <10 dots left (gets very confusing otherwise because numbers from previous moves are left)
		{
			printf_xy(lcd_width-start_pos+2, hor_line-2,"0%u", number_of_dots-position[count-1]);
		}
	
		//printf_xy(lcd_width-start_pos+2, hor_line-2, "%u", number_of_dots-position[count-1]); // Print positions on left side of screen
		count++;
	}
	Sprite8 (lcd_width-start_pos-1,your_pos,sprite_height,you,LCD_MEM,SPRT_OR);   // Drawe you	
}

// Main Function
void _main(void)
{
	FontSetSys (F_4x6); // Switch to small font
	lcd_width=LCD_WIDTH;   // These are (were?) needed to be constants for some reason I never figured out
	lcd_height=LCD_HEIGHT;
	win_level=lcd_height/path_size-2; // Set the winning level (different on 89 or 92+ - determined by screen size)
	while (next_level==TRUE)
	{
		next_level=FALSE; 
		ClrScr();
		upper_bound=lcd_height/2-(lev+2)*path_size/2;  // Set the upper bound of the road
		lower_bound=lcd_height/2+(lev+2)*path_size/2; // Set the lower bound of the road
		create_road();
		play();
	}
	lev=1;
	next_level=TRUE;
	FontSetSys(F_8x10); // Switch back to normal font
}
