#include "asm86.h"
#include "rom86.h"
#include "ram86.h"

.org $801F	;loader+this prog's 4 bytes+lists+other crap
	ret
ProgStart:
	call _runindicoff
	call _flushallmenus
	call _clrLCD
	call Put_Big_Bar
	call SetupMenu		;so that when the prog ends, WRITEBACK! <==push pc
;	call WriteBack		;WRITE THE STUFF BETWEEN DATA_START & DATA_END to VAR!
	ret
	;you fall down, down.., down.....
SetupMenu:
	call ClearWorkArea
;	call Put_Big_Bar
	ld hl,Title
	set textInverse,(IY+textflags)
	ld a,10
	ld (_penCol),a
	ld a,0
	ld (_penRow),a
	call _vputs
	ld ix,BoltIcon
	ld bc,$0100
	call PutSprite
	res textInverse,(IY+textflags)

	ld a,16
	ld (_penCol),a
	ld hl,MMenu1
	ld a,10
	ld (_penRow),a
	call _vputs

	ld a,16
	ld (_penCol),a
	ld hl,MMenu2
	ld a,20
	ld (_penRow),a
	call _vputs

	ld a,16
	ld (_penCol),a
	ld hl,MMenu3
	ld a,30
	ld (_penRow),a
	call _vputs

	ld a,16
	ld (_penCol),a
	ld hl,MMenu4
	ld a,40
	ld (_penRow),a
	call _vputs

	ld a,0
	ld (selection),a

	ld bc,(256*4)+10
	ld ix,Chooser
	call PutSprite
SetupMenu_KeyLoop:
	call _get_key
	cp K_F1
	call z,About
	cp K_EXIT
	jp z,_clrLCD
	cp K_ENTER
	jp z,SM_CheckSelection
	cp K_DOWN
	jp z,SM_MoveDown
	cp K_UP
	jp z,SM_MoveUp
	cp K_SECOND
	jp z,SM_CheckSelection
	jr SetupMenu_Keyloop
SM_CheckSelection
	ld a,(selection)
	cp 0
	jp z,Check4aPass
	cp 1
	jp z,ChangePassWord
	cp 2
	jp z,OptionMenu
	cp 3
	jp z,_clrLCD
;if invalid, RESET!
SM_MoveDown:
	ld a,(selection)
	cp 3
	jp z,SetupMenu_KeyLoop
	cp 0
	call z,Cursor1
	cp 1
	call z,Cursor2
	cp 2
	call z,Cursor3
	jp SetupMenu_KeyLoop
SM_MoveUp:
	ld a,(selection)
	cp 0
	jp z,SetupMenu_KeyLoop
	cp 1
	call z,Cursor0
	cp 2
	call z,Cursor1
	cp 3
	call z,Cursor2
	jp SetupMenu_KeyLoop
Cursor0:
	ld a,0
	ld (selection),a
	ld bc,(256*4)+10
	ld ix,Chooser
	call PutSprite
	ld bc,(256*4)+20
	ld ix,NoChooser
	call PutSprite
	ld a,$FF
	ret
Cursor1:
	ld a,1
	ld (selection),a
	ld bc,(256*4)+10
	ld ix,NoChooser
	call PutSprite
	ld bc,(256*4)+20
	ld ix,Chooser
	call PutSprite
	ld bc,(256*4)+30
	ld ix,NoChooser
	call PutSprite
	ld a,$FF
	ret
Cursor2:
	ld a,2
	ld (selection),a
	ld bc,(256*4)+20
	ld ix,NoChooser
	call PutSprite
	ld bc,(256*4)+30
	ld ix,Chooser
	call PutSprite
	ld bc,(256*4)+40
	ld ix,NoChooser
	call PutSprite
	ld a,$FF
	ret
Cursor3:
	ld a,3
	ld (selection),a
	ld bc,(256*4)+30
	ld ix,NoChooser
	call PutSprite
	ld bc,(256*4)+40
	ld ix,Chooser
	call PutSprite
	ld a,$FF
	ret

OptionMenu:
	call ClearWorkArea
;	call Put_Big_Bar
	ld hl,Title
	set textInverse,(IY+textflags)
	ld a,10
	ld (_penCol),a
	ld a,0
	ld (_penRow),a
	call _vputs
	ld ix,BoltIcon
	ld bc,$0100
	call PutSprite
	res textInverse,(IY+textflags)

	ld a,16
	ld (_penCol),a
	ld hl,OMenu1
	ld a,10
	ld (_penRow),a
	call _vputs

	ld a,16
	ld (_penCol),a
	ld hl,OMenu2
	ld a,20
	ld (_penRow),a
	call _vputs

	ld a,16
	ld (_penCol),a
	ld hl,OMenu3
	ld a,30
	ld (_penRow),a
	call _vputs

	ld a,16
	ld (_penCol),a
	ld hl,OMenu4
	ld a,40
	ld (_penRow),a
	call _vputs

	ld a,0
	ld (selection),a

	ld bc,(256*4)+10
	ld ix,Chooser
	call PutSprite
OptionMenu_KeyLoop:
	call _get_key
	cp K_F1
	call z,About
	cp K_EXIT
	jp z,SetupMenu	;Back to the Main Menu
	cp K_ENTER
	jp z,OM_CheckSelection
	cp K_DOWN
	jp z,OM_MoveDown
	cp K_UP
	jp z,OM_MoveUp
	cp K_SECOND
	jp z,OM_CheckSelection
	jr OptionMenu_Keyloop
OM_CheckSelection
	ld a,(selection)
	cp 0		;PutSprite as TEMP routine 'cause I don't have those yet
	jp z,PutSprite;ExitToWhere		;Hello, I NEED A SECOND LEVEL MENU!
	cp 1
	jp z,PutSprite;PassWordActive
	cp 2
	jp z,ResetPassWord
	cp 3
	jp z,SetupMenu
;if invalid, RESET!
OM_MoveDown:
	ld a,(selection)
	cp 3
	jp z,OptionMenu_KeyLoop
	cp 0
	call z,Cursor1
	cp 1
	call z,Cursor2
	cp 2
	call z,Cursor3
	jp OptionMenu_KeyLoop
OM_MoveUp:
	ld a,(selection)
	cp 0
	jp z,OptionMenu_KeyLoop
	cp 1
	call z,Cursor0
	cp 2
	call z,Cursor1
	cp 3
	call z,Cursor2
	jp OptionMenu_KeyLoop

Check4Password:		;z set if exists, reset if not
	ld a,(PasswordExists)
	cp 1		;check for exist
	ret
Check4aPass:
	call Check4Password
	jp nz,NoPassword
EnterPass:
	call ClearWorkArea
	call ClrBuffers
	ld a,1
	ld (_penCol),a
	ld a,10
	ld (_penRow),a
	ld hl,PassTXT
	call _vputs
	ld a,32
	ld (_penCol),a
	ld a,10
	ld (_penRow),a

	ld hl,Input_Buffer
	ld b,12
	call TextIn
	jp z,EP_Enter
	call nz,EP_Off
	jp EnterPass
EP_Enter:	;(which ACTUALLY works)
	ld b,12
	ld hl,Input_Buffer
	ld de,Password
EP_ChkPLoop:
	ld a,(hl)		;"ld c,(hl)"
	ld c,a
	ld a,(de)
	sub c
	cp 0
	jp nz,EP_Off
	inc hl
	inc de
	djnz EP_ChkPLoop
	jp ReturnToWhat		;Right!
EP_Off:	;WRONGO!
	ld a,%00000001
	out (3),a		;turn off lcd
;	halt			;wait for [on]
	jp EnterPass
ReturnToWhat:
	ld a,(ExitTo)
	ret ;z (not yet)	;the only thing you can do now is return to shell cause the option has not been implemented.
	;(no way to change 'exit to...')
;	jp z,$056E		;Absolute address for _jforcecmdnochar, not affected by (eek) paging
;	jp z,SetupMenu	;Bolt86
;<WRITE CODE TO COMPARE A to 0,1,2,3. DO ACTIONS ACCORDINGLY>

NoPassword:
	ld hl,NP_Title
	ld de,NP_Text
	call DialogBox
	jp SetupMenu
ChangePassword:		;commented things in ChangePassword are things not yet done.
	call Check4Password		;none? Dont jp EnterPass
	call z,EnterPass
	call ClearWorkArea
	call ClrBuffers
	ld a,1
	ld (_penCol),a
	ld a,10
	ld (_penRow),a
	ld hl,EnterTXT
	call _vputs
	ld a,32
	ld (_penCol),a
	ld a,10
	ld (_penRow),a

	ld hl,Input_Buffer
	ld b,12
	call TextIn
	jp z,ComfirmPass
	jp nz,YouDidntEnterPass
ComfirmPass:
	ld a,1
	ld (_penCol),a
	ld a,18
	ld (_penRow),a
	ld hl,ComfirmTXT
	call _vputs
	ld a,32
	ld (_penCol),a
	ld a,18
	ld (_penRow),a
	ld hl,Comfirm_Buffer
	ld b,12
	call TextIn
	jp z,CheckPass
	jp nz,YouDidntEnterPass
CheckPass:	;(which ACTUALLY works)
	ld b,12
	ld hl,Input_Buffer
	ld de,Comfirm_Buffer
ChkPLoop:
	ld a,(hl)		;"ld c,(hl)"
	ld c,a
	ld a,(de)
	sub c
	cp 0
	jp nz,YouDidntEnterPass
	inc hl
	inc de
	djnz ChkPLoop
WritePass:
	ld a,1
	ld (PasswordExists),a
	ld bc,12
	ld hl,Input_Buffer
	ld de,Password
	ldir		;hl->de
	ld hl,WP_DTitle
	ld de,WP_DText
	call DialogBox
	call ClrBuffers
	jp SetupMenu
ClrBuffers:
	ld b,12
	ld a,0
	ld hl,Input_Buffer
	call CB_Loop
	ld b,12
	ld hl,Comfirm_Buffer
	call CB_Loop
	ret
CB_Loop:
	ld (hl),a
	inc hl
	djnz CB_Loop
	ret

YouDidntEnterPass:
	call ClrBuffers
	ld hl,YDEP_DTitle
	ld de,YDEP_DText
	call DialogBox
	jp SetupMenu

ResetPassWord:		;No password exists
	call Check4Password		;none? Dont jp EnterPass
	call z,EnterPass
	ld a,1	;Yes, there is a choice
	ld (Choice),a
	ld hl,ReallyTtl
	ld de,ReallyTxt
	call DialogBox
	ld a,(Choice)
	cp 3	;Enter
	jr z,RESET
RPW_GotoSetupMenu:
	xor a
	ld (Choice),a
	jp SetupMenu
RESET:
	xor a
	ld (Choice),a
	ld (PasswordExists),a
	ld hl,Password
	ld a,0
	ld b,12
RPW_Loop:
	ld (hl),a
	inc hl
	djnz RPW_Loop
	ld hl,RPW_DTitle
	ld de,RPW_DText
	call SlowDownBuster
	call DialogBox
	jp SetupMenu
ClearWorkArea:
;==========================================
; clear_screen by jimi (malcolmj1@juno.com)
; input:	none
: output:	all bits in video mem reset
; destroy:	bc,de,hl
; clock cycles:	71 t-states
; size:		14 bytes
;==========================================
	ld hl,$fC80	;start of video memory
	ld (hl),0
	ld de,$fC81	;2nd byte in video mem
	ld bc,895	;size of video mem-1
	ldir		;copy already cleared
	ret		;we're done
ClearPlotSScreen:	;for DialogBox and the like
;==========================================
; clear_screen by jimi (malcolmj1@juno.com)
; input:	none
: output:	all bits in graph mem reset
; destroy:	bc,de,hl
; clock cycles:	71 t-states
; size:		14 bytes
;==========================================
	ld hl,_plotSScreen
	ld de,_plotSScreen+1
	ld (hl),0
	ld bc,1024
	ldir
	ret		;we're done
DialogBox:
	push de
	push hl
	call ClearWorkArea
	call ClearPlotSScreen		;Yeah, the GRPAH messes up the box.
;<Actual code>
;Horizontal
	ld h,1
	ld bc,(256*10)+54				;(10,12)
	ld de,(256*118)+54			;(x,y)
	call _ILine
	ld h,1
	ld bc,(256*10)+46
	ld de,(256*118)+46
	call _ILine
	ld h,1
	ld bc,(256*10)+2
	ld de,(256*118)+2
	call _ILine
;Vertical
	ld h,1
	ld bc,(256*10)+2
	ld de,(256*10)+54
	call _ILine
	ld h,1
	ld bc,(256*118)+2
	ld de,(256*118)+54
	call _ILine
;</Actual Code>
	pop hl
	ld a,14
	ld (_penCol),a
	ld a,10
	ld (_penRow),a
	call _vputs

	pop hl
	ld a,17
	ld (_penCol),a
	ld a,28
	ld (_penRow),a
	call _vputs
	ld a,(Choice)
	cp 1
	jr z,DB_Choice
;<MODIFICATION>
	call _getkey
;</MODIFICATION>

	ret
DB_Choice:
	call _getkey
	cp kexit
	jr z,DB_C_Exit
	cp kenter
	jr z,DB_C_Enter
	jr DB_Choice
DB_C_Enter:
	ld a,3	;Enter
	ld (Choice),a
	ret
DB_C_Exit:
	ld a,4	;Exit
	ld (Choice),a
	ret
Choice:
	.db 0

Put_Big_Bar:		;af, b, hl destroyed
	ld hl, $FC00
	ld a,$FF
	ld b,128
PBB_Loop1:
	ld (hl),a
	inc hl
	djnz PBB_Loop1
	ret

About:
	ld hl,Title
	ld de,Ver
	call DialogBox
	ld a,$FF		;So Setup/Option Menu won't go to something 'automatically'(cp)
	ld a,17
	ld (_penCol),a
	ld a,39
	ld (_penRow),a
	ld hl,Company
	call _vputs
	call _getkey
	pop hl
	ld de,$D7E0
	call cphlNde
	jp z,SetupMenu
	jp nz,OptionMenu

Data_Start:
Settings:
Password:
	.db 0,0,0,0,0,0,0,0,0,0,0,0,0	;12 chars, one 0
ExitTo:
	.db 0	;Exit to shell, 1=Exit to homescreen, 2=Exit to Bolt 86
PasswordOn:
	.db 0	;Password On, 1=Password INACTIVE
PasswordExists:		;For initial run, disables 'Protect calc' until pw set
	.db 0	;Doesn't exist. 1=exists. When there is a password, it equals 1.
Data_End:

Input_Buffer:
	.db 0,0,0,0,0,0,0,0,0,0,0,0,0	;12 chars
Comfirm_Buffer:		;Comfirm your pass...
	.db 0,0,0,0,0,0,0,0,0,0,0,0,0	;12 chars
ComfirmTXT:
	.db "Comfirm:",0
EnterTXT:
	.db "Enter:",0
PassTXT:
	.db "Pass?:",0
ReallyTtl:
	.db "Bolt 86: Reset Password?",0
ReallyTxt:
	.db "Enter to reset Exit to cancel",0
Title:
	.db "Bolt 86 by Patrick Wong v0.37",$1,0
Ver:                 ;BETA
	.db "Version 0.37",$1,0
Company:
	.db "(C) CrystalTech 2000",0
NP_Title:
	.db "Bolt 86: Protect Calc FAIL",0
NP_Text:
	.db "No password!",0
YDEP_DTitle:
	.db "Bolt 86: Password Change FAIL",0
YDEP_DText:
	.db "Password NOT changed",0
RPW_DTitle:
	.db "Bolt 86: Password Cleared",0
RPW_DText:
	.db "Password Cleared",0
WP_DTitle:
	.db "Bolt 86: Password Written",0
WP_DText:
	.db "Password Written",0
MMenu1:
	.db ">Protect calc",0
MMenu2:
	.db ">Change password",0
MMenu3:
	.db ">Options",0
MMenu4:
	.db ">Exit",0
OMenu1:
	.db ">Exit to:",0
OMenu2:
	.db ">Password on:",0
OMenu3:
	.db ">Reset password",Lellipsis,0
OChoiceY:
	.db ">Yes",0
OChoiceN:
	.db ">No",0
OChoiceTIOS:
	.db ">TI-OS",0
OChoiceShell:
	.db ">Shell",0
OChoiceBolt86:
	.db ">Bolt 86",0
OMenu4:
	.db ">Exit",0
selection:	;Temp_Var
	.db 0
Chooser:
	.db %00001000
	.db %00001100
	.db %11111010
	.db %10000001
	.db %11111010
	.db %00001100
	.db %00001000
	.db %00000000
	.db %00001000
	.db %00001100
	.db %11111110
	.db %11111111
	.db %11111110
	.db %00001100
	.db %00001000
	.db %00000000

NoChooser:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00001000
	.db %00001100
	.db %11111010
	.db %10000011
	.db %11111010
	.db %00001100
	.db %00001000
	.db %00000000

BoltIcon:
	.db %00011000
	.db %00100100
	.db %00100100
	.db %00100100
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

UselessOtherSprites:
	;I haven't used these sprites yet... in version 0.5 $01 I hope
Locked:
	.db %00011000
	.db %00100100
	.db %00100100
	.db %00100100
	.db %01111110
	.db %01000010
	.db %01000010
	.db %01111110
	.db %00011000
	.db %00111100
	.db %00111100
	.db %00111100
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110

Unlocked:
	.db %00011000
	.db %00100100
	.db %00100100
	.db %00100000
	.db %01111110
	.db %01000010
	.db %01000010
	.db %01111110
	.db %00011000
	.db %00111100
	.db %00111100
	.db %00111100
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110

Wrong:
	.db %10000010
	.db %01000100
	.db %00101000
	.db %00010000
	.db %00101000
	.db %01000100
	.db %10000010
	.db %00000000
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %00000000

Right:
	.db %00000100
	.db %00000100
	.db %00001000
	.db %00001000
	.db %10010000
	.db %01010000
	.db %00100000
	.db %00000000
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %11111110
	.db %00000000

;In: hl=destination b=max chars
;Out: (hl)=Text in SPECIAL FORMAT
;but it was meant for PASSWORDS!
;Why store in easy-to-view format?
TextIn:


TextInLoop:
	push hl
	call _get_key
	pop hl
	cp 0			;No key? RELOOP
	jr z,TextInLoop	;Above
	call SlowDownBuster
	cp K_ENTER		;Commit
	jp z, TIP_ENTER		;enter was pressed

	cp K_EXIT				;exit key?

	jr z, TIP_CANCEL		;EXIT

	ld c,a					;back up A
	ld a, b					;load counter value

	cp 0					;see if char allowance has maxed out

	jr z, TextInLoop			;too many characters, so bypass remaining input but not the enter and exit keys.

	ld a,c					;LOAD BACK A
	ld (hl),a				;To 'Text area'
	ld a,Lasterisk		;Password
	call _vputmap			;display a space

	inc hl					;forward pointer

	dec b					;decrement counter

	jr TextInLoop
TIP_ENTER:
	cp a					;set the z flag, faster than cp 0, a=a

	ret						;done

TIP_CANCEL
	xor a					;a=0

	cp 1					;set the nz flag

	ret						;done

SlowDownBuster:
	halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt \ halt
	halt
	halt \ halt
	ret
;WHY? TRY [2nd]+[On]. It shuts off and lets you back into the OS.
; in: ix = 8x8 masked sprite, bc = x,y location

PutSprite: ;Modified by ME for slight speed optimization, instead of sprite in hl[push hl\pop ix]
VIDEODRAW=$FC00
 call FindAddress					; calc address and offset

PutSpriteE:
 ld de,$FC00					; draw sprite to video memory

 add hl,de							; add offset to buffer start

RenderSpriteCV =$+1

 ld b,8								; set row counter to 8 bytes

RenderSpriteL:
 push bc							; save row counter and sprite offset

 ld a,(ix+8)						; load mask for this row

RenderSpriteM =$-1

 cpl								; invert the mask

 ld b,a								; save inverted mask

 ld d,(ix)							; load sprite byte for this row

 inc ix								; advance sprite pointer

 ld a,c								; set shift counter to sprite offset

 ld c,$ff							; set all bits of right mask byte

 ld e,0								; clear right byte of sprite

 or a								; is the sprite aligned?

 jr z,RenderSpriteD					; then skip shifting it

RenderSpriteS:
 srl d								; shift left sprite byte

 rr e								; into the right sprite byte

 scf								; set carry

 rr b 								; shift left mask byte

 rr c								; into the right mask byte

 dec a								; decrease shift counter

 jr nz,RenderSpriteS				; loop until counter is 0

RenderSpriteD:
RenderSpriteCL =$

 ld a,b								; load the left sprite byte

 and (hl)							; and it with the screen

 or d								; or it with the mask

 ld (hl),a							; set screen memory to left byte

 inc hl								; increase screen pointer

RenderSpriteCR =$

 ld a,c								; load the right sprite byte

 and (hl)							; and it with the screen

 or e								; or it with the mask

 ld (hl),a							; set screen memory to left byte

 ld de,15							; next row is 15 bytes ahead

 add hl,de							; move screen pointer to next row

 pop bc								; restore loop counter and shift mask

 djnz RenderSpriteL					; loop for all bytes in sprite

 ret								; done drawing the sprite

; in: bc = x,y location

; out: hl = offset of byte, c = offset in video byte

FindAddress:
 ld a,c								; get the y coord

 add a,a							; multiply by 2

 add a,a							; again by 4

 ld l,a								; save as low byte

 ld h,0								; clear high byte

 add hl,hl							; multiply by 8

 add hl,hl							; and again by 16

 ld a,b								; now get the x coord

 and %11111000						; clear lower 3 bits

 rra								; divide by 2

 rra								; this time by 4

 rra								; and finally by 8

 or l								; combine with low byte

 ld l,a								; save it

 ld a,b								; get x coord again

 and %00000111						; clear all but last 3 bits

 ld c,a								; save sprite offset in c

 ret								; return to caller


cphlNde:
	;compares hl to de

	;already in rom, but since we're swapping pages, can't

	;rely on it being there. this is identical routine

	;Also faster.

	push hl					;save hl

	or a						;reset carry flag

	sbc hl,de					;subtract de from hl and store in hl

	pop hl					;restore hl (all that was affected by subtraction was flags)

	ret						;return


WriteBack:		;We're gonna be calling this many times...

	ld hl,_asapvar			;hl->name of program

	rst 20h				;copy to OP1

	rst 10h				;_findsym

	xor a

	ld hl,data_start-_asm_exec_ram+4		;offset

	add hl,de				;hl=pointer to data in original prog

	adc a,b				;in case we overlapped pages

	call _SET_ABS_DEST_ADDR

	xor a					;no absolute addressing now

	ld hl,data_start			;get data from here

	call _SET_ABS_SRC_ADDR

	ld hl,data_end-data_start	;number of bytes to save

	call _SET_MM_NUM_BYTES

	jp _MM_LDIR			;copy data and return