;Sweet16 v1.1
; by Jonathan Marcus (Appelkore@aol.com)

#include mAsm86

.org _asm_exec_ram
	nop
	jp start
	.dw 0,title
title:
	.db "Sweet16 v1.1 ",$D0," JM",0

addr: .dw 0

get_address:
	ld hl,$FC70
	ld de,$FC71
	ld bc,$038F
	ldir					;clear everything below title
	ld hl,$0701
	ld (_penCol),hl
	ld hl,str_input_address
	call _vputs
	ld hl,$0D07
	ld (_penCol),hl

;--- Jonah's hex input routine (with modifications) ---
	ld d,4
	ld hl,0
input_hex_byte:
	push de
	push hl
input_hex_key:
	halt
	call _getcsc
	or a
	jr z,input_hex_key
	pop hl
	pop de
	cp K_EXIT
	jr z,get_address_done	;canceled (skip changing (addr))
	push hl
	ld hl,keytable
	ld bc,16
	cpir
	pop hl
	jr nz,input_hex_key
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl				;x 16
	ld a,c
	or l					;add new value
	ld l,a
	ld a,c

	push de
	call vdisp_nybble
	pop de

	dec d
	jr nz,input_hex_byte
;------------------------------------------------------

	ld (addr),hl
get_address_done:
	ld hl,$FC70
	ld de,$FC71
	ld bc,$0060
	ldir					;clear "Enter address"
	jr main

start:
	call _runindicoff
	call _clrLCD
	ld hl,$0002
	ld (_penCol),hl
	ld hl,str_sweet
	call _vputs
	ld bc,$003D
	ld (_penCol),bc
	call _vputs

	ld hl,$FC00
	ld b,$70
invert_title_loop:
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	djnz invert_title_loop

	ld hl,1

leftone:
	dec hl

main_set_addr:
	ld (addr),hl
main:						;display stuff
	ld hl,$0701
	ld (_penCol),hl
	ld hl,(addr)
	ld b,8					;8 rows
row_loop:
	push hl
	ld hl,(_penCol)
	add h,6
	ld l,7
	ld (_penCol),hl
	pop hl

	ld a,h
	call vdisp_a_hex
	ld a,l
	call vdisp_a_hex

	ld a,25
	ld (_penCol),a
	push bc
	ld b,8					;8 cols
dump_loop:
	ld a,(hl)
	call vdisp_a_hex
	ld a,' '
	call _vputmap
	inc hl
	djnz dump_loop
	pop bc
	djnz row_loop

;down left right up
;exit=$37,custom=$17
main_keys:
	halt
	call _getcsc
	or a
	jr z,main_keys
	ld hl,(addr)
	dec a
	jr z,downrow
	dec a
	jr z,leftone
	dec a
	jr z,rightone
	dec a
	jr z,uprow
	cp $13
	jp z,get_address
	cp $33					;K_EXIT-4
	jr nz,main_keys
	jp _clrScrn

uprow:
	ld de,$FFF8				;=-8
	jr moverow

downrow:
	ld de,8

moverow:
	add hl,de
	jr main_set_addr

rightone:
	inc hl
	jr main_set_addr

keytable:
	.db K_LN,K_RAISE,K_TAN,K_COS,K_SIN,K_LOG,K_9,K_8
	.db K_7,K_6,K_5,K_4,K_3,K_2,K_1,K_0

str_sweet:
	.db "Sweet16 v1.1",0
str_by:
	.db "by Jonathan Marcus",0
str_input_address:
	.db "Enter address ",$1F,0

vdisp_a_hex:			; disp a as hex byte in small font
	push af
	and %11110000
	rra
	rra
	rra
	rra
	call vdisp_nybble
	pop af
	and %00001111
vdisp_nybble:
	cp 10
	jr c,vready_char
	add a,7
vready_char:
	add a,'0'
	jp _vputmap

.end
