; Japanese Input/Display program
;  By Li Tao
;   ltao@delta.fullerton.edu
;   http://delta.fullerton.edu/~ltao
;   5/26/01

; Character number's:
;         0       = Space
;         1-46    = Hiragana
;         47-92   = Katakana
;         93-106  = Extras
;         107-132 = Letters
;         133-142 = Numbers
;         143-150 = Punctuation
;------------------------------------------------- Actual characters
;         151-196 = Hiragana spec 1 (number-150)
;         197-242 = Katakana spec 1 (number-150)
;         243-247 = Hiragana spec 2 (number-217)
;         248-252 = Katakana spec 2 (number-176)
;         253     = Black (H or K)
;         254     = Return
;         255     = End string

#include "ti86asm.inc"
#include "ti86abs.inc"

.org _asm_exec_ram

	nop
	jp Cleanup
	.dw 0
	.dw Title

Title:
	.db "Japanese Input Program v1.0",0
Author:
 	.db "by Li Tao",0
EMail:
	.db "<ltao@delta.fullerton.edu>",0
Choice1:
	.db "F1) New file",0
Choice2:
	.db "F2) Read file",0

Cleanup:
 call _clrScrn
 res appTextSave,(iy + appflags)
 ld hl,_plotSScreen
 ld de,_plotSScreen + 1
 ld bc,1024
 ld (hl),0
 ldir
 set graphdraw,(iy + graphflags)
 ld hl,0
 ld a,0
 ld (TempLength),hl
 ld (VariableStart),hl
 ld (InputCursorPosition),hl
 ld (InputStartPosition),hl
 ld (Temp),a
 ld (DrawStringDispCursFlag),a
 ld (DrawStringCurrScroll),hl
 ld (TempAddress),hl
 ld (Mode),hl
 ld (DrawStringCounter),a
 ld (DrawStringPosition),hl
 ld a,1
 ld (Consonant),a
 ld a,75
 ld (ScreenLength),a

Menu:
 call _runindicoff
 call _clrScrn
 ld bc,16
 ld (_penCol),bc
 ld hl,Title
 ld bc,10
 ld (_penRow),bc
 call _vputs

 ld bc,60
 ld (_penCol),bc
 ld hl,Author
 ld bc,18
 ld (_penRow),bc
 call _vputs

 ld bc,30
 ld (_penCol),bc
 ld hl,EMail
 ld bc,26
 ld (_penRow),bc
 call _vputs

 ld bc,40
 ld (_penCol),bc
 ld hl,Choice1
 ld bc,42
 ld (_penRow),bc
 call _vputs

 ld bc,40
 ld (_penCol),bc
 ld hl,Choice2
 ld bc,50
 ld (_penRow),bc
 call _vputs

Main:
 call _getkey
 cp kF1
 jr z,DoInput
 cp kF2
 jp z,DoRead
 cp kExit
 jr z,Done
 jr Main

DoInput:
 call _runindicoff
 call _clrScrn

 ld hl,StringData
 call Input
 call $498C

; Save 

 ld bc,0
 ld (_curCol),bc
 ld bc,7
 ld (_curRow),bc

 ld hl,StringVarPrompt
 call _puts
 call GetVariable
 cp kExit
 jr z,Done
 ld a,b
 cp 8
 jr z,Done

 ld a,8
 sub b
 ld (VariableLength),a
 ld hl,VariableStart
 rst 20h
 rst 10h
 jr nc,AlreadyExists
 call Length
 inc hl

; too big
 ld a,h
 cp 32
 jr nc,TooBig

 call _CREATESTRNG
 ex de, hl
 ld a, b
 call _load_ram_ahl
 inc hl
 inc hl
 push hl
 call Length
 inc hl
 ld b,h
 ld c,l
 pop de ; load de with hl
 ld hl,StringData
 ldir

Done:
 set appTextSave,(iy + appflags)
 call _clrScrn
 call _homeup

 call _runindicon
 ld (iy+shiftflags),0
 ret

TooBig:
 ld hl,TooBigMessage
 jr Exists
DoesntExist:
 ld hl,DoesntExistMessage
 jr Exists
AlreadyExists:
 ld hl,AlreadyExistsMessage
Exists:
 call _newline
 call _puts
 call _getkey
 jr Done

StringVarPrompt:
 .db "Save as:",0
TooBigMessage:
 .db "String too big",0
AlreadyExistsMessage:
 .db "Already exists!",0
DoesntExistMessage:
 .db "Doesn't exist!",0
OpenVarPrompt:
 .db "Open:",0

DoRead:
 call _clrScrn
 ld bc,0
 ld (_curCol),bc
 ld bc,6
 ld (_curRow),bc
 ld hl,OpenVarPrompt
 call _puts
 call GetVariable
 cp kExit
 jp z,Done
 ld a,b
 cp 8
 jp z,Done

 ld a,8
 sub b
 ld (VariableLength),a
 ld hl,VariableStart
 rst 20h
 rst 10h
 jp c,DoesntExist
 ex de, hl
 ld a, b
 call _load_ram_ahl
 inc hl
 inc hl
 push hl
 call LengthVar
; too big
 ld a,h
 cp 32
 ld (TempLength),hl
 pop hl
 jp nc,TooBig

DisplayString:
 push hl
; Display Loop
 ld hl,DrawStringCurrScroll
 ld (hl),0
 pop hl
DisplayStringScroll:
 push hl
 call _clrScrn
 pop hl
 ld a,0
 call DrawStringWithScrollNoCursor

 push hl
 call _getkey
 pop hl
 cp kUp
 jr z,DisplayStringScrollUp
 cp kDown
 jr z,DisplayStringScrollDown
 cp kNext
 jr z,DisplayStringPosition
 cp kExit
 jp z,Done
 jr DisplayStringScroll
DisplayStringScrollUp:
 push de
 push hl
 ld hl,(DrawStringCurrScroll)
; Check for going too high
 ld de,0
 call $403C
 pop hl
 pop de
 jr z,DisplayStringScroll
 push de
 push hl
 ld hl,(DrawStringCurrScroll)
 cp 0 ; clear C flag
 ld de,15
 sbc hl,de
 ld (DrawStringCurrScroll),hl
 pop hl
 pop de
 jr DisplayStringScroll
DisplayStringScrollDown:
 push de
 push hl
 ld hl,(DrawStringCurrScroll)
 ld d,0
 ld a,(ScreenLength)
 ld e,a
 add hl,de
 push hl
 ld hl,(TempLength)
 ex de,hl
 pop hl
 call CompHLDE
 pop hl
 pop de
 jr nc,DisplayStringScroll
 push de
 push hl
 ld hl,(DrawStringCurrScroll)
 ld de,15
 add hl,de
 ld (DrawStringCurrScroll),hl
 pop hl
 pop de
 jr DisplayStringScroll
DisplayStringWithScroll:
 push de
 push hl
 ld hl,(DrawStringCurrScroll)
 ld d,0
 ld a,(ScreenLength)
 ld e,a
 add hl,de
 push hl
 call Length
 ex de,hl
 pop hl
 call CompHLDE
 pop hl
 pop de
 jp nc,DisplayStringScroll
 push de
 push hl
 ld hl,(DrawStringCurrScroll)
 ld de,15
 add hl,de
 ld (DrawStringCurrScroll),hl
 pop hl
 pop de
 jp DisplayStringScroll
DisplayStringPosition:
 ld bc,0
 ld (_curCol),bc
 ld bc,7
 ld (_curRow),bc
 push hl
 push de
 ld hl,(DrawStringCurrScroll)
 xor a
 call $4A33 ; display AHL (current position)
 ld a,Lslash
 call _putc
 ld hl,(TempLength)
 xor a
 call $4A33 ; display AHL
 call _getkey
 pop de
 pop hl
 jp DisplayStringScroll

; Temporary length of string
TempLength:
 .dw 0


GetVariable:
 ld hl,VariableName
 ld b,8
 call $4994 
GetVariableLoop:
 push hl
 push bc
 call _getkey
 pop bc
 pop hl
 call $498C
 cp kExit
 ret z
 cp kEnter
 ret z
 call $4994 
 cp kDel
 jr z,GetVariableDelete
 sub kCapA
 cp 26
 jr c,GetVariableUpper
 add a,kCapA
 sub ka
 cp 26
 jr c,GetVariableLower
 add a,ka
 sub k0
 cp 10
 jr c,GetVariableNumber
 jr GetVariableLoop
GetVariableUpper:
 add a,LcapA
 jr GetVariableBack
GetVariableLower:
 add a,La
 jr GetVariableBack
GetVariableNumber:
 add a,L0
GetVariableBack:
 ld (hl),a
 push bc
 push hl
 call _putc
 pop hl
 pop bc
 inc hl
 dec b
 jr nz,GetVariableLoop
 call _getkey
 call $498C
 ret
GetVariableDelete:
 ld a,b
 cp 8
 jr z,GetVariableLoop
 push hl
 push bc
 call $498C
 ld bc,(_curCol)
 dec bc
 ld (_curCol),bc
 ld a,32
 call _putc
 ld bc,(_curCol)
 dec bc
 ld (_curCol),bc
 call $4994 
 pop bc
 pop hl
 dec hl
 inc b
 jr GetVariableLoop
VariableStart:
 .db 0
VariableLength:
 .db 0
VariableName:
 .db "         ",0

; HL = Data to write to
; 
Input:
 ld (hl),255
 push hl
 ld hl,Mode
 ld (hl),0
 ld hl,Consonant
 ld (hl),1
 call $4994
 call _clrScrn

 ld hl,DrawStringCurrScroll
 ld (hl),0

 ld hl,_curRow
 ld (hl),0
 ld hl,_curCol
 ld (hl),20
 pop hl
 push hl
 push hl

 call DrawStringWithScroll
 pop bc
 pop hl
InputLoop:
 call CheckScrollDown
 push hl
 call _getkey
 pop hl
 sub ka
 cp 26
 jp c,InputJLetter
 add a,ka
; Check for 'N'
 push af
 ld a,(Consonant)
 cp 21
 jr z,InputLoopYesN
 cp 67
 jr z,InputLoopYesN
 jr InputLoopNoN
InputLoopYesN:
 inc hl
 call InputResetConsonant
InputLoopNoN:
 pop af
 sub kCapA
 cp 26
 jp c,InputLetter
 add a,kCapA
 sub k0
 cp 10
 jp c,InputNumber
 add a,k0
 cp kExit
 jp z,InputReturn
 cp kDel
 jp z,InputDelete
 cp kSpace
 jp z,InputSpace
 cp kStore
 jp z,InputDash
 cp kEqual
 jp z,InputDash
 cp kNext
 jp z,InputMode
 cp kGrMenu
 jp z,InputExclamation
 cp kTable
 jp z,InputQuestion
 cp kDecPnt
 jp z,InputPeriod
 cp kComma
 jp z,InputComma
 cp kPrgm
 jp z,InputPeriod
 cp kCustom
 jp z,InputComma
 cp kLeft
 jp z,InputOpenQuotes
 cp kRight
 jp z,InputCloseQuotes
 cp kClear
 jp z,InputClear
 cp kF1
 jp z,InputJLetterLower
 cp kF2
 jp z,InputJLetterLower
 cp kF3
 jp z,InputJLetterLower
 cp kF4
 jp z,InputJLetterLower
 cp kF5
 jp z,InputJLetterLower
 cp kEnter
 jp z,InputEnter
 jp InputLoop
InputBack:
 ld (hl),a
 inc hl
 ld (hl),255
InputBackDrawString:
 push hl
 push bc
 push bc
 pop hl
 call DrawStringWithScroll
 pop bc
 pop hl
 jp InputLoop
InputMode:
 push hl
 push bc
 push bc
 ld hl,Mode
 ld h,(hl)
 ld a,46
 sub h
 ld (Mode),a
 inc a
 ld (Consonant),a
 pop hl
 call DrawStringWithScroll
 pop bc
 pop hl
 jp InputLoop
InputLetter:
 add a,107
 jr InputBack
InputNumber:
 add a,133
 jr InputBack
InputJLetterLower:
 sub kF1
 add a,101
 jr InputBack
InputSpace:
 ld a,0
 jr InputBack
InputDash:
 ld a,106
 jr InputBack
InputExclamation:
 ld a,143
 jr InputBack
InputQuestion:
 ld a,144
 jr InputBack
InputPeriod:
 ld a,145
 jr InputBack
InputComma:
 ld a,146
 jr InputBack
InputOpenQuotes:
 ld a,147
 jr InputBack
InputCloseQuotes:
 ld a,148
 jr InputBack
InputClear:
 push bc
 pop hl
 ld (hl),255
 jp Input
InputJLetterV:
 ld a,199
 jr InputBack

InputDelete:
 dec hl
 push hl
 push bc
; Switch BC and HL
 push bc
 push hl
 pop bc
 pop hl
 dec hl
 cp 0    ; clear carry
 sbc hl,bc
 pop bc
 pop hl
; Put in a space
 ld a,0
 jp z,InputBack

 ld (hl),255

 call CheckScrollUp

 push bc
 push hl
 push bc
 pop hl
 ld a,1
 call DrawStringWithScroll
; ---
 pop hl
 pop bc

 jp InputLoop
InputResetConsonant:
 push af
 ld a,(Mode)
 inc a
 ld (Consonant),a
 pop af
 ret

InputJLetter:
 cp 13
 jp z,InputJLetterN
 cp 21
 jp z,InputJLetterV
;InputJLetterDoubleN:
 push hl
 push bc
 ld c,a
 ld b,0
 ld hl,CharData
 add hl,bc
 pop bc
 ld a,(hl)
 cp 255
 jp z,InputJVowel
 pop hl
 cp 0
 jp z,InputLoop
 push hl
 ld h,a
 ld a,(Mode)
 ld l,a
 cp 0
 ld a,h
 jr nz,InputJLetterFixPK
 add a,l

InputJLetterBackP:

 ld d,a
 ld a,(Consonant)
 cp 1
 jr z,InputJLetterOK
 cp 47
 jr z,InputJLetterOK
; This is for N (by itself), SH, CH, and TS

; OK if blend
 ld a,d

 cp 41
 jp z,InputJYBlend
 cp 87
 jp z,InputJYBlend

; Check if it is N, if it is, inc hl
 pop hl
 call InputCheckN
 push hl
 jr z,InputJLetterOK

; It's ok if double consonants
 cp d
 jr z,InputJLetterOK

 ld a,d

; Skip the consonant
 jr InputJLetterBack

InputJYBlend:
 ld hl,CharData
 push bc
 ld bc,24
 add hl,bc
 pop bc
 jr InputJVowel

InputJLetterOK:
 ld a,d
 push bc
 ld hl,Consonant
 ld b,(hl)
 cp b
 jr z,InputLittletsu

InputJLetterBack2:
 pop bc

 ld hl,Consonant
 ld (hl),a

InputJLetterBack:
 pop hl
 jp InputLoop
InputLittletsu:
 cp 21
 jr z,InputJLetterBack2
 cp 67
 jr z,InputJLetterBack2
 ld hl,Mode
 ld a,(hl)
 cp 0
 ld a,100
 call z,InputLittletsu2
 pop bc
 pop hl
 jp InputBack
InputLittletsu2:
 ld a,96
 ret
InputJLetterFixPK:
 ld h,a

 cp 243 ; P
 jr nz,InputJLetterFixNotP

 ld a,248
 jr InputJLetterBackP
InputJLetterDoubleN:
 inc hl
 ld a,(Mode)
 add a,46
 ld (hl),a
 inc hl
 ld (hl),255
 dec hl
 sub 25     ; N
 ld (Consonant),a
 ret
InputJLetterFixNotP:
 ld a,h
 add a,l
 jr InputJLetterBackP
InputJLetterN:
 ld d,a
; Check for double N's
 ld a,(Consonant)
 cp 21
 ld a,d
 call z,InputJLetterDoubleN
 ld a,(Consonant)
 cp 67
 ld a,d
 call z,InputJLetterDoubleN
 ld a,(Mode)
 add a,46
 ld (hl),a
 inc hl
 ld (hl),255
 dec hl
 sub 25     ; N
 ld (Consonant),a

 jp InputBackDrawString

InputJVowel:
; Clear carry
 cp 0
 push bc
 ld bc,CharData
 sbc hl,bc
 ld bc,VowelData
 add hl,bc
 pop bc
; Check for Y,W
 ld a,(Consonant)
 cp 41
 jr z,InputJVowelSpecY
 cp 44
 jr z,InputJVowelSpecW
 cp 87
 jr z,InputJVowelSpecY
 cp 93
 jr z,InputJVowelSpecY
 cp 97
 jr z,InputJVowelSpecY
 cp 90
 jr z,InputJVowelSpecW
 ld a,(hl)
InputJVowelOK:
 ld hl,Consonant
 add a,(hl)
 ld (hl),1

 call InputResetConsonant

; Fix if blend
 ld e,a
 ld a,d

 cp 41
 call z,InputJVowelSpecLittleY
 cp 87
 call z,InputJVowelSpecLittleY

 ld a,e

 pop hl
 jp InputBack

InputJVowelSpecLittleY:
 ld a,(Mode)
 ld hl,Consonant
 cp 0
 ld (hl),93
 ret z
 ld (hl),97
 ret

InputJVowelSpecY:
 ld a,(hl)
 sra a
 jr InputJVowelOK
InputJVowelSpecW:
 ld a,(hl)
 sra a
 sra a
 jr InputJVowelOK

; Checks if consonant is N; increases hl if it is
InputCheckN:
 ld a,(Consonant)
 cp 67
 jr z,InputCheckN2
 cp 21
 jr z,InputCheckN2
 ret
InputCheckN2:
 inc hl
 ret
InputEnter:
 push bc
 push de
 ld hl,StringData   ; HL = pointer
 ld b,0             ; B = put space flag
 ld c,0             ; C = character counter in line (0-15)
 ld de,0            ; DE = line counter
InputEnterLoop:
 ld a,(hl)
 cp 255
 call z,InputEnterLoopSetSpace
; Set space
 ld a,b
 cp 1
 call z,InputEnterLoopPutSpace
 inc hl
 inc c
 ld a,c
 cp 15
 jr nz,InputEnterLoop
 ld a,b
 cp 1
 jr z,InputEnterLoopDone
 ld c,0
 inc de
 jr InputEnterLoop
InputEnterLoopSetSpace:
 ld b,1
 ret
InputEnterLoopPutSpace:
 ld (hl),0
 ret
InputEnterLoopDone:
 ld (hl),255
 pop de
 pop bc
 push hl
 push bc
 push bc
 pop hl
 call DrawStringWithScroll
 pop bc
 pop hl
 jp InputLoop
; saves cursor position
InputReturn:
 ld (InputCursorPosition),hl
 push bc
 pop hl
 ld (InputStartPosition),hl
 ret

InputCursorPosition:
 .dw 0
InputStartPosition:
 .dw 0
Temp:
 .db 0

; C = character
; B = special
; D = Y
; E = X
; Messes up DE!
DrawChar:
 push bc
 ld hl,Sprites
 ld a,c
 cp 253
 call z,DrawCharModHLBlack
; Clear carry flag
 cp 0
 ld a,0
;sla a
 sla c
 adc a,0
 sla a
 sla c
 adc a,0
 sla a
 sla c
 adc a,0
 ld b,a

 add hl,bc
 push hl
 pop ix
; srl d
; rra
; and $80
; or e
; ld e,a
 ld b,d
 ld hl,0
 ld a,0
 push de
DrawCharLocLoop:
 cp b
 jr z,DrawCharLocDone
 ld de,192
 add hl,de
 dec b
 jr DrawCharLocLoop
DrawCharLocDone:
 pop de
 ld d,0
 add hl,de
 push hl
 pop de

 ld hl,$fc00
 add hl,de

 pop bc
 push hl
 sla b
 sla b
 ld hl,Specials
 ld c,b
 ld b,0
 add hl,bc
 push hl
 pop de
 pop hl
 ld b,4
DrawCharSpecLoop:
 ld a,(de)
 ld (hl),a
 inc de
 push de
 ld de,16
 add hl,de
 pop de
 djnz DrawCharSpecLoop

 ld b,8
 ld de,$10
DrawCharLoop:
 ld a,(ix+0)
 ld (hl),a
 inc ix
 add hl,de
 djnz DrawCharLoop
 ret
DrawCharModHLBlack:
 call BlackCursor
 ld c,0
 ret

; HL = string to draw
; A  = flag for displaying cursor after character
DrawString:
 ld (DrawStringDispCursFlag),a
 ld de,(DrawStringPosition)
 ld a,(ScreenLength)
 ld (DrawStringCounter),a
DrawStringLoop:
 ld a,(DrawStringCounter)
 dec a
 cp 0
 ret z
 ld (DrawStringCounter),a
 ld b,0
 ld a,(hl)
 cp 255
 jr z,DrawStringDone
 cp 248
 jr nc,DrawStringSpec2K
 cp 243
 jr nc,DrawStringSpec2H
 cp 150
 jr nc,DrawStringSpec1
DrawStringBack:
 ld c,a
 push af
 push de
 push hl
 call DrawChar
 pop hl
 pop de
 inc hl
 call MoveRight
 pop af
 jr DrawStringLoop
DrawStringDone:
 ld a,(DrawStringDispCursFlag)
 cp 0
 ret z
 ld c,253
 ld b,0
 push de
 call DrawChar
 pop de
 push de
 call MoveRight
 ld c,0
 ld b,0
 call DrawChar
 pop de
 call MoveRight
 ret

DrawStringSpec1:
 ld b,1
 sub 150
 jr DrawStringBack
DrawStringSpec2H:
 ld b,2
 sub 217
 jr DrawStringBack
DrawStringSpec2K:
 ld b,2
 sub 176
 jr DrawStringBack
DrawStringDispCursFlag:
 .db 0


; Draws the string with the auto-scrolling
; HL - the string
; DrawStringCurrScroll - the current scrolling amount (75 per screen usually)
DrawStringWithScroll:
 push af
 push hl
 push de
 ld de,(DrawStringCurrScroll)
 add hl,de
 ld a,1
 call DrawString
 pop de
 pop hl
 pop af
 ret

; Same as above except no cursor
DrawStringWithScrollNoCursor:
 push af
 push hl
 push de
 ld de,(DrawStringCurrScroll)
 add hl,de
 ld a,0
 call DrawString
 pop de
 pop hl
 pop af
 ret

DrawStringCurrScroll:
 .dw 0

; Checks for scrolling downwards
; HL doesn't need to be given, and is preserved
; DrawStringCurrScroll - the current scrolling amount (ptr)
; Clobbers A

CheckScrollDown:
 push hl
 push de
 call Length
 ex de,hl
 cp 0 ; clear carry flag
 ld hl,(DrawStringCurrScroll)

 push de
 ld d,0
 ld a,(ScreenLength)
 ld e,a
 dec e
 add hl,de
 pop de

 call CompHLDE   ; not for the _cphlde in the rom because this compares which is bigger
 pop de
 pop hl

 ret nc  ; No scrolling needed

 push bc
 push hl
 push de
 ld de,45
 ld hl,(DrawStringCurrScroll)
 add hl,de
 ld (DrawStringCurrScroll),hl
 call _clrScrn
 pop de
 pop hl
 pop bc

 push hl
 push bc
 push bc
 pop hl
 call DrawStringWithScroll
 pop bc
 pop hl
 ret

CheckScrollUp:
 push hl
 push de
 call Length
 ex de,hl
 cp 0 ; clear carry flag
 ld hl,(DrawStringCurrScroll)
 inc de

 call CompHLDE   ; not for the _cphlde in the rom because this compares which is bigger
 pop de
 pop hl

 ret c  ; No scrolling needed

 push bc
 push hl
 push de
 ld de,45
 ld hl,(DrawStringCurrScroll)
 cp 0
 sbc hl,de
 ld (DrawStringCurrScroll),hl
 call _clrScrn
 pop de
 pop hl
 pop bc

 push hl
 push bc
 push bc
 pop hl
 call DrawStringWithScroll
 pop bc
 pop hl
 ret

; Compares HL and DE and sets z if equal, c if HL is less than DE
; A is clobbered!
CompHLDE:
 ld a,h
 cp d
 ret nz
 ld a,l
 cp e
 ret

; Scroll DE to new line
NewLine:
 inc d
 ld e,0
 ret
; Scroll DE up one line
UpLine:
 dec d
 ld e,14
 ret

; Move DE one space to the left or right, scroll if necessary
MoveRight:
 push af
 inc e
 ld a,e
 cp 15
 call z,NewLine
 pop af
 ret

MoveLeft:
 push af
 dec e
 ld a,e
 cp 255
 call z,UpLine
 pop af
 ret

; Loads either a black H or a black K sprite in hl
BlackCursor:
 push af
 ld a,(Mode)
 cp 0
 jr z,BlackCursorH
 ld hl,BlackK
 pop af
 ret
BlackCursorH:
 ld hl,BlackH
 pop af
 ret

; Finds length of typed string
; Output: hl - length
Length:
 ld hl,StringData
LengthVar:
 push hl
 ld bc,65535
 ld a,255
 cpir
 pop bc
 cp 0
 sbc hl,bc
 dec hl
 ret

TempAddress:
 .dw 0
Consonant:
 .db 1
Mode:
 .db 0
DrawStringPosition: ; X, Y
 .db 0,0
ScreenLength:
 .db 75
DrawStringCounter:
 .db 0

FileName:
 .db 32,32,32,32,32,32,32,32,0

CharData:
 .db 255,176,16,166,255,26,156,26,255,161,6,36,31
 .db 21,255,243,0,36,11,16,255,0,44,0,41,161

VowelData:
 .db 0,255,255,255,3,255,255,255,1,255,255,255,255
 .db 255,4,255,255,255,255,255,2,255,255,255,1,255

Specials:
Spec1:
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
Spec2:
 .db %00000000
 .db %00001010
 .db %00001010
 .db %00000000
Spec3:
 .db %00000000
 .db %00000100
 .db %00001010
 .db %00000100
Spec4:
 .db %11111111
 .db %11111111
 .db %11111111
 .db %11111111

Sprites:
Space:
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

Hiragana:
 .db %00100000
 .db %11111100
 .db %00100000
 .db %00111100
 .db %01100110
 .db %10101010
 .db %10010010
 .db %01100100

 .db %00000000
 .db %10000100
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %01010000
 .db %00100000

 .db %01111000
 .db %00000000
 .db %00111000
 .db %01000100
 .db %00000100
 .db %00000100
 .db %00001000
 .db %00110000

 .db %00110000
 .db %00000000
 .db %01111100
 .db %00001000
 .db %00010000
 .db %00111000
 .db %01001000
 .db %10000110

 .db %00100010
 .db %11111010
 .db %00100000
 .db %00111100
 .db %01100010
 .db %10100010
 .db %10100010
 .db %01100100

 .db %01000000
 .db %01000100
 .db %11110010
 .db %01001010
 .db %01001000
 .db %10001000
 .db %00001000
 .db %00110000

 .db %00010000
 .db %00111100
 .db %00001000
 .db %00111110
 .db %00000100
 .db %01001100
 .db %01000000
 .db %00111100

 .db %00010000
 .db %00100000
 .db %01000000
 .db %10000000
 .db %10000000
 .db %01000000
 .db %00100000
 .db %00010000

 .db %00000100
 .db %10000100
 .db %10011110
 .db %10000100
 .db %10000100
 .db %10000100
 .db %10000100
 .db %00001000

 .db %00000000
 .db %01111100
 .db %00000010
 .db %00000000
 .db %00000000
 .db %00000000
 .db %10000000
 .db %01111110

 .db %00100000
 .db %00010000
 .db %11111110
 .db %00001000
 .db %01111100
 .db %10000000
 .db %10000000
 .db %01111100

 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10001000
 .db %10001000
 .db %01110000

 .db %00000100
 .db %11111110
 .db %00000100
 .db %00011100
 .db %00100100
 .db %00011100
 .db %00000100
 .db %00011000

 .db %01000100
 .db %01000100
 .db %11111110
 .db %01000100
 .db %01000100
 .db %01001000
 .db %01000000
 .db %00111100

 .db %01111100
 .db %00010000
 .db %00100000
 .db %11111110
 .db %00010000
 .db %00100000
 .db %00100000
 .db %00011100

 .db %00100000
 .db %00100000
 .db %11111100
 .db %01000000
 .db %01011110
 .db %01000000
 .db %10010000
 .db %10001110

 .db %00100000
 .db %00100000
 .db %11111100
 .db %01000000
 .db %01111100
 .db %01000010
 .db %00000010
 .db %00011100

 .db %00000000
 .db %00000000
 .db %11111100
 .db %00000010
 .db %00000010
 .db %00000010
 .db %00000100
 .db %00111000

 .db %00000000
 .db %11111110
 .db %00001100
 .db %00010000
 .db %00100000
 .db %00100000
 .db %00010000
 .db %00001100

 .db %00100000
 .db %00100000
 .db %00101100
 .db %00110000
 .db %01000000
 .db %10000000
 .db %10000000
 .db %01111110

 .db %00100000
 .db %00100100
 .db %11110010
 .db %01000000
 .db %10000100
 .db %00111100
 .db %01000110
 .db %00111000

 .db %00000000
 .db %10011110
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10100000
 .db %10011110

 .db %00001000
 .db %01001000
 .db %01011100
 .db %01101010
 .db %11010010
 .db %10100110
 .db %10101010
 .db %01001110

 .db %00100000
 .db %00100000
 .db %11101100
 .db %00110010
 .db %00100010
 .db %01100110
 .db %10101010
 .db %00101110

 .db %00000000
 .db %00111000
 .db %01010100
 .db %10010010
 .db %10010010
 .db %10010010
 .db %10010010
 .db %01100100

 .db %00000100
 .db %10011110
 .db %10000100
 .db %10000100
 .db %10011100
 .db %10100110
 .db %10100100
 .db %10011000

 .db %00000000
 .db %11110000
 .db %00100100
 .db %01000110
 .db %01000100
 .db %10001100
 .db %10001000
 .db %01110000

 .db %00000000
 .db %00111000
 .db %00001000
 .db %00010000
 .db %01001000
 .db %10001010
 .db %10001010
 .db %00110000

 .db %00000000
 .db %00000000
 .db %00100000
 .db %01010000
 .db %10001000
 .db %00000100
 .db %00000010
 .db %00000000

 .db %00011110
 .db %10000100
 .db %10011110
 .db %10000100
 .db %10011100
 .db %10100110
 .db %10100100
 .db %10011000

 .db %00001000
 .db %01111100
 .db %00001000
 .db %01111100
 .db %00001000
 .db %01111000
 .db %10001100
 .db %01111000

 .db %01110000
 .db %00010000
 .db %00010100
 .db %01111110
 .db %10010100
 .db %10100100
 .db %10100100
 .db %01001000

 .db %00100000
 .db %11110010
 .db %00100010
 .db %01100000
 .db %10100000
 .db %10100010
 .db %01100010
 .db %00111100

 .db %00001000
 .db %01001000
 .db %01011000
 .db %01101100
 .db %10101010
 .db %10010010
 .db %10110010
 .db %01000100

 .db %00100000
 .db %00100000
 .db %11111000
 .db %00100000
 .db %11111000
 .db %00100000
 .db %00100010
 .db %00011100

 .db %01100000
 .db %00011000
 .db %10000000
 .db %10111000
 .db %11000100
 .db %00000100
 .db %00000100
 .db %01111000

 .db %10001000
 .db %10001000
 .db %10001000
 .db %10001000
 .db %10001000
 .db %00001000
 .db %00010000
 .db %01100000

 .db %01111100
 .db %00001000
 .db %00110000
 .db %01111100
 .db %10000010
 .db %00110010
 .db %01001010
 .db %00111100

 .db %00100000
 .db %00100000
 .db %11101100
 .db %00110010
 .db %00100010
 .db %01100100
 .db %10100100
 .db %00100010

 .db %01111100
 .db %00001000
 .db %00110000
 .db %01111100
 .db %10000010
 .db %00000010
 .db %01000010
 .db %00111100

 .db %01001000
 .db %01001000
 .db %11111100
 .db %01000010
 .db %01010010
 .db %01001100
 .db %00100000
 .db %00100000

 .db %00001000
 .db %10111100
 .db %11001010
 .db %10001010
 .db %10001010
 .db %10101010
 .db %00011100
 .db %00100000

 .db %00001000
 .db %00001000
 .db %00001110
 .db %00001000
 .db %00001000
 .db %01111000
 .db %10001100
 .db %01110010

 .db %00100000
 .db %00100000
 .db %11101100
 .db %10110010
 .db %00100010
 .db %01100010
 .db %10100010
 .db %00100100

 .db %00100000
 .db %11110000
 .db %01000000
 .db %01101000
 .db %10110000
 .db %01010000
 .db %01000000
 .db %00111000

 .db %00010000
 .db %00010000
 .db %00100000
 .db %00100000
 .db %01110000
 .db %01001000
 .db %10001000
 .db %10000100

Katakana:
 .db %00000000
 .db %11111110
 .db %00000010
 .db %00010010
 .db %00011100
 .db %00010000
 .db %00010000
 .db %01100000

 .db %00000100
 .db %00000100
 .db %00001000
 .db %00110000
 .db %11010000
 .db %00010000
 .db %00010000
 .db %00010000

 .db %00010000
 .db %00010000
 .db %11111110
 .db %10000010
 .db %10000010
 .db %00000010
 .db %00000100
 .db %00011000

 .db %00000000
 .db %01111100
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %11111110

 .db %00001000
 .db %00001000
 .db %11111110
 .db %00011000
 .db %00101000
 .db %01001000
 .db %10001000
 .db %00011000

 .db %00100000
 .db %00100000
 .db %01111110
 .db %00100010
 .db %00100010
 .db %00100010
 .db %01000010
 .db %10001100

 .db %00010000
 .db %11111110
 .db %00010000
 .db %00010000
 .db %11111110
 .db %00010000
 .db %00010000
 .db %00010000

 .db %00000000
 .db %01111100
 .db %01000100
 .db %10000100
 .db %00000100
 .db %00000100
 .db %00001000
 .db %01110000

 .db %01000000
 .db %01000000
 .db %01111110
 .db %01000100
 .db %10000100
 .db %00000100
 .db %00001000
 .db %00110000

 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000010
 .db %00000010
 .db %00000010
 .db %00000010
 .db %11111110

 .db %01000100
 .db %01000100
 .db %11111110
 .db %01000100
 .db %01000100
 .db %00000100
 .db %00000100
 .db %00111000

 .db %00000000
 .db %11100000
 .db %00000100
 .db %11100100
 .db %00000100
 .db %00000100
 .db %00001000
 .db %11110000

 .db %00000000
 .db %11111100
 .db %00000100
 .db %00000100
 .db %00001000
 .db %00011000
 .db %00100100
 .db %11000010

 .db %01000000
 .db %01000000
 .db %11111110
 .db %01000010
 .db %01000100
 .db %01000000
 .db %01000000
 .db %00111100

 .db %00000000
 .db %10000010
 .db %10000010
 .db %01000010
 .db %00000100
 .db %00000100
 .db %00001000
 .db %00110000

 .db %00000000
 .db %01111110
 .db %01000010
 .db %01110010
 .db %10001110
 .db %00000010
 .db %00000100
 .db %00111000

 .db %00000110
 .db %01111000
 .db %00001000
 .db %11111110
 .db %00001000
 .db %00001000
 .db %00010000
 .db %01100000

 .db %00000000
 .db %10100100
 .db %10100100
 .db %00000100
 .db %00000100
 .db %00000100
 .db %00001000
 .db %01110000

 .db %00000000
 .db %01111100
 .db %00000000
 .db %11111110
 .db %00001000
 .db %00001000
 .db %00001000
 .db %00110000

 .db %00100000
 .db %00100000
 .db %00100000
 .db %00111000
 .db %00100100
 .db %00100000
 .db %00100000
 .db %00100000

 .db %00001000
 .db %00001000
 .db %11111110
 .db %00001000
 .db %00001000
 .db %00001000
 .db %00010000
 .db %01100000

 .db %00000000
 .db %01111100
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %11111110

 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000010
 .db %00010100
 .db %00001000
 .db %00010100
 .db %01100010

 .db %00010000
 .db %00010000
 .db %11111110
 .db %00000100
 .db %00011000
 .db %00110100
 .db %11010010
 .db %00010000

 .db %00000000
 .db %00000100
 .db %00000100
 .db %00000100
 .db %00001000
 .db %00001000
 .db %00110000
 .db %11000000

 .db %00000000
 .db %00000000
 .db %01001000
 .db %01000100
 .db %01000100
 .db %01000010
 .db %10000010
 .db %10000010

 .db %10000000
 .db %10000000
 .db %10001100
 .db %11110000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %01111110

 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000010
 .db %00000100
 .db %00000100
 .db %00001000
 .db %00110000

 .db %00000000
 .db %00000000
 .db %00100000
 .db %01010000
 .db %10001000
 .db %00000100
 .db %00000010
 .db %00000000

 .db %00010000
 .db %00010000
 .db %11111110
 .db %00010000
 .db %01010100
 .db %01010010
 .db %01010010
 .db %10010010

 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000010
 .db %01000100
 .db %00101000
 .db %00010000
 .db %00001000

 .db %01111000
 .db %00000000
 .db %00000000
 .db %01111000
 .db %00000000
 .db %00000000
 .db %11110000
 .db %00001100

 .db %00000000
 .db %00100000
 .db %00100000
 .db %00100000
 .db %01000100
 .db %01000100
 .db %10000010
 .db %11111110

 .db %00000000
 .db %00000100
 .db %00100100
 .db %00010100
 .db %00001000
 .db %00001100
 .db %00110010
 .db %11000000

 .db %00000000
 .db %11111100
 .db %00100000
 .db %00100000
 .db %11111110
 .db %00100000
 .db %00100000
 .db %00011110

 .db %00000000
 .db %01111100
 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000100
 .db %00001000
 .db %00110000

 .db %10001000
 .db %10001000
 .db %10001000
 .db %10001000
 .db %10001000
 .db %00001000
 .db %00010000
 .db %01100000

 .db %00000000
 .db %01010000
 .db %01010000
 .db %01010000
 .db %01010000
 .db %01010000
 .db %01010010
 .db %10011100

 .db %00000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000100
 .db %10001000
 .db %10110000
 .db %11000000

 .db %00000000
 .db %00000000
 .db %11111110
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %11111110

 .db %00000000
 .db %00100000
 .db %11111110
 .db %00100010
 .db %00100100
 .db %00101000
 .db %00100000
 .db %00100000

 .db %00000000
 .db %01111000
 .db %00001000
 .db %00001000
 .db %00001000
 .db %00001000
 .db %00001000
 .db %11111110

 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000010
 .db %01111110
 .db %00000010
 .db %00000010
 .db %11111110

 .db %00000000
 .db %11111110
 .db %10000010
 .db %10000010
 .db %10000010
 .db %00000010
 .db %00000100
 .db %00111000

 .db %00000000
 .db %11111110
 .db %00000010
 .db %00000010
 .db %01111110
 .db %00000010
 .db %00000100
 .db %01111000

 .db %00000000
 .db %11100010
 .db %00000010
 .db %00000010
 .db %00000010
 .db %00000010
 .db %00000100
 .db %11111000

ExtraHiragana:
 .db %00000000
 .db %00000000
 .db %01010000
 .db %01111000
 .db %11010100
 .db %01000100
 .db %00101000
 .db %00100000

 .db %00000000
 .db %00000000
 .db %00010000
 .db %10111000
 .db %11010100
 .db %10010100
 .db %00111000
 .db %00010000

 .db %00000000
 .db %00000000
 .db %00010000
 .db %00011000
 .db %00010000
 .db %01110000
 .db %10011000
 .db %01110000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %11111000
 .db %00000100
 .db %00000100
 .db %00001000
 .db %00110000

ExtraKatakana:
 .db %00000000
 .db %00000000
 .db %00000000
 .db %01000000
 .db %11111000
 .db %01001000
 .db %01010000
 .db %01000000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %01110000
 .db %00010000
 .db %00010000
 .db %11111000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %11111000
 .db %00001000
 .db %11111000
 .db %00001000
 .db %11111000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %10101000
 .db %10101000
 .db %00001000
 .db %00010000
 .db %11100000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %11111000
 .db %00001000
 .db %00101000
 .db %00110000
 .db %01000000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00010000
 .db %00100000
 .db %11100000
 .db %00100000
 .db %00100000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00100000
 .db %11111000
 .db %10001000
 .db %00010000
 .db %01100000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %01110000
 .db %00100000
 .db %00100000
 .db %11111000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00010000
 .db %11111000
 .db %00110000
 .db %01010000
 .db %10010000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %11111100
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

Roman:
 .db %00000000
 .db %00010000
 .db %00101000
 .db %00101000
 .db %01000100
 .db %01111100
 .db %10000010
 .db %10000010

 .db %00000000
 .db %11111000
 .db %10000100
 .db %10000100
 .db %11111000
 .db %10000100
 .db %10000100
 .db %11111000

 .db %00000000
 .db %01111000
 .db %10000100
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000100
 .db %01111000

 .db %00000000
 .db %11111000
 .db %10000100
 .db %10000100
 .db %10000100
 .db %10000100
 .db %10000100
 .db %11111000

 .db %00000000
 .db %11111100
 .db %10000000
 .db %10000000
 .db %11111000
 .db %10000000
 .db %10000000
 .db %11111100

 .db %00000000
 .db %11111100
 .db %10000000
 .db %10000000
 .db %11111000
 .db %10000000
 .db %10000000
 .db %10000000

 .db %00000000
 .db %01111100
 .db %10000010
 .db %10000000
 .db %10001110
 .db %10000010
 .db %10000010
 .db %01111100

 .db %00000000
 .db %10000010
 .db %10000010
 .db %10000010
 .db %11111110
 .db %10000010
 .db %10000010
 .db %10000010

 .db %00000000
 .db %01111100
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %01111100

 .db %00000000
 .db %01111100
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %10010000
 .db %01100000

 .db %00000000
 .db %10001000
 .db %10010000
 .db %10100000
 .db %11000000
 .db %10100000
 .db %10010000
 .db %10001000

 .db %00000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %11111000

 .db %00000000
 .db %10000010
 .db %11000110
 .db %10101010
 .db %10010010
 .db %10000010
 .db %10000010
 .db %10000010

 .db %00000000
 .db %10000010
 .db %11000010
 .db %10100010
 .db %10010010
 .db %10001010
 .db %10000110
 .db %10000010

 .db %00000000
 .db %01111100
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %01111100

 .db %00000000
 .db %11111100
 .db %10000010
 .db %10000010
 .db %11111100
 .db %10000000
 .db %10000000
 .db %10000000

 .db %00000000
 .db %01111100
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10001010
 .db %10000110
 .db %01111110

 .db %00000000
 .db %11111100
 .db %10000010
 .db %10000010
 .db %11111100
 .db %10001000
 .db %10000100
 .db %10000010

 .db %00000000
 .db %01111110
 .db %10000000
 .db %10000000
 .db %01111100
 .db %00000010
 .db %00000010
 .db %11111100

 .db %00000000
 .db %11111110
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000

 .db %00000000
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10000010
 .db %01111100

 .db %00000000
 .db %10000010
 .db %10000010
 .db %01000100
 .db %01000100
 .db %00101000
 .db %00101000
 .db %00010000

 .db %00000000
 .db %10000010
 .db %10000010
 .db %10000010
 .db %10010010
 .db %10101010
 .db %11000110
 .db %10000010

 .db %00000000
 .db %10000010
 .db %01000100
 .db %00101000
 .db %00010000
 .db %00101000
 .db %01000100
 .db %10000010

 .db %00000000
 .db %10000010
 .db %01000100
 .db %00101000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000

 .db %00000000
 .db %11111110
 .db %00000100
 .db %00001000
 .db %00010000
 .db %00100000
 .db %01000000
 .db %11111110

Numbers:
 .db %00000000
 .db %00111000
 .db %01000100
 .db %01000100
 .db %01000100
 .db %01000100
 .db %01000100
 .db %00111000

 .db %00000000
 .db %00010000
 .db %00110000
 .db %01010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %01111100

 .db %00000000
 .db %00111000
 .db %01000100
 .db %00000100
 .db %00001000
 .db %00010000
 .db %00100000
 .db %01111100

 .db %00000000
 .db %00111000
 .db %01000100
 .db %00000100
 .db %00011000
 .db %00000100
 .db %01000100
 .db %00111000

 .db %00000000
 .db %01001000
 .db %01001000
 .db %01001000
 .db %01111100
 .db %00001000
 .db %00001000
 .db %00001000

 .db %00000000
 .db %01111100
 .db %01000000
 .db %01000000
 .db %01111000
 .db %00000100
 .db %00000100
 .db %01111000

 .db %00000000
 .db %00011000
 .db %00100000
 .db %01000000
 .db %01111000
 .db %01000100
 .db %01000100
 .db %00111000

 .db %00000000
 .db %01111100
 .db %01000100
 .db %00001000
 .db %00010000
 .db %00010000
 .db %00100000
 .db %00100000

 .db %00000000
 .db %00111000
 .db %01000100
 .db %01000100
 .db %00111000
 .db %01000100
 .db %01000100
 .db %00111000

 .db %00000000
 .db %00111000
 .db %01000100
 .db %01000100
 .db %00111000
 .db %00001000
 .db %00010000
 .db %00010000

Punctuation:
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00010000
 .db %00000000
 .db %00010000
 .db %00010000

 .db %00111000
 .db %01000100
 .db %01000100
 .db %00000100
 .db %00011000
 .db %00010000
 .db %00000000
 .db %00010000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00011000
 .db %00100100
 .db %00100100
 .db %00011000

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00110000
 .db %00001000
 .db %00000100

 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %10000000
 .db %10000000
 .db %10000000
 .db %11110000

 .db %00011110
 .db %00000010
 .db %00000010
 .db %00000010
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

BlackH:
 .db %11111111
 .db %11011011
 .db %11011011
 .db %11000011
 .db %11011011
 .db %11011011
 .db %11111111
 .db %11111111

BlackK:
 .db %11111111
 .db %11011011
 .db %11010111
 .db %11001111
 .db %11010111
 .db %11011011
 .db %11111111
 .db %11111111

StringData:
 .db 255
.end
