;------------------------------------------------------------------------------
;EditPad 86 v.82
;by Dark Ryder, TNC
;
;  Keep in mind that this is only version .8 and still BETA!  Obviously, I
;need to make it change filenames, or it won't do much good.  I intend to
;release .9 next, the 'Final BETA' version, that will have all the features
;planned for 1.0, but I want to get some user feedback before the release
;version.
;
;  If you notice that different sections' comments are written differently,
;that's because I wrote some in the morning, some in the evening, and some at
;suppertime.  (And I'm writing this at one in the morning!)  Also, if the code
;seems muddled or backwards, it's because I'm kind of muddled and backwards.
;
;  Questions, comments, and requests are welcome at DarkRyder@cyberdude.com 
;------------------------------------------------------------------------------
#include "asm86.h"					;Pretty much required.
#include "ti86asm.inc"				;Required if you want to do anything.
#include "ti86ops.inc"				;Handles the OPx's (for file I/O)
#include "ti86abs.inc"				;Handles absolute addressing.
#include "ti86fnt.inc"				;A few extra font equates.

.org _asm_exec_ram

 nop								;AShell 1.1 compatible (A86)
 jp Asm_Start						; program ID table:
 .dw 0							; v0
 .dw Title						; Pointer to Program Title

Asm_Start:
 ld a,(iy+shiftflags)				;This is an easier way to
 or $18							; set both shiftAplha and
 ld (iy+shiftflags),a				; shift2nd.
 call _runindicoff					;Makes the status bar look nicer.

;------------------------------------------------------------------------------
;PutBar draws the status bar at the top of the screen.
; it's actually treated as the beginning of the Main loop.
;------------------------------------------------------------------------------
PutBar:
 call _clrScrn						;Clears the screen and _textshadow.
 ld hl,VIDEO_MEM					;Start at the top of the screen...
 ld de,VIDEO_MEM+1
 ld (hl),$FF						;...and fill in...
 ld bc,$006F						;...seven full lines.
 ldir							;Go!
 set textInverse,(iy+textflags)		;The bar is black, so invert the text.
 ld hl,0							;Start at the top right corner,
 ld (_penCol),hl
 ld hl,FileName					; get the length of the name,
 ld b,(hl)
 inc hl							; point HL at the name itself,
 call _vputsn						; and display it.
 bit shift2nd,(iy+shiftflags)			;Check if we need to display
 jr z,PreMain						; an Alpha symbol
 ld a,LcapA						;Start the character to display at 'A'
 bit shiftAlpha,(iy+shiftflags)		;Check if it's actually lower case.
 jr z,PutFlag
 add a,$20						;Change it to lower case
PutFlag:
 ld hl,$007B						;Five pixels from edge of screen
 ld (_penCol),hl
 call _vputmap						;Display one character
PreMain:
 res textInverse,(iy+textflags)		;Done with inverse text.

TransText:
 ld hl,_textShadow					;_textShadow is the calc's text memory.
 push hl							;We'll need it later.
 ld hl,(ProgLen)					;File size.
 ld de,DataArea					;Size offset.
 add hl,de						;Last byte in the file...
 ex de,hl							; but we need it in de.
 ld bc,(_curPos)					;Display offset (bc 'cause de is busy).
 add hl,bc						;hl still has 'DataArea' in it!
TransLoop:
 call cp_hl2de						;Is this the last byte?
 jr z,TransLoopOut					; if so, we're done translating.
 ld a,(hl)						;Get a byte.
; cp 0							;Is it 'Enter'?
; call z,doEnter					; if so, unpack it.
 ex (sp),hl						;Get the destination address.
 ld (hl),a						;Put the byte.
 inc hl							;Next byte!
 ex (sp),hl						;Get the source address.
 inc hl							;Next byte!
 jr TransLoop						;And cycle.
TransLoopOut:
 pop hl							;Get the destination address.
 ld (hl),LcurInv					;Write the cursor.
 inc hl							;Next byte!
 ld (hl),0						;We'll be '_puts'ing it.
 ld de,_textShadow + $93				;Only 7 lines on the display.
 call cp_hl2de						;Check if the display is too large.
 jr c,TransCheck					; if not, goto the next check.
 ld hl,(_curPos)					;Get the display offset.
 inc hl							;Raise the offset.
 ld (_curPos),hl					;Put the display offset.
 jr TransText						;And start all over again...
TransCheck:
 ld de,_textShadow + $7E				;End of the 6th line.
 call cp_hl2de						;Check if the display is too small.
 jr nc,TransDone					; if not, we're done checking!
 ld hl,(_curPos)					;We need to check if the file is too
 ld de,0							; short because the _file_ is too
 call cp_hl2de						; short.
 jr z,TransDone					;If so, ignore the adjustment.
 ld hl,(_curPos)					;Get the display offset.
 dec hl							;Lower the offset.
 ld (_curPos),hl					;Put the display offset.
 jr TransText						;And start all over again...
TransDone:
 res appTextSave,(iy+appflags)		;Don't affect _textShadow!!!
 ld hl,$0001						;Start on the second line.
 ld (_curRow),hl
 ld hl,_textShadow					;Display the text memory.
 call _puts						;And go!
 set appTextSave,(iy+appflags)		;It's OK to affect it again.

;------------------------------------------------------------------------------
;Main routine using custom keyboard handler.
;------------------------------------------------------------------------------
Main:
 call GetCode						;My new keyboard handler.
 cp '?'							;Keys that do nothing are marked as '?'
 jr z,Main						;So get a new code!
 cp $10							;Was it Alpha?
 jr z,SetFlag						; if so, set the flag.
 cp $08							;Was it 2nd?
 jr z,SetFlag						; if so, set the flag.
 cp $00							;Was it Enter?
 jr z,StoreChar					; if so, start a new line.
 cp '='							;Was it =?
 jr z,StoreChar					; if so, just display it.
 cp ' '							;Was it Space?
 jr z,StoreChar					; if so, just display it.
 cp '['							;Was it Backspace (Clear)?
 jr z,UndoLast						; if so, remove the last char.
 cp '%'							;Was it Save (F1)?
 jr z,NewDoc						; if so, start over.
 cp '$'							;Was it Save (F2)?
 jr z,Load						; if so, load it.
 cp '~'							;Was it Save (F4)?
 jr z,Save						; if so, save it.
 cp '&'							;Was it Exit?
 jr z,ExitCheck					; if so, make sure the file is saved.
 bit shift2nd,(iy+shiftflags)			;Are we in 'literal' mode?
 jr z,LitCode						; if so, interpret it.
 bit shiftAlpha,(iy+shiftflags)		;Check for lower case flag.
 jr z,StoreChar					;If not, just display it.
 add a,$20						;If so, shift the char to lower case.

StoreChar:						;Adds char to file
 ld hl,(ProgLen)					;Get the file length.
 inc hl							;Add one.
 ld (ProgLen),hl					;Store the file length.
 ld de,DataArea - 1					;This makes hl point to the next byte
 add hl,de						; in the file storeage area.
 ld (hl),a						;Stores a.
 jp PutBar						;Update the status bar.

UndoLast:
 ld hl,(ProgLen)					;Get the length.
 dec hl							;Decrement.
 ld (ProgLen),hl					;Write the new length.
 jp PutBar						;And return.

LitCode:
 ld de,Lit_End - Lit_Start			;We need to get a different code for
 add hl,de						; literal chars.  That's all LitCode
 ld a,(hl)						; really does.
 jr StoreChar

;------------------------------------------------------------------------------
;SetFlag makes the Alpha key act like "Caps Lock" and 2nd act like "Num Lock"
;------------------------------------------------------------------------------
SetFlag:
 ld b,a							;Load the flag to flip into b.
 ld a,(iy+shiftflags)				;Get the shiftflags.
 xor b							;Flip the proper bit.
 ld (iy+shiftflags),a				;Put the flags back.
 jp PutBar						;Update the status bar.

ExitCheck:
 ld a,(iy+shiftflags)				;Grab the shift flags.
 and $E7							;Clear the shift flags.
 ld (iy+shiftflags),a				;Apply the shift flags.
 call _clrScrn						;Clears the screen and _textshadow.
 ret								;Leave!

NewDoc:
 ld hl,0							;We use hl to clear both
 ld (ProgLen),hl					; the file length
 ld (_curPos),hl					; and the currennt display offset.
 jp Asm_Start						;Sets the flags.

;------------------------------------------------------------------------------
;Save only handles the name 'Untitled', for now.
;------------------------------------------------------------------------------
Save:
 ld hl,FileName-1					;We need an extra byte, but we don't
 rst 20h							; care what it is.  Then we move the
 rst 10h							; filename into OP1 so we can find out
 call nc,_delvar					; whether or not it already exists.
 ld hl,(ProgLen)					;Get the file's length.
 inc hl							;Add space for $03 EOF
 push hl							;Store for later.
 call _CREATESTRNG					; and make a string the right size.
 ld a,b							;_CREATESTRING puts the address in bde
 ex de,hl							; instead of ahl, so we have to switch.
 call _load_ram_ahl					;Load the new string's location.
 ld de,DataArea					;Point de at the file.
 ex de,hl							;Oops!  I forgot this at first...
 pop bc							;Get the number of bytes to move.
 inc de							;Skip the size bytes; _CREATESTRNG
 inc de							; already set them.
 ldir							;Go!
 ex de,hl							;'Cause we can't load into (de).
 ld (hl),$03						;End Of File marker for TiL.
 jp PutBar						;And return.

LoadRecent:
; ld hl,LastName - 1
; jr AfterName

Load:
 ld hl,FileName - 1					;Get the filename.
AfterName:
 rst 20h							;a.k.a. _MOV10TOOP1
 rst 10h							;a.k.a. _FINDSYM
 jp c,PutBar						;If it doesn't exist, DON'T LOAD!
 ld a,b							;Switch bde into ahl
 ex de,hl
 call _load_ram_ahl					;Get the right RAM page.
 push hl							;We'll need this for the LDIR.
 call $0033						;a.k.a. 'ld hl,(hl)'
 dec hl							;To skip $03 EOF
 ld (ProgLen),hl					;Write the file length.
 ld b,h							;ld bc,hl
 ld c,l
 ld de,-7							;Seven is the _minimum_ chars that can
 add hl,de						; fill the display, so we'll set the
 jr c,NoAdjPos						; display offset there.
 ld hl,0							;Don't go below zero!
NoAdjPos:
 ld (_curPos),hl					;Set the display offset
 pop hl							;Get the var location, again.
 inc hl							;Skip the size bytes, this time.
 inc hl
 ld de,DataArea					;de = destination
 ldir							;Move it!
 jp PutBar

GetCode:
 call GET_KEY						;Get a scan code from the keypad.
 ld b,0							;We need to add it to hl (as an
 ld c,a							; index), but we have to put it
 ld hl,CharTable					; bc first.  CharTable is the index.
 add hl,bc						;This tells us what the key should do!
 ld a,(hl)						; (Thanks to Joshua Grams for releasing
 ret								; the JMV source!)

;mul_ahl:							;I can't seem to find a good multiply
; cp 0							; routine anywhere.
; jr nz,GoMult						;If a != 0, we can continue,
; ld hl,0							; but if not, we'll zero out hl,
; ret								; and return.
;GoMult:
; ex de,hl							;Put hl into de.
; ld hl,0							;There might have been something in de.
;MultLoop:
; add hl,de						;Add an 'hl'
; dec a							;Subtract an a.
; ret z							;If a has been reduced to zero, we're
; jr MultLoop						; done.

;------------------------------------------------------------------------------
;I'm really very fond of this routine - 6 bytes equivalent to 'cp hl,de'
;------------------------------------------------------------------------------
cp_hl2de:							;I don't trust TI's routine to set the
 ld a,h							; carry flag correctly.
 cp d							;Compare 'h' to d.
 ret nz							;If they're not equal, we're done.
 ld a,l							;Prepare l.
 cp e							;Compare 'l' to e.
 ret								;And we're done!

CharTable:
 .db "?????????"					;NoKey, arrows, and 4 filler bytes.
Lit_Start:
 .db 0,"XTOJE[?"					;Column 5 and 1 filler byte.
 .db " WSNID??"					;Column 4 and 1 filler byte.
 .db "ZVRMHC??"					;Column 3 (except More).
 .db "YUQLGB??"					;Column 2 (except Exit).
 .db "?=PKFA?",$10					;Column 1 (except 2nd).
 .db "?~?$%"						;Menu Keys (F#).
 .db 8,"&?"						;2nd, Exit, More.
; .db "@~#$%"						;Menu Keys (F#).

Lit_End:							;This minimizes the extra bytes.
 .db "_+-*/^[?"
 .db " 369)???"
 .db ".258(???"
 .db "0147",$1B,"???"
 .db "??,",$12

Title:
 .db "EditPad 86 v.82",0

FileName:							;The name of the file we're working on
 .db 8,"Untitled"					; stored in OPx format.

;LastName:						;The name of the last new file saved or
; .db 8,"Untitled"					; file opened, in OPx format.

_curPos:							;I guess I decided to name it after
 .dw 0							; _curRow, for some reason...

ProgLen:							;I have _no idea_ why I called the file
 .dw 0							; length 'ProgLen'.

;------------------------------------------------------------------------------
;I decided to store the current file in _asm_exec_ram because it's so large,
; and EditPad is so small.
;------------------------------------------------------------------------------
DataArea:

.end								;Goodbye!
